/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.utility.visitor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.bytebuddy.jar.asm.Handle;
import net.bytebuddy.jar.asm.Label;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.utility.OpenedClassReader;

public class FramePaddingMethodVisitor
extends MethodVisitor {
    private boolean padding = false;
    private boolean injected = false;
    private final List<Label> labels = new ArrayList<Label>();
    private final Map<Label, Label> mapped = new HashMap<Label, Label>();

    public FramePaddingMethodVisitor(MethodVisitor methodVisitor) {
        super(OpenedClassReader.ASM_API, methodVisitor);
    }

    @Override
    public void visitLabel(Label label) {
        this.labels.add(label);
        super.visitLabel(label);
    }

    @Override
    public void visitFrame(int type, int localVariableLength, Object[] localVariable, int stackSize, Object[] stack) {
        if (this.padding) {
            this.injected = true;
            super.visitInsn(0);
        } else {
            this.padding = true;
        }
        if (!this.mapped.isEmpty()) {
            this.patch(localVariableLength, localVariable);
            this.patch(stackSize, stack);
        }
        super.visitFrame(type, localVariableLength, localVariable, stackSize, stack);
    }

    @Override
    public void visitInsn(int opcode) {
        this.reset();
        super.visitInsn(opcode);
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        this.reset();
        super.visitIntInsn(opcode, operand);
    }

    @Override
    public void visitVarInsn(int opcode, int offset) {
        this.reset();
        super.visitVarInsn(opcode, offset);
    }

    @Override
    public void visitTypeInsn(int opcode, String type) {
        this.reset();
        super.visitTypeInsn(opcode, type);
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
        this.reset();
        super.visitFieldInsn(opcode, owner, name, descriptor);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String descriptor) {
        this.reset();
        super.visitMethodInsn(opcode, owner, name, descriptor);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        this.reset();
        super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
    }

    @Override
    public void visitInvokeDynamicInsn(String name, String descriptor, Handle handle, Object ... argument) {
        this.reset();
        super.visitInvokeDynamicInsn(name, descriptor, handle, argument);
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        this.reset();
        super.visitJumpInsn(opcode, label);
    }

    @Override
    public void visitLdcInsn(Object value) {
        this.reset();
        super.visitLdcInsn(value);
    }

    @Override
    public void visitIincInsn(int offset, int increment) {
        this.reset();
        super.visitIincInsn(offset, increment);
    }

    @Override
    public void visitTableSwitchInsn(int minimum, int maximum, Label defaultLabel, Label ... label) {
        this.reset();
        super.visitTableSwitchInsn(minimum, maximum, defaultLabel, label);
    }

    @Override
    public void visitLookupSwitchInsn(Label defaultLabel, int[] key, Label[] label) {
        this.reset();
        super.visitLookupSwitchInsn(defaultLabel, key, label);
    }

    @Override
    public void visitMultiANewArrayInsn(String descriptor, int dimensions) {
        this.reset();
        super.visitMultiANewArrayInsn(descriptor, dimensions);
    }

    private void patch(int length, Object[] target) {
        if (target != null) {
            for (int index = 0; index < length; ++index) {
                Label label;
                if (!(target[index] instanceof Label) || (label = this.mapped.get((Label)target[index])) == null) continue;
                target[index] = label;
            }
        }
    }

    private void reset() {
        if (this.padding) {
            if (this.injected) {
                for (Label label : this.labels) {
                    Label target = new Label();
                    super.visitLabel(target);
                    this.mapped.put(label, target);
                }
                this.injected = false;
            }
            this.padding = false;
        }
        this.labels.clear();
    }
}

