/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#include "config.h"
#include "JSBufferEncodingType.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>

namespace WebCore {
using namespace JSC;

String convertEnumerationToString(BufferEncodingType enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("utf8"),
        MAKE_STATIC_STRING_IMPL("ucs2"),
        MAKE_STATIC_STRING_IMPL("utf16le"),
        MAKE_STATIC_STRING_IMPL("latin1"),
        MAKE_STATIC_STRING_IMPL("ascii"),
        MAKE_STATIC_STRING_IMPL("base64"),
        MAKE_STATIC_STRING_IMPL("base64url"),
        MAKE_STATIC_STRING_IMPL("hex"),
        MAKE_STATIC_STRING_IMPL("buffer"),
    };
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, BufferEncodingType enumerationValue)
{
    return jsStringWithCache(lexicalGlobalObject.vm(), convertEnumerationToString(enumerationValue));
}

// this function is mostly copied from node
template<> std::optional<BufferEncodingType> parseEnumeration<BufferEncodingType>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    JSC::JSString* str = value.toStringOrNull(&lexicalGlobalObject);
    if (!str)
        return std::nullopt;

    auto encoding = str->value(&lexicalGlobalObject);
    if (encoding.length() < 3)
        return std::nullopt;

    switch (encoding[0]) {
    case 'u':
    case 'U':
        // utf8, utf16le
        if (encoding[1] == 't' && encoding[2] == 'f') {
            // Skip `-`
            const size_t skip = encoding[3] == '-' ? 4 : 3;
            if (encoding[skip] == '8' && encoding[skip + 1] == '\0')
                return BufferEncodingType::utf8;
            if (WTF::equalIgnoringASCIICase(encoding.substringSharingImpl(skip, 5), "16le"_s))
                return BufferEncodingType::ucs2;
            // ucs2
        } else if (encoding[1] == 'c' && encoding[2] == 's') {
            const size_t skip = encoding[3] == '-' ? 4 : 3;
            if (encoding[skip] == '2' && encoding[skip + 1] == '\0')
                return BufferEncodingType::ucs2;
        }
        if (WTF::equalIgnoringASCIICase(encoding, "utf8"_s))
            return BufferEncodingType::utf8;
        if (WTF::equalIgnoringASCIICase(encoding, "utf-8"_s))
            return BufferEncodingType::utf8;
        if (WTF::equalIgnoringASCIICase(encoding, "ucs2"_s))
            return BufferEncodingType::ucs2;
        if (WTF::equalIgnoringASCIICase(encoding, "ucs-2"_s))
            return BufferEncodingType::ucs2;
        if (WTF::equalIgnoringASCIICase(encoding, "utf16le"_s))
            return BufferEncodingType::ucs2;
        if (WTF::equalIgnoringASCIICase(encoding, "utf-16le"_s))
            return BufferEncodingType::ucs2;
        break;

    case 'l':
    case 'L':
        // latin1
        if (encoding[1] == 'a') {
            if (WTF::equalIgnoringASCIICase(encoding.substringSharingImpl(2, 4), "tin1"_s))
                return BufferEncodingType::latin1;
        }
        if (WTF::equalIgnoringASCIICase(encoding, "latin1"_s))
            return BufferEncodingType::latin1;
        break;

    case 'b':
    case 'B':
        // binary is a deprecated alias of latin1
        if (encoding[1] == 'i') {
            if (WTF::equalIgnoringASCIICase(encoding.substringSharingImpl(2, 5), "nary"_s))
                return BufferEncodingType::latin1;
            // buffer
        } else if (encoding[1] == 'u') {
            if (WTF::equalIgnoringASCIICase(encoding.substringSharingImpl(2, 5), "ffer"_s))
                return BufferEncodingType::buffer;
            // base64
        } else if (encoding[1] == 'a') {
            if (WTF::equalIgnoringASCIICase(encoding.substringSharingImpl(2, 5), "se64"_s))
                return BufferEncodingType::base64;
            if (WTF::equalIgnoringASCIICase(encoding.substringSharingImpl(2, 8), "se64url"_s))
                return BufferEncodingType::base64url;
        }
        if (WTF::equalIgnoringASCIICase(encoding, "binary"_s))
            return BufferEncodingType::latin1; // BINARY is a deprecated alias of LATIN1.
        if (WTF::equalIgnoringASCIICase(encoding, "buffer"_s))
            return BufferEncodingType::buffer;
        if (WTF::equalIgnoringASCIICase(encoding, "base64"_s))
            return BufferEncodingType::base64;
        if (WTF::equalIgnoringASCIICase(encoding, "base64url"_s))
            return BufferEncodingType::base64url;
        break;

    case 'a':
    case 'A':
        // ascii
        if (encoding[1] == 's') {
            if (WTF::equalIgnoringASCIICase(encoding.substringSharingImpl(2, 3), "cii"_s))
                return BufferEncodingType::ascii;
        }
        if (WTF::equalIgnoringASCIICase(encoding, "ascii"_s))
            return BufferEncodingType::ascii;
        break;

    case 'h':
    case 'H':
        // hex
        if (encoding[1] == 'e')
            if (encoding[2] == 'x' && encoding[3] == '\0')
                return BufferEncodingType::hex;
        if (WTF::equalIgnoringASCIICase(encoding, "hex"_s))
            return BufferEncodingType::hex;
        break;
    }

    return std::nullopt;
}
template<> const char* expectedEnumerationValues<BufferEncodingType>()
{
    return "\"utf8\", \"ucs2\", \"utf16le\", \"latin1\", \"ascii\", \"base64\", \"base64url\", \"hex\", \"buffer\"";
}

} // namespace WebCore
