//clang-format off
/*
 * Copyright (c) 2016 Apple Inc. All rights reserved.
 * Copyright (c) 2022 Codeblog Corp. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#pragma once

#include <JavaScriptCore/BuiltinUtils.h>
#include <JavaScriptCore/Identifier.h>
#include <JavaScriptCore/JSFunction.h>
#include <JavaScriptCore/UnlinkedFunctionExecutable.h>

namespace JSC {
class FunctionExecutable;
}

namespace WebCore {

/* JSBufferPrototype */
extern const char* const s_jsBufferPrototypeSetBigUint64Code;
extern const int s_jsBufferPrototypeSetBigUint64CodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeSetBigUint64CodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeSetBigUint64CodeConstructorKind;
extern const char* const s_jsBufferPrototypeReadInt8Code;
extern const int s_jsBufferPrototypeReadInt8CodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeReadInt8CodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeReadInt8CodeConstructorKind;
extern const char* const s_jsBufferPrototypeReadUInt8Code;
extern const int s_jsBufferPrototypeReadUInt8CodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeReadUInt8CodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeReadUInt8CodeConstructorKind;
extern const char* const s_jsBufferPrototypeReadInt16LECode;
extern const int s_jsBufferPrototypeReadInt16LECodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeReadInt16LECodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeReadInt16LECodeConstructorKind;
extern const char* const s_jsBufferPrototypeReadInt16BECode;
extern const int s_jsBufferPrototypeReadInt16BECodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeReadInt16BECodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeReadInt16BECodeConstructorKind;
extern const char* const s_jsBufferPrototypeReadUInt16LECode;
extern const int s_jsBufferPrototypeReadUInt16LECodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeReadUInt16LECodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeReadUInt16LECodeConstructorKind;
extern const char* const s_jsBufferPrototypeReadUInt16BECode;
extern const int s_jsBufferPrototypeReadUInt16BECodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeReadUInt16BECodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeReadUInt16BECodeConstructorKind;
extern const char* const s_jsBufferPrototypeReadInt32LECode;
extern const int s_jsBufferPrototypeReadInt32LECodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeReadInt32LECodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeReadInt32LECodeConstructorKind;
extern const char* const s_jsBufferPrototypeReadInt32BECode;
extern const int s_jsBufferPrototypeReadInt32BECodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeReadInt32BECodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeReadInt32BECodeConstructorKind;
extern const char* const s_jsBufferPrototypeReadUInt32LECode;
extern const int s_jsBufferPrototypeReadUInt32LECodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeReadUInt32LECodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeReadUInt32LECodeConstructorKind;
extern const char* const s_jsBufferPrototypeReadUInt32BECode;
extern const int s_jsBufferPrototypeReadUInt32BECodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeReadUInt32BECodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeReadUInt32BECodeConstructorKind;
extern const char* const s_jsBufferPrototypeReadFloatLECode;
extern const int s_jsBufferPrototypeReadFloatLECodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeReadFloatLECodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeReadFloatLECodeConstructorKind;
extern const char* const s_jsBufferPrototypeReadFloatBECode;
extern const int s_jsBufferPrototypeReadFloatBECodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeReadFloatBECodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeReadFloatBECodeConstructorKind;
extern const char* const s_jsBufferPrototypeReadDoubleLECode;
extern const int s_jsBufferPrototypeReadDoubleLECodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeReadDoubleLECodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeReadDoubleLECodeConstructorKind;
extern const char* const s_jsBufferPrototypeReadDoubleBECode;
extern const int s_jsBufferPrototypeReadDoubleBECodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeReadDoubleBECodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeReadDoubleBECodeConstructorKind;
extern const char* const s_jsBufferPrototypeReadBigInt64LECode;
extern const int s_jsBufferPrototypeReadBigInt64LECodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeReadBigInt64LECodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeReadBigInt64LECodeConstructorKind;
extern const char* const s_jsBufferPrototypeReadBigInt64BECode;
extern const int s_jsBufferPrototypeReadBigInt64BECodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeReadBigInt64BECodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeReadBigInt64BECodeConstructorKind;
extern const char* const s_jsBufferPrototypeReadBigUInt64LECode;
extern const int s_jsBufferPrototypeReadBigUInt64LECodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeReadBigUInt64LECodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeReadBigUInt64LECodeConstructorKind;
extern const char* const s_jsBufferPrototypeReadBigUInt64BECode;
extern const int s_jsBufferPrototypeReadBigUInt64BECodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeReadBigUInt64BECodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeReadBigUInt64BECodeConstructorKind;
extern const char* const s_jsBufferPrototypeWriteInt8Code;
extern const int s_jsBufferPrototypeWriteInt8CodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeWriteInt8CodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeWriteInt8CodeConstructorKind;
extern const char* const s_jsBufferPrototypeWriteUInt8Code;
extern const int s_jsBufferPrototypeWriteUInt8CodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeWriteUInt8CodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeWriteUInt8CodeConstructorKind;
extern const char* const s_jsBufferPrototypeWriteInt16LECode;
extern const int s_jsBufferPrototypeWriteInt16LECodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeWriteInt16LECodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeWriteInt16LECodeConstructorKind;
extern const char* const s_jsBufferPrototypeWriteInt16BECode;
extern const int s_jsBufferPrototypeWriteInt16BECodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeWriteInt16BECodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeWriteInt16BECodeConstructorKind;
extern const char* const s_jsBufferPrototypeWriteUInt16LECode;
extern const int s_jsBufferPrototypeWriteUInt16LECodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeWriteUInt16LECodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeWriteUInt16LECodeConstructorKind;
extern const char* const s_jsBufferPrototypeWriteUInt16BECode;
extern const int s_jsBufferPrototypeWriteUInt16BECodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeWriteUInt16BECodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeWriteUInt16BECodeConstructorKind;
extern const char* const s_jsBufferPrototypeWriteInt32LECode;
extern const int s_jsBufferPrototypeWriteInt32LECodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeWriteInt32LECodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeWriteInt32LECodeConstructorKind;
extern const char* const s_jsBufferPrototypeWriteInt32BECode;
extern const int s_jsBufferPrototypeWriteInt32BECodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeWriteInt32BECodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeWriteInt32BECodeConstructorKind;
extern const char* const s_jsBufferPrototypeWriteUInt32LECode;
extern const int s_jsBufferPrototypeWriteUInt32LECodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeWriteUInt32LECodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeWriteUInt32LECodeConstructorKind;
extern const char* const s_jsBufferPrototypeWriteUInt32BECode;
extern const int s_jsBufferPrototypeWriteUInt32BECodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeWriteUInt32BECodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeWriteUInt32BECodeConstructorKind;
extern const char* const s_jsBufferPrototypeWriteFloatLECode;
extern const int s_jsBufferPrototypeWriteFloatLECodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeWriteFloatLECodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeWriteFloatLECodeConstructorKind;
extern const char* const s_jsBufferPrototypeWriteFloatBECode;
extern const int s_jsBufferPrototypeWriteFloatBECodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeWriteFloatBECodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeWriteFloatBECodeConstructorKind;
extern const char* const s_jsBufferPrototypeWriteDoubleLECode;
extern const int s_jsBufferPrototypeWriteDoubleLECodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeWriteDoubleLECodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeWriteDoubleLECodeConstructorKind;
extern const char* const s_jsBufferPrototypeWriteDoubleBECode;
extern const int s_jsBufferPrototypeWriteDoubleBECodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeWriteDoubleBECodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeWriteDoubleBECodeConstructorKind;
extern const char* const s_jsBufferPrototypeWriteBigInt64LECode;
extern const int s_jsBufferPrototypeWriteBigInt64LECodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeWriteBigInt64LECodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeWriteBigInt64LECodeConstructorKind;
extern const char* const s_jsBufferPrototypeWriteBigInt64BECode;
extern const int s_jsBufferPrototypeWriteBigInt64BECodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeWriteBigInt64BECodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeWriteBigInt64BECodeConstructorKind;
extern const char* const s_jsBufferPrototypeWriteBigUInt64LECode;
extern const int s_jsBufferPrototypeWriteBigUInt64LECodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeWriteBigUInt64LECodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeWriteBigUInt64LECodeConstructorKind;
extern const char* const s_jsBufferPrototypeWriteBigUInt64BECode;
extern const int s_jsBufferPrototypeWriteBigUInt64BECodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeWriteBigUInt64BECodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeWriteBigUInt64BECodeConstructorKind;
extern const char* const s_jsBufferPrototypeSliceCode;
extern const int s_jsBufferPrototypeSliceCodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeSliceCodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeSliceCodeConstructorKind;
extern const char* const s_jsBufferPrototypeUtf8WriteCode;
extern const int s_jsBufferPrototypeUtf8WriteCodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeUtf8WriteCodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeUtf8WriteCodeConstructorKind;
extern const char* const s_jsBufferPrototypeUcs2WriteCode;
extern const int s_jsBufferPrototypeUcs2WriteCodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeUcs2WriteCodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeUcs2WriteCodeConstructorKind;
extern const char* const s_jsBufferPrototypeUtf16leWriteCode;
extern const int s_jsBufferPrototypeUtf16leWriteCodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeUtf16leWriteCodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeUtf16leWriteCodeConstructorKind;
extern const char* const s_jsBufferPrototypeLatin1WriteCode;
extern const int s_jsBufferPrototypeLatin1WriteCodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeLatin1WriteCodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeLatin1WriteCodeConstructorKind;
extern const char* const s_jsBufferPrototypeAsciiWriteCode;
extern const int s_jsBufferPrototypeAsciiWriteCodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeAsciiWriteCodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeAsciiWriteCodeConstructorKind;
extern const char* const s_jsBufferPrototypeBase64WriteCode;
extern const int s_jsBufferPrototypeBase64WriteCodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeBase64WriteCodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeBase64WriteCodeConstructorKind;
extern const char* const s_jsBufferPrototypeBase64urlWriteCode;
extern const int s_jsBufferPrototypeBase64urlWriteCodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeBase64urlWriteCodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeBase64urlWriteCodeConstructorKind;
extern const char* const s_jsBufferPrototypeHexWriteCode;
extern const int s_jsBufferPrototypeHexWriteCodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeHexWriteCodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeHexWriteCodeConstructorKind;
extern const char* const s_jsBufferPrototypeUtf8SliceCode;
extern const int s_jsBufferPrototypeUtf8SliceCodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeUtf8SliceCodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeUtf8SliceCodeConstructorKind;
extern const char* const s_jsBufferPrototypeUcs2SliceCode;
extern const int s_jsBufferPrototypeUcs2SliceCodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeUcs2SliceCodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeUcs2SliceCodeConstructorKind;
extern const char* const s_jsBufferPrototypeUtf16leSliceCode;
extern const int s_jsBufferPrototypeUtf16leSliceCodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeUtf16leSliceCodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeUtf16leSliceCodeConstructorKind;
extern const char* const s_jsBufferPrototypeLatin1SliceCode;
extern const int s_jsBufferPrototypeLatin1SliceCodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeLatin1SliceCodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeLatin1SliceCodeConstructorKind;
extern const char* const s_jsBufferPrototypeAsciiSliceCode;
extern const int s_jsBufferPrototypeAsciiSliceCodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeAsciiSliceCodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeAsciiSliceCodeConstructorKind;
extern const char* const s_jsBufferPrototypeBase64SliceCode;
extern const int s_jsBufferPrototypeBase64SliceCodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeBase64SliceCodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeBase64SliceCodeConstructorKind;
extern const char* const s_jsBufferPrototypeBase64urlSliceCode;
extern const int s_jsBufferPrototypeBase64urlSliceCodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeBase64urlSliceCodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeBase64urlSliceCodeConstructorKind;
extern const char* const s_jsBufferPrototypeHexSliceCode;
extern const int s_jsBufferPrototypeHexSliceCodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeHexSliceCodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeHexSliceCodeConstructorKind;
extern const char* const s_jsBufferPrototypeToJSONCode;
extern const int s_jsBufferPrototypeToJSONCodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeToJSONCodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeToJSONCodeConstructorKind;
extern const char* const s_jsBufferPrototypeSubarrayCode;
extern const int s_jsBufferPrototypeSubarrayCodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeSubarrayCodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeSubarrayCodeConstructorKind;
extern const char* const s_jsBufferPrototypeInitializeBunBufferCode;
extern const int s_jsBufferPrototypeInitializeBunBufferCodeLength;
extern const JSC::ConstructAbility s_jsBufferPrototypeInitializeBunBufferCodeConstructAbility;
extern const JSC::ConstructorKind s_jsBufferPrototypeInitializeBunBufferCodeConstructorKind;

#define WEBCORE_FOREACH_JSBUFFERPROTOTYPE_BUILTIN_DATA(macro) \
    macro(setBigUint64, jsBufferPrototypeSetBigUint64, 3) \
    macro(readInt8, jsBufferPrototypeReadInt8, 1) \
    macro(readUInt8, jsBufferPrototypeReadUInt8, 1) \
    macro(readInt16LE, jsBufferPrototypeReadInt16LE, 1) \
    macro(readInt16BE, jsBufferPrototypeReadInt16BE, 1) \
    macro(readUInt16LE, jsBufferPrototypeReadUInt16LE, 1) \
    macro(readUInt16BE, jsBufferPrototypeReadUInt16BE, 1) \
    macro(readInt32LE, jsBufferPrototypeReadInt32LE, 1) \
    macro(readInt32BE, jsBufferPrototypeReadInt32BE, 1) \
    macro(readUInt32LE, jsBufferPrototypeReadUInt32LE, 1) \
    macro(readUInt32BE, jsBufferPrototypeReadUInt32BE, 1) \
    macro(readFloatLE, jsBufferPrototypeReadFloatLE, 1) \
    macro(readFloatBE, jsBufferPrototypeReadFloatBE, 1) \
    macro(readDoubleLE, jsBufferPrototypeReadDoubleLE, 1) \
    macro(readDoubleBE, jsBufferPrototypeReadDoubleBE, 1) \
    macro(readBigInt64LE, jsBufferPrototypeReadBigInt64LE, 1) \
    macro(readBigInt64BE, jsBufferPrototypeReadBigInt64BE, 1) \
    macro(readBigUInt64LE, jsBufferPrototypeReadBigUInt64LE, 1) \
    macro(readBigUInt64BE, jsBufferPrototypeReadBigUInt64BE, 1) \
    macro(writeInt8, jsBufferPrototypeWriteInt8, 2) \
    macro(writeUInt8, jsBufferPrototypeWriteUInt8, 2) \
    macro(writeInt16LE, jsBufferPrototypeWriteInt16LE, 2) \
    macro(writeInt16BE, jsBufferPrototypeWriteInt16BE, 2) \
    macro(writeUInt16LE, jsBufferPrototypeWriteUInt16LE, 2) \
    macro(writeUInt16BE, jsBufferPrototypeWriteUInt16BE, 2) \
    macro(writeInt32LE, jsBufferPrototypeWriteInt32LE, 2) \
    macro(writeInt32BE, jsBufferPrototypeWriteInt32BE, 2) \
    macro(writeUInt32LE, jsBufferPrototypeWriteUInt32LE, 2) \
    macro(writeUInt32BE, jsBufferPrototypeWriteUInt32BE, 2) \
    macro(writeFloatLE, jsBufferPrototypeWriteFloatLE, 2) \
    macro(writeFloatBE, jsBufferPrototypeWriteFloatBE, 2) \
    macro(writeDoubleLE, jsBufferPrototypeWriteDoubleLE, 2) \
    macro(writeDoubleBE, jsBufferPrototypeWriteDoubleBE, 2) \
    macro(writeBigInt64LE, jsBufferPrototypeWriteBigInt64LE, 2) \
    macro(writeBigInt64BE, jsBufferPrototypeWriteBigInt64BE, 2) \
    macro(writeBigUInt64LE, jsBufferPrototypeWriteBigUInt64LE, 2) \
    macro(writeBigUInt64BE, jsBufferPrototypeWriteBigUInt64BE, 2) \
    macro(slice, jsBufferPrototypeSlice, 2) \
    macro(utf8Write, jsBufferPrototypeUtf8Write, 3) \
    macro(ucs2Write, jsBufferPrototypeUcs2Write, 3) \
    macro(utf16leWrite, jsBufferPrototypeUtf16leWrite, 3) \
    macro(latin1Write, jsBufferPrototypeLatin1Write, 3) \
    macro(asciiWrite, jsBufferPrototypeAsciiWrite, 3) \
    macro(base64Write, jsBufferPrototypeBase64Write, 3) \
    macro(base64urlWrite, jsBufferPrototypeBase64urlWrite, 3) \
    macro(hexWrite, jsBufferPrototypeHexWrite, 3) \
    macro(utf8Slice, jsBufferPrototypeUtf8Slice, 2) \
    macro(ucs2Slice, jsBufferPrototypeUcs2Slice, 2) \
    macro(utf16leSlice, jsBufferPrototypeUtf16leSlice, 2) \
    macro(latin1Slice, jsBufferPrototypeLatin1Slice, 2) \
    macro(asciiSlice, jsBufferPrototypeAsciiSlice, 2) \
    macro(base64Slice, jsBufferPrototypeBase64Slice, 2) \
    macro(base64urlSlice, jsBufferPrototypeBase64urlSlice, 2) \
    macro(hexSlice, jsBufferPrototypeHexSlice, 2) \
    macro(toJSON, jsBufferPrototypeToJSON, 0) \
    macro(subarray, jsBufferPrototypeSubarray, 2) \
    macro(initializeBunBuffer, jsBufferPrototypeInitializeBunBuffer, 1) \

#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_SETBIGUINT64 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_READINT8 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_READUINT8 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_READINT16LE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_READINT16BE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_READUINT16LE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_READUINT16BE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_READINT32LE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_READINT32BE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_READUINT32LE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_READUINT32BE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_READFLOATLE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_READFLOATBE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_READDOUBLELE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_READDOUBLEBE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_READBIGINT64LE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_READBIGINT64BE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_READBIGUINT64LE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_READBIGUINT64BE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_WRITEINT8 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_WRITEUINT8 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_WRITEINT16LE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_WRITEINT16BE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_WRITEUINT16LE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_WRITEUINT16BE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_WRITEINT32LE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_WRITEINT32BE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_WRITEUINT32LE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_WRITEUINT32BE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_WRITEFLOATLE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_WRITEFLOATBE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_WRITEDOUBLELE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_WRITEDOUBLEBE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_WRITEBIGINT64LE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_WRITEBIGINT64BE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_WRITEBIGUINT64LE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_WRITEBIGUINT64BE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_SLICE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_UTF8WRITE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_UCS2WRITE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_UTF16LEWRITE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_LATIN1WRITE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_ASCIIWRITE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_BASE64WRITE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_BASE64URLWRITE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_HEXWRITE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_UTF8SLICE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_UCS2SLICE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_UTF16LESLICE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_LATIN1SLICE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_ASCIISLICE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_BASE64SLICE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_BASE64URLSLICE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_HEXSLICE 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_TOJSON 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_SUBARRAY 1
#define WEBCORE_BUILTIN_JSBUFFERPROTOTYPE_INITIALIZEBUNBUFFER 1

#define WEBCORE_FOREACH_JSBUFFERPROTOTYPE_BUILTIN_CODE(macro) \
    macro(jsBufferPrototypeSetBigUint64Code, setBigUint64, ASCIILiteral(), s_jsBufferPrototypeSetBigUint64CodeLength) \
    macro(jsBufferPrototypeReadInt8Code, readInt8, ASCIILiteral(), s_jsBufferPrototypeReadInt8CodeLength) \
    macro(jsBufferPrototypeReadUInt8Code, readUInt8, ASCIILiteral(), s_jsBufferPrototypeReadUInt8CodeLength) \
    macro(jsBufferPrototypeReadInt16LECode, readInt16LE, ASCIILiteral(), s_jsBufferPrototypeReadInt16LECodeLength) \
    macro(jsBufferPrototypeReadInt16BECode, readInt16BE, ASCIILiteral(), s_jsBufferPrototypeReadInt16BECodeLength) \
    macro(jsBufferPrototypeReadUInt16LECode, readUInt16LE, ASCIILiteral(), s_jsBufferPrototypeReadUInt16LECodeLength) \
    macro(jsBufferPrototypeReadUInt16BECode, readUInt16BE, ASCIILiteral(), s_jsBufferPrototypeReadUInt16BECodeLength) \
    macro(jsBufferPrototypeReadInt32LECode, readInt32LE, ASCIILiteral(), s_jsBufferPrototypeReadInt32LECodeLength) \
    macro(jsBufferPrototypeReadInt32BECode, readInt32BE, ASCIILiteral(), s_jsBufferPrototypeReadInt32BECodeLength) \
    macro(jsBufferPrototypeReadUInt32LECode, readUInt32LE, ASCIILiteral(), s_jsBufferPrototypeReadUInt32LECodeLength) \
    macro(jsBufferPrototypeReadUInt32BECode, readUInt32BE, ASCIILiteral(), s_jsBufferPrototypeReadUInt32BECodeLength) \
    macro(jsBufferPrototypeReadFloatLECode, readFloatLE, ASCIILiteral(), s_jsBufferPrototypeReadFloatLECodeLength) \
    macro(jsBufferPrototypeReadFloatBECode, readFloatBE, ASCIILiteral(), s_jsBufferPrototypeReadFloatBECodeLength) \
    macro(jsBufferPrototypeReadDoubleLECode, readDoubleLE, ASCIILiteral(), s_jsBufferPrototypeReadDoubleLECodeLength) \
    macro(jsBufferPrototypeReadDoubleBECode, readDoubleBE, ASCIILiteral(), s_jsBufferPrototypeReadDoubleBECodeLength) \
    macro(jsBufferPrototypeReadBigInt64LECode, readBigInt64LE, ASCIILiteral(), s_jsBufferPrototypeReadBigInt64LECodeLength) \
    macro(jsBufferPrototypeReadBigInt64BECode, readBigInt64BE, ASCIILiteral(), s_jsBufferPrototypeReadBigInt64BECodeLength) \
    macro(jsBufferPrototypeReadBigUInt64LECode, readBigUInt64LE, ASCIILiteral(), s_jsBufferPrototypeReadBigUInt64LECodeLength) \
    macro(jsBufferPrototypeReadBigUInt64BECode, readBigUInt64BE, ASCIILiteral(), s_jsBufferPrototypeReadBigUInt64BECodeLength) \
    macro(jsBufferPrototypeWriteInt8Code, writeInt8, ASCIILiteral(), s_jsBufferPrototypeWriteInt8CodeLength) \
    macro(jsBufferPrototypeWriteUInt8Code, writeUInt8, ASCIILiteral(), s_jsBufferPrototypeWriteUInt8CodeLength) \
    macro(jsBufferPrototypeWriteInt16LECode, writeInt16LE, ASCIILiteral(), s_jsBufferPrototypeWriteInt16LECodeLength) \
    macro(jsBufferPrototypeWriteInt16BECode, writeInt16BE, ASCIILiteral(), s_jsBufferPrototypeWriteInt16BECodeLength) \
    macro(jsBufferPrototypeWriteUInt16LECode, writeUInt16LE, ASCIILiteral(), s_jsBufferPrototypeWriteUInt16LECodeLength) \
    macro(jsBufferPrototypeWriteUInt16BECode, writeUInt16BE, ASCIILiteral(), s_jsBufferPrototypeWriteUInt16BECodeLength) \
    macro(jsBufferPrototypeWriteInt32LECode, writeInt32LE, ASCIILiteral(), s_jsBufferPrototypeWriteInt32LECodeLength) \
    macro(jsBufferPrototypeWriteInt32BECode, writeInt32BE, ASCIILiteral(), s_jsBufferPrototypeWriteInt32BECodeLength) \
    macro(jsBufferPrototypeWriteUInt32LECode, writeUInt32LE, ASCIILiteral(), s_jsBufferPrototypeWriteUInt32LECodeLength) \
    macro(jsBufferPrototypeWriteUInt32BECode, writeUInt32BE, ASCIILiteral(), s_jsBufferPrototypeWriteUInt32BECodeLength) \
    macro(jsBufferPrototypeWriteFloatLECode, writeFloatLE, ASCIILiteral(), s_jsBufferPrototypeWriteFloatLECodeLength) \
    macro(jsBufferPrototypeWriteFloatBECode, writeFloatBE, ASCIILiteral(), s_jsBufferPrototypeWriteFloatBECodeLength) \
    macro(jsBufferPrototypeWriteDoubleLECode, writeDoubleLE, ASCIILiteral(), s_jsBufferPrototypeWriteDoubleLECodeLength) \
    macro(jsBufferPrototypeWriteDoubleBECode, writeDoubleBE, ASCIILiteral(), s_jsBufferPrototypeWriteDoubleBECodeLength) \
    macro(jsBufferPrototypeWriteBigInt64LECode, writeBigInt64LE, ASCIILiteral(), s_jsBufferPrototypeWriteBigInt64LECodeLength) \
    macro(jsBufferPrototypeWriteBigInt64BECode, writeBigInt64BE, ASCIILiteral(), s_jsBufferPrototypeWriteBigInt64BECodeLength) \
    macro(jsBufferPrototypeWriteBigUInt64LECode, writeBigUInt64LE, ASCIILiteral(), s_jsBufferPrototypeWriteBigUInt64LECodeLength) \
    macro(jsBufferPrototypeWriteBigUInt64BECode, writeBigUInt64BE, ASCIILiteral(), s_jsBufferPrototypeWriteBigUInt64BECodeLength) \
    macro(jsBufferPrototypeSliceCode, slice, ASCIILiteral(), s_jsBufferPrototypeSliceCodeLength) \
    macro(jsBufferPrototypeUtf8WriteCode, utf8Write, ASCIILiteral(), s_jsBufferPrototypeUtf8WriteCodeLength) \
    macro(jsBufferPrototypeUcs2WriteCode, ucs2Write, ASCIILiteral(), s_jsBufferPrototypeUcs2WriteCodeLength) \
    macro(jsBufferPrototypeUtf16leWriteCode, utf16leWrite, ASCIILiteral(), s_jsBufferPrototypeUtf16leWriteCodeLength) \
    macro(jsBufferPrototypeLatin1WriteCode, latin1Write, ASCIILiteral(), s_jsBufferPrototypeLatin1WriteCodeLength) \
    macro(jsBufferPrototypeAsciiWriteCode, asciiWrite, ASCIILiteral(), s_jsBufferPrototypeAsciiWriteCodeLength) \
    macro(jsBufferPrototypeBase64WriteCode, base64Write, ASCIILiteral(), s_jsBufferPrototypeBase64WriteCodeLength) \
    macro(jsBufferPrototypeBase64urlWriteCode, base64urlWrite, ASCIILiteral(), s_jsBufferPrototypeBase64urlWriteCodeLength) \
    macro(jsBufferPrototypeHexWriteCode, hexWrite, ASCIILiteral(), s_jsBufferPrototypeHexWriteCodeLength) \
    macro(jsBufferPrototypeUtf8SliceCode, utf8Slice, ASCIILiteral(), s_jsBufferPrototypeUtf8SliceCodeLength) \
    macro(jsBufferPrototypeUcs2SliceCode, ucs2Slice, ASCIILiteral(), s_jsBufferPrototypeUcs2SliceCodeLength) \
    macro(jsBufferPrototypeUtf16leSliceCode, utf16leSlice, ASCIILiteral(), s_jsBufferPrototypeUtf16leSliceCodeLength) \
    macro(jsBufferPrototypeLatin1SliceCode, latin1Slice, ASCIILiteral(), s_jsBufferPrototypeLatin1SliceCodeLength) \
    macro(jsBufferPrototypeAsciiSliceCode, asciiSlice, ASCIILiteral(), s_jsBufferPrototypeAsciiSliceCodeLength) \
    macro(jsBufferPrototypeBase64SliceCode, base64Slice, ASCIILiteral(), s_jsBufferPrototypeBase64SliceCodeLength) \
    macro(jsBufferPrototypeBase64urlSliceCode, base64urlSlice, ASCIILiteral(), s_jsBufferPrototypeBase64urlSliceCodeLength) \
    macro(jsBufferPrototypeHexSliceCode, hexSlice, ASCIILiteral(), s_jsBufferPrototypeHexSliceCodeLength) \
    macro(jsBufferPrototypeToJSONCode, toJSON, ASCIILiteral(), s_jsBufferPrototypeToJSONCodeLength) \
    macro(jsBufferPrototypeSubarrayCode, subarray, ASCIILiteral(), s_jsBufferPrototypeSubarrayCodeLength) \
    macro(jsBufferPrototypeInitializeBunBufferCode, initializeBunBuffer, ASCIILiteral(), s_jsBufferPrototypeInitializeBunBufferCodeLength) \

#define WEBCORE_FOREACH_JSBUFFERPROTOTYPE_BUILTIN_FUNCTION_NAME(macro) \
    macro(asciiSlice) \
    macro(asciiWrite) \
    macro(base64Slice) \
    macro(base64Write) \
    macro(base64urlSlice) \
    macro(base64urlWrite) \
    macro(hexSlice) \
    macro(hexWrite) \
    macro(initializeBunBuffer) \
    macro(latin1Slice) \
    macro(latin1Write) \
    macro(readBigInt64BE) \
    macro(readBigInt64LE) \
    macro(readBigUInt64BE) \
    macro(readBigUInt64LE) \
    macro(readDoubleBE) \
    macro(readDoubleLE) \
    macro(readFloatBE) \
    macro(readFloatLE) \
    macro(readInt16BE) \
    macro(readInt16LE) \
    macro(readInt32BE) \
    macro(readInt32LE) \
    macro(readInt8) \
    macro(readUInt16BE) \
    macro(readUInt16LE) \
    macro(readUInt32BE) \
    macro(readUInt32LE) \
    macro(readUInt8) \
    macro(setBigUint64) \
    macro(slice) \
    macro(subarray) \
    macro(toJSON) \
    macro(ucs2Slice) \
    macro(ucs2Write) \
    macro(utf16leSlice) \
    macro(utf16leWrite) \
    macro(utf8Slice) \
    macro(utf8Write) \
    macro(writeBigInt64BE) \
    macro(writeBigInt64LE) \
    macro(writeBigUInt64BE) \
    macro(writeBigUInt64LE) \
    macro(writeDoubleBE) \
    macro(writeDoubleLE) \
    macro(writeFloatBE) \
    macro(writeFloatLE) \
    macro(writeInt16BE) \
    macro(writeInt16LE) \
    macro(writeInt32BE) \
    macro(writeInt32LE) \
    macro(writeInt8) \
    macro(writeUInt16BE) \
    macro(writeUInt16LE) \
    macro(writeUInt32BE) \
    macro(writeUInt32LE) \
    macro(writeUInt8) \

#define DECLARE_BUILTIN_GENERATOR(codeName, functionName, overriddenName, argumentCount) \
    JSC::FunctionExecutable* codeName##Generator(JSC::VM&);

WEBCORE_FOREACH_JSBUFFERPROTOTYPE_BUILTIN_CODE(DECLARE_BUILTIN_GENERATOR)
#undef DECLARE_BUILTIN_GENERATOR

class JSBufferPrototypeBuiltinsWrapper : private JSC::WeakHandleOwner {
public:
    explicit JSBufferPrototypeBuiltinsWrapper(JSC::VM& vm)
        : m_vm(vm)
        WEBCORE_FOREACH_JSBUFFERPROTOTYPE_BUILTIN_FUNCTION_NAME(INITIALIZE_BUILTIN_NAMES)
#define INITIALIZE_BUILTIN_SOURCE_MEMBERS(name, functionName, overriddenName, length) , m_##name##Source(JSC::makeSource(StringImpl::createWithoutCopying(s_##name, length), { }))
        WEBCORE_FOREACH_JSBUFFERPROTOTYPE_BUILTIN_CODE(INITIALIZE_BUILTIN_SOURCE_MEMBERS)
#undef INITIALIZE_BUILTIN_SOURCE_MEMBERS
    {
    }

#define EXPOSE_BUILTIN_EXECUTABLES(name, functionName, overriddenName, length) \
    JSC::UnlinkedFunctionExecutable* name##Executable(); \
    const JSC::SourceCode& name##Source() const { return m_##name##Source; }
    WEBCORE_FOREACH_JSBUFFERPROTOTYPE_BUILTIN_CODE(EXPOSE_BUILTIN_EXECUTABLES)
#undef EXPOSE_BUILTIN_EXECUTABLES

    WEBCORE_FOREACH_JSBUFFERPROTOTYPE_BUILTIN_FUNCTION_NAME(DECLARE_BUILTIN_IDENTIFIER_ACCESSOR)

    void exportNames();

private:
    JSC::VM& m_vm;

    WEBCORE_FOREACH_JSBUFFERPROTOTYPE_BUILTIN_FUNCTION_NAME(DECLARE_BUILTIN_NAMES)

#define DECLARE_BUILTIN_SOURCE_MEMBERS(name, functionName, overriddenName, length) \
    JSC::SourceCode m_##name##Source;\
    JSC::Weak<JSC::UnlinkedFunctionExecutable> m_##name##Executable;
    WEBCORE_FOREACH_JSBUFFERPROTOTYPE_BUILTIN_CODE(DECLARE_BUILTIN_SOURCE_MEMBERS)
#undef DECLARE_BUILTIN_SOURCE_MEMBERS

};

#define DEFINE_BUILTIN_EXECUTABLES(name, functionName, overriddenName, length) \
inline JSC::UnlinkedFunctionExecutable* JSBufferPrototypeBuiltinsWrapper::name##Executable() \
{\
    if (!m_##name##Executable) {\
        JSC::Identifier executableName = functionName##PublicName();\
        if (overriddenName)\
            executableName = JSC::Identifier::fromString(m_vm, overriddenName);\
        m_##name##Executable = JSC::Weak<JSC::UnlinkedFunctionExecutable>(JSC::createBuiltinExecutable(m_vm, m_##name##Source, executableName, s_##name##ConstructorKind, s_##name##ConstructAbility), this, &m_##name##Executable);\
    }\
    return m_##name##Executable.get();\
}
WEBCORE_FOREACH_JSBUFFERPROTOTYPE_BUILTIN_CODE(DEFINE_BUILTIN_EXECUTABLES)
#undef DEFINE_BUILTIN_EXECUTABLES

inline void JSBufferPrototypeBuiltinsWrapper::exportNames()
{
#define EXPORT_FUNCTION_NAME(name) m_vm.propertyNames->appendExternalName(name##PublicName(), name##PrivateName());
    WEBCORE_FOREACH_JSBUFFERPROTOTYPE_BUILTIN_FUNCTION_NAME(EXPORT_FUNCTION_NAME)
#undef EXPORT_FUNCTION_NAME
}

} // namespace WebCore
