/**
 * @license React
 * react-dom-server.bun.production.min.js
 *
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
"use strict";
var aa = require("react");
function h(a) {
  let b = "https://reactjs.org/docs/error-decoder.html?invariant=" + a;
  for (let a = 1; a < arguments.length; a++)
    b += "&args[]=" + encodeURIComponent(arguments[a]);
  return (
    `Minified React error #${a}; visit ${b} for the full message or ` +
    "use the non-minified dev environment for full errors and additional helpful warnings."
  );
}
const ba = new TextEncoder();
function m(a) {
  return ba.encode(a);
}
const q = Object.prototype.hasOwnProperty,
  ca =
    /^[:A-Z_a-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD][:A-Z_a-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD\-.0-9\u00B7\u0300-\u036F\u203F-\u2040]*$/,
  ia = {},
  ja = {};
function ka(a) {
  if (q.call(ja, a)) return !0;
  if (q.call(ia, a)) return !1;
  if (ca.test(a)) return (ja[a] = !0);
  ia[a] = !0;
  return !1;
}
function u(a, b, c, d, e, f, g) {
  this.acceptsBooleans = 2 === b || 3 === b || 4 === b;
  this.attributeName = d;
  this.attributeNamespace = e;
  this.mustUseProperty = c;
  this.propertyName = a;
  this.type = b;
  this.sanitizeURL = f;
  this.removeEmptyString = g;
}
const v = {},
  la =
    "children dangerouslySetInnerHTML defaultValue defaultChecked innerHTML suppressContentEditableWarning suppressHydrationWarning style".split(
      " "
    );
la.push("innerText", "textContent");
la.forEach((a) => {
  v[a] = new u(a, 0, !1, a, null, !1, !1);
});
[
  ["acceptCharset", "accept-charset"],
  ["className", "class"],
  ["htmlFor", "for"],
  ["httpEquiv", "http-equiv"],
].forEach(([a, b]) => {
  v[a] = new u(a, 1, !1, b, null, !1, !1);
});
["contentEditable", "draggable", "spellCheck", "value"].forEach((a) => {
  v[a] = new u(a, 2, !1, a.toLowerCase(), null, !1, !1);
});
[
  "autoReverse",
  "externalResourcesRequired",
  "focusable",
  "preserveAlpha",
].forEach((a) => {
  v[a] = new u(a, 2, !1, a, null, !1, !1);
});
"allowFullScreen async autoFocus autoPlay controls default defer disabled disablePictureInPicture disableRemotePlayback formNoValidate hidden loop noModule noValidate open playsInline readOnly required reversed scoped seamless itemScope"
  .split(" ")
  .forEach((a) => {
    v[a] = new u(a, 3, !1, a.toLowerCase(), null, !1, !1);
  });
["checked", "multiple", "muted", "selected"].forEach((a) => {
  v[a] = new u(a, 3, !0, a, null, !1, !1);
});
["capture", "download"].forEach((a) => {
  v[a] = new u(a, 4, !1, a, null, !1, !1);
});
["cols", "rows", "size", "span"].forEach((a) => {
  v[a] = new u(a, 6, !1, a, null, !1, !1);
});
["rowSpan", "start"].forEach((a) => {
  v[a] = new u(a, 5, !1, a.toLowerCase(), null, !1, !1);
});
const ma = /[\-:]([a-z])/g,
  na = (a) => a[1].toUpperCase();
"accent-height alignment-baseline arabic-form baseline-shift cap-height clip-path clip-rule color-interpolation color-interpolation-filters color-profile color-rendering dominant-baseline enable-background fill-opacity fill-rule flood-color flood-opacity font-family font-size font-size-adjust font-stretch font-style font-variant font-weight glyph-name glyph-orientation-horizontal glyph-orientation-vertical horiz-adv-x horiz-origin-x image-rendering letter-spacing lighting-color marker-end marker-mid marker-start overline-position overline-thickness paint-order panose-1 pointer-events rendering-intent shape-rendering stop-color stop-opacity strikethrough-position strikethrough-thickness stroke-dasharray stroke-dashoffset stroke-linecap stroke-linejoin stroke-miterlimit stroke-opacity stroke-width text-anchor text-decoration text-rendering underline-position underline-thickness unicode-bidi unicode-range units-per-em v-alphabetic v-hanging v-ideographic v-mathematical vector-effect vert-adv-y vert-origin-x vert-origin-y word-spacing writing-mode xmlns:xlink x-height"
  .split(" ")
  .forEach((a) => {
    const b = a.replace(ma, na);
    v[b] = new u(b, 1, !1, a, null, !1, !1);
  });
"xlink:actuate xlink:arcrole xlink:role xlink:show xlink:title xlink:type"
  .split(" ")
  .forEach((a) => {
    const b = a.replace(ma, na);
    v[b] = new u(b, 1, !1, a, "http://www.w3.org/1999/xlink", !1, !1);
  });
["xml:base", "xml:lang", "xml:space"].forEach((a) => {
  const b = a.replace(ma, na);
  v[b] = new u(b, 1, !1, a, "http://www.w3.org/XML/1998/namespace", !1, !1);
});
["tabIndex", "crossOrigin"].forEach((a) => {
  v[a] = new u(a, 1, !1, a.toLowerCase(), null, !1, !1);
});
v.xlinkHref = new u(
  "xlinkHref",
  1,
  !1,
  "xlink:href",
  "http://www.w3.org/1999/xlink",
  !0,
  !1
);
["src", "href", "action", "formAction"].forEach((a) => {
  v[a] = new u(a, 1, !1, a.toLowerCase(), null, !0, !0);
});
const w = {
    animationIterationCount: !0,
    aspectRatio: !0,
    borderImageOutset: !0,
    borderImageSlice: !0,
    borderImageWidth: !0,
    boxFlex: !0,
    boxFlexGroup: !0,
    boxOrdinalGroup: !0,
    columnCount: !0,
    columns: !0,
    flex: !0,
    flexGrow: !0,
    flexPositive: !0,
    flexShrink: !0,
    flexNegative: !0,
    flexOrder: !0,
    gridArea: !0,
    gridRow: !0,
    gridRowEnd: !0,
    gridRowSpan: !0,
    gridRowStart: !0,
    gridColumn: !0,
    gridColumnEnd: !0,
    gridColumnSpan: !0,
    gridColumnStart: !0,
    fontWeight: !0,
    lineClamp: !0,
    lineHeight: !0,
    opacity: !0,
    order: !0,
    orphans: !0,
    tabSize: !0,
    widows: !0,
    zIndex: !0,
    zoom: !0,
    fillOpacity: !0,
    floodOpacity: !0,
    stopOpacity: !0,
    strokeDasharray: !0,
    strokeDashoffset: !0,
    strokeMiterlimit: !0,
    strokeOpacity: !0,
    strokeWidth: !0,
  },
  oa = ["Webkit", "ms", "Moz", "O"];
Object.keys(w).forEach(function (a) {
  oa.forEach(function (b) {
    b = b + a.charAt(0).toUpperCase() + a.substring(1);
    w[b] = w[a];
  });
});
const pa = global.Bun.escapeHTML;
function x(a) {
  return "boolean" === typeof a || "number" === typeof a ? "" + a : pa(a);
}
const qa = /([A-Z])/g,
  ra = /^ms-/,
  sa = Array.isArray,
  ta = m("<script>"),
  ua = m("\x3c/script>"),
  va = m('<script src="'),
  wa = m('<script type="module" src="'),
  xa = m('" async="">\x3c/script>'),
  ya = /(<\/|<)(s)(cript)/gi,
  za = (a, b, c, d) => `${b}${"s" === c ? "\\u0073" : "\\u0053"}${d}`;
function Aa(a, b, c, d, e) {
  a = void 0 === a ? "" : a;
  b = void 0 === b ? ta : m('<script nonce="' + x(b) + '">');
  const f = [];
  void 0 !== c && f.push(b, ("" + c).replace(ya, za), ua);
  if (void 0 !== d) for (c = 0; c < d.length; c++) f.push(va, x(d[c]), xa);
  if (void 0 !== e) for (d = 0; d < e.length; d++) f.push(wa, x(e[d]), xa);
  return {
    bootstrapChunks: f,
    startInlineScript: b,
    placeholderPrefix: m(a + "P:"),
    segmentPrefix: m(a + "S:"),
    boundaryPrefix: a + "B:",
    idPrefix: a,
    nextSuspenseID: 0,
    sentCompleteSegmentFunction: !1,
    sentCompleteBoundaryFunction: !1,
    sentClientRenderFunction: !1,
  };
}
function Ba(a) {
  return {
    insertionMode:
      "http://www.w3.org/2000/svg" === a
        ? 2
        : "http://www.w3.org/1998/Math/MathML" === a
        ? 3
        : 0,
    selectedValue: null,
  };
}
function Ca(a, b, c) {
  switch (b) {
    case "select":
      return {
        insertionMode: 1,
        selectedValue: null != c.value ? c.value : c.defaultValue,
      };
    case "svg":
      return { insertionMode: 2, selectedValue: null };
    case "math":
      return { insertionMode: 3, selectedValue: null };
    case "foreignObject":
      return { insertionMode: 1, selectedValue: null };
    case "table":
      return { insertionMode: 4, selectedValue: null };
    case "thead":
    case "tbody":
    case "tfoot":
      return { insertionMode: 5, selectedValue: null };
    case "colgroup":
      return { insertionMode: 7, selectedValue: null };
    case "tr":
      return { insertionMode: 6, selectedValue: null };
  }
  return 4 <= a.insertionMode || 0 === a.insertionMode
    ? { insertionMode: 1, selectedValue: null }
    : a;
}
const Da = m("\x3c!-- --\x3e");
function Ea(a, b, c, d) {
  if ("" === b) return d;
  d && a.push(Da);
  a.push(x(b));
  return !0;
}
const Fa = new Map(),
  Ga = m(' style="'),
  Ha = m(":"),
  Ia = m(";");
function Ja(a, b, c) {
  if ("object" !== typeof c) throw Error(h(62));
  b = !0;
  for (const g in c)
    if (q.call(c, g)) {
      var d = c[g];
      if (null != d && "boolean" !== typeof d && "" !== d) {
        var e = void 0;
        if (0 === g.indexOf("--")) (e = x(g)), (d = x(("" + d).trim()));
        else {
          e = g;
          var f = Fa.get(e);
          void 0 !== f
            ? (e = f)
            : ((f = m(
                x(e.replace(qa, "-$1").toLowerCase().replace(ra, "-ms-"))
              )),
              Fa.set(e, f),
              (e = f));
          d =
            "number" === typeof d
              ? 0 === d || q.call(w, g)
                ? "" + d
                : d + "px"
              : x(("" + d).trim());
        }
        b ? ((b = !1), a.push(Ga, e, Ha, d)) : a.push(Ia, e, Ha, d);
      }
    }
  b || a.push(y);
}
const z = m(" "),
  A = m('="'),
  y = m('"'),
  Ka = m('=""');
function B(a, b, c, d) {
  switch (c) {
    case "style":
      Ja(a, b, d);
      return;
    case "defaultValue":
    case "defaultChecked":
    case "innerHTML":
    case "suppressContentEditableWarning":
    case "suppressHydrationWarning":
      return;
  }
  if (
    !(2 < c.length) ||
    ("o" !== c[0] && "O" !== c[0]) ||
    ("n" !== c[1] && "N" !== c[1])
  )
    if (((b = v.hasOwnProperty(c) ? v[c] : null), null !== b)) {
      switch (typeof d) {
        case "function":
        case "symbol":
          return;
        case "boolean":
          if (!b.acceptsBooleans) return;
      }
      c = b.attributeName;
      switch (b.type) {
        case 3:
          d && a.push(z, c, Ka);
          break;
        case 4:
          !0 === d ? a.push(z, c, Ka) : !1 !== d && a.push(z, c, A, x(d), y);
          break;
        case 5:
          isNaN(d) || a.push(z, c, A, x(d), y);
          break;
        case 6:
          !isNaN(d) && 1 <= d && a.push(z, c, A, x(d), y);
          break;
        default:
          b.sanitizeURL && (d = "" + d), a.push(z, c, A, x(d), y);
      }
    } else if (ka(c)) {
      switch (typeof d) {
        case "function":
        case "symbol":
          return;
        case "boolean":
          if (
            ((b = c.toLowerCase().slice(0, 5)), "data-" !== b && "aria-" !== b)
          )
            return;
      }
      a.push(z, c, A, x(d), y);
    }
}
const C = m(">"),
  La = m("/>");
function D(a, b, c) {
  if (null != b) {
    if (null != c) throw Error(h(60));
    if ("object" !== typeof b || !("__html" in b)) throw Error(h(61));
    b = b.__html;
    null !== b && void 0 !== b && a.push("" + b);
  }
}
function Ma(a) {
  let b = "";
  aa.Children.forEach(a, function (a) {
    null != a && (b += a);
  });
  return b;
}
const Na = m(' selected=""');
function Oa(a, b, c, d) {
  a.push(E(c));
  let e = (c = null);
  for (const f in b)
    if (q.call(b, f)) {
      const g = b[f];
      if (null != g)
        switch (f) {
          case "children":
            c = g;
            break;
          case "dangerouslySetInnerHTML":
            e = g;
            break;
          default:
            B(a, d, f, g);
        }
    }
  a.push(C);
  D(a, e, c);
  return "string" === typeof c ? (a.push(x(c)), null) : c;
}
const Pa = m("\n"),
  Ra = /^[a-zA-Z][a-zA-Z:_\.\-\d]*$/,
  Sa = new Map();
function E(a) {
  let b = Sa.get(a);
  if (void 0 === b) {
    if (!Ra.test(a)) throw Error(h(65, a));
    b = m("<" + a);
    Sa.set(a, b);
  }
  return b;
}
const Ta = m("<!DOCTYPE html>");
function Ua(a, b, c, d, e) {
  switch (b) {
    case "select":
      a.push(E("select"));
      var f = null,
        g = null;
      for (var l in c)
        if (q.call(c, l)) {
          var k = c[l];
          if (null != k)
            switch (l) {
              case "children":
                f = k;
                break;
              case "dangerouslySetInnerHTML":
                g = k;
                break;
              case "defaultValue":
              case "value":
                break;
              default:
                B(a, d, l, k);
            }
        }
      a.push(C);
      D(a, g, f);
      return (a = f);
    case "option":
      g = e.selectedValue;
      a.push(E("option"));
      var n = (k = null),
        r = null;
      l = null;
      for (f in c)
        if (q.call(c, f)) {
          var t = c[f];
          if (null != t)
            switch (f) {
              case "children":
                k = t;
                break;
              case "selected":
                r = t;
                break;
              case "dangerouslySetInnerHTML":
                l = t;
                break;
              case "value":
                n = t;
              default:
                B(a, d, f, t);
            }
        }
      if (null != g)
        if (((c = null !== n ? "" + n : Ma(k)), sa(g)))
          for (d = 0; d < g.length; d++) {
            if ("" + g[d] === c) {
              a.push(Na);
              break;
            }
          }
        else "" + g === c && a.push(Na);
      else r && a.push(Na);
      a.push(C);
      D(a, l, k);
      return (a = k);
    case "textarea":
      a.push(E("textarea"));
      l = g = f = null;
      for (k in c)
        if (q.call(c, k) && ((n = c[k]), null != n))
          switch (k) {
            case "children":
              l = n;
              break;
            case "value":
              f = n;
              break;
            case "defaultValue":
              g = n;
              break;
            case "dangerouslySetInnerHTML":
              throw Error(h(91));
            default:
              B(a, d, k, n);
          }
      null === f && null !== g && (f = g);
      a.push(C);
      if (null != l) {
        if (null != f) throw Error(h(92));
        if (sa(l) && 1 < l.length) throw Error(h(93));
        f = "" + l;
      }
      "string" === typeof f && "\n" === f[0] && a.push(Pa);
      null !== f && a.push(x("" + f));
      return null;
    case "input":
      a.push(E("input"));
      n = l = k = f = null;
      for (g in c)
        if (q.call(c, g) && ((r = c[g]), null != r))
          switch (g) {
            case "children":
            case "dangerouslySetInnerHTML":
              throw Error(h(399, "input"));
            case "defaultChecked":
              n = r;
              break;
            case "defaultValue":
              k = r;
              break;
            case "checked":
              l = r;
              break;
            case "value":
              f = r;
              break;
            default:
              B(a, d, g, r);
          }
      null !== l ? B(a, d, "checked", l) : null !== n && B(a, d, "checked", n);
      null !== f ? B(a, d, "value", f) : null !== k && B(a, d, "value", k);
      a.push(La);
      return null;
    case "menuitem":
      a.push(E("menuitem"));
      for (const b in c)
        if (q.call(c, b) && ((f = c[b]), null != f))
          switch (b) {
            case "children":
            case "dangerouslySetInnerHTML":
              throw Error(h(400));
            default:
              B(a, d, b, f);
          }
      a.push(C);
      return null;
    case "title":
      a.push(E("title"));
      f = null;
      for (t in c)
        if (q.call(c, t) && ((g = c[t]), null != g))
          switch (t) {
            case "children":
              f = g;
              break;
            case "dangerouslySetInnerHTML":
              throw Error(h(434));
            default:
              B(a, d, t, g);
          }
      a.push(C);
      return (a = f);
    case "listing":
    case "pre":
      a.push(E(b));
      g = f = null;
      for (n in c)
        if (q.call(c, n) && ((k = c[n]), null != k))
          switch (n) {
            case "children":
              f = k;
              break;
            case "dangerouslySetInnerHTML":
              g = k;
              break;
            default:
              B(a, d, n, k);
          }
      a.push(C);
      if (null != g) {
        if (null != f) throw Error(h(60));
        if ("object" !== typeof g || !("__html" in g)) throw Error(h(61));
        c = g.__html;
        null !== c &&
          void 0 !== c &&
          ("string" === typeof c && 0 < c.length && "\n" === c[0]
            ? a.push(Pa, c)
            : a.push("" + c));
      }
      "string" === typeof f && "\n" === f[0] && a.push(Pa);
      return (a = f);
    case "area":
    case "base":
    case "br":
    case "col":
    case "embed":
    case "hr":
    case "img":
    case "keygen":
    case "link":
    case "meta":
    case "param":
    case "source":
    case "track":
    case "wbr":
      a.push(E(b));
      for (const e in c)
        if (q.call(c, e) && ((f = c[e]), null != f))
          switch (e) {
            case "children":
            case "dangerouslySetInnerHTML":
              throw Error(h(399, b));
            default:
              B(a, d, e, f);
          }
      a.push(La);
      return null;
    case "annotation-xml":
    case "color-profile":
    case "font-face":
    case "font-face-src":
    case "font-face-uri":
    case "font-face-format":
    case "font-face-name":
    case "missing-glyph":
      return Oa(a, c, b, d);
    case "html":
      return 0 === e.insertionMode && a.push(Ta), Oa(a, c, b, d);
    default:
      if (-1 === b.indexOf("-") && "string" !== typeof c.is)
        return Oa(a, c, b, d);
      a.push(E(b));
      g = f = null;
      for (r in c)
        if (
          q.call(c, r) &&
          ((k = c[r]),
          null != k &&
            "function" !== typeof k &&
            "object" !== typeof k &&
            !1 !== k)
        )
          switch (
            (!0 === k && (k = ""), "className" === r && (r = "class"), r)
          ) {
            case "children":
              f = k;
              break;
            case "dangerouslySetInnerHTML":
              g = k;
              break;
            case "style":
              Ja(a, d, k);
              break;
            case "suppressContentEditableWarning":
            case "suppressHydrationWarning":
              break;
            default:
              ka(r) &&
                "function" !== typeof k &&
                "symbol" !== typeof k &&
                a.push(z, r, A, x(k), y);
          }
      a.push(C);
      D(a, g, f);
      return (a = f);
  }
}
const Va = m("</"),
  Wa = m(">"),
  Xa = m('<template id="'),
  Ya = m('"></template>'),
  Za = m("\x3c!--$--\x3e"),
  $a = m('\x3c!--$?--\x3e<template id="'),
  ab = m('"></template>'),
  bb = m("\x3c!--$!--\x3e"),
  cb = m("\x3c!--/$--\x3e"),
  db = m("<template"),
  eb = m('"'),
  fb = m(' data-dgst="');
m(' data-msg="');
m(' data-stck="');
const gb = m("></template>");
function hb(a, b, c) {
  a.write($a);
  if (null === c) throw Error(h(395));
  a.write(c);
  return !!a.write(ab);
}
const ib = m('<div hidden id="'),
  jb = m('">'),
  kb = m("</div>"),
  lb = m('<svg aria-hidden="true" style="display:none" id="'),
  mb = m('">'),
  nb = m("</svg>"),
  ob = m('<math aria-hidden="true" style="display:none" id="'),
  pb = m('">'),
  qb = m("</math>"),
  rb = m('<table hidden id="'),
  sb = m('">'),
  tb = m("</table>"),
  ub = m('<table hidden><tbody id="'),
  vb = m('">'),
  xb = m("</tbody></table>"),
  yb = m('<table hidden><tr id="'),
  zb = m('">'),
  Ab = m("</tr></table>"),
  Bb = m('<table hidden><colgroup id="'),
  Cb = m('">'),
  Db = m("</colgroup></table>");
function Eb(a, b, c, d) {
  switch (c.insertionMode) {
    case 0:
    case 1:
      return (
        a.write(ib),
        a.write(b.segmentPrefix),
        (b = d.toString(16)),
        a.write(b),
        !!a.write(jb)
      );
    case 2:
      return (
        a.write(lb),
        a.write(b.segmentPrefix),
        (b = d.toString(16)),
        a.write(b),
        !!a.write(mb)
      );
    case 3:
      return (
        a.write(ob),
        a.write(b.segmentPrefix),
        (b = d.toString(16)),
        a.write(b),
        !!a.write(pb)
      );
    case 4:
      return (
        a.write(rb),
        a.write(b.segmentPrefix),
        (b = d.toString(16)),
        a.write(b),
        !!a.write(sb)
      );
    case 5:
      return (
        a.write(ub),
        a.write(b.segmentPrefix),
        (b = d.toString(16)),
        a.write(b),
        !!a.write(vb)
      );
    case 6:
      return (
        a.write(yb),
        a.write(b.segmentPrefix),
        (b = d.toString(16)),
        a.write(b),
        !!a.write(zb)
      );
    case 7:
      return (
        a.write(Bb),
        a.write(b.segmentPrefix),
        (b = d.toString(16)),
        a.write(b),
        !!a.write(Cb)
      );
    default:
      throw Error(h(397));
  }
}
function Fb(a, b) {
  switch (b.insertionMode) {
    case 0:
    case 1:
      return !!a.write(kb);
    case 2:
      return !!a.write(nb);
    case 3:
      return !!a.write(qb);
    case 4:
      return !!a.write(tb);
    case 5:
      return !!a.write(xb);
    case 6:
      return !!a.write(Ab);
    case 7:
      return !!a.write(Db);
    default:
      throw Error(h(397));
  }
}
const Gb = m(
    'function $RS(a,b){a=document.getElementById(a);b=document.getElementById(b);for(a.parentNode.removeChild(a);a.firstChild;)b.parentNode.insertBefore(a.firstChild,b);b.parentNode.removeChild(b)};$RS("'
  ),
  Hb = m('$RS("'),
  Ib = m('","'),
  Jb = m('")\x3c/script>'),
  Kb = m(
    'function $RC(a,b){a=document.getElementById(a);b=document.getElementById(b);b.parentNode.removeChild(b);if(a){a=a.previousSibling;var f=a.parentNode,c=a.nextSibling,e=0;do{if(c&&8===c.nodeType){var d=c.data;if("/$"===d)if(0===e)break;else e--;else"$"!==d&&"$?"!==d&&"$!"!==d||e++}d=c.nextSibling;f.removeChild(c);c=d}while(c);for(;b.firstChild;)f.insertBefore(b.firstChild,c);a.data="$";a._reactRetry&&a._reactRetry()}};$RC("'
  ),
  Lb = m('$RC("'),
  Mb = m('","'),
  Nb = m('")\x3c/script>'),
  Ob = m(
    'function $RX(b,c,d,e){var a=document.getElementById(b);a&&(b=a.previousSibling,b.data="$!",a=a.dataset,c&&(a.dgst=c),d&&(a.msg=d),e&&(a.stck=e),b._reactRetry&&b._reactRetry())};$RX("'
  ),
  Pb = m('$RX("'),
  Qb = m('"'),
  Rb = m(")\x3c/script>"),
  Sb = m(","),
  Tb = /[<\u2028\u2029]/g;
function Ub(a) {
  return JSON.stringify(a).replace(Tb, (a) => {
    switch (a) {
      case "<":
        return "\\u003c";
      case "\u2028":
        return "\\u2028";
      case "\u2029":
        return "\\u2029";
      default:
        throw Error(
          "escapeJSStringsForInstructionScripts encountered a match it does not know how to replace. this means the match regex and the replacement characters are no longer in sync. This is a bug in React"
        );
    }
  });
}
const Vb = Symbol.for("react.element"),
  Wb = Symbol.for("react.portal"),
  Xb = Symbol.for("react.fragment"),
  Yb = Symbol.for("react.strict_mode"),
  Zb = Symbol.for("react.profiler"),
  $b = Symbol.for("react.provider"),
  ac = Symbol.for("react.context"),
  bc = Symbol.for("react.server_context"),
  cc = Symbol.for("react.forward_ref"),
  dc = Symbol.for("react.suspense"),
  ec = Symbol.for("react.suspense_list"),
  fc = Symbol.for("react.memo"),
  gc = Symbol.for("react.lazy"),
  hc = Symbol.for("react.scope"),
  ic = Symbol.for("react.debug_trace_mode"),
  jc = Symbol.for("react.legacy_hidden"),
  kc = Symbol.for("react.cache"),
  lc = Symbol.for("react.default_value"),
  mc = Symbol.iterator;
function nc(a) {
  if (null == a) return null;
  if ("function" === typeof a) return a.displayName || a.name || null;
  if ("string" === typeof a) return a;
  switch (a) {
    case Xb:
      return "Fragment";
    case Wb:
      return "Portal";
    case Zb:
      return "Profiler";
    case Yb:
      return "StrictMode";
    case dc:
      return "Suspense";
    case ec:
      return "SuspenseList";
    case kc:
      return "Cache";
  }
  if ("object" === typeof a)
    switch (a.$$typeof) {
      case ac:
        return (a.displayName || "Context") + ".Consumer";
      case $b:
        return (a._context.displayName || "Context") + ".Provider";
      case cc:
        var b = a.render;
        a = a.displayName;
        a ||
          ((a = b.displayName || b.name || ""),
          (a = "" !== a ? `${"ForwardRef"}(${a})` : "ForwardRef"));
        return a;
      case fc:
        return (
          (b = a.displayName || null), null !== b ? b : nc(a.type) || "Memo"
        );
      case gc:
        b = a._payload;
        a = a._init;
        try {
          return nc(a(b));
        } catch (c) {
          break;
        }
      case bc:
        return (a.displayName || a._globalName) + ".Provider";
    }
  return null;
}
const oc = {};
function pc(a, b) {
  {
    a = a.contextTypes;
    if (!a) return oc;
    const c = {};
    for (const d in a) c[d] = b[d];
    return c;
  }
}
let F = null;
function G(a, b) {
  if (a !== b) {
    a.context._currentValue = a.parentValue;
    a = a.parent;
    const c = b.parent;
    if (null === a) {
      if (null !== c) throw Error(h(401));
    } else {
      if (null === c) throw Error(h(401));
      G(a, c);
    }
    b.context._currentValue = b.value;
  }
}
function qc(a) {
  a.context._currentValue = a.parentValue;
  a = a.parent;
  null !== a && qc(a);
}
function rc(a) {
  const b = a.parent;
  null !== b && rc(b);
  a.context._currentValue = a.value;
}
function sc(a, b) {
  a.context._currentValue = a.parentValue;
  a = a.parent;
  if (null === a) throw Error(h(402));
  a.depth === b.depth ? G(a, b) : sc(a, b);
}
function tc(a, b) {
  const c = b.parent;
  if (null === c) throw Error(h(402));
  a.depth === c.depth ? G(a, c) : tc(a, c);
  b.context._currentValue = b.value;
}
function H(a) {
  const b = F;
  b !== a &&
    (null === b
      ? rc(a)
      : null === a
      ? qc(b)
      : b.depth === a.depth
      ? G(b, a)
      : b.depth > a.depth
      ? sc(b, a)
      : tc(b, a),
    (F = a));
}
const I = Object.assign,
  uc = {
    isMounted() {
      return !1;
    },
    enqueueSetState(a, b) {
      a = a._reactInternals;
      null !== a.queue && a.queue.push(b);
    },
    enqueueReplaceState(a, b) {
      a = a._reactInternals;
      a.replace = !0;
      a.queue = [b];
    },
    enqueueForceUpdate() {},
  };
function vc(a, b, c, d) {
  var e = void 0 !== a.state ? a.state : null;
  a.updater = uc;
  a.props = c;
  a.state = e;
  var f = { queue: [], replace: !1 };
  a._reactInternals = f;
  var g = b.contextType;
  a.context = "object" === typeof g && null !== g ? g._currentValue : d;
  g = b.getDerivedStateFromProps;
  "function" === typeof g &&
    ((g = g(c, e)),
    (e = null === g || void 0 === g ? e : I({}, e, g)),
    (a.state = e));
  if (
    "function" !== typeof b.getDerivedStateFromProps &&
    "function" !== typeof a.getSnapshotBeforeUpdate &&
    ("function" === typeof a.UNSAFE_componentWillMount ||
      "function" === typeof a.componentWillMount)
  )
    if (
      ((b = a.state),
      "function" === typeof a.componentWillMount && a.componentWillMount(),
      "function" === typeof a.UNSAFE_componentWillMount &&
        a.UNSAFE_componentWillMount(),
      b !== a.state && uc.enqueueReplaceState(a, a.state, null),
      null !== f.queue && 0 < f.queue.length)
    )
      if (
        ((b = f.queue),
        (g = f.replace),
        (f.queue = null),
        (f.replace = !1),
        g && 1 === b.length)
      )
        a.state = b[0];
      else {
        f = g ? b[0] : a.state;
        e = !0;
        for (g = g ? 1 : 0; g < b.length; g++) {
          var l = b[g];
          l = "function" === typeof l ? l.call(a, f, c, d) : l;
          null != l && (e ? ((e = !1), (f = I({}, f, l))) : I(f, l));
        }
        a.state = f;
      }
    else f.queue = null;
}
const wc = { id: 1, overflow: "" };
function xc(a, b, c) {
  var d = a.id;
  a = a.overflow;
  var e = 32 - J(d) - 1;
  d &= ~(1 << e);
  c += 1;
  var f = 32 - J(b) + e;
  if (30 < f) {
    const g = e - (e % 5);
    f = (d & ((1 << g) - 1)).toString(32);
    d >>= g;
    e -= g;
    return { id: (1 << (32 - J(b) + e)) | (c << e) | d, overflow: f + a };
  }
  return { id: (1 << f) | (c << e) | d, overflow: a };
}
const J = Math.clz32 ? Math.clz32 : yc,
  zc = Math.log,
  Ac = Math.LN2;
function yc(a) {
  a >>>= 0;
  return 0 === a ? 32 : (31 - ((zc(a) / Ac) | 0)) | 0;
}
function Bc(a, b) {
  return (a === b && (0 !== a || 1 / a === 1 / b)) || (a !== a && b !== b);
}
const Cc = "function" === typeof Object.is ? Object.is : Bc;
let K = null,
  Dc = null,
  L = null,
  M = null,
  N = !1,
  O = !1,
  P = 0,
  Q = null,
  R = 0;
function S() {
  if (null === K) throw Error(h(321));
  return K;
}
function Ec() {
  if (0 < R) throw Error(h(312));
  return { memoizedState: null, queue: null, next: null };
}
function Fc() {
  null === M
    ? null === L
      ? ((N = !1), (L = M = Ec()))
      : ((N = !0), (M = L))
    : null === M.next
    ? ((N = !1), (M = M.next = Ec()))
    : ((N = !0), (M = M.next));
  return M;
}
function Gc() {
  Dc = K = null;
  O = !1;
  L = null;
  R = 0;
  M = Q = null;
}
function Hc(a, b) {
  return "function" === typeof b ? b(a) : b;
}
function Ic(a, b, c) {
  K = S();
  M = Fc();
  if (N) {
    var d = M.queue;
    b = d.dispatch;
    if (null !== Q && ((c = Q.get(d)), void 0 !== c)) {
      Q.delete(d);
      d = M.memoizedState;
      do (d = a(d, c.action)), (c = c.next);
      while (null !== c);
      M.memoizedState = d;
      return [d, b];
    }
    return [M.memoizedState, b];
  }
  a = a === Hc ? ("function" === typeof b ? b() : b) : void 0 !== c ? c(b) : b;
  M.memoizedState = a;
  a = M.queue = { last: null, dispatch: null };
  a = a.dispatch = Jc.bind(null, K, a);
  return [M.memoizedState, a];
}
function Kc(a, b) {
  K = S();
  M = Fc();
  b = void 0 === b ? null : b;
  if (null !== M) {
    const a = M.memoizedState;
    if (null !== a && null !== b) {
      a: {
        var c = a[1];
        if (null === c) c = !1;
        else {
          for (let a = 0; a < c.length && a < b.length; a++)
            if (!Cc(b[a], c[a])) {
              c = !1;
              break a;
            }
          c = !0;
        }
      }
      if (c) return a[0];
    }
  }
  a = a();
  M.memoizedState = [a, b];
  return a;
}
function Jc(a, b, c) {
  if (25 <= R) throw Error(h(301));
  if (a === K)
    if (
      ((O = !0),
      (a = { action: c, next: null }),
      null === Q && (Q = new Map()),
      (c = Q.get(b)),
      void 0 === c)
    )
      Q.set(b, a);
    else {
      for (b = c; null !== b.next; ) b = b.next;
      b.next = a;
    }
}
function Lc() {
  throw Error(h(394));
}
function Mc() {
  throw Error(h(393));
}
function T() {}
const Nc = {
  readContext: function (a) {
    return a._currentValue;
  },
  useContext: function (a) {
    S();
    return a._currentValue;
  },
  useMemo: Kc,
  useReducer: Ic,
  useRef: function (a) {
    K = S();
    M = Fc();
    const b = M.memoizedState;
    return null === b ? ((a = { current: a }), (M.memoizedState = a)) : b;
  },
  useState: function (a) {
    return Ic(Hc, a);
  },
  useInsertionEffect: T,
  useLayoutEffect: function () {},
  useCallback: function (a, b) {
    return Kc(() => a, b);
  },
  useImperativeHandle: T,
  useEffect: T,
  useDebugValue: T,
  useDeferredValue: function (a) {
    S();
    return a;
  },
  useTransition: function () {
    S();
    return [!1, Lc];
  },
  useId: function () {
    var a = Dc.treeContext;
    var b = a.overflow;
    a = a.id;
    a = (a & ~(1 << (32 - J(a) - 1))).toString(32) + b;
    const c = U;
    if (null === c) throw Error(h(404));
    b = P++;
    a = ":" + c.idPrefix + "R" + a;
    0 < b && (a += "H" + b.toString(32));
    return (b = a + ":");
  },
  useMutableSource: function (a, b) {
    S();
    return b(a._source);
  },
  useSyncExternalStore: function (a, b, c) {
    if (void 0 === c) throw Error(h(407));
    return c();
  },
  getCacheForType: function () {
    throw Error(h(248));
  },
  useCacheRefresh: function () {
    return Mc;
  },
};
let U = null;
const Oc =
  aa.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED.ReactCurrentDispatcher;
function Pc(a) {
  console.error(a);
  return null;
}
function V() {}
function Qc(a, b, c, d, e, f, g, l, k) {
  const n = [],
    r = new Set();
  b = {
    destination: null,
    responseState: b,
    progressiveChunkSize: void 0 === d ? 12800 : d,
    status: 0,
    fatalError: null,
    nextSegmentId: 0,
    allPendingTasks: 0,
    pendingRootTasks: 0,
    completedRootSegment: null,
    abortableTasks: r,
    pingedTasks: n,
    clientRenderedBoundaries: [],
    completedBoundaries: [],
    partialBoundaries: [],
    onError: void 0 === e ? Pc : e,
    onAllReady: void 0 === f ? V : f,
    onShellReady: void 0 === g ? V : g,
    onShellError: void 0 === l ? V : l,
    onFatalError: void 0 === k ? V : k,
  };
  c = W(b, 0, null, c, !1, !1);
  c.parentFlushed = !0;
  a = Rc(b, a, null, c, r, oc, null, wc);
  n.push(a);
  return b;
}
function Sc(a, b) {
  const c = a.pingedTasks;
  c.push(b);
  1 === c.length && queueMicrotask(() => Tc(a));
}
function Rc(a, b, c, d, e, f, g, l) {
  a.allPendingTasks++;
  null === c ? a.pendingRootTasks++ : c.pendingTasks++;
  const k = {
    node: b,
    ping: () => Sc(a, k),
    blockedBoundary: c,
    blockedSegment: d,
    abortSet: e,
    legacyContext: f,
    context: g,
    treeContext: l,
  };
  e.add(k);
  return k;
}
function W(a, b, c, d, e, f) {
  return {
    status: 0,
    id: -1,
    index: b,
    parentFlushed: !1,
    chunks: [],
    children: [],
    formatContext: d,
    boundary: c,
    lastPushedText: e,
    textEmbedded: f,
  };
}
function X(a, b) {
  a = a.onError(b);
  if (null != a && "string" !== typeof a)
    throw Error(
      `onError returned something with a type other than "string". onError should return a string and may return null or undefined but must not return anything else. It received something of type "${typeof a}" instead`
    );
  return a;
}
function Y(a, b) {
  var c = a.onShellError;
  c(b);
  c = a.onFatalError;
  c(b);
  null !== a.destination
    ? ((a.status = 2), a.destination.close(b))
    : ((a.status = 1), (a.fatalError = b));
}
function Uc(a, b, c, d, e) {
  K = {};
  Dc = b;
  P = 0;
  for (a = c(d, e); O; ) (O = !1), (P = 0), (R += 1), (M = null), (a = c(d, e));
  Gc();
  return a;
}
function Vc(a, b, c, d) {
  const e = c.render();
  var f = d.childContextTypes;
  if (null !== f && void 0 !== f) {
    const l = b.legacyContext;
    var g = l;
    if ("function" !== typeof c.getChildContext) d = g;
    else {
      c = c.getChildContext();
      for (const a in c)
        if (!(a in f)) throw Error(h(108, nc(d) || "Unknown", a));
      d = { ...g, ...c };
    }
    b.legacyContext = d;
    Z(a, b, e);
    b.legacyContext = l;
  } else Z(a, b, e);
}
function Wc(a, b) {
  if (a && a.defaultProps) {
    b = I({}, b);
    a = a.defaultProps;
    for (const c in a) void 0 === b[c] && (b[c] = a[c]);
    return b;
  }
  return b;
}
function Xc(a, b, c, d, e) {
  if ("function" === typeof c)
    if (c.prototype && c.prototype.isReactComponent) {
      e = pc(c, b.legacyContext);
      var f = e;
      var g = c.contextType;
      f = new c(d, "object" === typeof g && null !== g ? g._currentValue : f);
      vc(f, c, d, e);
      Vc(a, b, f, c);
    } else if (
      ((f = pc(c, b.legacyContext)),
      (e = Uc(a, b, c, d, f)),
      (g = 0 !== P),
      "object" === typeof e &&
        null !== e &&
        "function" === typeof e.render &&
        void 0 === e.$$typeof)
    )
      vc(e, c, d, f), Vc(a, b, e, c);
    else if (g) {
      d = b.treeContext;
      b.treeContext = xc(d, 1, 0);
      try {
        Z(a, b, e);
      } finally {
        b.treeContext = d;
      }
    } else Z(a, b, e);
  else if ("string" === typeof c) {
    e = b.blockedSegment;
    f = Ua(e.chunks, c, d, a.responseState, e.formatContext);
    e.lastPushedText = !1;
    g = e.formatContext;
    e.formatContext = Ca(g, c, d);
    Yc(a, b, f);
    e.formatContext = g;
    switch (c) {
      case "area":
      case "base":
      case "br":
      case "col":
      case "embed":
      case "hr":
      case "img":
      case "input":
      case "keygen":
      case "link":
      case "meta":
      case "param":
      case "source":
      case "track":
      case "wbr":
        break;
      default:
        e.chunks.push(Va, c, Wa);
    }
    e.lastPushedText = !1;
  } else {
    switch (c) {
      case jc:
      case ic:
      case Yb:
      case Zb:
      case Xb:
        Z(a, b, d.children);
        return;
      case ec:
        Z(a, b, d.children);
        return;
      case hc:
        throw Error(h(343));
      case dc:
        a: {
          c = b.blockedBoundary;
          e = b.blockedSegment;
          f = d.fallback;
          d = d.children;
          g = new Set();
          const l = {
              id: null,
              rootSegmentID: -1,
              parentFlushed: !1,
              pendingTasks: 0,
              forceClientRender: !1,
              completedSegments: [],
              byteSize: 0,
              fallbackAbortableTasks: g,
              errorDigest: null,
            },
            k = W(a, e.chunks.length, l, e.formatContext, !1, !1);
          e.children.push(k);
          e.lastPushedText = !1;
          const n = W(a, 0, null, e.formatContext, !1, !1);
          n.parentFlushed = !0;
          b.blockedBoundary = l;
          b.blockedSegment = n;
          try {
            if (
              (Yc(a, b, d),
              n.lastPushedText && n.textEmbedded && n.chunks.push(Da),
              (n.status = 1),
              Zc(l, n),
              0 === l.pendingTasks)
            )
              break a;
          } catch (r) {
            (n.status = 4),
              (l.forceClientRender = !0),
              (l.errorDigest = X(a, r));
          } finally {
            (b.blockedBoundary = c), (b.blockedSegment = e);
          }
          b = Rc(a, f, c, k, g, b.legacyContext, b.context, b.treeContext);
          a.pingedTasks.push(b);
        }
        return;
    }
    if ("object" === typeof c && null !== c)
      switch (c.$$typeof) {
        case cc:
          d = Uc(a, b, c.render, d, e);
          if (0 !== P) {
            c = b.treeContext;
            b.treeContext = xc(c, 1, 0);
            try {
              Z(a, b, d);
            } finally {
              b.treeContext = c;
            }
          } else Z(a, b, d);
          return;
        case fc:
          c = c.type;
          d = Wc(c, d);
          Xc(a, b, c, d, e);
          return;
        case $b:
          e = d.children;
          c = c._context;
          d = d.value;
          f = c._currentValue;
          c._currentValue = d;
          g = F;
          F = d = {
            parent: g,
            depth: null === g ? 0 : g.depth + 1,
            context: c,
            parentValue: f,
            value: d,
          };
          b.context = d;
          Z(a, b, e);
          a = F;
          if (null === a) throw Error(h(403));
          d = a.parentValue;
          a.context._currentValue = d === lc ? a.context._defaultValue : d;
          a = F = a.parent;
          b.context = a;
          return;
        case ac:
          d = d.children;
          d = d(c._currentValue);
          Z(a, b, d);
          return;
        case gc:
          e = c._init;
          c = e(c._payload);
          d = Wc(c, d);
          Xc(a, b, c, d, void 0);
          return;
      }
    throw Error(h(130, null == c ? c : typeof c, ""));
  }
}
function Z(a, b, c) {
  b.node = c;
  if ("object" === typeof c && null !== c) {
    switch (c.$$typeof) {
      case Vb:
        Xc(a, b, c.type, c.props, c.ref);
        return;
      case Wb:
        throw Error(h(257));
      case gc:
        var d = c._init;
        c = d(c._payload);
        Z(a, b, c);
        return;
    }
    if (sa(c)) {
      $c(a, b, c);
      return;
    }
    null === c || "object" !== typeof c
      ? (d = null)
      : ((d = (mc && c[mc]) || c["@@iterator"]),
        (d = "function" === typeof d ? d : null));
    if (d && (d = d.call(c))) {
      c = d.next();
      if (!c.done) {
        const e = [];
        do e.push(c.value), (c = d.next());
        while (!c.done);
        $c(a, b, e);
      }
      return;
    }
    a = Object.prototype.toString.call(c);
    throw Error(
      h(
        31,
        "[object Object]" === a
          ? "object with keys {" + Object.keys(c).join(", ") + "}"
          : a
      )
    );
  }
  "string" === typeof c
    ? ((d = b.blockedSegment),
      (d.lastPushedText = Ea(
        b.blockedSegment.chunks,
        c,
        a.responseState,
        d.lastPushedText
      )))
    : "number" === typeof c &&
      ((d = b.blockedSegment),
      (d.lastPushedText = Ea(
        b.blockedSegment.chunks,
        "" + c,
        a.responseState,
        d.lastPushedText
      )));
}
function $c(a, b, c) {
  const d = c.length;
  for (let e = 0; e < d; e++) {
    const f = b.treeContext;
    b.treeContext = xc(f, d, e);
    try {
      Yc(a, b, c[e]);
    } finally {
      b.treeContext = f;
    }
  }
}
function Yc(a, b, c) {
  const d = b.blockedSegment.formatContext,
    e = b.legacyContext,
    f = b.context;
  try {
    return Z(a, b, c);
  } catch (g) {
    if (
      (Gc(),
      "object" === typeof g && null !== g && "function" === typeof g.then)
    ) {
      {
        c = g;
        const d = b.blockedSegment,
          e = W(
            a,
            d.chunks.length,
            null,
            d.formatContext,
            d.lastPushedText,
            !0
          );
        d.children.push(e);
        d.lastPushedText = !1;
        a = Rc(
          a,
          b.node,
          b.blockedBoundary,
          e,
          b.abortSet,
          b.legacyContext,
          b.context,
          b.treeContext
        ).ping;
        c.then(a, a);
      }
      b.blockedSegment.formatContext = d;
      b.legacyContext = e;
      b.context = f;
      H(f);
    } else
      throw (
        ((b.blockedSegment.formatContext = d),
        (b.legacyContext = e),
        (b.context = f),
        H(f),
        g)
      );
  }
}
function ad(a) {
  const b = a.blockedBoundary;
  a = a.blockedSegment;
  a.status = 3;
  bd(this, b, a);
}
function cd(a, b, c) {
  var d = a.blockedBoundary;
  a.blockedSegment.status = 3;
  null === d
    ? (b.allPendingTasks--,
      2 !== b.status &&
        ((b.status = 2), null !== b.destination && b.destination.end()))
    : (d.pendingTasks--,
      d.forceClientRender ||
        ((d.forceClientRender = !0),
        (a = void 0 === c ? Error(h(432)) : c),
        (d.errorDigest = b.onError(a)),
        d.parentFlushed && b.clientRenderedBoundaries.push(d)),
      d.fallbackAbortableTasks.forEach((a) => cd(a, b, c)),
      d.fallbackAbortableTasks.clear(),
      b.allPendingTasks--,
      0 === b.allPendingTasks && ((d = b.onAllReady), d()));
}
function Zc(a, b) {
  if (
    0 === b.chunks.length &&
    1 === b.children.length &&
    null === b.children[0].boundary
  ) {
    const c = b.children[0];
    c.id = b.id;
    c.parentFlushed = !0;
    1 === c.status && Zc(a, c);
  } else a.completedSegments.push(b);
}
function bd(a, b, c) {
  if (null === b) {
    if (c.parentFlushed) {
      if (null !== a.completedRootSegment) throw Error(h(389));
      a.completedRootSegment = c;
    }
    a.pendingRootTasks--;
    0 === a.pendingRootTasks &&
      ((a.onShellError = V), (b = a.onShellReady), b());
  } else
    b.pendingTasks--,
      b.forceClientRender ||
        (0 === b.pendingTasks
          ? (c.parentFlushed && 1 === c.status && Zc(b, c),
            b.parentFlushed && a.completedBoundaries.push(b),
            b.fallbackAbortableTasks.forEach(ad, a),
            b.fallbackAbortableTasks.clear())
          : c.parentFlushed &&
            1 === c.status &&
            (Zc(b, c),
            1 === b.completedSegments.length &&
              b.parentFlushed &&
              a.partialBoundaries.push(b)));
  a.allPendingTasks--;
  0 === a.allPendingTasks && ((a = a.onAllReady), a());
}
function Tc(a) {
  if (2 !== a.status) {
    var b = F,
      c = Oc.current;
    Oc.current = Nc;
    var d = U;
    U = a.responseState;
    try {
      const b = a.pingedTasks;
      let c;
      for (c = 0; c < b.length; c++) {
        {
          var e = a,
            f = b[c];
          const d = f.blockedSegment;
          if (0 === d.status) {
            H(f.context);
            try {
              Z(e, f, f.node),
                d.lastPushedText && d.textEmbedded && d.chunks.push(Da),
                f.abortSet.delete(f),
                (d.status = 1),
                bd(e, f.blockedBoundary, d);
            } catch (t) {
              if (
                (Gc(),
                "object" === typeof t &&
                  null !== t &&
                  "function" === typeof t.then)
              ) {
                const a = f.ping;
                t.then(a, a);
              } else {
                f.abortSet.delete(f);
                d.status = 4;
                {
                  var g = f.blockedBoundary,
                    l = t;
                  const a = X(e, l);
                  null === g
                    ? Y(e, l)
                    : (g.pendingTasks--,
                      g.forceClientRender ||
                        ((g.forceClientRender = !0),
                        (g.errorDigest = a),
                        g.parentFlushed && e.clientRenderedBoundaries.push(g)));
                  e.allPendingTasks--;
                  if (0 === e.allPendingTasks) {
                    const a = e.onAllReady;
                    a();
                  }
                }
              }
            } finally {
            }
          }
        }
      }
      b.splice(0, c);
      null !== a.destination && dd(a, a.destination);
    } catch (k) {
      X(a, k), Y(a, k);
    } finally {
      (U = d), (Oc.current = c), c === Nc && H(b);
    }
  }
}
function ed(a, b, c) {
  c.parentFlushed = !0;
  switch (c.status) {
    case 0:
      var d = (c.id = a.nextSegmentId++);
      c.lastPushedText = !1;
      c.textEmbedded = !1;
      a = a.responseState;
      b.write(Xa);
      b.write(a.placeholderPrefix);
      a = d.toString(16);
      b.write(a);
      return (b = !!b.write(Ya));
    case 1: {
      c.status = 2;
      var e = !0;
      d = c.chunks;
      let f = 0;
      c = c.children;
      for (let g = 0; g < c.length; g++) {
        for (e = c[g]; f < e.index; f++) b.write(d[f]);
        e = fd(a, b, e);
      }
      for (; f < d.length - 1; f++) b.write(d[f]);
      f < d.length && (e = !!b.write(d[f]));
      return e;
    }
    default:
      throw Error(h(390));
  }
}
function fd(a, b, c) {
  var d = c.boundary;
  if (null === d) return ed(a, b, c);
  d.parentFlushed = !0;
  if (d.forceClientRender)
    (d = d.errorDigest),
      b.write(bb),
      b.write(db),
      d && (b.write(fb), (d = x(d)), b.write(d), b.write(eb)),
      b.write(gb),
      ed(a, b, c);
  else if (0 < d.pendingTasks) {
    d.rootSegmentID = a.nextSegmentId++;
    0 < d.completedSegments.length && a.partialBoundaries.push(d);
    {
      var e = a.responseState;
      const b = e.nextSuspenseID++;
      e = m(e.boundaryPrefix + b.toString(16));
    }
    d = d.id = e;
    hb(b, a.responseState, d);
    ed(a, b, c);
  } else if (d.byteSize > a.progressiveChunkSize)
    (d.rootSegmentID = a.nextSegmentId++),
      a.completedBoundaries.push(d),
      hb(b, a.responseState, d.id),
      ed(a, b, c);
  else {
    b.write(Za);
    c = d.completedSegments;
    if (1 !== c.length) throw Error(h(391));
    fd(a, b, c[0]);
  }
  return !!b.write(cb);
}
function gd(a, b, c) {
  Eb(b, a.responseState, c.formatContext, c.id);
  fd(a, b, c);
  return Fb(b, c.formatContext);
}
function hd(a, b, c) {
  var d = c.completedSegments;
  let e = 0;
  for (; e < d.length; e++) id(a, b, c, d[e]);
  d.length = 0;
  a = a.responseState;
  d = c.id;
  c = c.rootSegmentID;
  b.write(a.startInlineScript);
  a.sentCompleteBoundaryFunction
    ? b.write(Lb)
    : ((a.sentCompleteBoundaryFunction = !0), b.write(Kb));
  if (null === d) throw Error(h(395));
  c = c.toString(16);
  b.write(d);
  b.write(Mb);
  b.write(a.segmentPrefix);
  b.write(c);
  return (b = !!b.write(Nb));
}
function id(a, b, c, d) {
  if (2 === d.status) return !0;
  var e = d.id;
  if (-1 === e) {
    if (-1 === (d.id = c.rootSegmentID)) throw Error(h(392));
    return gd(a, b, d);
  }
  gd(a, b, d);
  a = a.responseState;
  b.write(a.startInlineScript);
  a.sentCompleteSegmentFunction
    ? b.write(Hb)
    : ((a.sentCompleteSegmentFunction = !0), b.write(Gb));
  b.write(a.segmentPrefix);
  e = e.toString(16);
  b.write(e);
  b.write(Ib);
  b.write(a.placeholderPrefix);
  b.write(e);
  return (b = !!b.write(Jb));
}
function dd(a, b) {
  try {
    var c = a.completedRootSegment;
    if (null !== c && 0 === a.pendingRootTasks) {
      fd(a, b, c);
      a.completedRootSegment = null;
      var d = a.responseState.bootstrapChunks;
      for (c = 0; c < d.length - 1; c++) b.write(d[c]);
      c < d.length && b.write(d[c]);
    }
    const da = a.clientRenderedBoundaries;
    let p;
    for (p = 0; p < da.length; p++) {
      const c = da[p];
      d = b;
      var e = a.responseState,
        f = c.id,
        g = c.errorDigest,
        l = c.errorMessage,
        k = c.errorComponentStack;
      d.write(e.startInlineScript);
      e.sentClientRenderFunction
        ? d.write(Pb)
        : ((e.sentClientRenderFunction = !0), d.write(Ob));
      if (null === f) throw Error(h(395));
      d.write(f);
      d.write(Qb);
      if (g || l || k) {
        d.write(Sb);
        var n = Ub(g || "");
        d.write(n);
      }
      if (l || k) {
        d.write(Sb);
        var r = Ub(l || "");
        d.write(r);
      }
      if (k) {
        d.write(Sb);
        var t = Ub(k);
        d.write(t);
      }
      if (!d.write(Rb)) {
        a.destination = null;
        p++;
        da.splice(0, p);
        return;
      }
    }
    da.splice(0, p);
    const ea = a.completedBoundaries;
    for (p = 0; p < ea.length; p++)
      if (!hd(a, b, ea[p])) {
        a.destination = null;
        p++;
        ea.splice(0, p);
        return;
      }
    ea.splice(0, p);
    b.flush();
    const fa = a.partialBoundaries;
    for (p = 0; p < fa.length; p++) {
      a: {
        e = a;
        f = b;
        var Qa = fa[p];
        const c = Qa.completedSegments;
        for (g = 0; g < c.length; g++)
          if (!id(e, f, Qa, c[g])) {
            g++;
            c.splice(0, g);
            var wb = !1;
            break a;
          }
        c.splice(0, g);
        wb = !0;
      }
      if (!wb) {
        a.destination = null;
        p++;
        fa.splice(0, p);
        return;
      }
    }
    fa.splice(0, p);
    const ha = a.completedBoundaries;
    for (p = 0; p < ha.length; p++)
      if (!hd(a, b, ha[p])) {
        a.destination = null;
        p++;
        ha.splice(0, p);
        return;
      }
    ha.splice(0, p);
  } finally {
    b.flush(),
      b.flush(),
      0 === a.allPendingTasks &&
        0 === a.pingedTasks.length &&
        0 === a.clientRenderedBoundaries.length &&
        0 === a.completedBoundaries.length &&
        b.end();
  }
}
function jd(a, b) {
  if (1 === a.status) (a.status = 2), b.close(a.fatalError);
  else if (2 !== a.status && null === a.destination) {
    a.destination = b;
    try {
      dd(a, b);
    } catch (c) {
      X(a, c), Y(a, c);
    }
  }
}
function kd(a, b) {
  try {
    const c = a.abortableTasks;
    c.forEach((c) => cd(c, a, b));
    c.clear();
    null !== a.destination && dd(a, a.destination);
  } catch (c) {
    X(a, c), Y(a, c);
  }
}
const ld = {
  type: "direct",
  pull: void 0,
  cancel: void 0,
  [Symbol.toStringTag]: "ReactDOMServerReadableStreamSource",
};
function md(a) {
  let b = !1,
    c;
  if (a.onAllReady) {
    let d = a.onAllReady;
    a.onAllReady = () => {
      c ? (jd(a, c), (c = void 0)) : (b = !0);
      d();
      d = void 0;
    };
  } else
    a.onAllReady = () => {
      c ? (jd(a, c), (c = void 0)) : (b = !0);
    };
  Tc(a);
  return Object.create(ld, {
    pull: {
      value: (d) => {
        b ? ((c = void 0), jd(a, d)) : (c = d);
      },
    },
    cancel: {
      value: () => {
        kd(a);
      },
    },
  });
}
function nd(a, b) {
  a = md(a);
  b = b && Number.isFinite(b) && 0 < b ? b : 2048;
  return new ReadableStream(a, { highWaterMark: b });
}
export const renderToReadableStream = function (a, b) {
  let c;
  try {
    const d = Qc(
      a,
      Aa(
        b ? b.identifierPrefix : void 0,
        b ? b.nonce : void 0,
        b ? b.bootstrapScriptContent : void 0,
        b ? b.bootstrapScripts : void 0,
        b ? b.bootstrapModules : void 0
      ),
      Ba(b ? b.namespaceURI : void 0),
      b ? b.progressiveChunkSize : void 0,
      b ? b.onError : void 0,
      b ? b.onAllReady : void 0,
      void 0,
      (a) => {
        c && c.cancel(a).catch(() => {});
      },
      b
    );
    c = nd(d, b && b.progressiveChunkSize);
    const e = b && b.signal;
    if (e) {
      const a = () => {
        kd(d);
        e.removeEventListener("abort", a);
      };
      e.addEventListener("abort", a);
    }
    return Promise.resolve(c);
  } catch (d) {
    c && c.cancel(d).catch(() => {});
    if (b.onShellError) b.onShellError(d);
    return Promise.reject(d);
  }
};
export const version = "18.1.0";
