/*
 * Copyright (c) 2015 Igalia
 * Copyright (c) 2015 Igalia S.L.
 * Copyright (c) 2015 Igalia.
 * Copyright (c) 2015, 2016 Canon Inc. All rights reserved.
 * Copyright (c) 2015, 2016, 2017 Canon Inc.
 * Copyright (c) 2016, 2020 Apple Inc. All rights reserved.
 * Copyright (c) 2022 Codeblog Corp. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#include "config.h"
#include "JSBufferPrototypeBuiltins.h"

#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapInlines.h>
#include <JavaScriptCore/IdentifierInlines.h>
#include <JavaScriptCore/Intrinsic.h>
#include <JavaScriptCore/JSCJSValueInlines.h>
#include <JavaScriptCore/JSCellInlines.h>
#include <JavaScriptCore/StructureInlines.h>
#include <JavaScriptCore/VM.h>

namespace WebCore {

const JSC::ConstructAbility s_jsBufferPrototypeSetBigUint64CodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeSetBigUint64CodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeSetBigUint64CodeLength = 107;
static const JSC::Intrinsic s_jsBufferPrototypeSetBigUint64CodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeSetBigUint64Code =
    "(function (offset, value, le) {\n" \
    "  \"use strict\";\n" \
    "  return this.dataView.setBigUint64(offset, value, le);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeReadInt8CodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeReadInt8CodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeReadInt8CodeLength = 80;
static const JSC::Intrinsic s_jsBufferPrototypeReadInt8CodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeReadInt8Code =
    "(function (offset) {\n" \
    "  \"use strict\";\n" \
    "  return this.dataView.getInt8(offset);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeReadUInt8CodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeReadUInt8CodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeReadUInt8CodeLength = 81;
static const JSC::Intrinsic s_jsBufferPrototypeReadUInt8CodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeReadUInt8Code =
    "(function (offset) {\n" \
    "  \"use strict\";\n" \
    "  return this.dataView.getUint8(offset);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeReadInt16LECodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeReadInt16LECodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeReadInt16LECodeLength = 87;
static const JSC::Intrinsic s_jsBufferPrototypeReadInt16LECodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeReadInt16LECode =
    "(function (offset) {\n" \
    "  \"use strict\";\n" \
    "  return this.dataView.getInt16(offset, true);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeReadInt16BECodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeReadInt16BECodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeReadInt16BECodeLength = 88;
static const JSC::Intrinsic s_jsBufferPrototypeReadInt16BECodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeReadInt16BECode =
    "(function (offset) {\n" \
    "  \"use strict\";\n" \
    "  return this.dataView.getInt16(offset, false);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeReadUInt16LECodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeReadUInt16LECodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeReadUInt16LECodeLength = 88;
static const JSC::Intrinsic s_jsBufferPrototypeReadUInt16LECodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeReadUInt16LECode =
    "(function (offset) {\n" \
    "  \"use strict\";\n" \
    "  return this.dataView.getUint16(offset, true);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeReadUInt16BECodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeReadUInt16BECodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeReadUInt16BECodeLength = 89;
static const JSC::Intrinsic s_jsBufferPrototypeReadUInt16BECodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeReadUInt16BECode =
    "(function (offset) {\n" \
    "  \"use strict\";\n" \
    "  return this.dataView.getUint16(offset, false);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeReadInt32LECodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeReadInt32LECodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeReadInt32LECodeLength = 87;
static const JSC::Intrinsic s_jsBufferPrototypeReadInt32LECodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeReadInt32LECode =
    "(function (offset) {\n" \
    "  \"use strict\";\n" \
    "  return this.dataView.getInt32(offset, true);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeReadInt32BECodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeReadInt32BECodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeReadInt32BECodeLength = 88;
static const JSC::Intrinsic s_jsBufferPrototypeReadInt32BECodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeReadInt32BECode =
    "(function (offset) {\n" \
    "  \"use strict\";\n" \
    "  return this.dataView.getInt32(offset, false);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeReadUInt32LECodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeReadUInt32LECodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeReadUInt32LECodeLength = 88;
static const JSC::Intrinsic s_jsBufferPrototypeReadUInt32LECodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeReadUInt32LECode =
    "(function (offset) {\n" \
    "  \"use strict\";\n" \
    "  return this.dataView.getUint32(offset, true);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeReadUInt32BECodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeReadUInt32BECodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeReadUInt32BECodeLength = 89;
static const JSC::Intrinsic s_jsBufferPrototypeReadUInt32BECodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeReadUInt32BECode =
    "(function (offset) {\n" \
    "  \"use strict\";\n" \
    "  return this.dataView.getUint32(offset, false);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeReadFloatLECodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeReadFloatLECodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeReadFloatLECodeLength = 89;
static const JSC::Intrinsic s_jsBufferPrototypeReadFloatLECodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeReadFloatLECode =
    "(function (offset) {\n" \
    "  \"use strict\";\n" \
    "  return this.dataView.getFloat32(offset, true);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeReadFloatBECodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeReadFloatBECodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeReadFloatBECodeLength = 90;
static const JSC::Intrinsic s_jsBufferPrototypeReadFloatBECodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeReadFloatBECode =
    "(function (offset) {\n" \
    "  \"use strict\";\n" \
    "  return this.dataView.getFloat32(offset, false);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeReadDoubleLECodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeReadDoubleLECodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeReadDoubleLECodeLength = 89;
static const JSC::Intrinsic s_jsBufferPrototypeReadDoubleLECodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeReadDoubleLECode =
    "(function (offset) {\n" \
    "  \"use strict\";\n" \
    "  return this.dataView.getFloat64(offset, true);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeReadDoubleBECodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeReadDoubleBECodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeReadDoubleBECodeLength = 90;
static const JSC::Intrinsic s_jsBufferPrototypeReadDoubleBECodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeReadDoubleBECode =
    "(function (offset) {\n" \
    "  \"use strict\";\n" \
    "  return this.dataView.getFloat64(offset, false);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeReadBigInt64LECodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeReadBigInt64LECodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeReadBigInt64LECodeLength = 90;
static const JSC::Intrinsic s_jsBufferPrototypeReadBigInt64LECodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeReadBigInt64LECode =
    "(function (offset) {\n" \
    "  \"use strict\";\n" \
    "  return this.dataView.getBigInt64(offset, true);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeReadBigInt64BECodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeReadBigInt64BECodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeReadBigInt64BECodeLength = 91;
static const JSC::Intrinsic s_jsBufferPrototypeReadBigInt64BECodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeReadBigInt64BECode =
    "(function (offset) {\n" \
    "  \"use strict\";\n" \
    "  return this.dataView.getBigInt64(offset, false);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeReadBigUInt64LECodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeReadBigUInt64LECodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeReadBigUInt64LECodeLength = 91;
static const JSC::Intrinsic s_jsBufferPrototypeReadBigUInt64LECodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeReadBigUInt64LECode =
    "(function (offset) {\n" \
    "  \"use strict\";\n" \
    "  return this.dataView.getBigUint64(offset, true);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeReadBigUInt64BECodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeReadBigUInt64BECodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeReadBigUInt64BECodeLength = 92;
static const JSC::Intrinsic s_jsBufferPrototypeReadBigUInt64BECodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeReadBigUInt64BECode =
    "(function (offset) {\n" \
    "  \"use strict\";\n" \
    "  return this.dataView.getBigUint64(offset, false);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeWriteInt8CodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeWriteInt8CodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeWriteInt8CodeLength = 108;
static const JSC::Intrinsic s_jsBufferPrototypeWriteInt8CodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeWriteInt8Code =
    "(function (value, offset) {\n" \
    "  \"use strict\";\n" \
    "  this.dataView.setInt8(offset, value);\n" \
    "  return offset + 1;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeWriteUInt8CodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeWriteUInt8CodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeWriteUInt8CodeLength = 109;
static const JSC::Intrinsic s_jsBufferPrototypeWriteUInt8CodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeWriteUInt8Code =
    "(function (value, offset) {\n" \
    "  \"use strict\";\n" \
    "  this.dataView.setUint8(offset, value);\n" \
    "  return offset + 1;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeWriteInt16LECodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeWriteInt16LECodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeWriteInt16LECodeLength = 115;
static const JSC::Intrinsic s_jsBufferPrototypeWriteInt16LECodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeWriteInt16LECode =
    "(function (value, offset) {\n" \
    "  \"use strict\";\n" \
    "  this.dataView.setInt16(offset, value, true);\n" \
    "  return offset + 2;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeWriteInt16BECodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeWriteInt16BECodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeWriteInt16BECodeLength = 116;
static const JSC::Intrinsic s_jsBufferPrototypeWriteInt16BECodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeWriteInt16BECode =
    "(function (value, offset) {\n" \
    "  \"use strict\";\n" \
    "  this.dataView.setInt16(offset, value, false);\n" \
    "  return offset + 2;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeWriteUInt16LECodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeWriteUInt16LECodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeWriteUInt16LECodeLength = 116;
static const JSC::Intrinsic s_jsBufferPrototypeWriteUInt16LECodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeWriteUInt16LECode =
    "(function (value, offset) {\n" \
    "  \"use strict\";\n" \
    "  this.dataView.setUint16(offset, value, true);\n" \
    "  return offset + 2;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeWriteUInt16BECodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeWriteUInt16BECodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeWriteUInt16BECodeLength = 117;
static const JSC::Intrinsic s_jsBufferPrototypeWriteUInt16BECodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeWriteUInt16BECode =
    "(function (value, offset) {\n" \
    "  \"use strict\";\n" \
    "  this.dataView.setUint16(offset, value, false);\n" \
    "  return offset + 2;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeWriteInt32LECodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeWriteInt32LECodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeWriteInt32LECodeLength = 115;
static const JSC::Intrinsic s_jsBufferPrototypeWriteInt32LECodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeWriteInt32LECode =
    "(function (value, offset) {\n" \
    "  \"use strict\";\n" \
    "  this.dataView.setInt32(offset, value, true);\n" \
    "  return offset + 4;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeWriteInt32BECodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeWriteInt32BECodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeWriteInt32BECodeLength = 116;
static const JSC::Intrinsic s_jsBufferPrototypeWriteInt32BECodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeWriteInt32BECode =
    "(function (value, offset) {\n" \
    "  \"use strict\";\n" \
    "  this.dataView.setInt32(offset, value, false);\n" \
    "  return offset + 4;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeWriteUInt32LECodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeWriteUInt32LECodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeWriteUInt32LECodeLength = 116;
static const JSC::Intrinsic s_jsBufferPrototypeWriteUInt32LECodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeWriteUInt32LECode =
    "(function (value, offset) {\n" \
    "  \"use strict\";\n" \
    "  this.dataView.setUint32(offset, value, true);\n" \
    "  return offset + 4;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeWriteUInt32BECodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeWriteUInt32BECodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeWriteUInt32BECodeLength = 117;
static const JSC::Intrinsic s_jsBufferPrototypeWriteUInt32BECodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeWriteUInt32BECode =
    "(function (value, offset) {\n" \
    "  \"use strict\";\n" \
    "  this.dataView.setUint32(offset, value, false);\n" \
    "  return offset + 4;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeWriteFloatLECodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeWriteFloatLECodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeWriteFloatLECodeLength = 117;
static const JSC::Intrinsic s_jsBufferPrototypeWriteFloatLECodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeWriteFloatLECode =
    "(function (value, offset) {\n" \
    "  \"use strict\";\n" \
    "  this.dataView.setFloat32(offset, value, true);\n" \
    "  return offset + 4;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeWriteFloatBECodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeWriteFloatBECodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeWriteFloatBECodeLength = 118;
static const JSC::Intrinsic s_jsBufferPrototypeWriteFloatBECodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeWriteFloatBECode =
    "(function (value, offset) {\n" \
    "  \"use strict\";\n" \
    "  this.dataView.setFloat32(offset, value, false);\n" \
    "  return offset + 4;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeWriteDoubleLECodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeWriteDoubleLECodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeWriteDoubleLECodeLength = 117;
static const JSC::Intrinsic s_jsBufferPrototypeWriteDoubleLECodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeWriteDoubleLECode =
    "(function (value, offset) {\n" \
    "  \"use strict\";\n" \
    "  this.dataView.setFloat64(offset, value, true);\n" \
    "  return offset + 8;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeWriteDoubleBECodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeWriteDoubleBECodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeWriteDoubleBECodeLength = 118;
static const JSC::Intrinsic s_jsBufferPrototypeWriteDoubleBECodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeWriteDoubleBECode =
    "(function (value, offset) {\n" \
    "  \"use strict\";\n" \
    "  this.dataView.setFloat64(offset, value, false);\n" \
    "  return offset + 8;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeWriteBigInt64LECodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeWriteBigInt64LECodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeWriteBigInt64LECodeLength = 118;
static const JSC::Intrinsic s_jsBufferPrototypeWriteBigInt64LECodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeWriteBigInt64LECode =
    "(function (value, offset) {\n" \
    "  \"use strict\";\n" \
    "  this.dataView.setBigInt64(offset, value, true);\n" \
    "  return offset + 8;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeWriteBigInt64BECodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeWriteBigInt64BECodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeWriteBigInt64BECodeLength = 119;
static const JSC::Intrinsic s_jsBufferPrototypeWriteBigInt64BECodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeWriteBigInt64BECode =
    "(function (value, offset) {\n" \
    "  \"use strict\";\n" \
    "  this.dataView.setBigInt64(offset, value, false);\n" \
    "  return offset + 8;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeWriteBigUInt64LECodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeWriteBigUInt64LECodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeWriteBigUInt64LECodeLength = 119;
static const JSC::Intrinsic s_jsBufferPrototypeWriteBigUInt64LECodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeWriteBigUInt64LECode =
    "(function (value, offset) {\n" \
    "  \"use strict\";\n" \
    "  this.dataView.setBigUint64(offset, value, true);\n" \
    "  return offset + 8;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeWriteBigUInt64BECodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeWriteBigUInt64BECodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeWriteBigUInt64BECodeLength = 120;
static const JSC::Intrinsic s_jsBufferPrototypeWriteBigUInt64BECodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeWriteBigUInt64BECode =
    "(function (value, offset) {\n" \
    "  \"use strict\";\n" \
    "  this.dataView.setBigUint64(offset, value, false);\n" \
    "  return offset + 8;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeSliceCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeSliceCodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeSliceCodeLength = 262;
static const JSC::Intrinsic s_jsBufferPrototypeSliceCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeSliceCode =
    "(function (start, end) {\n" \
    "  \"use strict\";\n" \
    "  if (start === undefined && end === undefined) {\n" \
    "    return this;\n" \
    "  }\n" \
    "\n" \
    "  Buffer[Symbol.species] ||= Buffer;\n" \
    "\n" \
    "  return new Buffer(this.buffer, this.byteOffset + (start || 0), (end || this.byteLength)  - (start || 0));\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeUtf8WriteCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeUtf8WriteCodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeUtf8WriteCodeLength = 105;
static const JSC::Intrinsic s_jsBufferPrototypeUtf8WriteCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeUtf8WriteCode =
    "(function (text, offset, length) {\n" \
    "  \"use strict\";\n" \
    "  return this.write(text, offset, length, \"utf8\");\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeUcs2WriteCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeUcs2WriteCodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeUcs2WriteCodeLength = 105;
static const JSC::Intrinsic s_jsBufferPrototypeUcs2WriteCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeUcs2WriteCode =
    "(function (text, offset, length) {\n" \
    "  \"use strict\";\n" \
    "  return this.write(text, offset, length, \"ucs2\");\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeUtf16leWriteCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeUtf16leWriteCodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeUtf16leWriteCodeLength = 108;
static const JSC::Intrinsic s_jsBufferPrototypeUtf16leWriteCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeUtf16leWriteCode =
    "(function (text, offset, length) {\n" \
    "  \"use strict\";\n" \
    "  return this.write(text, offset, length, \"utf16le\");\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeLatin1WriteCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeLatin1WriteCodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeLatin1WriteCodeLength = 107;
static const JSC::Intrinsic s_jsBufferPrototypeLatin1WriteCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeLatin1WriteCode =
    "(function (text, offset, length) {\n" \
    "  \"use strict\";\n" \
    "  return this.write(text, offset, length, \"latin1\");\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeAsciiWriteCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeAsciiWriteCodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeAsciiWriteCodeLength = 106;
static const JSC::Intrinsic s_jsBufferPrototypeAsciiWriteCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeAsciiWriteCode =
    "(function (text, offset, length) {\n" \
    "  \"use strict\";\n" \
    "  return this.write(text, offset, length, \"ascii\");\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeBase64WriteCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeBase64WriteCodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeBase64WriteCodeLength = 107;
static const JSC::Intrinsic s_jsBufferPrototypeBase64WriteCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeBase64WriteCode =
    "(function (text, offset, length) {\n" \
    "  \"use strict\";\n" \
    "  return this.write(text, offset, length, \"base64\");\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeBase64urlWriteCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeBase64urlWriteCodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeBase64urlWriteCodeLength = 110;
static const JSC::Intrinsic s_jsBufferPrototypeBase64urlWriteCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeBase64urlWriteCode =
    "(function (text, offset, length) {\n" \
    "  \"use strict\";\n" \
    "  return this.write(text, offset, length, \"base64url\");\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeHexWriteCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeHexWriteCodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeHexWriteCodeLength = 104;
static const JSC::Intrinsic s_jsBufferPrototypeHexWriteCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeHexWriteCode =
    "(function (text, offset, length) {\n" \
    "  \"use strict\";\n" \
    "  return this.write(text, offset, length, \"hex\");\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeUtf8SliceCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeUtf8SliceCodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeUtf8SliceCodeLength = 96;
static const JSC::Intrinsic s_jsBufferPrototypeUtf8SliceCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeUtf8SliceCode =
    "(function (offset, length) {\n" \
    "  \"use strict\";\n" \
    "  return this.toString(offset, length, \"utf8\");\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeUcs2SliceCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeUcs2SliceCodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeUcs2SliceCodeLength = 96;
static const JSC::Intrinsic s_jsBufferPrototypeUcs2SliceCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeUcs2SliceCode =
    "(function (offset, length) {\n" \
    "  \"use strict\";\n" \
    "  return this.toString(offset, length, \"ucs2\");\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeUtf16leSliceCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeUtf16leSliceCodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeUtf16leSliceCodeLength = 99;
static const JSC::Intrinsic s_jsBufferPrototypeUtf16leSliceCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeUtf16leSliceCode =
    "(function (offset, length) {\n" \
    "  \"use strict\";\n" \
    "  return this.toString(offset, length, \"utf16le\");\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeLatin1SliceCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeLatin1SliceCodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeLatin1SliceCodeLength = 98;
static const JSC::Intrinsic s_jsBufferPrototypeLatin1SliceCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeLatin1SliceCode =
    "(function (offset, length) {\n" \
    "  \"use strict\";\n" \
    "  return this.toString(offset, length, \"latin1\");\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeAsciiSliceCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeAsciiSliceCodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeAsciiSliceCodeLength = 97;
static const JSC::Intrinsic s_jsBufferPrototypeAsciiSliceCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeAsciiSliceCode =
    "(function (offset, length) {\n" \
    "  \"use strict\";\n" \
    "  return this.toString(offset, length, \"ascii\");\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeBase64SliceCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeBase64SliceCodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeBase64SliceCodeLength = 98;
static const JSC::Intrinsic s_jsBufferPrototypeBase64SliceCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeBase64SliceCode =
    "(function (offset, length) {\n" \
    "  \"use strict\";\n" \
    "  return this.toString(offset, length, \"base64\");\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeBase64urlSliceCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeBase64urlSliceCodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeBase64urlSliceCodeLength = 101;
static const JSC::Intrinsic s_jsBufferPrototypeBase64urlSliceCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeBase64urlSliceCode =
    "(function (offset, length) {\n" \
    "  \"use strict\";\n" \
    "  return this.toString(offset, length, \"base64url\");\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeHexSliceCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeHexSliceCodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeHexSliceCodeLength = 95;
static const JSC::Intrinsic s_jsBufferPrototypeHexSliceCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeHexSliceCode =
    "(function (offset, length) {\n" \
    "  \"use strict\";\n" \
    "  return this.toString(offset, length, \"hex\");\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeToJSONCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeToJSONCodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeToJSONCodeLength = 118;
static const JSC::Intrinsic s_jsBufferPrototypeToJSONCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeToJSONCode =
    "(function () {\n" \
    "  \"use strict\";\n" \
    "  const type = \"Buffer\";\n" \
    "  const data = @Array.from(this);\n" \
    "  return { type, data };\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeSubarrayCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeSubarrayCodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeSubarrayCodeLength = 196;
static const JSC::Intrinsic s_jsBufferPrototypeSubarrayCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeSubarrayCode =
    "(function (start, end) {\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    Buffer[Symbol.species] ??= Buffer;\n" \
    "    return new Buffer(this.buffer, this.byteOffset + (start || 0), (end || this.byteLength)  - (start || 0));\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsBufferPrototypeInitializeBunBufferCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsBufferPrototypeInitializeBunBufferCodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsBufferPrototypeInitializeBunBufferCodeLength = 45;
static const JSC::Intrinsic s_jsBufferPrototypeInitializeBunBufferCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsBufferPrototypeInitializeBunBufferCode =
    "(function (parameters)\n" \
    "{\n" \
    "  \"use strict\";\n" \
    "\n" \
    "})\n" \
;


#define DEFINE_BUILTIN_GENERATOR(codeName, functionName, overriddenName, argumentCount) \
JSC::FunctionExecutable* codeName##Generator(JSC::VM& vm) \
{\
    JSVMClientData* clientData = static_cast<JSVMClientData*>(vm.clientData); \
    return clientData->builtinFunctions().jsBufferPrototypeBuiltins().codeName##Executable()->link(vm, nullptr, clientData->builtinFunctions().jsBufferPrototypeBuiltins().codeName##Source(), std::nullopt, s_##codeName##Intrinsic); \
}
WEBCORE_FOREACH_JSBUFFERPROTOTYPE_BUILTIN_CODE(DEFINE_BUILTIN_GENERATOR)
#undef DEFINE_BUILTIN_GENERATOR


} // namespace WebCore
