/*
 * Copyright (c) 2015 Igalia
 * Copyright (c) 2015 Igalia S.L.
 * Copyright (c) 2015 Igalia.
 * Copyright (c) 2015, 2016 Canon Inc. All rights reserved.
 * Copyright (c) 2015, 2016, 2017 Canon Inc.
 * Copyright (c) 2016, 2020 Apple Inc. All rights reserved.
 * Copyright (c) 2022 Codeblog Corp. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#include "config.h"
#include "ReadableByteStreamControllerBuiltins.h"

#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapInlines.h>
#include <JavaScriptCore/IdentifierInlines.h>
#include <JavaScriptCore/Intrinsic.h>
#include <JavaScriptCore/JSCJSValueInlines.h>
#include <JavaScriptCore/JSCellInlines.h>
#include <JavaScriptCore/StructureInlines.h>
#include <JavaScriptCore/VM.h>

namespace WebCore {

const JSC::ConstructAbility s_readableByteStreamControllerInitializeReadableByteStreamControllerCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableByteStreamControllerInitializeReadableByteStreamControllerCodeConstructorKind = JSC::ConstructorKind::None;
const int s_readableByteStreamControllerInitializeReadableByteStreamControllerCodeLength = 366;
static const JSC::Intrinsic s_readableByteStreamControllerInitializeReadableByteStreamControllerCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableByteStreamControllerInitializeReadableByteStreamControllerCode =
    "(function (stream, underlyingByteSource, highWaterMark)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (arguments.length !== 4 && arguments[3] !== @isReadableStream)\n" \
    "        @throwTypeError(\"ReadableByteStreamController constructor should not be called directly\");\n" \
    "\n" \
    "    return @privateInitializeReadableByteStreamController.@call(this, stream, underlyingByteSource, highWaterMark);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableByteStreamControllerEnqueueCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableByteStreamControllerEnqueueCodeConstructorKind = JSC::ConstructorKind::None;
const int s_readableByteStreamControllerEnqueueCodeLength = 665;
static const JSC::Intrinsic s_readableByteStreamControllerEnqueueCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableByteStreamControllerEnqueueCode =
    "(function (chunk)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (!@isReadableByteStreamController(this))\n" \
    "        throw @makeThisTypeError(\"ReadableByteStreamController\", \"enqueue\");\n" \
    "\n" \
    "    if (@getByIdDirectPrivate(this, \"closeRequested\"))\n" \
    "        @throwTypeError(\"ReadableByteStreamController is requested to close\");\n" \
    "\n" \
    "    if (@getByIdDirectPrivate(@getByIdDirectPrivate(this, \"controlledReadableStream\"), \"state\") !== @streamReadable)\n" \
    "        @throwTypeError(\"ReadableStream is not readable\");\n" \
    "\n" \
    "    if (!@isObject(chunk) || !@ArrayBuffer.@isView(chunk))\n" \
    "        @throwTypeError(\"Provided chunk is not a TypedArray\");\n" \
    "\n" \
    "    return @readableByteStreamControllerEnqueue(this, chunk);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableByteStreamControllerErrorCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableByteStreamControllerErrorCodeConstructorKind = JSC::ConstructorKind::None;
const int s_readableByteStreamControllerErrorCodeLength = 396;
static const JSC::Intrinsic s_readableByteStreamControllerErrorCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableByteStreamControllerErrorCode =
    "(function (error)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (!@isReadableByteStreamController(this))\n" \
    "        throw @makeThisTypeError(\"ReadableByteStreamController\", \"error\");\n" \
    "\n" \
    "    if (@getByIdDirectPrivate(@getByIdDirectPrivate(this, \"controlledReadableStream\"), \"state\") !== @streamReadable)\n" \
    "        @throwTypeError(\"ReadableStream is not readable\");\n" \
    "\n" \
    "    @readableByteStreamControllerError(this, error);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableByteStreamControllerCloseCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableByteStreamControllerCloseCodeConstructorKind = JSC::ConstructorKind::None;
const int s_readableByteStreamControllerCloseCodeLength = 501;
static const JSC::Intrinsic s_readableByteStreamControllerCloseCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableByteStreamControllerCloseCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (!@isReadableByteStreamController(this))\n" \
    "        throw @makeThisTypeError(\"ReadableByteStreamController\", \"close\");\n" \
    "\n" \
    "    if (@getByIdDirectPrivate(this, \"closeRequested\"))\n" \
    "        @throwTypeError(\"Close has already been requested\");\n" \
    "\n" \
    "    if (@getByIdDirectPrivate(@getByIdDirectPrivate(this, \"controlledReadableStream\"), \"state\") !== @streamReadable)\n" \
    "        @throwTypeError(\"ReadableStream is not readable\");\n" \
    "\n" \
    "    @readableByteStreamControllerClose(this);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableByteStreamControllerByobRequestCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableByteStreamControllerByobRequestCodeConstructorKind = JSC::ConstructorKind::None;
const int s_readableByteStreamControllerByobRequestCodeLength = 817;
static const JSC::Intrinsic s_readableByteStreamControllerByobRequestCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableByteStreamControllerByobRequestCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (!@isReadableByteStreamController(this))\n" \
    "        throw @makeGetterTypeError(\"ReadableByteStreamController\", \"byobRequest\");\n" \
    "\n" \
    "    \n" \
    "    var request = @getByIdDirectPrivate(this, \"byobRequest\");\n" \
    "    if (request === @undefined) {\n" \
    "        var pending = @getByIdDirectPrivate(this, \"pendingPullIntos\");\n" \
    "        const firstDescriptor = pending.peek();\n" \
    "        if (firstDescriptor) {\n" \
    "            const view = new @Uint8Array(firstDescriptor.buffer,\n" \
    "            firstDescriptor.byteOffset + firstDescriptor.bytesFilled,\n" \
    "            firstDescriptor.byteLength - firstDescriptor.bytesFilled);\n" \
    "            @putByIdDirectPrivate(this, \"byobRequest\", new @ReadableStreamBYOBRequest(this, view, @isReadableStream));\n" \
    "        }\n" \
    "    }\n" \
    "\n" \
    "    return @getByIdDirectPrivate(this, \"byobRequest\");\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableByteStreamControllerDesiredSizeCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableByteStreamControllerDesiredSizeCodeConstructorKind = JSC::ConstructorKind::None;
const int s_readableByteStreamControllerDesiredSizeCodeLength = 231;
static const JSC::Intrinsic s_readableByteStreamControllerDesiredSizeCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableByteStreamControllerDesiredSizeCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (!@isReadableByteStreamController(this))\n" \
    "        throw @makeGetterTypeError(\"ReadableByteStreamController\", \"desiredSize\");\n" \
    "\n" \
    "    return @readableByteStreamControllerGetDesiredSize(this);\n" \
    "})\n" \
;


#define DEFINE_BUILTIN_GENERATOR(codeName, functionName, overriddenName, argumentCount) \
JSC::FunctionExecutable* codeName##Generator(JSC::VM& vm) \
{\
    JSVMClientData* clientData = static_cast<JSVMClientData*>(vm.clientData); \
    return clientData->builtinFunctions().readableByteStreamControllerBuiltins().codeName##Executable()->link(vm, nullptr, clientData->builtinFunctions().readableByteStreamControllerBuiltins().codeName##Source(), std::nullopt, s_##codeName##Intrinsic); \
}
WEBCORE_FOREACH_READABLEBYTESTREAMCONTROLLER_BUILTIN_CODE(DEFINE_BUILTIN_GENERATOR)
#undef DEFINE_BUILTIN_GENERATOR


} // namespace WebCore
