/*
 * Copyright (c) 2015 Igalia
 * Copyright (c) 2015 Igalia S.L.
 * Copyright (c) 2015 Igalia.
 * Copyright (c) 2015, 2016 Canon Inc. All rights reserved.
 * Copyright (c) 2015, 2016, 2017 Canon Inc.
 * Copyright (c) 2016, 2020 Apple Inc. All rights reserved.
 * Copyright (c) 2022 Codeblog Corp. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#pragma once

#include <JavaScriptCore/BuiltinUtils.h>
#include <JavaScriptCore/Identifier.h>
#include <JavaScriptCore/JSFunction.h>
#include <JavaScriptCore/UnlinkedFunctionExecutable.h>

namespace JSC {
class FunctionExecutable;
}

namespace WebCore {

/* ReadableStream */
extern const char* const s_readableStreamInitializeReadableStreamCode;
extern const int s_readableStreamInitializeReadableStreamCodeLength;
extern const JSC::ConstructAbility s_readableStreamInitializeReadableStreamCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamInitializeReadableStreamCodeConstructorKind;
extern const char* const s_readableStreamReadableStreamToArrayCode;
extern const int s_readableStreamReadableStreamToArrayCodeLength;
extern const JSC::ConstructAbility s_readableStreamReadableStreamToArrayCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamReadableStreamToArrayCodeConstructorKind;
extern const char* const s_readableStreamReadableStreamToTextCode;
extern const int s_readableStreamReadableStreamToTextCodeLength;
extern const JSC::ConstructAbility s_readableStreamReadableStreamToTextCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamReadableStreamToTextCodeConstructorKind;
extern const char* const s_readableStreamReadableStreamToArrayBufferCode;
extern const int s_readableStreamReadableStreamToArrayBufferCodeLength;
extern const JSC::ConstructAbility s_readableStreamReadableStreamToArrayBufferCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamReadableStreamToArrayBufferCodeConstructorKind;
extern const char* const s_readableStreamReadableStreamToJSONCode;
extern const int s_readableStreamReadableStreamToJSONCodeLength;
extern const JSC::ConstructAbility s_readableStreamReadableStreamToJSONCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamReadableStreamToJSONCodeConstructorKind;
extern const char* const s_readableStreamReadableStreamToBlobCode;
extern const int s_readableStreamReadableStreamToBlobCodeLength;
extern const JSC::ConstructAbility s_readableStreamReadableStreamToBlobCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamReadableStreamToBlobCodeConstructorKind;
extern const char* const s_readableStreamConsumeReadableStreamCode;
extern const int s_readableStreamConsumeReadableStreamCodeLength;
extern const JSC::ConstructAbility s_readableStreamConsumeReadableStreamCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamConsumeReadableStreamCodeConstructorKind;
extern const char* const s_readableStreamCreateEmptyReadableStreamCode;
extern const int s_readableStreamCreateEmptyReadableStreamCodeLength;
extern const JSC::ConstructAbility s_readableStreamCreateEmptyReadableStreamCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamCreateEmptyReadableStreamCodeConstructorKind;
extern const char* const s_readableStreamCreateNativeReadableStreamCode;
extern const int s_readableStreamCreateNativeReadableStreamCodeLength;
extern const JSC::ConstructAbility s_readableStreamCreateNativeReadableStreamCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamCreateNativeReadableStreamCodeConstructorKind;
extern const char* const s_readableStreamCancelCode;
extern const int s_readableStreamCancelCodeLength;
extern const JSC::ConstructAbility s_readableStreamCancelCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamCancelCodeConstructorKind;
extern const char* const s_readableStreamGetReaderCode;
extern const int s_readableStreamGetReaderCodeLength;
extern const JSC::ConstructAbility s_readableStreamGetReaderCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamGetReaderCodeConstructorKind;
extern const char* const s_readableStreamPipeThroughCode;
extern const int s_readableStreamPipeThroughCodeLength;
extern const JSC::ConstructAbility s_readableStreamPipeThroughCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamPipeThroughCodeConstructorKind;
extern const char* const s_readableStreamPipeToCode;
extern const int s_readableStreamPipeToCodeLength;
extern const JSC::ConstructAbility s_readableStreamPipeToCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamPipeToCodeConstructorKind;
extern const char* const s_readableStreamTeeCode;
extern const int s_readableStreamTeeCodeLength;
extern const JSC::ConstructAbility s_readableStreamTeeCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamTeeCodeConstructorKind;
extern const char* const s_readableStreamLockedCode;
extern const int s_readableStreamLockedCodeLength;
extern const JSC::ConstructAbility s_readableStreamLockedCodeConstructAbility;
extern const JSC::ConstructorKind s_readableStreamLockedCodeConstructorKind;

#define WEBCORE_FOREACH_READABLESTREAM_BUILTIN_DATA(macro) \
    macro(initializeReadableStream, readableStreamInitializeReadableStream, 2) \
    macro(readableStreamToArray, readableStreamReadableStreamToArray, 1) \
    macro(readableStreamToText, readableStreamReadableStreamToText, 1) \
    macro(readableStreamToArrayBuffer, readableStreamReadableStreamToArrayBuffer, 1) \
    macro(readableStreamToJSON, readableStreamReadableStreamToJSON, 1) \
    macro(readableStreamToBlob, readableStreamReadableStreamToBlob, 1) \
    macro(consumeReadableStream, readableStreamConsumeReadableStream, 3) \
    macro(createEmptyReadableStream, readableStreamCreateEmptyReadableStream, 0) \
    macro(createNativeReadableStream, readableStreamCreateNativeReadableStream, 3) \
    macro(cancel, readableStreamCancel, 1) \
    macro(getReader, readableStreamGetReader, 1) \
    macro(pipeThrough, readableStreamPipeThrough, 2) \
    macro(pipeTo, readableStreamPipeTo, 1) \
    macro(tee, readableStreamTee, 0) \
    macro(locked, readableStreamLocked, 0) \

#define WEBCORE_BUILTIN_READABLESTREAM_INITIALIZEREADABLESTREAM 1
#define WEBCORE_BUILTIN_READABLESTREAM_READABLESTREAMTOARRAY 1
#define WEBCORE_BUILTIN_READABLESTREAM_READABLESTREAMTOTEXT 1
#define WEBCORE_BUILTIN_READABLESTREAM_READABLESTREAMTOARRAYBUFFER 1
#define WEBCORE_BUILTIN_READABLESTREAM_READABLESTREAMTOJSON 1
#define WEBCORE_BUILTIN_READABLESTREAM_READABLESTREAMTOBLOB 1
#define WEBCORE_BUILTIN_READABLESTREAM_CONSUMEREADABLESTREAM 1
#define WEBCORE_BUILTIN_READABLESTREAM_CREATEEMPTYREADABLESTREAM 1
#define WEBCORE_BUILTIN_READABLESTREAM_CREATENATIVEREADABLESTREAM 1
#define WEBCORE_BUILTIN_READABLESTREAM_CANCEL 1
#define WEBCORE_BUILTIN_READABLESTREAM_GETREADER 1
#define WEBCORE_BUILTIN_READABLESTREAM_PIPETHROUGH 1
#define WEBCORE_BUILTIN_READABLESTREAM_PIPETO 1
#define WEBCORE_BUILTIN_READABLESTREAM_TEE 1
#define WEBCORE_BUILTIN_READABLESTREAM_LOCKED 1

#define WEBCORE_FOREACH_READABLESTREAM_BUILTIN_CODE(macro) \
    macro(readableStreamInitializeReadableStreamCode, initializeReadableStream, ASCIILiteral(), s_readableStreamInitializeReadableStreamCodeLength) \
    macro(readableStreamReadableStreamToArrayCode, readableStreamToArray, ASCIILiteral(), s_readableStreamReadableStreamToArrayCodeLength) \
    macro(readableStreamReadableStreamToTextCode, readableStreamToText, ASCIILiteral(), s_readableStreamReadableStreamToTextCodeLength) \
    macro(readableStreamReadableStreamToArrayBufferCode, readableStreamToArrayBuffer, ASCIILiteral(), s_readableStreamReadableStreamToArrayBufferCodeLength) \
    macro(readableStreamReadableStreamToJSONCode, readableStreamToJSON, ASCIILiteral(), s_readableStreamReadableStreamToJSONCodeLength) \
    macro(readableStreamReadableStreamToBlobCode, readableStreamToBlob, ASCIILiteral(), s_readableStreamReadableStreamToBlobCodeLength) \
    macro(readableStreamConsumeReadableStreamCode, consumeReadableStream, ASCIILiteral(), s_readableStreamConsumeReadableStreamCodeLength) \
    macro(readableStreamCreateEmptyReadableStreamCode, createEmptyReadableStream, ASCIILiteral(), s_readableStreamCreateEmptyReadableStreamCodeLength) \
    macro(readableStreamCreateNativeReadableStreamCode, createNativeReadableStream, ASCIILiteral(), s_readableStreamCreateNativeReadableStreamCodeLength) \
    macro(readableStreamCancelCode, cancel, ASCIILiteral(), s_readableStreamCancelCodeLength) \
    macro(readableStreamGetReaderCode, getReader, ASCIILiteral(), s_readableStreamGetReaderCodeLength) \
    macro(readableStreamPipeThroughCode, pipeThrough, ASCIILiteral(), s_readableStreamPipeThroughCodeLength) \
    macro(readableStreamPipeToCode, pipeTo, ASCIILiteral(), s_readableStreamPipeToCodeLength) \
    macro(readableStreamTeeCode, tee, ASCIILiteral(), s_readableStreamTeeCodeLength) \
    macro(readableStreamLockedCode, locked, "get locked"_s, s_readableStreamLockedCodeLength) \

#define WEBCORE_FOREACH_READABLESTREAM_BUILTIN_FUNCTION_NAME(macro) \
    macro(cancel) \
    macro(consumeReadableStream) \
    macro(createEmptyReadableStream) \
    macro(createNativeReadableStream) \
    macro(getReader) \
    macro(initializeReadableStream) \
    macro(locked) \
    macro(pipeThrough) \
    macro(pipeTo) \
    macro(readableStreamToArray) \
    macro(readableStreamToArrayBuffer) \
    macro(readableStreamToBlob) \
    macro(readableStreamToJSON) \
    macro(readableStreamToText) \
    macro(tee) \

#define DECLARE_BUILTIN_GENERATOR(codeName, functionName, overriddenName, argumentCount) \
    JSC::FunctionExecutable* codeName##Generator(JSC::VM&);

WEBCORE_FOREACH_READABLESTREAM_BUILTIN_CODE(DECLARE_BUILTIN_GENERATOR)
#undef DECLARE_BUILTIN_GENERATOR

class ReadableStreamBuiltinsWrapper : private JSC::WeakHandleOwner {
public:
    explicit ReadableStreamBuiltinsWrapper(JSC::VM& vm)
        : m_vm(vm)
        WEBCORE_FOREACH_READABLESTREAM_BUILTIN_FUNCTION_NAME(INITIALIZE_BUILTIN_NAMES)
#define INITIALIZE_BUILTIN_SOURCE_MEMBERS(name, functionName, overriddenName, length) , m_##name##Source(JSC::makeSource(StringImpl::createWithoutCopying(s_##name, length), { }))
        WEBCORE_FOREACH_READABLESTREAM_BUILTIN_CODE(INITIALIZE_BUILTIN_SOURCE_MEMBERS)
#undef INITIALIZE_BUILTIN_SOURCE_MEMBERS
    {
    }

#define EXPOSE_BUILTIN_EXECUTABLES(name, functionName, overriddenName, length) \
    JSC::UnlinkedFunctionExecutable* name##Executable(); \
    const JSC::SourceCode& name##Source() const { return m_##name##Source; }
    WEBCORE_FOREACH_READABLESTREAM_BUILTIN_CODE(EXPOSE_BUILTIN_EXECUTABLES)
#undef EXPOSE_BUILTIN_EXECUTABLES

    WEBCORE_FOREACH_READABLESTREAM_BUILTIN_FUNCTION_NAME(DECLARE_BUILTIN_IDENTIFIER_ACCESSOR)

    void exportNames();

private:
    JSC::VM& m_vm;

    WEBCORE_FOREACH_READABLESTREAM_BUILTIN_FUNCTION_NAME(DECLARE_BUILTIN_NAMES)

#define DECLARE_BUILTIN_SOURCE_MEMBERS(name, functionName, overriddenName, length) \
    JSC::SourceCode m_##name##Source;\
    JSC::Weak<JSC::UnlinkedFunctionExecutable> m_##name##Executable;
    WEBCORE_FOREACH_READABLESTREAM_BUILTIN_CODE(DECLARE_BUILTIN_SOURCE_MEMBERS)
#undef DECLARE_BUILTIN_SOURCE_MEMBERS

};

#define DEFINE_BUILTIN_EXECUTABLES(name, functionName, overriddenName, length) \
inline JSC::UnlinkedFunctionExecutable* ReadableStreamBuiltinsWrapper::name##Executable() \
{\
    if (!m_##name##Executable) {\
        JSC::Identifier executableName = functionName##PublicName();\
        if (overriddenName)\
            executableName = JSC::Identifier::fromString(m_vm, overriddenName);\
        m_##name##Executable = JSC::Weak<JSC::UnlinkedFunctionExecutable>(JSC::createBuiltinExecutable(m_vm, m_##name##Source, executableName, s_##name##ConstructorKind, s_##name##ConstructAbility), this, &m_##name##Executable);\
    }\
    return m_##name##Executable.get();\
}
WEBCORE_FOREACH_READABLESTREAM_BUILTIN_CODE(DEFINE_BUILTIN_EXECUTABLES)
#undef DEFINE_BUILTIN_EXECUTABLES

inline void ReadableStreamBuiltinsWrapper::exportNames()
{
#define EXPORT_FUNCTION_NAME(name) m_vm.propertyNames->appendExternalName(name##PublicName(), name##PrivateName());
    WEBCORE_FOREACH_READABLESTREAM_BUILTIN_FUNCTION_NAME(EXPORT_FUNCTION_NAME)
#undef EXPORT_FUNCTION_NAME
}

} // namespace WebCore
