const std = @import("std");

pub const fixtures = std.ComptimeStringMap([]u8, .{
    .{ "package.json", @embedFile("./fixtures/package.json") },
    .{ "tsconfig.json", @embedFile("./fixtures/tsconfig.json") },
    .{ "simple-component.js", @embedFile("./fixtures/simple-component.js") },
    .{ "simple-component.tsx", @embedFile("./fixtures/simple-component.tsx") },
    .{ "simple-component.tsx", @embedFile("./fixtures/simple-component.tsx") },
});

pub const sample_route_list = .{
    .@"pages/[...catch-all-at-root].js" = "//pages/[...catch-all-at-root].js",
    .@"pages/index.js" = "//pages/index.js",
    .@"pages/Foo.js" = "//pages/Foo.js",
    .@"pages/[TitleCaseParam].js" = "//pages/[TitleCaseParam].js",
    .@"pages/[TitleCaseParam]/file.js" = "//pages/[TitleCaseParam]/file.js",
    .@"pages/[TitleCaseParam]/[snake_case_param].js" = "//pages/[TitleCaseParam]/[snake_case_param].js",
    .@"pages/[TitleCaseParam]/[snake_case_param]/file.js" = "//pages/[TitleCaseParam]/[snake_case_param]/file.js",
    .@"pages/[TitleCaseParam]/[snake_case_param]/bacon/index.js" = "//pages/[TitleCaseParam]/[snake_case_param]/bacon/index.js",
};

pub const github_api_routes_list = .{
    .@"pages/[...catch-all-at-root].js" = "//pages/[...catch-all-at-root].js",
    .@"pages/index.js" = "//pages/index.js",
    .@"pages/app.js" = "//pages/app.js",
    .@"pages/app/installations.js" = "//pages/app/installations.js",
    .@"pages/app/installations/[installation_id].js" = "//pages/app/installations/[installation_id].js",
    .@"pages/apps/[app_slug].js" = "//pages/apps/[app_slug].js",
    .@"pages/codes_of_conduct.js" = "//pages/codes_of_conduct.js",
    .@"pages/codes_of_conduct/[key].js" = "//pages/codes_of_conduct/[key].js",
    .@"pages/emojis.js" = "//pages/emojis.js",
    .@"pages/events.js" = "//pages/events.js",
    .@"pages/feeds.js" = "//pages/feeds.js",
    .@"pages/gitignore/templates.js" = "//pages/gitignore/templates.js",
    .@"pages/gitignore/templates/[name].js" = "//pages/gitignore/templates/[name].js",
    .@"pages/installation/repositories.js" = "//pages/installation/repositories.js",
    .@"pages/licenses.js" = "//pages/licenses.js",
    .@"pages/licenses/[license].js" = "//pages/licenses/[license].js",
    .@"pages/meta.js" = "//pages/meta.js",
    .@"pages/networks/[owner]/[repo]/events.js" = "//pages/networks/[owner]/[repo]/events.js",
    .@"pages/octocat.js" = "//pages/octocat.js",
    .@"pages/organizations.js" = "//pages/organizations.js",
    .@"pages/orgs/[org]/index.js" = "//pages/orgs/[org].js",
    .@"pages/orgs/[org]/actions/permissions.js" = "//pages/orgs/[org]/actions/permissions.js",
    .@"pages/orgs/[org]/actions/permissions/repositories.js" = "//pages/orgs/[org]/actions/permissions/repositories.js",
    .@"pages/orgs/[org]/actions/permissions/selected-actions.js" = "//pages/orgs/[org]/actions/permissions/selected-actions.js",
    .@"pages/orgs/[org]/actions/runner-groups.js" = "//pages/orgs/[org]/actions/runner-groups.js",
    .@"pages/orgs/[org]/actions/runner-groups/[runner_group_id].js" = "//pages/orgs/[org]/actions/runner-groups/[runner_group_id].js",
    .@"pages/orgs/[org]/actions/runner-groups/[runner_group_id]/repositories.js" = "//pages/orgs/[org]/actions/runner-groups/[runner_group_id]/repositories.js",
    .@"pages/orgs/[org]/actions/runner-groups/[runner_group_id]/runners.js" = "//pages/orgs/[org]/actions/runner-groups/[runner_group_id]/runners.js",
    .@"pages/orgs/[org]/actions/runners.js" = "//pages/orgs/[org]/actions/runners.js",
    .@"pages/orgs/[org]/actions/runners/[runner_id].js" = "//pages/orgs/[org]/actions/runners/[runner_id].js",
    .@"pages/orgs/[org]/actions/runners/downloads.js" = "//pages/orgs/[org]/actions/runners/downloads.js",
    .@"pages/orgs/[org]/actions/secrets.js" = "//pages/orgs/[org]/actions/secrets.js",
    .@"pages/orgs/[org]/actions/secrets/[secret_name].js" = "//pages/orgs/[org]/actions/secrets/[secret_name].js",
    .@"pages/orgs/[org]/actions/secrets/[secret_name]/repositories.js" = "//pages/orgs/[org]/actions/secrets/[secret_name]/repositories.js",
    .@"pages/orgs/[org]/actions/secrets/public-key.js" = "//pages/orgs/[org]/actions/secrets/public-key.js",
    .@"pages/orgs/[org]/audit-log.js" = "//pages/orgs/[org]/audit-log.js",
    .@"pages/orgs/[org]/blocks.js" = "//pages/orgs/[org]/blocks.js",
    .@"pages/orgs/[org]/blocks/[username].js" = "//pages/orgs/[org]/blocks/[username].js",
    .@"pages/orgs/[org]/credential-authorizations.js" = "//pages/orgs/[org]/credential-authorizations.js",
    .@"pages/orgs/[org]/events.js" = "//pages/orgs/[org]/events.js",
    .@"pages/orgs/[org]/external-group/[group_id].js" = "//pages/orgs/[org]/external-group/[group_id].js",
    .@"pages/orgs/[org]/external-groups.js" = "//pages/orgs/[org]/external-groups.js",
    .@"pages/orgs/[org]/failed_invitations.js" = "//pages/orgs/[org]/failed_invitations.js",
    .@"pages/orgs/[org]/hooks.js" = "//pages/orgs/[org]/hooks.js",
    .@"pages/orgs/[org]/hooks/[hook_id].js" = "//pages/orgs/[org]/hooks/[hook_id].js",
    .@"pages/orgs/[org]/hooks/[hook_id]/config.js" = "//pages/orgs/[org]/hooks/[hook_id]/config.js",
    .@"pages/orgs/[org]/hooks/[hook_id]/deliveries.js" = "//pages/orgs/[org]/hooks/[hook_id]/deliveries.js",
    .@"pages/orgs/[org]/hooks/[hook_id]/deliveries/[delivery_id].js" = "//pages/orgs/[org]/hooks/[hook_id]/deliveries/[delivery_id].js",
    .@"pages/orgs/[org]/installations.js" = "//pages/orgs/[org]/installations.js",
    .@"pages/orgs/[org]/interaction-limits.js" = "//pages/orgs/[org]/interaction-limits.js",
    .@"pages/orgs/[org]/invitations.js" = "//pages/orgs/[org]/invitations.js",
    .@"pages/orgs/[org]/invitations/[invitation_id]/teams.js" = "//pages/orgs/[org]/invitations/[invitation_id]/teams.js",
    .@"pages/orgs/[org]/members.js" = "//pages/orgs/[org]/members.js",
    .@"pages/orgs/[org]/members/[username].js" = "//pages/orgs/[org]/members/[username].js",
    .@"pages/orgs/[org]/memberships/[username].js" = "//pages/orgs/[org]/memberships/[username].js",
    .@"pages/orgs/[org]/outside_collaborators.js" = "//pages/orgs/[org]/outside_collaborators.js",
    .@"pages/orgs/[org]/projects.js" = "//pages/orgs/[org]/projects.js",
    .@"pages/orgs/[org]/public_members.js" = "//pages/orgs/[org]/public_members.js",
    .@"pages/orgs/[org]/public_members/[username].js" = "//pages/orgs/[org]/public_members/[username].js",
    .@"pages/orgs/[org]/repos.js" = "//pages/orgs/[org]/repos.js",
    .@"pages/orgs/[org]/secret-scanning/alerts.js" = "//pages/orgs/[org]/secret-scanning/alerts.js",
    .@"pages/orgs/[org]/team-sync/groups.js" = "//pages/orgs/[org]/team-sync/groups.js",
    .@"pages/orgs/[org]/teams.js" = "//pages/orgs/[org]/teams.js",
    .@"pages/orgs/[org]/teams/[team_slug].js" = "//pages/orgs/[org]/teams/[team_slug].js",
    .@"pages/orgs/[org]/teams/[team_slug]/discussions.js" = "//pages/orgs/[org]/teams/[team_slug]/discussions.js",
    .@"pages/orgs/[org]/teams/[team_slug]/discussions/[discussion_number].js" = "//pages/orgs/[org]/teams/[team_slug]/discussions/[discussion_number].js",
    .@"pages/orgs/[org]/teams/[team_slug]/discussions/[discussion_number]/comments.js" = "//pages/orgs/[org]/teams/[team_slug]/discussions/[discussion_number]/comments.js",
    .@"pages/orgs/[org]/teams/[team_slug]/discussions/[discussion_number]/comments/[comment_number].js" = "//pages/orgs/[org]/teams/[team_slug]/discussions/[discussion_number]/comments/[comment_number].js",
    .@"pages/orgs/[org]/teams/[team_slug]/discussions/[discussion_number]/comments/[comment_number]/reactions.js" = "//pages/orgs/[org]/teams/[team_slug]/discussions/[discussion_number]/comments/[comment_number]/reactions.js",
    .@"pages/orgs/[org]/teams/[team_slug]/discussions/[discussion_number]/reactions.js" = "//pages/orgs/[org]/teams/[team_slug]/discussions/[discussion_number]/reactions.js",
    .@"pages/orgs/[org]/teams/[team_slug]/invitations.js" = "//pages/orgs/[org]/teams/[team_slug]/invitations.js",
    .@"pages/orgs/[org]/teams/[team_slug]/members.js" = "//pages/orgs/[org]/teams/[team_slug]/members.js",
    .@"pages/orgs/[org]/teams/[team_slug]/memberships/[username].js" = "//pages/orgs/[org]/teams/[team_slug]/memberships/[username].js",
    .@"pages/orgs/[org]/teams/[team_slug]/projects.js" = "//pages/orgs/[org]/teams/[team_slug]/projects.js",
    .@"pages/orgs/[org]/teams/[team_slug]/projects/[project_id].js" = "//pages/orgs/[org]/teams/[team_slug]/projects/[project_id].js",
    .@"pages/orgs/[org]/teams/[team_slug]/repos.js" = "//pages/orgs/[org]/teams/[team_slug]/repos.js",
    .@"pages/orgs/[org]/teams/[team_slug]/repos/[owner]/[repo].js" = "//pages/orgs/[org]/teams/[team_slug]/repos/[owner]/[repo].js",
    .@"pages/orgs/[org]/teams/[team_slug]/teams.js" = "//pages/orgs/[org]/teams/[team_slug]/teams.js",
    .@"pages/projects/[project_id].js" = "//pages/projects/[project_id].js",
    .@"pages/projects/[project_id]/collaborators.js" = "//pages/projects/[project_id]/collaborators.js",
    .@"pages/projects/[project_id]/collaborators/[username]/permission.js" = "//pages/projects/[project_id]/collaborators/[username]/permission.js",
    .@"pages/projects/[project_id]/columns.js" = "//pages/projects/[project_id]/columns.js",
    .@"pages/projects/columns/[column_id].js" = "//pages/projects/columns/[column_id].js",
    .@"pages/projects/columns/[column_id]/cards.js" = "//pages/projects/columns/[column_id]/cards.js",
    .@"pages/projects/columns/cards/[card_id].js" = "//pages/projects/columns/cards/[card_id].js",
    .@"pages/rate_limit.js" = "//pages/rate_limit.js",
    .@"pages/repos/[owner]/[repo].js" = "//pages/repos/[owner]/[repo].js",
    .@"pages/repos/[owner]/[repo]/actions/artifacts.js" = "//pages/repos/[owner]/[repo]/actions/artifacts.js",
    .@"pages/repos/[owner]/[repo]/actions/artifacts/[artifact_id].js" = "//pages/repos/[owner]/[repo]/actions/artifacts/[artifact_id].js",
    .@"pages/repos/[owner]/[repo]/actions/artifacts/[artifact_id]/[archive_format].js" = "//pages/repos/[owner]/[repo]/actions/artifacts/[artifact_id]/[archive_format].js",
    .@"pages/repos/[owner]/[repo]/actions/jobs/[job_id].js" = "//pages/repos/[owner]/[repo]/actions/jobs/[job_id].js",
    .@"pages/repos/[owner]/[repo]/actions/jobs/[job_id]/logs.js" = "//pages/repos/[owner]/[repo]/actions/jobs/[job_id]/logs.js",
    .@"pages/repos/[owner]/[repo]/actions/permissions.js" = "//pages/repos/[owner]/[repo]/actions/permissions.js",
    .@"pages/repos/[owner]/[repo]/actions/permissions/selected-actions.js" = "//pages/repos/[owner]/[repo]/actions/permissions/selected-actions.js",
    .@"pages/repos/[owner]/[repo]/actions/runners.js" = "//pages/repos/[owner]/[repo]/actions/runners.js",
    .@"pages/repos/[owner]/[repo]/actions/runners/[runner_id].js" = "//pages/repos/[owner]/[repo]/actions/runners/[runner_id].js",
    .@"pages/repos/[owner]/[repo]/actions/runners/downloads.js" = "//pages/repos/[owner]/[repo]/actions/runners/downloads.js",
    .@"pages/repos/[owner]/[repo]/actions/runs.js" = "//pages/repos/[owner]/[repo]/actions/runs.js",
    .@"pages/repos/[owner]/[repo]/actions/runs/[run_id].js" = "//pages/repos/[owner]/[repo]/actions/runs/[run_id].js",
    .@"pages/repos/[owner]/[repo]/actions/runs/[run_id]/approvals.js" = "//pages/repos/[owner]/[repo]/actions/runs/[run_id]/approvals.js",
    .@"pages/repos/[owner]/[repo]/actions/runs/[run_id]/artifacts.js" = "//pages/repos/[owner]/[repo]/actions/runs/[run_id]/artifacts.js",
    .@"pages/repos/[owner]/[repo]/actions/runs/[run_id]/attempts/[attempt_number].js" = "//pages/repos/[owner]/[repo]/actions/runs/[run_id]/attempts/[attempt_number].js",
    .@"pages/repos/[owner]/[repo]/actions/runs/[run_id]/attempts/[attempt_number]/jobs.js" = "//pages/repos/[owner]/[repo]/actions/runs/[run_id]/attempts/[attempt_number]/jobs.js",
    .@"pages/repos/[owner]/[repo]/actions/runs/[run_id]/attempts/[attempt_number]/logs.js" = "//pages/repos/[owner]/[repo]/actions/runs/[run_id]/attempts/[attempt_number]/logs.js",
    .@"pages/repos/[owner]/[repo]/actions/runs/[run_id]/jobs.js" = "//pages/repos/[owner]/[repo]/actions/runs/[run_id]/jobs.js",
    .@"pages/repos/[owner]/[repo]/actions/runs/[run_id]/logs.js" = "//pages/repos/[owner]/[repo]/actions/runs/[run_id]/logs.js",
    .@"pages/repos/[owner]/[repo]/actions/runs/[run_id]/pending_deployments.js" = "//pages/repos/[owner]/[repo]/actions/runs/[run_id]/pending_deployments.js",
    .@"pages/repos/[owner]/[repo]/actions/secrets.js" = "//pages/repos/[owner]/[repo]/actions/secrets.js",
    .@"pages/repos/[owner]/[repo]/actions/secrets/[secret_name].js" = "//pages/repos/[owner]/[repo]/actions/secrets/[secret_name].js",
    .@"pages/repos/[owner]/[repo]/actions/secrets/public-key.js" = "//pages/repos/[owner]/[repo]/actions/secrets/public-key.js",
    .@"pages/repos/[owner]/[repo]/actions/workflows.js" = "//pages/repos/[owner]/[repo]/actions/workflows.js",
    .@"pages/repos/[owner]/[repo]/actions/workflows/[workflow_id].js" = "//pages/repos/[owner]/[repo]/actions/workflows/[workflow_id].js",
    .@"pages/repos/[owner]/[repo]/actions/workflows/[workflow_id]/runs.js" = "//pages/repos/[owner]/[repo]/actions/workflows/[workflow_id]/runs.js",
    .@"pages/repos/[owner]/[repo]/assignees.js" = "//pages/repos/[owner]/[repo]/assignees.js",
    .@"pages/repos/[owner]/[repo]/assignees/[assignee].js" = "//pages/repos/[owner]/[repo]/assignees/[assignee].js",
    .@"pages/repos/[owner]/[repo]/autolinks.js" = "//pages/repos/[owner]/[repo]/autolinks.js",
    .@"pages/repos/[owner]/[repo]/autolinks/[autolink_id].js" = "//pages/repos/[owner]/[repo]/autolinks/[autolink_id].js",
    .@"pages/repos/[owner]/[repo]/branches.js" = "//pages/repos/[owner]/[repo]/branches.js",
    .@"pages/repos/[owner]/[repo]/branches/[branch].js" = "//pages/repos/[owner]/[repo]/branches/[branch].js",
    .@"pages/repos/[owner]/[repo]/branches/[branch]/protection.js" = "//pages/repos/[owner]/[repo]/branches/[branch]/protection.js",
    .@"pages/repos/[owner]/[repo]/branches/[branch]/protection/enforce_admins.js" = "//pages/repos/[owner]/[repo]/branches/[branch]/protection/enforce_admins.js",
    .@"pages/repos/[owner]/[repo]/branches/[branch]/protection/required_pull_request_reviews.js" = "//pages/repos/[owner]/[repo]/branches/[branch]/protection/required_pull_request_reviews.js",
    .@"pages/repos/[owner]/[repo]/branches/[branch]/protection/required_signatures.js" = "//pages/repos/[owner]/[repo]/branches/[branch]/protection/required_signatures.js",
    .@"pages/repos/[owner]/[repo]/branches/[branch]/protection/required_status_checks.js" = "//pages/repos/[owner]/[repo]/branches/[branch]/protection/required_status_checks.js",
    .@"pages/repos/[owner]/[repo]/branches/[branch]/protection/required_status_checks/contexts.js" = "//pages/repos/[owner]/[repo]/branches/[branch]/protection/required_status_checks/contexts.js",
    .@"pages/repos/[owner]/[repo]/branches/[branch]/protection/restrictions.js" = "//pages/repos/[owner]/[repo]/branches/[branch]/protection/restrictions.js",
    .@"pages/repos/[owner]/[repo]/branches/[branch]/protection/restrictions/apps.js" = "//pages/repos/[owner]/[repo]/branches/[branch]/protection/restrictions/apps.js",
    .@"pages/repos/[owner]/[repo]/branches/[branch]/protection/restrictions/teams.js" = "//pages/repos/[owner]/[repo]/branches/[branch]/protection/restrictions/teams.js",
    .@"pages/repos/[owner]/[repo]/branches/[branch]/protection/restrictions/users.js" = "//pages/repos/[owner]/[repo]/branches/[branch]/protection/restrictions/users.js",
    .@"pages/repos/[owner]/[repo]/check-runs/[check_run_id].js" = "//pages/repos/[owner]/[repo]/check-runs/[check_run_id].js",
    .@"pages/repos/[owner]/[repo]/check-runs/[check_run_id]/annotations.js" = "//pages/repos/[owner]/[repo]/check-runs/[check_run_id]/annotations.js",
    .@"pages/repos/[owner]/[repo]/check-suites/[check_suite_id].js" = "//pages/repos/[owner]/[repo]/check-suites/[check_suite_id].js",
    .@"pages/repos/[owner]/[repo]/check-suites/[check_suite_id]/check-runs.js" = "//pages/repos/[owner]/[repo]/check-suites/[check_suite_id]/check-runs.js",
    .@"pages/repos/[owner]/[repo]/code-scanning/alerts.js" = "//pages/repos/[owner]/[repo]/code-scanning/alerts.js",
    .@"pages/repos/[owner]/[repo]/code-scanning/alerts/[alert_number].js" = "//pages/repos/[owner]/[repo]/code-scanning/alerts/[alert_number].js",
    .@"pages/repos/[owner]/[repo]/code-scanning/alerts/[alert_number]/instances.js" = "//pages/repos/[owner]/[repo]/code-scanning/alerts/[alert_number]/instances.js",
    .@"pages/repos/[owner]/[repo]/code-scanning/analyses.js" = "//pages/repos/[owner]/[repo]/code-scanning/analyses.js",
    .@"pages/repos/[owner]/[repo]/code-scanning/analyses/[analysis_id].js" = "//pages/repos/[owner]/[repo]/code-scanning/analyses/[analysis_id].js",
    .@"pages/repos/[owner]/[repo]/code-scanning/sarifs/[sarif_id].js" = "//pages/repos/[owner]/[repo]/code-scanning/sarifs/[sarif_id].js",
    .@"pages/repos/[owner]/[repo]/collaborators.js" = "//pages/repos/[owner]/[repo]/collaborators.js",
    .@"pages/repos/[owner]/[repo]/collaborators/[username].js" = "//pages/repos/[owner]/[repo]/collaborators/[username].js",
    .@"pages/repos/[owner]/[repo]/collaborators/[username]/permission.js" = "//pages/repos/[owner]/[repo]/collaborators/[username]/permission.js",
    .@"pages/repos/[owner]/[repo]/comments.js" = "//pages/repos/[owner]/[repo]/comments.js",
    .@"pages/repos/[owner]/[repo]/comments/[comment_id].js" = "//pages/repos/[owner]/[repo]/comments/[comment_id].js",
    .@"pages/repos/[owner]/[repo]/comments/[comment_id]/reactions.js" = "//pages/repos/[owner]/[repo]/comments/[comment_id]/reactions.js",
    .@"pages/repos/[owner]/[repo]/commits.js" = "//pages/repos/[owner]/[repo]/commits.js",
    .@"pages/repos/[owner]/[repo]/commits/[commit_sha]/branches-where-head.js" = "//pages/repos/[owner]/[repo]/commits/[commit_sha]/branches-where-head.js",
    .@"pages/repos/[owner]/[repo]/commits/[commit_sha]/comments.js" = "//pages/repos/[owner]/[repo]/commits/[commit_sha]/comments.js",
    .@"pages/repos/[owner]/[repo]/commits/[commit_sha]/pulls.js" = "//pages/repos/[owner]/[repo]/commits/[commit_sha]/pulls.js",
    .@"pages/repos/[owner]/[repo]/commits/[ref].js" = "//pages/repos/[owner]/[repo]/commits/[ref].js",
    .@"pages/repos/[owner]/[repo]/commits/[ref]/check-runs.js" = "//pages/repos/[owner]/[repo]/commits/[ref]/check-runs.js",
    .@"pages/repos/[owner]/[repo]/commits/[ref]/check-suites.js" = "//pages/repos/[owner]/[repo]/commits/[ref]/check-suites.js",
    .@"pages/repos/[owner]/[repo]/commits/[ref]/status.js" = "//pages/repos/[owner]/[repo]/commits/[ref]/status.js",
    .@"pages/repos/[owner]/[repo]/commits/[ref]/statuses.js" = "//pages/repos/[owner]/[repo]/commits/[ref]/statuses.js",
    .@"pages/repos/[owner]/[repo]/community/profile.js" = "//pages/repos/[owner]/[repo]/community/profile.js",
    .@"pages/repos/[owner]/[repo]/compare/[basehead].js" = "//pages/repos/[owner]/[repo]/compare/[basehead].js",
    .@"pages/repos/[owner]/[repo]/contents/[path].js" = "//pages/repos/[owner]/[repo]/contents/[path].js",
    .@"pages/repos/[owner]/[repo]/contributors.js" = "//pages/repos/[owner]/[repo]/contributors.js",
    .@"pages/repos/[owner]/[repo]/deployments.js" = "//pages/repos/[owner]/[repo]/deployments.js",
    .@"pages/repos/[owner]/[repo]/deployments/[deployment_id].js" = "//pages/repos/[owner]/[repo]/deployments/[deployment_id].js",
    .@"pages/repos/[owner]/[repo]/deployments/[deployment_id]/statuses.js" = "//pages/repos/[owner]/[repo]/deployments/[deployment_id]/statuses.js",
    .@"pages/repos/[owner]/[repo]/deployments/[deployment_id]/statuses/[status_id].js" = "//pages/repos/[owner]/[repo]/deployments/[deployment_id]/statuses/[status_id].js",
    .@"pages/repos/[owner]/[repo]/environments.js" = "//pages/repos/[owner]/[repo]/environments.js",
    .@"pages/repos/[owner]/[repo]/environments/[environment_name].js" = "//pages/repos/[owner]/[repo]/environments/[environment_name].js",
    .@"pages/repos/[owner]/[repo]/events.js" = "//pages/repos/[owner]/[repo]/events.js",
    .@"pages/repos/[owner]/[repo]/forks.js" = "//pages/repos/[owner]/[repo]/forks.js",
    .@"pages/repos/[owner]/[repo]/git/blobs/[file_sha].js" = "//pages/repos/[owner]/[repo]/git/blobs/[file_sha].js",
    .@"pages/repos/[owner]/[repo]/git/commits/[commit_sha].js" = "//pages/repos/[owner]/[repo]/git/commits/[commit_sha].js",
    .@"pages/repos/[owner]/[repo]/git/matching-refs/[ref].js" = "//pages/repos/[owner]/[repo]/git/matching-refs/[ref].js",
    .@"pages/repos/[owner]/[repo]/git/ref/[ref].js" = "//pages/repos/[owner]/[repo]/git/ref/[ref].js",
    .@"pages/repos/[owner]/[repo]/git/tags/[tag_sha].js" = "//pages/repos/[owner]/[repo]/git/tags/[tag_sha].js",
    .@"pages/repos/[owner]/[repo]/git/trees/[tree_sha].js" = "//pages/repos/[owner]/[repo]/git/trees/[tree_sha].js",
    .@"pages/repos/[owner]/[repo]/hooks.js" = "//pages/repos/[owner]/[repo]/hooks.js",
    .@"pages/repos/[owner]/[repo]/hooks/[hook_id].js" = "//pages/repos/[owner]/[repo]/hooks/[hook_id].js",
    .@"pages/repos/[owner]/[repo]/hooks/[hook_id]/config.js" = "//pages/repos/[owner]/[repo]/hooks/[hook_id]/config.js",
    .@"pages/repos/[owner]/[repo]/hooks/[hook_id]/deliveries.js" = "//pages/repos/[owner]/[repo]/hooks/[hook_id]/deliveries.js",
    .@"pages/repos/[owner]/[repo]/hooks/[hook_id]/deliveries/[delivery_id].js" = "//pages/repos/[owner]/[repo]/hooks/[hook_id]/deliveries/[delivery_id].js",
    .@"pages/repos/[owner]/[repo]/import.js" = "//pages/repos/[owner]/[repo]/import.js",
    .@"pages/repos/[owner]/[repo]/import/authors.js" = "//pages/repos/[owner]/[repo]/import/authors.js",
    .@"pages/repos/[owner]/[repo]/import/large_files.js" = "//pages/repos/[owner]/[repo]/import/large_files.js",
    .@"pages/repos/[owner]/[repo]/interaction-limits.js" = "//pages/repos/[owner]/[repo]/interaction-limits.js",
    .@"pages/repos/[owner]/[repo]/invitations.js" = "//pages/repos/[owner]/[repo]/invitations.js",
    .@"pages/repos/[owner]/[repo]/issues.js" = "//pages/repos/[owner]/[repo]/issues.js",
    .@"pages/repos/[owner]/[repo]/issues/[issue_number].js" = "//pages/repos/[owner]/[repo]/issues/[issue_number].js",
    .@"pages/repos/[owner]/[repo]/issues/[issue_number]/comments.js" = "//pages/repos/[owner]/[repo]/issues/[issue_number]/comments.js",
    .@"pages/repos/[owner]/[repo]/issues/[issue_number]/events.js" = "//pages/repos/[owner]/[repo]/issues/[issue_number]/events.js",
    .@"pages/repos/[owner]/[repo]/issues/[issue_number]/labels.js" = "//pages/repos/[owner]/[repo]/issues/[issue_number]/labels.js",
    .@"pages/repos/[owner]/[repo]/issues/[issue_number]/reactions.js" = "//pages/repos/[owner]/[repo]/issues/[issue_number]/reactions.js",
    .@"pages/repos/[owner]/[repo]/issues/[issue_number]/timeline.js" = "//pages/repos/[owner]/[repo]/issues/[issue_number]/timeline.js",
    .@"pages/repos/[owner]/[repo]/issues/comments.js" = "//pages/repos/[owner]/[repo]/issues/comments.js",
    .@"pages/repos/[owner]/[repo]/issues/comments/[comment_id].js" = "//pages/repos/[owner]/[repo]/issues/comments/[comment_id].js",
    .@"pages/repos/[owner]/[repo]/issues/comments/[comment_id]/reactions.js" = "//pages/repos/[owner]/[repo]/issues/comments/[comment_id]/reactions.js",
    .@"pages/repos/[owner]/[repo]/issues/events.js" = "//pages/repos/[owner]/[repo]/issues/events.js",
    .@"pages/repos/[owner]/[repo]/issues/events/[event_id].js" = "//pages/repos/[owner]/[repo]/issues/events/[event_id].js",
    .@"pages/repos/[owner]/[repo]/keys.js" = "//pages/repos/[owner]/[repo]/keys.js",
    .@"pages/repos/[owner]/[repo]/keys/[key_id].js" = "//pages/repos/[owner]/[repo]/keys/[key_id].js",
    .@"pages/repos/[owner]/[repo]/labels.js" = "//pages/repos/[owner]/[repo]/labels.js",
    .@"pages/repos/[owner]/[repo]/labels/[name].js" = "//pages/repos/[owner]/[repo]/labels/[name].js",
    .@"pages/repos/[owner]/[repo]/languages.js" = "//pages/repos/[owner]/[repo]/languages.js",
    .@"pages/repos/[owner]/[repo]/license.js" = "//pages/repos/[owner]/[repo]/license.js",
    .@"pages/repos/[owner]/[repo]/milestones.js" = "//pages/repos/[owner]/[repo]/milestones.js",
    .@"pages/repos/[owner]/[repo]/milestones/[milestone_number].js" = "//pages/repos/[owner]/[repo]/milestones/[milestone_number].js",
    .@"pages/repos/[owner]/[repo]/milestones/[milestone_number]/labels.js" = "//pages/repos/[owner]/[repo]/milestones/[milestone_number]/labels.js",
    .@"pages/repos/[owner]/[repo]/pages.js" = "//pages/repos/[owner]/[repo]/pages.js",
    .@"pages/repos/[owner]/[repo]/pages/builds.js" = "//pages/repos/[owner]/[repo]/pages/builds.js",
    .@"pages/repos/[owner]/[repo]/pages/builds/[build_id].js" = "//pages/repos/[owner]/[repo]/pages/builds/[build_id].js",
    .@"pages/repos/[owner]/[repo]/pages/builds/latest.js" = "//pages/repos/[owner]/[repo]/pages/builds/latest.js",
    .@"pages/repos/[owner]/[repo]/pages/health.js" = "//pages/repos/[owner]/[repo]/pages/health.js",
    .@"pages/repos/[owner]/[repo]/projects.js" = "//pages/repos/[owner]/[repo]/projects.js",
    .@"pages/repos/[owner]/[repo]/pulls.js" = "//pages/repos/[owner]/[repo]/pulls.js",
    .@"pages/repos/[owner]/[repo]/pulls/[pull_number].js" = "//pages/repos/[owner]/[repo]/pulls/[pull_number].js",
    .@"pages/repos/[owner]/[repo]/pulls/[pull_number]/comments.js" = "//pages/repos/[owner]/[repo]/pulls/[pull_number]/comments.js",
    .@"pages/repos/[owner]/[repo]/pulls/[pull_number]/commits.js" = "//pages/repos/[owner]/[repo]/pulls/[pull_number]/commits.js",
    .@"pages/repos/[owner]/[repo]/pulls/[pull_number]/files.js" = "//pages/repos/[owner]/[repo]/pulls/[pull_number]/files.js",
    .@"pages/repos/[owner]/[repo]/pulls/[pull_number]/merge.js" = "//pages/repos/[owner]/[repo]/pulls/[pull_number]/merge.js",
    .@"pages/repos/[owner]/[repo]/pulls/[pull_number]/requested_reviewers.js" = "//pages/repos/[owner]/[repo]/pulls/[pull_number]/requested_reviewers.js",
    .@"pages/repos/[owner]/[repo]/pulls/[pull_number]/reviews.js" = "//pages/repos/[owner]/[repo]/pulls/[pull_number]/reviews.js",
    .@"pages/repos/[owner]/[repo]/pulls/[pull_number]/reviews/[review_id].js" = "//pages/repos/[owner]/[repo]/pulls/[pull_number]/reviews/[review_id].js",
    .@"pages/repos/[owner]/[repo]/pulls/[pull_number]/reviews/[review_id]/comments.js" = "//pages/repos/[owner]/[repo]/pulls/[pull_number]/reviews/[review_id]/comments.js",
    .@"pages/repos/[owner]/[repo]/pulls/comments.js" = "//pages/repos/[owner]/[repo]/pulls/comments.js",
    .@"pages/repos/[owner]/[repo]/pulls/comments/[comment_id].js" = "//pages/repos/[owner]/[repo]/pulls/comments/[comment_id].js",
    .@"pages/repos/[owner]/[repo]/pulls/comments/[comment_id]/reactions.js" = "//pages/repos/[owner]/[repo]/pulls/comments/[comment_id]/reactions.js",
    .@"pages/repos/[owner]/[repo]/readme.js" = "//pages/repos/[owner]/[repo]/readme.js",
    .@"pages/repos/[owner]/[repo]/readme/[dir].js" = "//pages/repos/[owner]/[repo]/readme/[dir].js",
    .@"pages/repos/[owner]/[repo]/releases.js" = "//pages/repos/[owner]/[repo]/releases.js",
    .@"pages/repos/[owner]/[repo]/releases/[release_id].js" = "//pages/repos/[owner]/[repo]/releases/[release_id].js",
    .@"pages/repos/[owner]/[repo]/releases/[release_id]/assets.js" = "//pages/repos/[owner]/[repo]/releases/[release_id]/assets.js",
    .@"pages/repos/[owner]/[repo]/releases/assets/[asset_id].js" = "//pages/repos/[owner]/[repo]/releases/assets/[asset_id].js",
    .@"pages/repos/[owner]/[repo]/releases/latest.js" = "//pages/repos/[owner]/[repo]/releases/latest.js",
    .@"pages/repos/[owner]/[repo]/releases/tags/[tag].js" = "//pages/repos/[owner]/[repo]/releases/tags/[tag].js",
    .@"pages/repos/[owner]/[repo]/secret-scanning/alerts.js" = "//pages/repos/[owner]/[repo]/secret-scanning/alerts.js",
    .@"pages/repos/[owner]/[repo]/secret-scanning/alerts/[alert_number].js" = "//pages/repos/[owner]/[repo]/secret-scanning/alerts/[alert_number].js",
    .@"pages/repos/[owner]/[repo]/stargazers.js" = "//pages/repos/[owner]/[repo]/stargazers.js",
    .@"pages/repos/[owner]/[repo]/stats/code_frequency.js" = "//pages/repos/[owner]/[repo]/stats/code_frequency.js",
    .@"pages/repos/[owner]/[repo]/stats/commit_activity.js" = "//pages/repos/[owner]/[repo]/stats/commit_activity.js",
    .@"pages/repos/[owner]/[repo]/stats/contributors.js" = "//pages/repos/[owner]/[repo]/stats/contributors.js",
    .@"pages/repos/[owner]/[repo]/stats/participation.js" = "//pages/repos/[owner]/[repo]/stats/participation.js",
    .@"pages/repos/[owner]/[repo]/stats/punch_card.js" = "//pages/repos/[owner]/[repo]/stats/punch_card.js",
    .@"pages/repos/[owner]/[repo]/subscribers.js" = "//pages/repos/[owner]/[repo]/subscribers.js",
    .@"pages/repos/[owner]/[repo]/tags.js" = "//pages/repos/[owner]/[repo]/tags.js",
    .@"pages/repos/[owner]/[repo]/tarball/[ref].js" = "//pages/repos/[owner]/[repo]/tarball/[ref].js",
    .@"pages/repos/[owner]/[repo]/teams.js" = "//pages/repos/[owner]/[repo]/teams.js",
    .@"pages/repos/[owner]/[repo]/topics.js" = "//pages/repos/[owner]/[repo]/topics.js",
    .@"pages/repos/[owner]/[repo]/traffic/clones.js" = "//pages/repos/[owner]/[repo]/traffic/clones.js",
    .@"pages/repos/[owner]/[repo]/traffic/popular/paths.js" = "//pages/repos/[owner]/[repo]/traffic/popular/paths.js",
    .@"pages/repos/[owner]/[repo]/traffic/popular/referrers.js" = "//pages/repos/[owner]/[repo]/traffic/popular/referrers.js",
    .@"pages/repos/[owner]/[repo]/traffic/views.js" = "//pages/repos/[owner]/[repo]/traffic/views.js",
    .@"pages/repos/[owner]/[repo]/zipball/[ref].js" = "//pages/repos/[owner]/[repo]/zipball/[ref].js",
    .@"pages/repositories.js" = "//pages/repositories.js",
    .@"pages/repositories/[repository_id]/environments/[environment_name]/secrets.js" = "//pages/repositories/[repository_id]/environments/[environment_name]/secrets.js",
    .@"pages/repositories/[repository_id]/environments/[environment_name]/secrets/[secret_name].js" = "//pages/repositories/[repository_id]/environments/[environment_name]/secrets/[secret_name].js",
    .@"pages/repositories/[repository_id]/environments/[environment_name]/secrets/public-key.js" = "//pages/repositories/[repository_id]/environments/[environment_name]/secrets/public-key.js",
    .@"pages/repositories/[repository_id]/[...jarred-fake-catch-all].js" = "//pages/repositories/[...jarred-fake-catch-all].js",
    .@"pages/scim/v2/enterprises/[enterprise]/Groups.js" = "//pages/scim/v2/enterprises/[enterprise]/Groups.js",
    .@"pages/scim/v2/enterprises/[enterprise]/Groups/[scim_group_id].js" = "//pages/scim/v2/enterprises/[enterprise]/Groups/[scim_group_id].js",
    .@"pages/scim/v2/enterprises/[enterprise]/Users.js" = "//pages/scim/v2/enterprises/[enterprise]/Users.js",
    .@"pages/scim/v2/enterprises/[enterprise]/Users/[scim_user_id].js" = "//pages/scim/v2/enterprises/[enterprise]/Users/[scim_user_id].js",
    .@"pages/scim/v2/organizations/[org]/Users.js" = "//pages/scim/v2/organizations/[org]/Users.js",
    .@"pages/scim/v2/organizations/[org]/Users/[scim_user_id].js" = "//pages/scim/v2/organizations/[org]/Users/[scim_user_id].js",
    .@"pages/search/code.js" = "//pages/search/code.js",
    .@"pages/search/commits.js" = "//pages/search/commits.js",
    .@"pages/search/issues.js" = "//pages/search/issues.js",
    .@"pages/search/labels.js" = "//pages/search/labels.js",
    .@"pages/search/repositories.js" = "//pages/search/repositories.js",
    .@"pages/search/topics.js" = "//pages/search/topics.js",
    .@"pages/search/users.js" = "//pages/search/users.js",
    .@"pages/teams/[team_id].js" = "//pages/teams/[team_id].js",
    .@"pages/teams/[team_id]/discussions.js" = "//pages/teams/[team_id]/discussions.js",
    .@"pages/teams/[team_id]/discussions/[discussion_number].js" = "//pages/teams/[team_id]/discussions/[discussion_number].js",
    .@"pages/teams/[team_id]/discussions/[discussion_number]/comments.js" = "//pages/teams/[team_id]/discussions/[discussion_number]/comments.js",
    .@"pages/teams/[team_id]/discussions/[discussion_number]/comments/[comment_number].js" = "//pages/teams/[team_id]/discussions/[discussion_number]/comments/[comment_number].js",
    .@"pages/teams/[team_id]/discussions/[discussion_number]/comments/[comment_number]/reactions.js" = "//pages/teams/[team_id]/discussions/[discussion_number]/comments/[comment_number]/reactions.js",
    .@"pages/teams/[team_id]/discussions/[discussion_number]/reactions.js" = "//pages/teams/[team_id]/discussions/[discussion_number]/reactions.js",
    .@"pages/teams/[team_id]/invitations.js" = "//pages/teams/[team_id]/invitations.js",
    .@"pages/teams/[team_id]/members.js" = "//pages/teams/[team_id]/members.js",
    .@"pages/teams/[team_id]/members/[username].js" = "//pages/teams/[team_id]/members/[username].js",
    .@"pages/teams/[team_id]/memberships/[username].js" = "//pages/teams/[team_id]/memberships/[username].js",
    .@"pages/teams/[team_id]/projects.js" = "//pages/teams/[team_id]/projects.js",
    .@"pages/teams/[team_id]/projects/[project_id].js" = "//pages/teams/[team_id]/projects/[project_id].js",
    .@"pages/teams/[team_id]/repos.js" = "//pages/teams/[team_id]/repos.js",
    .@"pages/teams/[team_id]/repos/[owner]/[repo].js" = "//pages/teams/[team_id]/repos/[owner]/[repo].js",
    .@"pages/teams/[team_id]/teams.js" = "//pages/teams/[team_id]/teams.js",
    .@"pages/users.js" = "//pages/users.js",
    .@"pages/users/[username].js" = "//pages/users/[username].js",
    .@"pages/users/[username]/events.js" = "//pages/users/[username]/events.js",
    .@"pages/users/[username]/events/public.js" = "//pages/users/[username]/events/public.js",
    .@"pages/users/[username]/followers.js" = "//pages/users/[username]/followers.js",
    .@"pages/users/[username]/following.js" = "//pages/users/[username]/following.js",
    .@"pages/users/[username]/following/[target_user].js" = "//pages/users/[username]/following/[target_user].js",
    .@"pages/users/[username]/gpg_keys.js" = "//pages/users/[username]/gpg_keys.js",
    .@"pages/users/[username]/keys.js" = "//pages/users/[username]/keys.js",
    .@"pages/users/[username]/orgs.js" = "//pages/users/[username]/orgs.js",
    .@"pages/users/[username]/received_events.js" = "//pages/users/[username]/received_events.js",
    .@"pages/users/[username]/received_events/public.js" = "//pages/users/[username]/received_events/public.js",
    .@"pages/users/[username]/repos.js" = "//pages/users/[username]/repos.js",
    .@"pages/users/[username]/starred.js" = "//pages/users/[username]/starred.js",
    .@"pages/users/[username]/subscriptions.js" = "//pages/users/[username]/subscriptions.js",
    .@"pages/zen.js" = "//pages/zen.js",
};

// copy((await next.router.pageLoader.getPageList()).sort())
pub const vercel_routes_list = .{
    .@"pages/index.js" = "// pages/index.js",
    .@"pages/404.js" = "// pages/404.js",
    .@"pages/[teamSlug].js" = "// pages/[teamSlug].js",
    .@"pages/[teamSlug]/[project].js" = "// pages/[teamSlug]/[project].js",
    .@"pages/[teamSlug]/[project]/[id].js" = "// pages/[teamSlug]/[project]/[id].js",
    .@"pages/[teamSlug]/[project]/[id]/[suffix].js" = "// pages/[teamSlug]/[project]/[id]/[suffix].js",
    .@"pages/[teamSlug]/[project]/[id]/[suffix]/functions.js" = "// pages/[teamSlug]/[project]/[id]/[suffix]/functions.js",
    .@"pages/[teamSlug]/[project]/[id]/[suffix]/source.js" = "// pages/[teamSlug]/[project]/[id]/[suffix]/source.js",
    .@"pages/[teamSlug]/[project]/[id]/functions.js" = "// pages/[teamSlug]/[project]/[id]/functions.js",
    .@"pages/[teamSlug]/[project]/[id]/source.js" = "// pages/[teamSlug]/[project]/[id]/source.js",
    .@"pages/[teamSlug]/[project]/deployments.js" = "// pages/[teamSlug]/[project]/deployments.js",
    .@"pages/[teamSlug]/[project]/domains.js" = "// pages/[teamSlug]/[project]/domains.js",
    .@"pages/[teamSlug]/[project]/insights.js" = "// pages/[teamSlug]/[project]/insights.js",
    .@"pages/[teamSlug]/[project]/integrations/[cfgId].js" = "// pages/[teamSlug]/[project]/integrations/[cfgId].js",
    .@"pages/[teamSlug]/[project]/settings.js" = "// pages/[teamSlug]/[project]/settings.js",
    .@"pages/[teamSlug]/[project]/settings/advanced.js" = "// pages/[teamSlug]/[project]/settings/advanced.js",
    .@"pages/[teamSlug]/[project]/settings/domains.js" = "// pages/[teamSlug]/[project]/settings/domains.js",
    .@"pages/[teamSlug]/[project]/settings/environment-variables.js" = "// pages/[teamSlug]/[project]/settings/environment-variables.js",
    .@"pages/[teamSlug]/[project]/settings/general.js" = "// pages/[teamSlug]/[project]/settings/general.js",
    .@"pages/[teamSlug]/[project]/settings/git.js" = "// pages/[teamSlug]/[project]/settings/git.js",
    .@"pages/[teamSlug]/[project]/settings/integrations.js" = "// pages/[teamSlug]/[project]/settings/integrations.js",
    .@"pages/[teamSlug]/[project]/settings/security.js" = "// pages/[teamSlug]/[project]/settings/security.js",
    .@"pages/[teamSlug]/[project]/settings/serverless-functions.js" = "// pages/[teamSlug]/[project]/settings/serverless-functions.js",
    .@"pages/_app.js" = "// pages/_app.js",
    .@"pages/_error.js" = "// pages/_error.js",
    .@"pages/_flags.js" = "// pages/_flags.js",
    .@"pages/about.js" = "// pages/about.js",
    .@"pages/about/[member].js" = "// pages/about/[member].js",
    .@"pages/account.js" = "// pages/account.js",
    .@"pages/account/billing.js" = "// pages/account/billing.js",
    .@"pages/account/general.js" = "// pages/account/general.js",
    .@"pages/account/git.js" = "// pages/account/git.js",
    .@"pages/account/invoices.js" = "// pages/account/invoices.js",
    .@"pages/account/login-connections.js" = "// pages/account/login-connections.js",
    .@"pages/account/teams.js" = "// pages/account/teams.js",
    .@"pages/account/tokens.js" = "// pages/account/tokens.js",
    .@"pages/blog.js" = "// pages/blog.js",
    .@"pages/blog/[post].js" = "// pages/blog/[post].js",
    .@"pages/blog/preview/[post].js" = "// pages/blog/preview/[post].js",
    .@"pages/careers.js" = "// pages/careers.js",
    .@"pages/careers/[slug].js" = "// pages/careers/[slug].js",
    .@"pages/careers/[slug]/preview.js" = "// pages/careers/[slug]/preview.js",
    .@"pages/careers/preview.js" = "// pages/careers/preview.js",
    .@"pages/case-studies/apideck.js" = "// pages/case-studies/apideck.js",
    .@"pages/case-studies/barnebys.js" = "// pages/case-studies/barnebys.js",
    .@"pages/case-studies/cssbattle.js" = "// pages/case-studies/cssbattle.js",
    .@"pages/case-studies/dashing.js" = "// pages/case-studies/dashing.js",
    .@"pages/case-studies/fireflies.js" = "// pages/case-studies/fireflies.js",
    .@"pages/case-studies/fitt.js" = "// pages/case-studies/fitt.js",
    .@"pages/case-studies/flowkit.js" = "// pages/case-studies/flowkit.js",
    .@"pages/case-studies/integral.js" = "// pages/case-studies/integral.js",
    .@"pages/case-studies/labelbox.js" = "// pages/case-studies/labelbox.js",
    .@"pages/case-studies/mural.js" = "// pages/case-studies/mural.js",
    .@"pages/case-studies/unspent.js" = "// pages/case-studies/unspent.js",
    .@"pages/changelog.js" = "// pages/changelog.js",
    .@"pages/changelog/[item].js" = "// pages/changelog/[item].js",
    .@"pages/changelog/preview/[item].js" = "// pages/changelog/preview/[item].js",
    .@"pages/cli.js" = "// pages/cli.js",
    .@"pages/communications-center.js" = "// pages/communications-center.js",
    .@"pages/confirm.js" = "// pages/confirm.js",
    .@"pages/contact.js" = "// pages/contact.js",
    .@"pages/contact/sales.js" = "// pages/contact/sales.js",
    .@"pages/customers.js" = "// pages/customers.js",
    .@"pages/customers/[slug].js" = "// pages/customers/[slug].js",
    .@"pages/customers/preview/[slug].js" = "// pages/customers/preview/[slug].js",
    .@"pages/dashboard.js" = "// pages/dashboard.js",
    .@"pages/dashboard/[teamSlug]/activity.js" = "// pages/dashboard/[teamSlug]/activity.js",
    .@"pages/dashboard/[teamSlug]/domains.js" = "// pages/dashboard/[teamSlug]/domains.js",
    .@"pages/dashboard/[teamSlug]/domains/[domain].js" = "// pages/dashboard/[teamSlug]/domains/[domain].js",
    .@"pages/dashboard/[teamSlug]/domains/delegate.js" = "// pages/dashboard/[teamSlug]/domains/delegate.js",
    .@"pages/dashboard/[teamSlug]/integrations.js" = "// pages/dashboard/[teamSlug]/integrations.js",
    .@"pages/dashboard/[teamSlug]/integrations/[cfgId].js" = "// pages/dashboard/[teamSlug]/integrations/[cfgId].js",
    .@"pages/dashboard/[teamSlug]/integrations/[cfgId]/installed.js" = "// pages/dashboard/[teamSlug]/integrations/[cfgId]/installed.js",
    .@"pages/dashboard/[teamSlug]/integrations/configuration.js" = "// pages/dashboard/[teamSlug]/integrations/configuration.js",
    .@"pages/dashboard/[teamSlug]/integrations/console.js" = "// pages/dashboard/[teamSlug]/integrations/console.js",
    .@"pages/dashboard/[teamSlug]/integrations/console/[slug].js" = "// pages/dashboard/[teamSlug]/integrations/console/[slug].js",
    .@"pages/dashboard/[teamSlug]/integrations/create.js" = "// pages/dashboard/[teamSlug]/integrations/create.js",
    .@"pages/dashboard/[teamSlug]/integrations/edit.js" = "// pages/dashboard/[teamSlug]/integrations/edit.js",
    .@"pages/dashboard/[teamSlug]/project/deployments.js" = "// pages/dashboard/[teamSlug]/project/deployments.js",
    .@"pages/dashboard/[teamSlug]/project/integrations/configuration.js" = "// pages/dashboard/[teamSlug]/project/integrations/configuration.js",
    .@"pages/dashboard/[teamSlug]/usage.js" = "// pages/dashboard/[teamSlug]/usage.js",
    .@"pages/dashboard/activity.js" = "// pages/dashboard/activity.js",
    .@"pages/dashboard/domains.js" = "// pages/dashboard/domains.js",
    .@"pages/dashboard/domains/[domain].js" = "// pages/dashboard/domains/[domain].js",
    .@"pages/dashboard/domains/delegate.js" = "// pages/dashboard/domains/delegate.js",
    .@"pages/dashboard/integrations.js" = "// pages/dashboard/integrations.js",
    .@"pages/dashboard/integrations/[cfgId].js" = "// pages/dashboard/integrations/[cfgId].js",
    .@"pages/dashboard/integrations/[cfgId]/installed.js" = "// pages/dashboard/integrations/[cfgId]/installed.js",
    .@"pages/dashboard/integrations/console.js" = "// pages/dashboard/integrations/console.js",
    .@"pages/dashboard/integrations/console/[slug].js" = "// pages/dashboard/integrations/console/[slug].js",
    .@"pages/dashboard/integrations/create.js" = "// pages/dashboard/integrations/create.js",
    .@"pages/dashboard/integrations/edit.js" = "// pages/dashboard/integrations/edit.js",
    .@"pages/dashboard/integrations/installed.js" = "// pages/dashboard/integrations/installed.js",
    .@"pages/dashboard/project/deployments.js" = "// pages/dashboard/project/deployments.js",
    .@"pages/dashboard/project/insights.js" = "// pages/dashboard/project/insights.js",
    .@"pages/dashboard/project/integrations/[cfgId].js" = "// pages/dashboard/project/integrations/[cfgId].js",
    .@"pages/dashboard/usage.js" = "// pages/dashboard/usage.js",
    .@"pages/deployment/redirect.js" = "// pages/deployment/redirect.js",
    .@"pages/deployments/[host]/source.js" = "// pages/deployments/[host]/source.js",
    .@"pages/design.js" = "// pages/design.js",
    .@"pages/design/autocomplete.js" = "// pages/design/autocomplete.js",
    .@"pages/design/avatar.js" = "// pages/design/avatar.js",
    .@"pages/design/badge.js" = "// pages/design/badge.js",
    .@"pages/design/brands.js" = "// pages/design/brands.js",
    .@"pages/design/button.js" = "// pages/design/button.js",
    .@"pages/design/calendar.js" = "// pages/design/calendar.js",
    .@"pages/design/capacity.js" = "// pages/design/capacity.js",
    .@"pages/design/checkbox.js" = "// pages/design/checkbox.js",
    .@"pages/design/collapse.js" = "// pages/design/collapse.js",
    .@"pages/design/color.js" = "// pages/design/color.js",
    .@"pages/design/combobox.js" = "// pages/design/combobox.js",
    .@"pages/design/description.js" = "// pages/design/description.js",
    .@"pages/design/drawer.js" = "// pages/design/drawer.js",
    .@"pages/design/entity.js" = "// pages/design/entity.js",
    .@"pages/design/error.js" = "// pages/design/error.js",
    .@"pages/design/feedback.js" = "// pages/design/feedback.js",
    .@"pages/design/fieldset.js" = "// pages/design/fieldset.js",
    .@"pages/design/file-tree.js" = "// pages/design/file-tree.js",
    .@"pages/design/footer.js" = "// pages/design/footer.js",
    .@"pages/design/grid.js" = "// pages/design/grid.js",
    .@"pages/design/icon.js" = "// pages/design/icon.js",
    .@"pages/design/icons.js" = "// pages/design/icons.js",
    .@"pages/design/image.js" = "// pages/design/image.js",
    .@"pages/design/input.js" = "// pages/design/input.js",
    .@"pages/design/keyboard-input.js" = "// pages/design/keyboard-input.js",
    .@"pages/design/link.js" = "// pages/design/link.js",
    .@"pages/design/loading-dots.js" = "// pages/design/loading-dots.js",
    .@"pages/design/marketing-text.js" = "// pages/design/marketing-text.js",
    .@"pages/design/menu.js" = "// pages/design/menu.js",
    .@"pages/design/modal.js" = "// pages/design/modal.js",
    .@"pages/design/nextjs.js" = "// pages/design/nextjs.js",
    .@"pages/design/note.js" = "// pages/design/note.js",
    .@"pages/design/playground.js" = "// pages/design/playground.js",
    .@"pages/design/popover.js" = "// pages/design/popover.js",
    .@"pages/design/popover-menu.js" = "// pages/design/popover-menu.js",
    .@"pages/design/progress.js" = "// pages/design/progress.js",
    .@"pages/design/radio.js" = "// pages/design/radio.js",
    .@"pages/design/scroller.js" = "// pages/design/scroller.js",
    .@"pages/design/select.js" = "// pages/design/select.js",
    .@"pages/design/show-more.js" = "// pages/design/show-more.js",
    .@"pages/design/skeleton.js" = "// pages/design/skeleton.js",
    .@"pages/design/snippet.js" = "// pages/design/snippet.js",
    .@"pages/design/spacer.js" = "// pages/design/spacer.js",
    .@"pages/design/spinner.js" = "// pages/design/spinner.js",
    .@"pages/design/stack.js" = "// pages/design/stack.js",
    .@"pages/design/status-dot.js" = "// pages/design/status-dot.js",
    .@"pages/design/switch.js" = "// pages/design/switch.js",
    .@"pages/design/table.js" = "// pages/design/table.js",
    .@"pages/design/tabs.js" = "// pages/design/tabs.js",
    .@"pages/design/tag.js" = "// pages/design/tag.js",
    .@"pages/design/text.js" = "// pages/design/text.js",
    .@"pages/design/textarea.js" = "// pages/design/textarea.js",
    .@"pages/design/toast.js" = "// pages/design/toast.js",
    .@"pages/design/toggle.js" = "// pages/design/toggle.js",
    .@"pages/design/tooltip.js" = "// pages/design/tooltip.js",
    .@"pages/design/ui.js" = "// pages/design/ui.js",
    .@"pages/design/video.js" = "// pages/design/video.js",
    .@"pages/design/video-card.js" = "// pages/design/video-card.js",
    .@"pages/design/window.js" = "// pages/design/window.js",
    .@"pages/domains.js" = "// pages/domains.js",
    .@"pages/experts.js" = "// pages/experts.js",
    .@"pages/experts/[slug].js" = "// pages/experts/[slug].js",
    .@"pages/experts/[slug]/projects/[projectSlug].js" = "// pages/experts/[slug]/projects/[projectSlug].js",
    .@"pages/git/authorize.js" = "// pages/git/authorize.js",
    .@"pages/github/installation-approved.js" = "// pages/github/installation-approved.js",
    .@"pages/github/installation-requested.js" = "// pages/github/installation-requested.js",
    .@"pages/github/installed.js" = "// pages/github/installed.js",
    .@"pages/hackathon.js" = "// pages/hackathon.js",
    .@"pages/home.js" = "// pages/home.js",
    .@"pages/import/[teamSlug].js" = "// pages/import/[teamSlug].js",
    .@"pages/insights.js" = "// pages/insights.js",
    .@"pages/integrations.js" = "// pages/integrations.js",
    .@"pages/integrations/[slug].js" = "// pages/integrations/[slug].js",
    .@"pages/integrations/[slug]/loading.js" = "// pages/integrations/[slug]/loading.js",
    .@"pages/integrations/[slug]/new.js" = "// pages/integrations/[slug]/new.js",
    .@"pages/keyboard.js" = "// pages/keyboard.js",
    .@"pages/legal/cookie-policy.js" = "// pages/legal/cookie-policy.js",
    .@"pages/legal/dmca-policy.js" = "// pages/legal/dmca-policy.js",
    .@"pages/legal/dpa.js" = "// pages/legal/dpa.js",
    .@"pages/legal/enterprise-terms.js" = "// pages/legal/enterprise-terms.js",
    .@"pages/legal/government-requests.js" = "// pages/legal/government-requests.js",
    .@"pages/legal/inactivity-policy.js" = "// pages/legal/inactivity-policy.js",
    .@"pages/legal/privacy-policy.js" = "// pages/legal/privacy-policy.js",
    .@"pages/legal/sla.js" = "// pages/legal/sla.js",
    .@"pages/legal/sub-processors.js" = "// pages/legal/sub-processors.js",
    .@"pages/legal/support-terms.js" = "// pages/legal/support-terms.js",
    .@"pages/legal/terms.js" = "// pages/legal/terms.js",
    .@"pages/legal/trademark-policy.js" = "// pages/legal/trademark-policy.js",
    .@"pages/live.js" = "// pages/live.js",
    .@"pages/login/[[...mode]].js" = "// pages/login/[[...mode]].js",
    .@"pages/login/scope/[teamSlug].js" = "// pages/login/scope/[teamSlug].js",
    .@"pages/new.js" = "// pages/new.js",
    .@"pages/new/[teamSlug].js" = "// pages/new/[teamSlug].js",
    .@"pages/new/[teamSlug]/clone.js" = "// pages/new/[teamSlug]/clone.js",
    .@"pages/new/[teamSlug]/git/third-party.js" = "// pages/new/[teamSlug]/git/third-party.js",
    .@"pages/new/[teamSlug]/import.js" = "// pages/new/[teamSlug]/import.js",
    .@"pages/new/[teamSlug]/success.js" = "// pages/new/[teamSlug]/success.js",
    .@"pages/new/[teamSlug]/templates.js" = "// pages/new/[teamSlug]/templates.js",
    .@"pages/new/clone.js" = "// pages/new/clone.js",
    .@"pages/new/git/connected.js" = "// pages/new/git/connected.js",
    .@"pages/new/git/third-party.js" = "// pages/new/git/third-party.js",
    .@"pages/new/import.js" = "// pages/new/import.js",
    .@"pages/new/success.js" = "// pages/new/success.js",
    .@"pages/new/templates.js" = "// pages/new/templates.js",
    .@"pages/notifications/account-being-deleted.js" = "// pages/notifications/account-being-deleted.js",
    .@"pages/notifications/account-deletion.js" = "// pages/notifications/account-deletion.js",
    .@"pages/notifications/authentication-failed.js" = "// pages/notifications/authentication-failed.js",
    .@"pages/notifications/cli-login-failed.js" = "// pages/notifications/cli-login-failed.js",
    .@"pages/notifications/cli-login-incomplete.js" = "// pages/notifications/cli-login-incomplete.js",
    .@"pages/notifications/cli-login-oob.js" = "// pages/notifications/cli-login-oob.js",
    .@"pages/notifications/cli-login-success.js" = "// pages/notifications/cli-login-success.js",
    .@"pages/notifications/deletion-confirmed.js" = "// pages/notifications/deletion-confirmed.js",
    .@"pages/notifications/email-change-failed.js" = "// pages/notifications/email-change-failed.js",
    .@"pages/notifications/email-changed.js" = "// pages/notifications/email-changed.js",
    .@"pages/notifications/email-confirmed.js" = "// pages/notifications/email-confirmed.js",
    .@"pages/notifications/email-signup-confirmed.js" = "// pages/notifications/email-signup-confirmed.js",
    .@"pages/notifications/token-expired.js" = "// pages/notifications/token-expired.js",
    .@"pages/oauth/authorize.js" = "// pages/oauth/authorize.js",
    .@"pages/oauth/git.js" = "// pages/oauth/git.js",
    .@"pages/oauth/verify.js" = "// pages/oauth/verify.js",
    .@"pages/oss.js" = "// pages/oss.js",
    .@"pages/partners.js" = "// pages/partners.js",
    .@"pages/partners/technology.js" = "// pages/partners/technology.js",
    .@"pages/popups/saml-sso.js" = "// pages/popups/saml-sso.js",
    .@"pages/pricing.js" = "// pages/pricing.js",
    .@"pages/security.js" = "// pages/security.js",
    .@"pages/signup/[[...mode]].js" = "// pages/signup/[[...mode]].js",
    .@"pages/solutions/angular.js" = "// pages/solutions/angular.js",
    .@"pages/solutions/gatsby.js" = "// pages/solutions/gatsby.js",
    .@"pages/solutions/nextjs.js" = "// pages/solutions/nextjs.js",
    .@"pages/solutions/react.js" = "// pages/solutions/react.js",
    .@"pages/solutions/vue.js" = "// pages/solutions/vue.js",
    .@"pages/support/request.js" = "// pages/support/request.js",
    .@"pages/teams.js" = "// pages/teams.js",
    .@"pages/teams/[teamSlug]/settings.js" = "// pages/teams/[teamSlug]/settings.js",
    .@"pages/teams/[teamSlug]/settings/billing.js" = "// pages/teams/[teamSlug]/settings/billing.js",
    .@"pages/teams/[teamSlug]/settings/general.js" = "// pages/teams/[teamSlug]/settings/general.js",
    .@"pages/teams/[teamSlug]/settings/git.js" = "// pages/teams/[teamSlug]/settings/git.js",
    .@"pages/teams/[teamSlug]/settings/invoices.js" = "// pages/teams/[teamSlug]/settings/invoices.js",
    .@"pages/teams/[teamSlug]/settings/members.js" = "// pages/teams/[teamSlug]/settings/members.js",
    .@"pages/teams/[teamSlug]/settings/security.js" = "// pages/teams/[teamSlug]/settings/security.js",
    .@"pages/teams/connect.js" = "// pages/teams/connect.js",
    .@"pages/teams/create.js" = "// pages/teams/create.js",
    .@"pages/teams/invite.js" = "// pages/teams/invite.js",
    .@"pages/teams/invite/[inviteCode].js" = "// pages/teams/invite/[inviteCode].js",
    .@"pages/tv.js" = "// pages/tv.js",
    .@"pages/tv/[video].js" = "// pages/tv/[video].js",
    .@"pages/vercel-live-auth.js" = "// pages/vercel-live-auth.js",
    .@"pages/virtual-event-starter-ki.js" = "// pages/virtual-event-starter-ki.js",
};
