#!/usr/local/bin/ruby -Ks
#
# reducegg.rb - oAnKCh폜
#
# usage: ruby reducegg.rb CERTAIN kwgg.dic > mygg.dic
#
# 2003-09-29
#	* nKCh̐VtH[}bg (wAKX 2x208-212) ɑΉ
#	* ɁA₪ɂȂGg͍폜
# 2003-09-28
# 	* fisrt ver.

# õXg
$certains = Array::new;

if ARGV.length <= 0 then
  $stderr.puts "usage: #{$0} CERTAIN [gg_dictionary]"
  exit 2
end

# CERTAIN ǂ݂
open(ARGV.shift) do |f|
  while line = f.gets do
    line.strip.split(//).each do |k|
      $certains.push(k) if /\s/ !~ k
    end
  end
end
$certains = $certains.sort.uniq

# nKChǂݍ݁AHȂAo͂
while line = gets do
  line.chomp!
  case line
  when /^([^ \/]+) \/(.*)$/
    # new format GG-dic
    leader, trailers = $1, $2.split(//)
    trailers.delete_if do |k|
      $certains.include?(k)
    end
    puts(leader + " /" + trailers.join("")) if 0 < trailers.length

  when /^(.)(.*)$/
    # old format GG-dic
    leader, trailers = $1, $2.split(//)
    trailers.delete_if do |k|
      $certains.include?(k)
    end
    puts(leader + trailers.join("")) if 0 < trailers.length

  else
    # invalid line
    $stderr.puts " skipped: #{line}"
  end # case line
end
