// -------------------------------------------------------------------
// class Block
//
// e[ui[邽߂̃NX

#ifndef BLOCK_H
#define BLOCK_H
// -------------------------------------------------------------------

#include <stdlib.h>
#include <string.h>

// -------------------------------------------------------------------
// NX̎

#define STRING_BLOCK  1
#define CONTROL_BLOCK 2
#define SPECIAL_BLOCK 3

// -------------------------------------------------------------------
// ubN̋@\

/* [h */
#define F_SWITCH_MODE   10      // @s  A/B [h̐؂ւ (OBSOLETE)
#define F_HIRAKATA      11      // @K A Ђ炪/
#define F_HANZEN        12      // @Z S p/Sp
#define F_PUNCT         13      // @p  Ǔ_؂ւ
//#define F_HANKANA     14      // @k  p
#define F_SHOWWIN       15      // @w  EBhE\\̐؂ւ
#define F_MAZE2GG       16      // @g K K[h
/* Ou^ */
#define F_BUSHU_PRE     21      // @b  Ou^̕񍇐
#define F_MAZE_PRE      22      // @m  Ou^̌ϊ
#define F_HIST          31      // @!  qXg
/*  */
#define F_QUIT          99      // @q ~ ϊ̒f
/* u^ */
#define F_BUSHU_POST    41      // @B  u^̕񍇐
#define F_MAZE_POST1    51      // @1  u^̌ϊ (1 )
#define F_MAZE_POST2    52      // @2  u^̌ϊ (2 )
#define F_MAZE_POST3    53      // @3  u^̌ϊ (3 )
#define F_MAZE_POST4    54      // @4  u^̌ϊ (4 )
#define F_MAZE_POST5    55      // @5  u^̌ϊ (5 )
#define F_MAZE_POST6    56      // @6  u^̌ϊ (6 )
#define F_MAZE_POST7    57      // @7  u^̌ϊ (7 )
#define F_MAZE_POST8    58      // @8  u^̌ϊ (8 )
#define F_MAZE_POST9    59      // @9  u^̌ϊ (9 )
#define F_DAKUTEN       61      // @D J u^̑_
#define F_HANDAKUTEN    62      // @P K u^̔_
#define F_KATA_POST0    100     // @- J u^̂ȕϊ (Ђ炪Ȍp)
#define F_KATA_POST1    101     // @Q J u^̂ȕϊ (1 )
#define F_KATA_POST2    102     // @R J u^̂ȕϊ (2 )
#define F_KATA_POST3    103     // @S J u^̂ȕϊ (3 )
#define F_KATA_POST4    104     // @T J u^̂ȕϊ (4 )
#define F_KATA_POST5    105     // @U J u^̂ȕϊ (5 )
#define F_KATA_POST6    106     // @V J u^̂ȕϊ (6 )
#define F_KATA_POST7    107     // @W J u^̂ȕϊ (7 )
#define F_KATA_POST8    108     // @X J u^̂ȕϊ (8 )
#define F_KATA_POST9    109     // @Y J u^̂ȕϊ (9 )
#define F_KATA_POSTH1   111     // @)  u^̂ȕϊ (Ђ炪1)
#define F_KATA_POSTH2   112     // @(  u^̂ȕϊ (Ђ炪2)
#define F_KATA_POSTH3   113     // @'  u^̂ȕϊ (Ђ炪3)
#define F_KATA_POSTH4   114     // @&  u^̂ȕϊ (Ђ炪4)
#define F_KATA_POSTH5   115     // @%  u^̂ȕϊ (Ђ炪5)
#define F_KATA_POSTH6   116     // @$  u^̂ȕϊ (Ђ炪6)
#define F_KATA_POSTS1   121     // @@  Ǒu^̂ȕϊk (1)
#define F_KATA_POSTS2   122     // @[  Ǒu^̂ȕϊk (2)
#define F_KATA_POSTS3   123     // @;  Ǒu^̂ȕϊk (3)
#define F_KATA_POSTS4   124     // @:  Ǒu^̂ȕϊk (4)
#define F_KATA_POSTS5   125     // @]  Ǒu^̂ȕϊk (5)
/* wv */
#define F_HELP_BACKW    71      // @h  wv (O̕)
#define F_HELP_FORW     72      // @H  wv (̕)
/* L[ */
#define F_VERB_FIRST    82      // @v E Ō̃L[
#define F_VERB_THIS     83      // @^ E ł̃L[

// -------------------------------------------------------------------
// Block

// visitor NX
class BlockVisitor;

// Block ̈ʌ` (ۃNX)
class Block {
 public:
    virtual char *getFace() = 0; // \p
    virtual ~Block() {};
    virtual int kind() = 0;     // NX̎
    virtual void *accept(BlockVisitor *) = 0;
};

// StringBlock - ͂ubN
class StringBlock : public Block {
 public:
    int length;                 // ̒
    char *str;                  // 
    char *face;                 // \p
    //<v127a - gg>
    int flagGG;                 // nKChΏ
    //</v127a - gg>
    char *getFace() { return face; }

    StringBlock(char * = 0);
    ~StringBlock();
    int kind() { return STRING_BLOCK; }
    void *accept(BlockVisitor *);
};

// ControlBlock - ubN
class ControlBlock : public Block {
 public:
    Block **block;
    //<v127a - gg>
    char *faceGG;
    //</v127a - gg>
    char *getFace() { return (char *)""; }

    ControlBlock();
    ~ControlBlock();
    int kind() { return CONTROL_BLOCK; }
    void *accept(BlockVisitor *);
};

// SpecialBlock - ̋@\̃ubN
class SpecialBlock : public Block {
 public:
    int function;           // ubN̋@\
    char *getFace();
    SpecialBlock(char);
    ~SpecialBlock() {};
    int kind() { return SPECIAL_BLOCK; }
    void *accept(BlockVisitor *);
};

class BlockVisitor {
 public:
    virtual void *visitStringBlock(StringBlock *) = 0;
    virtual void *visitControlBlock(ControlBlock *) = 0;
    virtual void *visitSpecialBlock(SpecialBlock *) = 0;
};

// -------------------------------------------------------------------
#endif // BLOCK_H
