#ifndef MOJI_H
#define MOJI_H
/* -------------------------------------------------------------------
 * MOJI ^
 * -------
 *
 *  MOJI (== unsigned short) ^ňB
 * ʏ̂̕قɁAzL[Aꕶ (񍇐ϊ̊Jn_)
 * AMOJI ^ňƂɂĂB
 * ƂɑΉ MOJI ^̕\ m ́ÂƂB
 *
 * - ASCII  c   : m = (MOJI)c
 * - p k     : m = (MOJI)k        (0x80 <= k)
 * - Sp (h l)     : m = B2MOJI(h, l)   (0x80 <= h)
 *
 * pȂƈ̂ȂA_┼_AO̕ƂƂ
 * ܂Ƃ߂ 1 Ƃ̂mȂB
 * Sp/p ̕ϊ鎞ƂB
 * <hankana>
 * ccƎvA
 * ͂A_┼_ɓƗƂĈƂɂB
 * </hankana>
 */

typedef unsigned short MOJI;

/* -------------------------------------------------------------------
 * char ȂǂƂ̑ݕϊ
 */

// Sp ( 1 oCg) ǂ
#define MSBOFF(c) ((c) & 0x7f)
#if 1  //<OKA> This may be better...
#define IS_ZENKAKU(c) (((c) & 0x80) && \
                       (0x01 <= MSBOFF(c) && MSBOFF(c) <= 0x1f || \
                        0x60 <= MSBOFF(c) && MSBOFF(c) <= 0x7c))
#else  //<OKA> ...than below.
#define IS_ZENKAKU(c) (((c) & 0x80) && \
                       (0x01 <= MSBOFF(c) & MSBOFF(c) <= 0x1f || \
                        0x60 <= MSBOFF(c) & MSBOFF(c) <= 0x7c))
#endif //</OKA>

// pȕǂ
#define IS_HANKANA(c) (((c) & 0x80) && \
                       (0x20 <= MSBOFF(c) && MSBOFF(c) <= 0x5f))

// 2  char  MOJI ^𐶐
#if 1  //<OKA> This may be better...
#define B2MOJI(h, l) MOJI((unsigned)((h) & 0xff) << 8 | (unsigned)((l) & 0xff))
#else  //<OKA> ...than below.
#define B2MOJI(h, l) ((unsigned)((h) & 0xff) << 8 | (unsigned)((l) & 0xff))
#endif //</OKA>

//<multishift>
//  s ̐擪 1  MOJI ^ɕϊ
#define STR2MOJI(s) B2MOJI(*(s), *((s) + 1))
//</multishift>

// MOJI  h  l o
#define MOJI2H(m) (((m) >> 8) & 0xff)
#define MOJI2L(m) ((m) & 0xff)

// MOJI ̎ނԂ
int mojitype(MOJI);

// char ̐擪 1  MOJI ^Ŏo
MOJI str2moji(const char *, char **);

// MOJI Aobt@ɒǉď (strcat ̂悤)
char *moji2strcat(char *, MOJI);

/* -------------------------------------------------------------------
 * MOJI ^̊eϊ
 * - mojiHirakata() : Ђ炪/ȕϊ
 * - mojiKata()     : Ȃւ̕ϊ(ȁЂ炪ȕϊ͍sȂ)
 * - mojiHanzen()   : p/Spϊ (ASCII )
 * - mojiDaku()     : /ϊ
 * - mojiHandaku()  : /ϊ
 * - mojiPunct()    : Ǔ_ϊ (uABv/uCDv)
 * - mojiHankana()  : <hankana/> Sp  p ̕ϊ
 */
MOJI mojiHirakata(MOJI);
MOJI mojiKata(MOJI);
MOJI mojiHanzen(MOJI);
MOJI mojiDaku(MOJI);
MOJI mojiHandaku(MOJI);
MOJI mojiPunct(MOJI);
//<hankana>
int mojiHankana(MOJI, MOJI *, MOJI *);
//</hankana>

/* -------------------------------------------------------------------
 * ̎
 */
#define MOJI_UNKNOWN -1
#define MOJI_ASCII    0         // ASCII 
#define MOJI_HANKANA 'K'        // p
#define MOJI_ZENKAKU 'Z'        // Sp
#define MOJI_UNICODE 'U'        // jR[h

#define MOJI_SPECIAL '@'        // 
#define MOJI_VKEY    '!'        // zL[
#define MOJI_CTRLVKY '"'        // Ctrl+zL[

/* -------------------------------------------------------------------
 * ꕶ
 */
#define MOJI_BUSHU B2MOJI('@', 'b') // Ou񍇐̕ϊJn_̃}[J
#define MOJI_MAZE  B2MOJI('@', 'm') // Ou̕ϊJn_̃}[J

/* -------------------------------------------------------------------
 * MojiBuffer
 * ----------
 * ŒTCY MOJI ^̃obt@
 * pushHard() gƂɂAOobt@ƂĎgB
 */
class MojiBuffer {
    int size;                   // obt@̑傫
    MOJI *buf;                  // size ̑傫z
    int beg;                    // e̐擪ʒu (0 .. (bufferSize - 1))
    int len;                    // e̒     (0 .. bufferSize)
    //int pt;                   // e̒𓮂|C^ (0 .. (len - 1))
    char *str;                  // e𕶎ƂĕԂɎgꎞobt@

public:
    MojiBuffer(int);
    ~MojiBuffer();

    void clear();               // ȅ
    int length();               // 
    int isEmpty();              // obt@󂩂ǂ
    int isFull();               // obt@tǂ
    void pushSoft(MOJI);        // } (size 𒴂Ȃ)
    void pushSoft(char *);      // V
    void pushSoftN(MOJI, int);  // V (̂ N )
    void pushSoftN(char *, int); // V
    void pushHard(MOJI);        // } (ߕ͏㏑)
    void pushHard(char *);      // V
    MOJI pop();                 //  1 ̎o
    MOJI popN(int);             //  N ̎o
    MOJI moji(int);             // wʒu̕
    char *string(int, int);     // wʒuEw蒷̕
    char *string(int);          // wʒu̕
    char *string();             // ƂĕԂ
};

// -------------------------------------------------------------------
#endif // MOJI_H
