#include "parser.h"
#include "moji.h"
#include "tc.h"
#include "debug.h"

// [hЂƂǂ
//̓t@C܂œ[hƂ݂ȂĂ
ControlBlock *Parser::parse() {
	ControlBlock *node = new ControlBlock();
    setNextToken();
    while (currentToken) {
        switch(currentToken) {
        case LBRACE:
            parseControl(node);
            break;
        case ARROW:
            parseRoute(node);
            break;
        default:
            parseError();
        }
        setNextToken();
    }
    return node;
}

// control block ЂƂǂ
void Parser::parseControl(ControlBlock *node) {
    checkToken(LBRACE);         // ŏ '{'
    setNextToken();

    for (int i = 0; i < TC_NKEYS; i++) {
      for (int j = 0; j < 2; j++) {
        int k = (j?TC_SHIFT(i):i);
        if (currentToken == LBRACE || currentToken == ARROW) {
            if (!node->block[k]) node->block[k] = new ControlBlock();
            if (node->block[k]->kind() != CONTROL_BLOCK) {
                delete(node->block[k]);
                node->block[k] = new ControlBlock();
            }
        }
        switch(currentToken) {
        case LBRACE:            // '{' : lXg control block
            parseControl((ControlBlock *)node->block[k]);
            setNextToken();
            if (currentToken != ARROW) break;
        case ARROW:             // '-n>' : control block ̎wʒuɈړ
            while (currentToken == ARROW) {
                parseRoute((ControlBlock *)node->block[k]);
                setNextToken();
            }
            break;
        case RBRACE:            // '}' uN
        case COMMA:             // ',' ĂuN
		case SLASH:             // '/' ĂuN
            break;
        case STRING:            // "str" : ubN
            if (node->block[k]) delete(node->block[k]);
            node->block[k] = new StringBlock(buffer);
            setNextToken();
            break;
        case SPECIAL:           // @c : ubN
            if (node->block[k]) delete(node->block[k]);
            node->block[k] = new SpecialBlock(buffer[0]);
            setNextToken();
            break;
        case 0:                 // rŃt@CIꍇ : G[
            parseError();
            break;
        }
        if (currentToken == SLASH) {
            setNextToken();
            continue;
        }
        break;
      }

        if (i != (TC_NKEYS - 1)) {
            // control ubN̍Ō̂ЂƂłȂAɂ̓R}Kv
            checkToken(COMMA);
            setNextToken();
        }
    }

    checkToken(RBRACE);         // ŏ '}'
    return ;
}

// control block ̒Ɉړ
void Parser::parseRoute(ControlBlock *node) {
    checkToken(ARROW);
    int k = buffer[0];
    setNextToken();

        if (currentToken == LBRACE || currentToken == ARROW) {
            if (!node->block[k]) node->block[k] = new ControlBlock();
            if (node->block[k]->kind() != CONTROL_BLOCK) {
                delete(node->block[k]);
                node->block[k] = new ControlBlock();
            }
        }
        switch(currentToken) {
        case LBRACE:            // '{' : lXg control block
            parseControl((ControlBlock *)node->block[k]);
            break;
        case ARROW:             // -n> : control block ̎wʒuɈړ
            parseRoute((ControlBlock *)node->block[k]);
            break;
        case STRING:            // "str" : ubN
            if (node->block[k]) delete(node->block[k]);
            node->block[k] = new StringBlock(buffer);
            break;
        case SPECIAL:           // @c : ubN
            if (node->block[k]) delete(node->block[k]);
            node->block[k] = new SpecialBlock(buffer[0]);
            break;
        case RBRACE:            // '}' G[
        case COMMA:             // ',' ĂG[
        case SLASH:             // '/' ĂG[
        case 0:                 // rŃt@CIꍇ : G[
            parseError();
            break;
        }

    return ;
}

// ݂̃g[Nߑł
void Parser::checkToken(int target) {
    if (currentToken != target) {
        parseError();           // G[
    }
}

// g[NЂƂǂ currentToken ɃZbg
void Parser::setNextToken() {
    currentToken = getToken();
}

// g[Nǂ
int Parser::getToken() {
    char c;

    is->get(c);
    if (is->eof()) return NULL;

    // '#' ܂ ';' ȍ~As܂ŃRg
    if (c == '#' || c == ';') {
        do {
            is ->get(c);
        } while (!is->eof() && c != 0 && c != '\n' && c != '\r');
        if (is->eof()) return NULL;
    }

    // ꕶ̃g[NV[Y
    switch (c) {
    case '{': return LBRACE;
    case '}': return RBRACE;
    case ',': return COMMA;
    case '/': return SLASH;

    case '\n':                  // ^J  : XLbvǍsԍ𑝂₷
        lineNumber++;
        // go down
    case ' ':                   // SPC : XLbv
    case '\t':                  // TAB : XLbv
    case '\r':                  // ^M  : XLbv
    case '\f':                  // ^L  : XLbv
        return getToken();

    case 0:
        return NULL;
    }

    // 
    if (c == '-') {
        is->get(c);
        int count = 0;
        while (!is->eof() && count < BUFFER_SIZE && c != '>') {
            if (is->eof() || c == 0) {
                parseError();
            }
            buffer[count] = c;
            count++;
            is->get(c);
        }
        buffer[count] = 0;
        int k;
        if (1 <= sscanf(buffer, "%d", &k)) ;
        else if (1 <= sscanf(buffer, "S%d", &k)) k = TC_SHIFT(k);
        else parseError();
        buffer[0] = k;
        return ARROW;
    }

    // 
    if (c == '@') {
        is->get(c);
        buffer[0] = c;
        return SPECIAL;
    }

    // ̎_ŁAĉ͕݁BG[B
    if (c != '"') {
        parseError();
    }

    // '"' ܂œǂ݂ŁAbuffer Ɋi[B
    // u"vǵu"\""vƕ\L邱ƂŎwłB
    // u\vǵu"\\"vƕ\LB
    // u\v́APɎ̈ꕶGXP[v邾ŁA
    // u"\n"vu"\t"vu"\ooo"v͖ΉB
    is->get(c);
    int count = 0;
    while (!is->eof() && count < BUFFER_SIZE && c != '"') {
        if (is->eof() || c == 0) {
            parseError();
        }
        if (IS_ZENKAKU(c)) {      // 擪 1 oCgĔf
            // Shift-JIS  2 oCg
            buffer[count] = c; count++; is->get(c);
            buffer[count] = c; count++; is->get(c);
        } else {
            // 1 oCg
            if (c == '\\') {
                // ŏ́u\v́APɓǂ݂Ƃ΂
                is->get(c);
            }
            buffer[count] = c; count++; is->get(c);
        }
    }
    buffer[count] = 0;

    return STRING;
}

// ǂ݂݂Ɏsꍇ
void Parser::parseError() {
    sprintf(buffer, "e[ut@C %d sڂ܂Ă悤ł",
            lineNumber);
    MessageBoxEx(hwnd, buffer, "G[",
                 MB_OK | MB_ICONERROR, LANG_JAPANESE);
    exit(1);
}

// -------------------------------------------------------------------
