#ifndef ST_TABLE_H
#define ST_TABLE_H
// -------------------------------------------------------------------
// class StTable
//
// Xg[N̋t\

//<multishift>
#include <iostream>
#include <fstream>
#include <windows.h>
//</multishift>
#include <map>

#include "block.h"
#include "moji.h"

// -------------------------------------------------------------------
// Xg[N : EOST I[̕ŕ\

typedef char STROKE;

#define EOST (STROKE)(0xff) // End Of STroke
#define STROKE_MAX (4)

int strokelen(const STROKE *);  // Xg[N
void strokecpy(STROKE *, const STROKE *); // Xg[ÑRs[

//<multishift>
// -------------------------------------------------------------------
// iVtg

#define MAXPREFS    8           // (iVtg) prefix ̌̏
#define MAXPREFLEN  4           // (iVtg) prefix ̒̏

struct PREF {
    char mkTbl[3];              // e[u\镶 (wxwxȂ
    int stlen;                  // prefix ̒
    STROKE st[MAXPREFLEN];      // prefix
    char mkSt[6][3];            // Xg[N\ (wxwxȂ)
};
//</multishift>

// -------------------------------------------------------------------
// StMap : STroke Map

typedef std::map<MOJI, STROKE *> StMap;

// -------------------------------------------------------------------
// StTable : STroke Table

class StTable {
public:
    STROKE *stroke;

    StMap *stMap;

    //<multishift>
    char defmkSt[6][3];         // wv̋L
    char (*mkSt)[3];
    char defmkTbl[3];           // e[u\镶
    char *mkTbl;
    int nprefs;                 // (iVtg) prefix ̌
    struct PREF pref[MAXPREFS]; // (iVtg) prefix `
    STROKE *baseStroke;         // prefix 菜 strokes
    //</multishift>

    StTable(Block *);
    ~StTable();

    void init(Block *);
    void initSub(Block *, STROKE *);
    int look(MOJI);

    //<multishift>
    /* readFile()  : u*.tblv prefix `ǂ݂ށB
     * setupPref() : "//26,23///://23,26///" ̂悤Ȉ
     *               prefix `ݒB
     * matchPref() : Xg[N prefix ̃}b`OB
     */
    void setupPref(const char *);
    //<127e>
    //void matchPref(STROKE *, STROKE **, char **, char (**)[]);
    void matchPref(STROKE *, STROKE **, char **, char (**)[3]);
    //</127e>
    //</multishift>
};

// -------------------------------------------------------------------
#endif // ST_TABLE_H
