#ifndef TABLE_WINDOW_H
#define TABLE_WINDOW_H
// -------------------------------------------------------------------
// class TableWindow
// C̃EBhE֘Ȁ

#include <iostream>
#include <fstream>
#include <windows.h>
#include <imm.h>
#include <stdio.h>
#include <stdlib.h>
#include <vector>

#include "block.h"
#include "bushu_dic.h"
#include "mg_table.h"
#include "moji.h"
//<v127a - gg>
#include "gg_dic.h"
//</v127a - gg>
#include "st_table.h"
#include "parser.h"
#include "tcode.h"
#include "version.h"

using namespace std;

#ifndef MAPVK_VK_TO_VSC
#define MAPVK_VK_TO_VSC (0)
#endif
#ifndef WM_UNICHAR
#define WM_UNICHAR 0x0109
#endif
#ifndef KEYEVENTF_UNICODE
#define KEYEVENTF_UNICODE     0x0004
#endif
typedef struct mytagGUITHREADINFO
{
    DWORD   cbSize;
    DWORD   flags;
    HWND    hwndActive;
    HWND    hwndFocus;
    HWND    hwndCapture;
    HWND    hwndMenuOwner;
    HWND    hwndMoveSize;
    HWND    hwndCaret;
    RECT    rcCaret;
} MYGUITHREADINFO, *PMYGUITHREADINFO, FAR * LPMYGUITHREADINFO;
struct MYHWINEVENTHOOK__ { int unused; };
typedef struct MYHWINEVENTHOOK__ *MYHWINEVENTHOOK;
typedef VOID (CALLBACK* MYWINEVENTPROC)(
    MYHWINEVENTHOOK hWinEventHook,
    DWORD         event,
    HWND          hwnd,
    LONG          idObject,
    LONG          idChild,
    DWORD         idEventThread,
    DWORD         dwmsEventTime);
#ifndef EVENT_SYSTEM_FOREGROUND
#define EVENT_SYSTEM_FOREGROUND         0x0003
#endif
#ifndef WINEVENT_OUTOFCONTEXT
#define WINEVENT_OUTOFCONTEXT   0x0000
#endif

/* -------------------------------------------------------------------
 * bZ[W
 */
#define KANCHOKU_ICONCLK 0x1001

#define ID_MYTIMER 32767

/* -------------------------------------------------------------------
 * 肷L[
 *
 * L[ԍ 0 ` 97 (== TC_NKEYS * 2 - 1) ͂ɗpL[B
 * 0x100ȍ~@\L[ƂȂĂB
 * Փ˂Ȃ悤ɋC邱ƁB
 */
#define ACTIVE_KEY (0x100 + 1) // ON/OFF ̐؂ւL[
#define ACTIVE2_KEY (0x100 + 2) // ON/OFF ̐؂ւL[A2
#define INACTIVE_KEY (0x100 + 3) // OFF ւ̐؂ւL[
#define INACTIVE2_KEY (0x100 + 4) // OFF ւ̐؂ւL[A2
#define ACTIVEIME_KEY (0x100 + 6) // IMEAɂ ON/OFF ̐؂ւ (Win])

#define ESC_KEY    (0x100 + 11) // ESC
#define CG_KEY     (0x100 + 12) // C-g

#define BS_KEY     (0x100 + 21) // BS
#define CH_KEY     (0x100 + 22) // C-h

#define RET_KEY    (0x100 + 31) // RET
#define CM_KEY     (0x100 + 32) // C-m
#define CJ_KEY     (0x100 + 33) // C-j

#define TAB_KEY    (0x100 + 41) // TAB
#define CI_KEY     (0x100 + 42) // C-i

#define LT_KEY     (0x100 + 51) // "<"
#define GT_KEY     (0x100 + 52) // ">"

#define LEFT_KEY   (0x100 + 61) // 
#define RIGHT_KEY  (0x100 + 62) // 
#define UP_KEY     (0x100 + 63) // 
#define DOWN_KEY   (0x100 + 64) // 
#define HOME_KEY   (0x100 + 65) // Home
#define END_KEY    (0x100 + 66) // End
#define PAGEUP_KEY   (0x100 + 67) // PgUp
#define PAGEDOWN_KEY (0x100 + 68) // PgDown
#define CLEFT_KEY  (0x100 + 71) // Ctrl+
#define CRIGHT_KEY (0x100 + 72) // Ctrl+


/* -------------------------------------------------------------------
 * z (1) - tHgƃEBhȆ傫
 *
 *   MARGIN                    BLOCK
 * Fddddddddddddddddddddddd 
 * FF 
 * F                      F 
 * F  F 
 * F                      F 
 * F  F 
 * F                      F  HEIGHT
 * F  F 
 * F                      F 
 * FF 
 * F                        F 
 * F    F 
 * FdddddddddddddddddddddddF 
 *  WIDTH  
 */
#define CHAR_SIZE (styleFontSize)          // ̑傫
#define LARGE_CHAR_SIZE (CHAR_SIZE+stylePadding*2)    // 傫̑傫
#define BLOCK_SIZE (CHAR_SIZE+stylePadding*3)         // zՂ̃L[̑傫
#define MARGIN_SIZE (4)         // zՂ̓VnE̗]
#define WIDTH  (MARGIN_SIZE * 2 + BLOCK_SIZE * 11 + 1)  // zՂ̉
#define HEIGHT (MARGIN_SIZE * 2 + BLOCK_SIZE * 5 + 1)   // zՂ̏c
#define TRUNC_MARK_SIZE (BLOCK_SIZE/3+3)
#define SHIFT_MARK_SIZE (BLOCK_SIZE/5+3)

/* -------------------------------------------------------------------
 * z (2) - F
 */
//<v127c>
// [AKX2:522] 256 Fł̖
// !!! see also table_window.c--handleCreate()--palent
//#define GRAYTONE(x) RGB((x), (x), (x))
#define GRAYTONE(x) PALETTERGB((x), (x), (x))
//</v127c>
// [h ON ̉z
#define COL_ON_LN styleCol[3] // g
#define COL_ON_K1 styleCol[4] // L[
#define COL_ON_K2 styleCol[5] // L[ (e)
#define COL_ON_K3 styleCol[6] // L[ (nCCg)
#define COL_ON_M1 styleCol[7] // ]
#define COL_ON_M2 styleCol[8] // ] (e)
#define COL_ON_M3 styleCol[9] // ] (nCCg)
// [h OFF ̉z
#define COL_OFF_LN styleCol[0] // g
#define COL_OFF_K1 styleCol[1] // L[
#define COL_OFF_M1 styleCol[2] // ]
//<v127c>
// FƔwiF
//#define COL_BLACK       (RGB(0x00, 0x00, 0x00)) // 
//#define COL_WHITE       (RGB(0xff, 0xff, 0xff)) // 
//#define COL_GRAY        (RGB(0x80, 0x80, 0x80)) // D
//#define COL_LT_GRAY     (RGB(0xc0, 0xc0, 0xc0)) // D
//#define COL_LT_RED      (RGB(0xff, 0xc0, 0xc0)) // 
//#define COL_LT_GREEN    (RGB(0xc0, 0xff, 0xc0)) // 
//#define COL_LT_BLUE     (RGB(0xc0, 0xc0, 0xff)) // 
//#define COL_LT_YELLOW   (RGB(0xff, 0xff, 0xc0)) // 
//#define COL_LT_CYAN     (RGB(0xc0, 0xff, 0xff)) // 
//#define COL_RED         (RGB(0xff, 0x00, 0x00)) // 
//#define COL_DK_CYAN     (RGB(0x00, 0x80, 0x80)) // [
////<v127a - gg>
//#define COL_DK_MAGENTA  (RGB(0x80, 0x00, 0x80)) // [
////</v127a - gg>
//#define COLORDEF(r, g, b) RGB((r), (g), (b))
#define COLORDEF(r, g, b) PALETTERGB((r), (g), (b))
#define COL_BLACK       styleCol[18] // 
#define COL_WHITE       (COLORDEF(0xff, 0xff, 0xff)) // 
#define COL_GRAY        (COLORDEF(0x80, 0x80, 0x80)) // D
#define COL_LT_GRAY     styleCol[13] // D
#define COL_LT_RED      styleCol[10] // 
#define COL_LT_GREEN    styleCol[11] // 
#define COL_LT_BLUE     styleCol[14] // 
#define COL_LT_YELLOW   styleCol[12] // 
#define COL_LT_CYAN     styleCol[15] // 
#define COL_RED         styleCol[19] // 
#define COL_DK_CYAN     styleCol[16] // [
#define COL_DK_MAGENTA  styleCol[17] // [
// !!! see also table_window.c--handleCreate()--palent
//</v127c>

/* -------------------------------------------------------------------
 * TableWindow NX
 */
class TableWindow {
private:
    // T-Code ϊ
    TCode *tc;

    // CX^Xnh
    HINSTANCE instance;
    // tHg
    HFONT hFont;
    HFONT hLFont;
    //<v127c>
    // pbg
    HPALETTE hPalette;
    //</v127c>
    // bZ[Ẅi[
    HWND hwnd;
    WPARAM wParam;
    WPARAM lParam;

    // ^XNgCɓo^
    NOTIFYICONDATA nid;

    // WM_KANCHOKU_CHAR֘A
    HINSTANCE hKanCharDLL;
    void (*lpfnMySetHook)(HHOOK *, HHOOK *);
    int (*lpfnMyEndHook)(void);
    HHOOK hNextMsgHook, hNextCWPHook;
    UINT WM_KANCHOKU_CHAR;
    UINT WM_KANCHOKU_UNICHAR;
    UINT WM_KANCHOKU_NOTIFYVKPROCESSKEY;
    UINT WM_KANCHOKU_NOTIFYIMESTATUS;
    UINT WM_KANCHOKU_SETIMESTATUS;

    HWND hwNewTarget;
    int inSetFocus;
    int bKeepBuffer;
    int bGlobalHotKey;

    enum HOTKEYMODE { OFF, NORMAL, EDITCLAUSE };
    HOTKEYMODE hotKeyMode;
    // ꊲL΂kߗpL[
    // T-CodeL[ƂԂĂꍇ̂LT_KEYAGT_KEY̑Ɏgp
    int tc_lt_key;
    int tc_gt_key;

    // J[\ړpostBufferNAAUnregister邽(łȂƈړx)
    int enabledCursorHotKey;

    // ShiftoizՕ\pj
    bool isShift;
    bool isShiftPrev;
    // Timeoutp
    int deciSecAfterStroke;

    // X^Cݒ
    COLORREF styleCol[20];
    char styleFontName[LF_FACESIZE];
    int styleFontSize;
    int stylePadding;

    // API̖IN
    HINSTANCE hUser32;
    BOOL (WINAPI *myGetGUIThreadInfo)(DWORD, PMYGUITHREADINFO);
    MYHWINEVENTHOOK (WINAPI *mySetWinEventHook)(DWORD, DWORD, HMODULE, MYWINEVENTPROC, DWORD, DWORD, DWORD);
    BOOL (WINAPI *myUnhookWinEvent)(MYHWINEVENTHOOK);

    // WinEvent
    MYHWINEVENTHOOK hEventHook;
    static VOID CALLBACK WinEventProc(MYHWINEVENTHOOK, DWORD, HWND, LONG, LONG, DWORD, DWORD);
    typedef struct { MYHWINEVENTHOOK h; void *p; } WEH;
    static vector<WEH> weh_map;
public:
    // RXgN^
    TableWindow(HINSTANCE i);
    // fXgN^
    ~TableWindow();
    // window procedure
    int wndProc(HWND, UINT, WPARAM, LPARAM);

private:
    // N/ҋ@
    void activate();            // N (HotKey ̊t)
    void inactivate();          // ҋ@ (HotKey ̉)
    //void setSpecialHotKey();    //  HotKey ̊mۂƉ
    void setMazeHotKey(int);
    void setCursorHotKey(int);
    void disableHotKey();
    void resumeHotKey();
    void disableGlobalHotKey();
    void resumeGlobalHotKey();
    void setTitleText();        // ^Cgo[̕ݒ

    // bZ[Wnh
    int handleCreate();         // WM_CREATE
    int handleDestroy();        // WM_DESTROY
    int handleLButtonDown();    // WM_LBUTTONDOWN
    int handlePaint();          // WM_PAINT
    int handleTimer();          // WM_TIMER
    int handleNotifyVKPROCESSKEY(); // WM_KANCHOKU_NOTIFYVKPROCESSKEY
    int handleNotifyIMEStatus();    // WM_KANCHOKU_NOTIFYIMESTATUS
    int handleForeground(HWND);     // EVENT_SYSTEM_FOREGROUND
    int handleHotKey();         // WM_HOTKEY

    // T-Code ֘A
    void initTC();              // T-Code ϊ̏
    void output();              // T-Code ϊʂ̏o

    // zՂ̕`
    void drawFrameOFF(HDC hdc); // OFF ̉zՂ̘g
    void drawFrame50(HDC hdc);  // ʏ펞̉zՂ̘g
    void drawFrame10(HDC hdc);  // ỈzՂ̘g
    void drawVKB50(HDC hdc, bool isWithBothSide = false);        // ʏ펞̉z
    void drawVKB10(HDC);        // Ỉz
    void drawMiniBuffer(HDC, int, COLORREF, MojiBuffer *);
                                // ~jobt@

    // G[
    void error(char *);         // G[\AI
    void warn(char *);          // x\邪Ap

    void readTargetWindowSetting(char *); // o͐EBhEƂ̐ݒ̓Ǎ
    int getOutputMethod(HWND);  // w肵EBhEɑ΂outputMethod擾

    void makeStyle();
    void readStyleSetting();
};

// -------------------------------------------------------------------
#endif // TABLE_WINDOW_H
