#ifndef TCODE_H
#define TCODE_H
/* -------------------------------------------------------------------
 * TCode NX - T-Code ϊ
 */

#include <vector>
#include <map>
#include <algorithm>
#ifdef _MSC_VER //<OKA>
using std::vector;
#endif          //</OKA>

#include "block.h"
#include "bushu_dic.h"
#include "mg_table.h"
//<v127a - gg>
#include "gg_dic.h"
//</v127a - gg>
#include "moji.h"
#include "st_table.h"
#include "tc.h"

//<record>
struct STATENT {
    int direct;                 // ړ͂
    int aux;                    // ⏕͂œ͂
};

#define STAT_DIRECT 0
#define STAT_AUX    1

typedef std::map<MOJI, struct STATENT> StatMap;
//</record>

// ΏۃEBhEւ̕o͕@
#define OUT_DISABLE -1
#define OUT_WMCHAR 0
#define OUT_WMIMECHAR 1
#define OUT_WMKANCHOKUCHAR 2
#define OUT_WMUNICHAR 3
#define OUT_KEYEVENTFUNICODE 4

/* TCode NX
 *
 * T-Code ϊƂĂ͂炭
 */
class TCode {
public:
    /* ϊe[u
     * --------------
     * ϊ퐶ɏǍ͒萔̂悤ɗṕB
     */
    int *vkey;                  // TC_NKEYS ̉zL[̔z
    ControlBlock *table;        // Xg[Nϊe[u
    StTable *stTable;           // Xg[Nte[u
    MgTable *mgTable;           // ϊ
    BushuDic *bushuDic;         // 񍇐ώ
    //<v127a - gg>
    GgDic *ggDic;               // nKCh
    //</v127a - gg>
    //int isReady;              // Ă邩
    int mazeReady;              // ϊp\
    int bushuReady;             // 񍇐p\
    //<v127a - gg>
    int ggReady;                // nKChp\
    //</v127a - gg>
    //<v127a - shiftcheck>
    bool *isShiftKana;          // ShiftԂRegisterHotKeyKvȃL[
                                // ǂtOi[z
    //</v127a - shiftcheck>
    bool isAnyShiftSeq;         // e[ut@Cŉ炩̃VtgŌ`Ă邩
    //<multishift2>
    DIR_TABLE dirTable;
    static void readDir(DIR_TABLE *, ifstream *);
    //</multishift2>

    /* IvV
     * ------------
     * kanchoku.ini Őݒ肷IvV
     * IvVꗗƃftHgĺAtable_window.c  initTC() QƁB
     */
    int OPT_hotKey;             // ON/OFF ̃L[
//<OKA> support unmodified hot key
    int OPT_unmodifiedHotKey;   // CTRLSHIFTȂǂmodifierȂłHotKeyƂē
//</OKA>
    int OPT_offHotKey;          // OFF L[
    int OPT_unmodifiedOffHotKey;// OFF L[(modifierȂ)
    char *OPT_keyboard;         // L[{[h`t@C
    char *OPT_tableFile;        // e[u`t@C

    char *OPT_bushu;            // 񍇐t@C
    char *OPT_mazegaki;         // ϊt@C
    //<v127a - gg>
    char *OPT_gg;               // nKCht@C
    //<gg-defg>
    char *OPT_defg;             // zēXg
    //</gg-defg>
    //</v127a - gg>
    int OPT_bushuAlgo;          // 񍇐ϊ̃ASY
    int OPT_conjugationalMaze;  // p̌ϊ
    int OPT_maze2gg;            // K[h
    STROKE *OPT_prefixautoassign; // nKCh̊OɃXg[NU

    int OPT_shiftKana;          // VtgŌł
    int OPT_shiftFallback;      // ꕔłVtgŌgȂz̏ꍇA
                                // VtgŌ̒`ȂʂŃVtgȂŌ̒`őp
    int OPT_shiftLockStroke;    // ShiftɂXg[NbN@\
    int OPT_enableHankakuKana;  // pȕϊ

    int OPT_useWMIMECHAR;       // o̓bZ[W
    std::map<char *, int, ltstr> OPT_outputMethodMap; // o͐EBhȄo͕@
    //<v127a - outputsleep>
    long OPT_outputSleep;       // zL[ output  Sleep  (ms)
    //</v127a - outputsleep>
    int OPT_outputVKeyMethod;
    int OPT_outputAlphabetAsVKey;
    int OPT_outputUnicode;

    int OPT_syncWithIME;        // IMEON/OFFƊWinON/OFFA
    int OPT_onoffLocal;         // EBhE؂ւƂɊeAvIMEԂD
    int OPT_whatisimeon;        // AIMEON/OFFƂON/OFFłANATIVE/ALNUMł
    int OPT_syncmaster;         // WinhotkeyIMEǂ
    int OPT_syncslave;          // IMȄԕωŊWinǂ
    int OPT_considerIMEAction;  // WM_KANCHOKU_NOTIFYVKPROCESSKEYp

    int OPT_xLoc;               // EBhEʒu
    int OPT_yLoc;               // V
    int OPT_offHide;            // OFF ɃEBhE\
    int OPT_followCaret;        // J[\Ǐ]
    int OPT_displayHelpDelay;   // zՕ\҂(ms)

    int OPT_hardBS;             // BS ŏɕ
    int OPT_weakBS;             // BS 1Xg[N߂
    int OPT_useCtrlKey;         // C-h Ȃǂ BS ȂǂƂĈ
    int OPT_clearBufOnMove;     // J[\ړŌu^ϊpobt@ɂ
    int OPT_useTTCode;          // O\ T-Code X^C̕wv
    int OPT_win95;              // win95 ł̃tHĝ̕␳
    char *OPT_offResetModes;    // e탂[hZbg
    int OPT_strokeTimeOut;      // Ō܂ł̑҂(ms)

    //<record>
    // L^p
    struct KWRECORD {
        char *OPT_record;       // kwrecord.txt t@C
        int nchar;              // ړ͕
        int nstroke;            // Xg[N
        int nbushu;             // 񍇐œ͂
        int nmaze;              // œ͂
        int nspecial;           // @\̎gp
    } record;
    void recordSetup(const char *);
    void recordOutput();

    // vp
    struct KWSTAT {
        char *OPT_stat;         // kwstat.txt t@C
        StatMap map;
    } stat;
    void statSetup(const char *);
    void statOutput();
    void statCount(MOJI, int);
    void statCount(MOJI, int, int);
    //</record>

    /* [h
     * --------
     * mode
     * ----
     * 僂[h
     * - OFF    : OFF
     * - NORMAL : ʏ̃Xg[ŃB~jobt@͂܂
     * - CAND   : ̌I[h
     * - HIST   : qXg (qXǧI[h)
     *
     * helpMode, helpModeSave
     * ----------------------
     * wv\邩ǂB
     * wv́Aʏ mode == NORMAL ɂB
     *
     * hanzenMode, hirakataMode, punctMode
     * -----------------------------------
     * mode == NORMAL ɂāAXg[NϊAꂼA
     * Ђ炪/ȕϊAp/SpϊAǓ_ϊ邩ǂB
     */
    enum MODE { OFF, NORMAL, CAND, CAND1, HIST };
    MODE mode;
    int helpMode;
    int helpModeSave;
    int hanzenMode;
    int hirakataMode;
    int punctMode;
    //int hankanaMode;
    int maze2ggMode;

    /* Xg[N͂̏
     * --------------------
     * - currentBlock   : ϊe[ǔ݈ʒu|C^B
     * - currentStroke  : ݂܂ł̃L[Xg[NێxN^B
     * - currentShift   : ݂܂ł̃Xg[NɃVtgŌB
     * - lockedBlock      : Xg[NbN@\ňꎞITCode::tablȇɂȂ|C^B
     * - lockedStroke     : Xg[NbN@\ŃbNXg[NB
     * - inputtedStroke   : displayHelpDelay ŃfBC̕\ɎgXg[NB
     */
    ControlBlock *currentBlock;
    std::vector<STROKE> *currentStroke;
    int currentShift;
    ControlBlock *lockedBlock;
    std::vector<STROKE> *lockedStroke;
    std::vector<STROKE> *inputtedStroke;

    /* ́Eϊpobt@
     * --------------------
     * - preBuffer  : Xg[NϊꎞIɕێobt@B
     *                KvɉāA񍇐EϊsꂽA
     *                AvP[Vɏo͂B
     * - postBuffer : AvP[Vɏo͂ꂽ (ŋ߂) ێB
     *                u^̕ϊŎgpBTableWindow::output() ōXVB
     * - postDelete : u^̕ϊŁAxf[g镶B
     * - helpBuffer : wv̑ΏۂƂȂ镶 (⏕ϊœ͂) 
     *                ێobt@B
     * - helpOffset : helpBuffer ŁAݕwv\镶wB
     */
    MojiBuffer *preBuffer;
    MojiBuffer *postBuffer;
    int postDelete;
    //<v127c - postInPre>
    int postInPre;
    int postKataPrevLen; // Ǒu^̂ȕϊŕϊ
    //</v127c>
    MojiBuffer *helpBuffer;
    int helpOffset;

    /* ϊ
     * ------------
     *
     * candOrder[], candSkip
     * ---------------------
     * ϊ̌ĨL[̗D揇ʁAсA
     * OQ/Q̃XLbvʁBtcode.c ł̒`QƁB
     *
     * currentCand, candOffset
     * -----------------------
     * ΐA݂̓ǂ݂ɑ΂S̃xN^AсA
     * ݉zՂɕ\ĂQ̃ItZbgB
     *
     * - yomi       : ݂̌ϊ̓ǂ
     * - yomiLen    : ݂̌ϊ̓ǂ݂̒
     * - cand       : I΂ꂽ
     */
    static const int candOrder[TC_NKEYS];
    static const unsigned int candSkip;
    std::vector<char *> *currentCand;
    unsigned int candOffset;
    char yomi[TC_BUFFER_SIZE * 2 + 1];
    int yomiLen;
    int okuriLen;
    char *cand;

    /* qXg
     * ------------
     * - hist[]     : ݂̃qXg̑S
     * - histRef[]  : eqXg̎Qƃrbg
     * - histPtr    : OɒǉꂽqXg̈ʒu
     */
    char *hist[TC_NHIST];
    int histRef[TC_NHIST];
    int histPtr;

    /* nKChAK[hAOU
	 */
    std::vector<char *> *ggCand;
    int ggCHeaderLen;  // ͍ς݂Ƃ镶
    int ggCStart;  // preBuffer or postBufferł̕ϊʊJnʒu
                   // ex. preBuffer == "", []  ggCStart == 1
                   //     preBuffer == "", postBuffer == "...", []  ggCStart == -1
    int ittaku;  // 
    char *explicitGG;
    MojiBuffer *assignedsBuffer;

    /* z
     * --------
     * - vkbFace[]  : zՂ̊eL[̃tFCX
     * - vkbFG[]    : zՂ̊eL[̑OiFBL TC_FG_* QƁB
     * - vkbBG[]    : zՂ̊eL[̔wiFBL TC_BG_* QƁB
     * - waitKeytop : displayHelpDelay oߑOǂ
     */
    char *vkbFace[TC_NKEYS*2];
    int vkbFG[TC_NKEYS*2];
    int vkbBG[TC_NKEYS];
    int vkbCorner[TC_NKEYS];
    int waitKeytop;

    /* RXgN^ƃfXgN^
     */
    //<v127a - gg>
    //TCode(int *, ControlBlock *, MgTable *, BushuDic *);
    TCode(int *, ControlBlock *, MgTable *, BushuDic *, GgDic *);
    //</v127a - gg>
    ~TCode();

    /* Zbg
     */
    void reset();
    void resetBuffer();
    void lockStroke();
    void unlockStroke();

    /* L[
     * --------
     * NORMAL, CAND, HIST ̊e[hɑΉAL[͏[`
     */
    void keyinNormal(int);
    void keyinNormalKataPost(int);
    void keyinNormalKataPostShrink(int);
    void keyinCand(int);
    void keyinCand1(int);
    void keyinHist(int);

    /* obt@Ǘ
     * ------------
     * - postBufferDeleted()    : postBuffer̖pop()iAvBackspace𑗂jƂB
     * - postBufferCount()      : preBuffer̓epostBuffer֓]iAvɕ𑗂jƂB
     */
    void postBufferDeleted(int);
    void postBufferCount(int);

    /* ⏕ϊ
     * --------
     * ApreBuffer ̓eɊւ́B
     * - isReducibleByBushu()   : 񍇐ϊsׂeǂB
     * - isReducibleByMaze()    : ϊsׂeǂB
     * - isReducibleByKata()    : ȕϊsׂeǂB
     * - reduceByBushu()        : 񍇐ϊsB
     * - reduceByMaze()         : ϊsB
     * - reduceByKata()         : ȕϊsB
     * - nfer()                 : ϊŊmB
     * - nferHirkata()          : Ђ炪/ȕϊsAmB
     * - isComplete()           : 񍇐ϊǂB
     */
    int isReducibleByBushu();
    int isReducibleByMaze();
    int isReducibleByKata();
    void reduceByBushu();
    void reduceByMaze();
    void reduceByKata();
    void finishCand(char *);
    void makeMazeYomiLonger();
    void makeMazeYomiShorter();
    void nfer();
    void nferHirakata();
    int isComplete();
    //<v127c - postInPre>
    void cancelPostInPre(int);
    //</v127c>

    void setCandGGHeader();
    void goCandGG();  // finishCand()
    void makeCandGG();  // output()ɌĂ
    void clearCandGG();
    int ggCInputted();

    /* wv
     * ----------
     * ⏕ϊœ͂̂Awv̑Ώۂɂׂ̂A
     * helpBuffer ɒǉ֐B
     * ƁẢB
     */
    void addToHelpBuffer(MOJI);
    void addToHelpBufferMaybe(MOJI);
    void addToHelpBufferMaybe(char *, char *);

    /* qXg
     * ------------
     * ⏕ϊœ͂̂AqXgɎĉׂA
     * hist ɒǉ֐B
     * qXgɎcׂ̏́A֐̒`QƁB
     */
    void addToHistMaybe(char *);
    void addToHistMaybe(MOJI);

    /* ˑ (nKCh)
     */
    void updateContext();
    //<v127a - gg>
    //<gg-defg>
    //void makeGG(MOJI *);
    void makeGG(char *strGG, int start = 0, int protectOnConflict = 0);
    //</gg-defg>
    void clearGG(ControlBlock *);
    //</v127a - gg>/
    void assignStroke(char *);
    void assignStroke(MOJI);
    void clearAssignStroke();

    /* z
     * --------
     * - makeVKB()      : zՂ쐬B
     *                    eL[̃tFCXEOiFEwiFݒB
     * - makeVKBBG()    : makeVKB ̉B
     *                    Xg[Nɏ]ĊeL[̔wiFݒB
     */
    void makeVKB(bool unlock = false);
    void makeVKBBG(vector<STROKE> *);
    void makeVKBBG(STROKE *);

    //<v127a - shiftcheck>
    /* isShiftKana[]Zbg */
    bool checkShiftKana(ControlBlock *block);
    //</v127a - shiftcheck>
    void checkShiftSeq(ControlBlock *block);
};

// -------------------------------------------------------------------
#endif // TCODE_H
