<!--
Please use semantic PR titles that respect this format:

<type>(#<issue number>): <subject>

Quick example:

feat(#1234): add hat wobble
^--^(#^--^): ^------------^
|     |      |
|     |      + - > subject
|     |
|     + -------- > issue number
|
+ -------------- > type: chore, feat, fix, perf.

https://docs.communityhealthtoolkit.org/contribute/code/workflow/#commit-message-format
-->

# Description

[description]

medic/cht-core#[number]

# Code review checklist
<!-- Remove or comment out any items that do not apply to this PR; in the remaining boxes, replace the [ ] with [x]. -->
- [ ] Readable: Concise, well named, follows the [style guide](https://docs.communityhealthtoolkit.org/contribute/code/style-guide/), documented if necessary.
- [ ] Documented: Configuration and user documentation on [cht-docs](https://github.com/medic/cht-docs/)
- [ ] Tested: Unit and/or e2e where appropriate
- [ ] Internationalised: All user facing text
- [ ] Backwards compatible: Works with existing data and configuration or includes a migration. Any breaking changes documented in the release notes.

# Compose URLs
<!-- Do not change these!  CI will automatically update these to be the deep URLs -->
If Build CI hasn't passed, these may 404:

* __CHT_CORE_COMPOSE_URL__
* __COUCH_SINGLE_COMPOSE_URL__
* __COUCH_CLUSTER_COMPOSE_URL__

# License

The software is provided under AGPL-3.0. Contributions to this project are accepted under the same license.

