const utils = require('@utils');
const commonPage = require('@page-objects/default/common/common.wdio.page');
const loginPage = require('@page-objects/default/login/login.wdio.page');
const aboutPage = require('@page-objects/default/about/about.wdio.page');
const partnersFactory = require('@factories/cht/config/partners');

describe('About page', () => {
  beforeEach(async () => {
    await loginPage.cookieLogin();
  });

  it('should open the about page', async () => {
    await commonPage.goToAboutPage();
    await (await aboutPage.userName()).waitForDisplayed();
  });

  it('should display partners', async () => {
    const partnerData = [
      {
        name: 'image1',
        // eslint-disable-next-line max-len
        data: 'iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAABSElEQVQ4T4XTQShmYRQG4Oev2cjSJEuxmVhIVnbYSMo0CxNZWigLZSFlYWMhWVBTY6PMckoWk4VpNkNhaUc2QknZaDZqlKLz9/26Xff6T91u9z3nvN97zvvdiuJ4zsEtuCsqrRSA0TyPHXzARxyiH/v5+jxBNHfiFDd4QiO6cIs3B2aBDqzjCE34iXb8R+QGsYbtrIoswSjiOcciLvEPE0nR15SP92tkCRpwj2kMYQTLOMAnPKZ9rJYRBB47mMG3RDaGcVxhFyf1lhj5Y3xJxSE/IlTFeD/wHWd4iESRjbVDLjCZPqaSkutkZdi59R5B7SKF9xGfMZtGDGwOw2UEPVhKiyxS2JdGqrpRVNCGTQyUXPO6BNH3Cxv4XUCyklyJfOkSmxNJbwHBXrqRf+q5ELZ1YyFH8jf9WFX4PRtbk1UxczbCwpo7XgCU0D8RAZWrCwAAAABJRU5ErkJggg==',
      },
      {
        name: 'image2',
        // eslint-disable-next-line max-len
        data: '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',
      }
    ];
    const partnersDoc = partnersFactory.build(partnerData);

    await utils.saveDoc(partnersDoc);
    await commonPage.goToAboutPage();
    await (await aboutPage.partners()).waitForDisplayed();

    const image1 = await aboutPage.getPartnerImage('image1');
    expect(image1).to.equal(`data:image/png;base64,${partnerData[0].data}`);
    const image2 = await aboutPage.getPartnerImage('image2');
    expect(image2).to.equal(`data:image/png;base64,${partnersDoc[1].data}`);
  });
});
