/*
 * 3DS OUTSCALE API
 *
 * Welcome to the 3DS OUTSCALE's API documentation.<br /><br />  The 3DS OUTSCALE API enables you to manage your resources in the 3DS OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the 3DS OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the 3DS OUTSCALE API. You can find a list of the differences [here](https://wiki.outscale.net/display/EN/3DS+OUTSCALE+APIs+Reference).<br /><br />  You can also manage your resources using the [Cockpit](https://wiki.outscale.net/display/EN/About+Cockpit) web interface.
 *
 * API version: 1.2
 * Contact: support@outscale.com
 * Generated by: OpenAPI Generator (https://openapi-generator.tech)
 */

package osc
// FiltersDhcpOptions One or more filters.
type FiltersDhcpOptions struct {
	// If `true`, lists all default DHCP options set. If `false`, lists all non-default DHCP options set.
	Default bool `json:"Default,omitempty"`
	// The IDs of the DHCP options sets.
	DhcpOptionsSetIds []string `json:"DhcpOptionsSetIds,omitempty"`
	// The domain name servers used for the DHCP options sets.
	DomainNameServers []string `json:"DomainNameServers,omitempty"`
	// The domain names used for the DHCP options sets.
	DomainNames []string `json:"DomainNames,omitempty"`
	// The Network Time Protocol (NTP) servers used for the DHCP options sets.
	NtpServers []string `json:"NtpServers,omitempty"`
	// The keys of the tags associated with the DHCP options sets.
	TagKeys []string `json:"TagKeys,omitempty"`
	// The values of the tags associated with the DHCP options sets.
	TagValues []string `json:"TagValues,omitempty"`
	// The key/value combination of the tags associated with the DHCP options sets, in the following format: \"Filters\":{\"Tags\":[\"TAGKEY=TAGVALUE\"]}.
	Tags []string `json:"Tags,omitempty"`
}
