// Code is generated by ucloud-model, DO NOT EDIT IT.

package ufile

import (
	"github.com/ucloud/ucloud-sdk-go/ucloud"
	"github.com/ucloud/ucloud-sdk-go/ucloud/request"
	"github.com/ucloud/ucloud-sdk-go/ucloud/response"
)

// DeleteBucketRequest is request schema for DeleteBucket action
type DeleteBucketRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// 待删除Bucket的名称
	BucketName *string `required:"true"`
}

// DeleteBucketResponse is response schema for DeleteBucket action
type DeleteBucketResponse struct {
	response.CommonBase

	// Bucket的ID
	BucketId string

	// Bucket的名称
	BucketName string
}

// NewDeleteBucketRequest will create request of DeleteBucket action.
func (c *UFileClient) NewDeleteBucketRequest() *DeleteBucketRequest {
	req := &DeleteBucketRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

// DeleteBucket - 删除Bucket
func (c *UFileClient) DeleteBucket(req *DeleteBucketRequest) (*DeleteBucketResponse, error) {
	var err error
	var res DeleteBucketResponse

	reqCopier := *req
	// In order to ignore the parameters about Region
	reqCopier.Region = ucloud.String("")

	err = c.Client.InvokeAction("DeleteBucket", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}
