//Code is generated by ucloud code generator, don't modify it by hand, it will cause undefined behaviors.
//go:generate ucloud-gen-go-api UNet GetEIPPrice

package unet

import (
	"github.com/ucloud/ucloud-sdk-go/ucloud/request"
	"github.com/ucloud/ucloud-sdk-go/ucloud/response"
)

// GetEIPPriceRequest is request schema for GetEIPPrice action
type GetEIPPriceRequest struct {
	request.CommonBase

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// 弹性IP的线路如下: 国际: International BGP: Bgp 各地域允许的线路参数如下: cn-sh1: Bgp cn-sh2: Bgp cn-gd: Bgp cn-bj1: Bgp cn-bj2: Bgp hk: International us-ca: International th-bkk: International kr-seoul:International us-ws:International ge-fra:International sg:International tw-kh:International.其他海外线路均为 International
	OperatorName *string `required:"true"`

	// 弹性IP的外网带宽, 单位为Mbps, 范围 [0-800]
	Bandwidth *int `required:"true"`

	// 付费方式, 枚举值为: Year, 按年付费; Month, 按月付费; Dynamic, 按需付费(需开启权限); 默认为获取三种价格
	ChargeType *string `required:"false"`

	// 弹性IP计费方式r. 枚举值为: Traffic, 流量计费; Bandwidth, 带宽计费; "ShareBandwidth",共享带宽模式. 默认为Bandwidth
	PayMode *string `required:"false"`
}

// GetEIPPriceResponse is response schema for GetEIPPrice action
type GetEIPPriceResponse struct {
	response.CommonBase

	// 弹性IP价格详情 详情见 EIPPriceDetailSet
	PriceSet []EIPPriceDetailSet
}

// NewGetEIPPriceRequest will create request of GetEIPPrice action.
func (c *UNetClient) NewGetEIPPriceRequest() *GetEIPPriceRequest {
	req := &GetEIPPriceRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

// GetEIPPrice - 获取弹性IP价格
func (c *UNetClient) GetEIPPrice(req *GetEIPPriceRequest) (*GetEIPPriceResponse, error) {
	var err error
	var res GetEIPPriceResponse

	err = c.Client.InvokeAction("GetEIPPrice", req, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}
