// Code is generated by ucloud-model, DO NOT EDIT IT.

package vpc

import (
	"github.com/ucloud/ucloud-sdk-go/ucloud/request"
	"github.com/ucloud/ucloud-sdk-go/ucloud/response"
)

// VPC API Schema

// AddVPCNetworkRequest is request schema for AddVPCNetwork action
type AddVPCNetworkRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// 增加网段
	Network []string `required:"true"`

	// 源VPC短ID
	VPCId *string `required:"true"`
}

// AddVPCNetworkResponse is response schema for AddVPCNetwork action
type AddVPCNetworkResponse struct {
	response.CommonBase
}

// NewAddVPCNetworkRequest will create request of AddVPCNetwork action.
func (c *VPCClient) NewAddVPCNetworkRequest() *AddVPCNetworkRequest {
	req := &AddVPCNetworkRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(false)
	return req
}

/*
API: AddVPCNetwork

添加VPC网段
*/
func (c *VPCClient) AddVPCNetwork(req *AddVPCNetworkRequest) (*AddVPCNetworkResponse, error) {
	var err error
	var res AddVPCNetworkResponse

	reqCopier := *req

	err = c.Client.InvokeAction("AddVPCNetwork", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// AddWhiteListResourceRequest is request schema for AddWhiteListResource action
type AddWhiteListResourceRequest struct {
	request.CommonBase

	// [公共参数] 项目Id。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// NAT网关Id
	NATGWId *string `required:"true"`

	// 可添加白名单的资源Id
	ResourceIds []string `required:"true"`
}

// AddWhiteListResourceResponse is response schema for AddWhiteListResource action
type AddWhiteListResourceResponse struct {
	response.CommonBase
}

// NewAddWhiteListResourceRequest will create request of AddWhiteListResource action.
func (c *VPCClient) NewAddWhiteListResourceRequest() *AddWhiteListResourceRequest {
	req := &AddWhiteListResourceRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(false)
	return req
}

/*
API: AddWhiteListResource

添加NAT网关白名单
*/
func (c *VPCClient) AddWhiteListResource(req *AddWhiteListResourceRequest) (*AddWhiteListResourceResponse, error) {
	var err error
	var res AddWhiteListResourceResponse

	reqCopier := *req

	err = c.Client.InvokeAction("AddWhiteListResource", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// AllocateSecondaryIpRequest is request schema for AllocateSecondaryIp action
type AllocateSecondaryIpRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"true"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// [公共参数] 可用区。参见 [可用区列表](../summary/regionlist.html)
	// Zone *string `required:"true"`

	// 指定Ip分配
	Ip *string `required:"false"`

	// 节点mac
	Mac *string `required:"true"`

	// 资源Id
	ObjectId *string `required:"true"`

	// 子网Id（若未指定，则根据zone获取默认子网进行创建）
	SubnetId *string `required:"false"`

	// vpcId
	VPCId *string `required:"false"`
}

// AllocateSecondaryIpResponse is response schema for AllocateSecondaryIp action
type AllocateSecondaryIpResponse struct {
	response.CommonBase

	//
	IpInfo IpInfo
}

// NewAllocateSecondaryIpRequest will create request of AllocateSecondaryIp action.
func (c *VPCClient) NewAllocateSecondaryIpRequest() *AllocateSecondaryIpRequest {
	req := &AllocateSecondaryIpRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(false)
	return req
}

/*
API: AllocateSecondaryIp

分配ip（用于uk8s使用）
*/
func (c *VPCClient) AllocateSecondaryIp(req *AllocateSecondaryIpRequest) (*AllocateSecondaryIpResponse, error) {
	var err error
	var res AllocateSecondaryIpResponse

	reqCopier := *req

	err = c.Client.InvokeAction("AllocateSecondaryIp", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// AllocateVIPRequest is request schema for AllocateVIP action
type AllocateVIPRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域
	// Region *string `required:"true"`

	// [公共参数] 可用区
	// Zone *string `required:"false"`

	// 业务组
	BusinessId *string `required:"false"`

	// 申请数量，默认: 1
	Count *int `required:"false"`

	// 指定ip
	Ip *string `required:"false"`

	// vip名，默认：VIP
	Name *string `required:"false"`

	// 备注
	Remark *string `required:"false"`

	// 子网id
	SubnetId *string `required:"true"`

	// 业务组名称，默认为Default
	Tag *string `required:"false"`

	// 指定vip所属的VPC
	VPCId *string `required:"true"`
}

// AllocateVIPResponse is response schema for AllocateVIP action
type AllocateVIPResponse struct {
	response.CommonBase

	// 申请到的VIP地址
	DataSet []string

	// 申请到的VIP资源相关信息
	VIPSet []VIPSet
}

// NewAllocateVIPRequest will create request of AllocateVIP action.
func (c *VPCClient) NewAllocateVIPRequest() *AllocateVIPRequest {
	req := &AllocateVIPRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(false)
	return req
}

/*
API: AllocateVIP

根据提供信息，申请内网VIP(Virtual IP），多用于高可用程序作为漂移IP。
*/
func (c *VPCClient) AllocateVIP(req *AllocateVIPRequest) (*AllocateVIPResponse, error) {
	var err error
	var res AllocateVIPResponse

	reqCopier := *req

	err = c.Client.InvokeAction("AllocateVIP", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// AssociateRouteTableRequest is request schema for AssociateRouteTable action
type AssociateRouteTableRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"true"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// 路由表资源ID
	RouteTableId *string `required:"true"`

	// 子网ID
	SubnetId *string `required:"true"`
}

// AssociateRouteTableResponse is response schema for AssociateRouteTable action
type AssociateRouteTableResponse struct {
	response.CommonBase
}

// NewAssociateRouteTableRequest will create request of AssociateRouteTable action.
func (c *VPCClient) NewAssociateRouteTableRequest() *AssociateRouteTableRequest {
	req := &AssociateRouteTableRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: AssociateRouteTable

绑定子网的路由表
*/
func (c *VPCClient) AssociateRouteTable(req *AssociateRouteTableRequest) (*AssociateRouteTableResponse, error) {
	var err error
	var res AssociateRouteTableResponse

	reqCopier := *req

	err = c.Client.InvokeAction("AssociateRouteTable", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// CloneRouteTableRequest is request schema for CloneRouteTable action
type CloneRouteTableRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"true"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// 被克隆的路由表ID
	RouteTableId *string `required:"true"`
}

// CloneRouteTableResponse is response schema for CloneRouteTable action
type CloneRouteTableResponse struct {
	response.CommonBase

	// 复制后新的路由表资源ID
	RouteTableId string
}

// NewCloneRouteTableRequest will create request of CloneRouteTable action.
func (c *VPCClient) NewCloneRouteTableRequest() *CloneRouteTableRequest {
	req := &CloneRouteTableRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: CloneRouteTable

将现有的路由表复制为一张新的路由表
*/
func (c *VPCClient) CloneRouteTable(req *CloneRouteTableRequest) (*CloneRouteTableResponse, error) {
	var err error
	var res CloneRouteTableResponse

	reqCopier := *req

	err = c.Client.InvokeAction("CloneRouteTable", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// CreateNATGWRequest is request schema for CreateNATGW action
type CreateNATGWRequest struct {
	request.CommonBase

	// [公共参数] 项目Id。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// NAT网关绑定的EIPId
	EIPIds []string `required:"true"`

	// NAT网关绑定的防火墙Id
	FirewallId *string `required:"true"`

	// 白名单开关标记。0表示关闭，1表示开启。默认为0
	IfOpen *int `required:"false"`

	// NAT网关名称
	NATGWName *string `required:"true"`

	// 备注。默认为空
	Remark *string `required:"false"`

	// NAT网关绑定的子网Id
	SubnetworkIds []string `required:"true"`

	// 业务组。默认为空
	Tag *string `required:"false"`

	// NAT网关所属的VPC Id。默认为Default VPC Id
	VPCId *string `required:"false"`
}

// CreateNATGWResponse is response schema for CreateNATGW action
type CreateNATGWResponse struct {
	response.CommonBase

	// 申请到的NATGateWay Id
	NATGWId string
}

// NewCreateNATGWRequest will create request of CreateNATGW action.
func (c *VPCClient) NewCreateNATGWRequest() *CreateNATGWRequest {
	req := &CreateNATGWRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(false)
	return req
}

/*
API: CreateNATGW

创建NAT网关
*/
func (c *VPCClient) CreateNATGW(req *CreateNATGWRequest) (*CreateNATGWResponse, error) {
	var err error
	var res CreateNATGWResponse

	reqCopier := *req

	err = c.Client.InvokeAction("CreateNATGW", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// CreateNATGWPolicyRequest is request schema for CreateNATGWPolicy action
type CreateNATGWPolicyRequest struct {
	request.CommonBase

	// [公共参数] 项目Id。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// 目标IP。填写对应的目标IP地址
	DstIP *string `required:"true"`

	// 目标端口。可填写固定端口，也可填写端口范围。支持的端口范围为1-65535
	DstPort *string `required:"true"`

	// NAT网关Id
	NATGWId *string `required:"true"`

	// 转发策略名称。默认为空
	PolicyName *string `required:"false"`

	// 协议类型。枚举值为：TCP、UDP
	Protocol *string `required:"true"`

	// 源IP。填写对应的EIP Id
	SrcEIPId *string `required:"true"`

	// 源端口。可填写固定端口，也可填写端口范围。支持的端口范围为1-65535
	SrcPort *string `required:"true"`
}

// CreateNATGWPolicyResponse is response schema for CreateNATGWPolicy action
type CreateNATGWPolicyResponse struct {
	response.CommonBase

	// 创建时分配的策略Id
	PolicyId string
}

// NewCreateNATGWPolicyRequest will create request of CreateNATGWPolicy action.
func (c *VPCClient) NewCreateNATGWPolicyRequest() *CreateNATGWPolicyRequest {
	req := &CreateNATGWPolicyRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(false)
	return req
}

/*
API: CreateNATGWPolicy

添加NAT网关端口转发规则
*/
func (c *VPCClient) CreateNATGWPolicy(req *CreateNATGWPolicyRequest) (*CreateNATGWPolicyResponse, error) {
	var err error
	var res CreateNATGWPolicyResponse

	reqCopier := *req

	err = c.Client.InvokeAction("CreateNATGWPolicy", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// CreateNetworkAclRequest is request schema for CreateNetworkAcl action
type CreateNetworkAclRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// ACL的名称
	AclName *string `required:"true"`

	// ACL的描述
	Description *string `required:"false"`

	// 将要创建的ACL所属VPC的ID
	VpcId *string `required:"true"`
}

// CreateNetworkAclResponse is response schema for CreateNetworkAcl action
type CreateNetworkAclResponse struct {
	response.CommonBase

	// 创建的ACL的ID
	AclId string
}

// NewCreateNetworkAclRequest will create request of CreateNetworkAcl action.
func (c *VPCClient) NewCreateNetworkAclRequest() *CreateNetworkAclRequest {
	req := &CreateNetworkAclRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(false)
	return req
}

/*
API: CreateNetworkAcl

创建网络ACL
*/
func (c *VPCClient) CreateNetworkAcl(req *CreateNetworkAclRequest) (*CreateNetworkAclResponse, error) {
	var err error
	var res CreateNetworkAclResponse

	reqCopier := *req

	err = c.Client.InvokeAction("CreateNetworkAcl", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// CreateNetworkAclAssociationRequest is request schema for CreateNetworkAclAssociation action
type CreateNetworkAclAssociationRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// ACL的ID
	AclId *string `required:"true"`

	// 需要绑定的子网ID
	SubnetworkId *string `required:"true"`
}

// CreateNetworkAclAssociationResponse is response schema for CreateNetworkAclAssociation action
type CreateNetworkAclAssociationResponse struct {
	response.CommonBase

	// Acl的ID
	AclId string

	// 创建的绑定关系的ID
	AssociationId string

	// 该子网之前的绑定关系信息
	PrevAssociation AssociationInfo
}

// NewCreateNetworkAclAssociationRequest will create request of CreateNetworkAclAssociation action.
func (c *VPCClient) NewCreateNetworkAclAssociationRequest() *CreateNetworkAclAssociationRequest {
	req := &CreateNetworkAclAssociationRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(false)
	return req
}

/*
API: CreateNetworkAclAssociation

创建ACL的绑定关系
*/
func (c *VPCClient) CreateNetworkAclAssociation(req *CreateNetworkAclAssociationRequest) (*CreateNetworkAclAssociationResponse, error) {
	var err error
	var res CreateNetworkAclAssociationResponse

	reqCopier := *req

	err = c.Client.InvokeAction("CreateNetworkAclAssociation", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// CreateNetworkAclEntryRequest is request schema for CreateNetworkAclEntry action
type CreateNetworkAclEntryRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// ACL的ID
	AclId *string `required:"true"`

	// IPv4段的CIDR表示
	CidrBlock *string `required:"true"`

	// 描述
	Description *string `required:"false"`

	// 出向或者入向（“Ingress”, "Egress")
	Direction *string `required:"true"`

	// 规则的行为("Accept", "Reject")
	EntryAction *string `required:"true"`

	// 协议规则描述
	IpProtocol *string `required:"true"`

	// 针对的端口范围
	PortRange *string `required:"true"`

	// Entry的优先级，对于同样的Direction来说，不能重复
	Priority *int `required:"true"`

	// 应用目标资源列表。默认为全部资源生效。TargetType为0时不用填写该值。
	TargetResourceIds []string `required:"false"`

	// 应用目标类型。0代表“子网内全部资源”，1代表“子网内指定资源”，默认为0
	TargetType *int `required:"false"`
}

// CreateNetworkAclEntryResponse is response schema for CreateNetworkAclEntry action
type CreateNetworkAclEntryResponse struct {
	response.CommonBase

	// 创建的Entry的ID
	EntryId string
}

// NewCreateNetworkAclEntryRequest will create request of CreateNetworkAclEntry action.
func (c *VPCClient) NewCreateNetworkAclEntryRequest() *CreateNetworkAclEntryRequest {
	req := &CreateNetworkAclEntryRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(false)
	return req
}

/*
API: CreateNetworkAclEntry

创建ACL的规则
*/
func (c *VPCClient) CreateNetworkAclEntry(req *CreateNetworkAclEntryRequest) (*CreateNetworkAclEntryResponse, error) {
	var err error
	var res CreateNetworkAclEntryResponse

	reqCopier := *req

	err = c.Client.InvokeAction("CreateNetworkAclEntry", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// CreateRouteTableRequest is request schema for CreateRouteTable action
type CreateRouteTableRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"true"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// 路由表名称。默认为RouteTable
	Name *string `required:"false"`

	// 备注
	Remark *string `required:"false"`

	// 路由表所属业务组
	Tag *string `required:"false"`

	// 所属的VPC资源ID
	VPCId *string `required:"true"`
}

// CreateRouteTableResponse is response schema for CreateRouteTable action
type CreateRouteTableResponse struct {
	response.CommonBase

	// 路由表ID
	RouteTableId string
}

// NewCreateRouteTableRequest will create request of CreateRouteTable action.
func (c *VPCClient) NewCreateRouteTableRequest() *CreateRouteTableRequest {
	req := &CreateRouteTableRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(false)
	return req
}

/*
API: CreateRouteTable

创建路由表
*/
func (c *VPCClient) CreateRouteTable(req *CreateRouteTableRequest) (*CreateRouteTableResponse, error) {
	var err error
	var res CreateRouteTableResponse

	reqCopier := *req

	err = c.Client.InvokeAction("CreateRouteTable", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// CreateSubnetRequest is request schema for CreateSubnet action
type CreateSubnetRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// 子网网络号位数，默认为24
	Netmask *int `required:"false"`

	// 备注
	Remark *string `required:"false"`

	// 子网网络地址，例如192.168.0.0
	Subnet *string `required:"true"`

	// 子网名称，默认为Subnet
	SubnetName *string `required:"false"`

	// 业务组名称，默认为Default
	Tag *string `required:"false"`

	// VPC资源ID
	VPCId *string `required:"true"`
}

// CreateSubnetResponse is response schema for CreateSubnet action
type CreateSubnetResponse struct {
	response.CommonBase

	// 子网ID
	SubnetId string
}

// NewCreateSubnetRequest will create request of CreateSubnet action.
func (c *VPCClient) NewCreateSubnetRequest() *CreateSubnetRequest {
	req := &CreateSubnetRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(false)
	return req
}

/*
API: CreateSubnet

创建子网
*/
func (c *VPCClient) CreateSubnet(req *CreateSubnetRequest) (*CreateSubnetResponse, error) {
	var err error
	var res CreateSubnetResponse

	reqCopier := *req

	err = c.Client.InvokeAction("CreateSubnet", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// CreateVPCRequest is request schema for CreateVPC action
type CreateVPCRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// VPC名称
	Name *string `required:"true"`

	// VPC网段
	Network []string `required:"true"`

	// 备注
	Remark *string `required:"false"`

	// 业务组名称
	Tag *string `required:"false"`

	// 【该字段已废弃，请谨慎使用】
	Type *int `required:"false" deprecated:"true"`
}

// CreateVPCResponse is response schema for CreateVPC action
type CreateVPCResponse struct {
	response.CommonBase

	// VPC资源Id
	VPCId string
}

// NewCreateVPCRequest will create request of CreateVPC action.
func (c *VPCClient) NewCreateVPCRequest() *CreateVPCRequest {
	req := &CreateVPCRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(false)
	return req
}

/*
API: CreateVPC

创建VPC
*/
func (c *VPCClient) CreateVPC(req *CreateVPCRequest) (*CreateVPCResponse, error) {
	var err error
	var res CreateVPCResponse

	reqCopier := *req

	err = c.Client.InvokeAction("CreateVPC", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// CreateVPCIntercomRequest is request schema for CreateVPCIntercom action
type CreateVPCIntercomRequest struct {
	request.CommonBase

	// [公共参数] 源VPC所在项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 源VPC所在地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// 目的VPC项目ID。默认与源VPC同项目。
	DstProjectId *string `required:"false"`

	// 目的VPC所在地域，默认与源VPC同地域。
	DstRegion *string `required:"false"`

	// 目的VPC短ID
	DstVPCId *string `required:"true"`

	// 源VPC短ID
	VPCId *string `required:"true"`
}

// CreateVPCIntercomResponse is response schema for CreateVPCIntercom action
type CreateVPCIntercomResponse struct {
	response.CommonBase
}

// NewCreateVPCIntercomRequest will create request of CreateVPCIntercom action.
func (c *VPCClient) NewCreateVPCIntercomRequest() *CreateVPCIntercomRequest {
	req := &CreateVPCIntercomRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(false)
	return req
}

/*
API: CreateVPCIntercom

新建VPC互通关系
*/
func (c *VPCClient) CreateVPCIntercom(req *CreateVPCIntercomRequest) (*CreateVPCIntercomResponse, error) {
	var err error
	var res CreateVPCIntercomResponse

	reqCopier := *req

	err = c.Client.InvokeAction("CreateVPCIntercom", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// DeleteNATGWRequest is request schema for DeleteNATGW action
type DeleteNATGWRequest struct {
	request.CommonBase

	// [公共参数] 项目Id。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// NAT网关Id
	NATGWId *string `required:"true"`

	// 是否释放绑定的EIP。true：解绑并释放；false：只解绑不释放。默认为false
	ReleaseEip *bool `required:"false"`
}

// DeleteNATGWResponse is response schema for DeleteNATGW action
type DeleteNATGWResponse struct {
	response.CommonBase
}

// NewDeleteNATGWRequest will create request of DeleteNATGW action.
func (c *VPCClient) NewDeleteNATGWRequest() *DeleteNATGWRequest {
	req := &DeleteNATGWRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: DeleteNATGW

删除NAT网关
*/
func (c *VPCClient) DeleteNATGW(req *DeleteNATGWRequest) (*DeleteNATGWResponse, error) {
	var err error
	var res DeleteNATGWResponse

	reqCopier := *req

	err = c.Client.InvokeAction("DeleteNATGW", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// DeleteNATGWPolicyRequest is request schema for DeleteNATGWPolicy action
type DeleteNATGWPolicyRequest struct {
	request.CommonBase

	// [公共参数] 项目Id。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// NAT网关Id
	NATGWId *string `required:"true"`

	// 端口转发规则Id
	PolicyId *string `required:"true"`
}

// DeleteNATGWPolicyResponse is response schema for DeleteNATGWPolicy action
type DeleteNATGWPolicyResponse struct {
	response.CommonBase
}

// NewDeleteNATGWPolicyRequest will create request of DeleteNATGWPolicy action.
func (c *VPCClient) NewDeleteNATGWPolicyRequest() *DeleteNATGWPolicyRequest {
	req := &DeleteNATGWPolicyRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: DeleteNATGWPolicy

删除NAT网关端口转发规则
*/
func (c *VPCClient) DeleteNATGWPolicy(req *DeleteNATGWPolicyRequest) (*DeleteNATGWPolicyResponse, error) {
	var err error
	var res DeleteNATGWPolicyResponse

	reqCopier := *req

	err = c.Client.InvokeAction("DeleteNATGWPolicy", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// DeleteNetworkAclRequest is request schema for DeleteNetworkAcl action
type DeleteNetworkAclRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// 需要删除的AclId
	AclId *string `required:"true"`
}

// DeleteNetworkAclResponse is response schema for DeleteNetworkAcl action
type DeleteNetworkAclResponse struct {
	response.CommonBase
}

// NewDeleteNetworkAclRequest will create request of DeleteNetworkAcl action.
func (c *VPCClient) NewDeleteNetworkAclRequest() *DeleteNetworkAclRequest {
	req := &DeleteNetworkAclRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: DeleteNetworkAcl

删除网络ACL
*/
func (c *VPCClient) DeleteNetworkAcl(req *DeleteNetworkAclRequest) (*DeleteNetworkAclResponse, error) {
	var err error
	var res DeleteNetworkAclResponse

	reqCopier := *req

	err = c.Client.InvokeAction("DeleteNetworkAcl", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// DeleteNetworkAclAssociationRequest is request schema for DeleteNetworkAclAssociation action
type DeleteNetworkAclAssociationRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// 需要删除的AclId
	AclId *string `required:"true"`

	// 绑定的子网ID
	SubnetworkId *string `required:"true"`
}

// DeleteNetworkAclAssociationResponse is response schema for DeleteNetworkAclAssociation action
type DeleteNetworkAclAssociationResponse struct {
	response.CommonBase
}

// NewDeleteNetworkAclAssociationRequest will create request of DeleteNetworkAclAssociation action.
func (c *VPCClient) NewDeleteNetworkAclAssociationRequest() *DeleteNetworkAclAssociationRequest {
	req := &DeleteNetworkAclAssociationRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: DeleteNetworkAclAssociation

删除网络ACL绑定关系
*/
func (c *VPCClient) DeleteNetworkAclAssociation(req *DeleteNetworkAclAssociationRequest) (*DeleteNetworkAclAssociationResponse, error) {
	var err error
	var res DeleteNetworkAclAssociationResponse

	reqCopier := *req

	err = c.Client.InvokeAction("DeleteNetworkAclAssociation", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// DeleteNetworkAclEntryRequest is request schema for DeleteNetworkAclEntry action
type DeleteNetworkAclEntryRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// Acl的ID
	AclId *string `required:"true"`

	// 需要删除的EntryId
	EntryId *string `required:"true"`
}

// DeleteNetworkAclEntryResponse is response schema for DeleteNetworkAclEntry action
type DeleteNetworkAclEntryResponse struct {
	response.CommonBase
}

// NewDeleteNetworkAclEntryRequest will create request of DeleteNetworkAclEntry action.
func (c *VPCClient) NewDeleteNetworkAclEntryRequest() *DeleteNetworkAclEntryRequest {
	req := &DeleteNetworkAclEntryRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: DeleteNetworkAclEntry

删除ACL的规则
*/
func (c *VPCClient) DeleteNetworkAclEntry(req *DeleteNetworkAclEntryRequest) (*DeleteNetworkAclEntryResponse, error) {
	var err error
	var res DeleteNetworkAclEntryResponse

	reqCopier := *req

	err = c.Client.InvokeAction("DeleteNetworkAclEntry", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// DeleteRouteTableRequest is request schema for DeleteRouteTable action
type DeleteRouteTableRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"true"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// 路由表资源ID
	RouteTableId *string `required:"true"`
}

// DeleteRouteTableResponse is response schema for DeleteRouteTable action
type DeleteRouteTableResponse struct {
	response.CommonBase
}

// NewDeleteRouteTableRequest will create request of DeleteRouteTable action.
func (c *VPCClient) NewDeleteRouteTableRequest() *DeleteRouteTableRequest {
	req := &DeleteRouteTableRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: DeleteRouteTable

删除自定义路由表
*/
func (c *VPCClient) DeleteRouteTable(req *DeleteRouteTableRequest) (*DeleteRouteTableResponse, error) {
	var err error
	var res DeleteRouteTableResponse

	reqCopier := *req

	err = c.Client.InvokeAction("DeleteRouteTable", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// DeleteSecondaryIpRequest is request schema for DeleteSecondaryIp action
type DeleteSecondaryIpRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"true"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// [公共参数] 可用区。参见 [可用区列表](../summary/regionlist.html)
	// Zone *string `required:"true"`

	// ip
	Ip *string `required:"true"`

	// mac
	Mac *string `required:"true"`

	// 资源Id
	ObjectId *string `required:"false"`

	// 子网Id
	SubnetId *string `required:"true"`

	// VPCId
	VPCId *string `required:"false"`
}

// DeleteSecondaryIpResponse is response schema for DeleteSecondaryIp action
type DeleteSecondaryIpResponse struct {
	response.CommonBase
}

// NewDeleteSecondaryIpRequest will create request of DeleteSecondaryIp action.
func (c *VPCClient) NewDeleteSecondaryIpRequest() *DeleteSecondaryIpRequest {
	req := &DeleteSecondaryIpRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: DeleteSecondaryIp

删除ip（用于uk8s使用）
*/
func (c *VPCClient) DeleteSecondaryIp(req *DeleteSecondaryIpRequest) (*DeleteSecondaryIpResponse, error) {
	var err error
	var res DeleteSecondaryIpResponse

	reqCopier := *req

	err = c.Client.InvokeAction("DeleteSecondaryIp", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// DeleteSubnetRequest is request schema for DeleteSubnet action
type DeleteSubnetRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// 子网ID
	SubnetId *string `required:"true"`
}

// DeleteSubnetResponse is response schema for DeleteSubnet action
type DeleteSubnetResponse struct {
	response.CommonBase
}

// NewDeleteSubnetRequest will create request of DeleteSubnet action.
func (c *VPCClient) NewDeleteSubnetRequest() *DeleteSubnetRequest {
	req := &DeleteSubnetRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: DeleteSubnet

删除子网
*/
func (c *VPCClient) DeleteSubnet(req *DeleteSubnetRequest) (*DeleteSubnetResponse, error) {
	var err error
	var res DeleteSubnetResponse

	reqCopier := *req

	err = c.Client.InvokeAction("DeleteSubnet", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// DeleteVPCRequest is request schema for DeleteVPC action
type DeleteVPCRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// VPC资源Id
	VPCId *string `required:"true"`
}

// DeleteVPCResponse is response schema for DeleteVPC action
type DeleteVPCResponse struct {
	response.CommonBase
}

// NewDeleteVPCRequest will create request of DeleteVPC action.
func (c *VPCClient) NewDeleteVPCRequest() *DeleteVPCRequest {
	req := &DeleteVPCRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: DeleteVPC

删除VPC
*/
func (c *VPCClient) DeleteVPC(req *DeleteVPCRequest) (*DeleteVPCResponse, error) {
	var err error
	var res DeleteVPCResponse

	reqCopier := *req

	err = c.Client.InvokeAction("DeleteVPC", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// DeleteVPCIntercomRequest is request schema for DeleteVPCIntercom action
type DeleteVPCIntercomRequest struct {
	request.CommonBase

	// [公共参数] 源VPC所在项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 源VPC所在地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// 目的VPC所在项目ID，默认为源VPC所在项目ID
	DstProjectId *string `required:"false"`

	// 目的VPC所在地域，默认为源VPC所在地域
	DstRegion *string `required:"false"`

	// 目的VPC短ID
	DstVPCId *string `required:"true"`

	// 源VPC短ID
	VPCId *string `required:"true"`
}

// DeleteVPCIntercomResponse is response schema for DeleteVPCIntercom action
type DeleteVPCIntercomResponse struct {
	response.CommonBase
}

// NewDeleteVPCIntercomRequest will create request of DeleteVPCIntercom action.
func (c *VPCClient) NewDeleteVPCIntercomRequest() *DeleteVPCIntercomRequest {
	req := &DeleteVPCIntercomRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: DeleteVPCIntercom

删除VPC互通关系
*/
func (c *VPCClient) DeleteVPCIntercom(req *DeleteVPCIntercomRequest) (*DeleteVPCIntercomResponse, error) {
	var err error
	var res DeleteVPCIntercomResponse

	reqCopier := *req

	err = c.Client.InvokeAction("DeleteVPCIntercom", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// DeleteWhiteListResourceRequest is request schema for DeleteWhiteListResource action
type DeleteWhiteListResourceRequest struct {
	request.CommonBase

	// [公共参数] 项目Id。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// NAT网关Id
	NATGWId *string `required:"true"`

	// 删除白名单的资源Id
	ResourceIds []string `required:"true"`
}

// DeleteWhiteListResourceResponse is response schema for DeleteWhiteListResource action
type DeleteWhiteListResourceResponse struct {
	response.CommonBase
}

// NewDeleteWhiteListResourceRequest will create request of DeleteWhiteListResource action.
func (c *VPCClient) NewDeleteWhiteListResourceRequest() *DeleteWhiteListResourceRequest {
	req := &DeleteWhiteListResourceRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: DeleteWhiteListResource

删除NAT网关白名单列表
*/
func (c *VPCClient) DeleteWhiteListResource(req *DeleteWhiteListResourceRequest) (*DeleteWhiteListResourceResponse, error) {
	var err error
	var res DeleteWhiteListResourceResponse

	reqCopier := *req

	err = c.Client.InvokeAction("DeleteWhiteListResource", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// DescribeNATGWRequest is request schema for DescribeNATGW action
type DescribeNATGWRequest struct {
	request.CommonBase

	// [公共参数] 项目Id。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// 数据分页值。默认为20
	Limit *int `required:"false"`

	// NAT网关Id。默认为该项目下所有NAT网关
	NATGWIds []string `required:"false"`

	// 数据偏移量。默认为0
	Offset *int `required:"false"`
}

// DescribeNATGWResponse is response schema for DescribeNATGW action
type DescribeNATGWResponse struct {
	response.CommonBase

	// 查到的NATGW信息列表
	DataSet []NatGatewayDataSet

	// 满足条件的实例的总数
	TotalCount int
}

// NewDescribeNATGWRequest will create request of DescribeNATGW action.
func (c *VPCClient) NewDescribeNATGWRequest() *DescribeNATGWRequest {
	req := &DescribeNATGWRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: DescribeNATGW

获取NAT网关信息
*/
func (c *VPCClient) DescribeNATGW(req *DescribeNATGWRequest) (*DescribeNATGWResponse, error) {
	var err error
	var res DescribeNATGWResponse

	reqCopier := *req

	err = c.Client.InvokeAction("DescribeNATGW", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// DescribeNATGWPolicyRequest is request schema for DescribeNATGWPolicy action
type DescribeNATGWPolicyRequest struct {
	request.CommonBase

	// [公共参数] 项目Id。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// 返回数据长度，默认为10000
	Limit *int `required:"false"`

	// NAT网关Id
	NATGWId *string `required:"true"`

	// 列表起始位置偏移量，默认为0
	Offset *int `required:"false"`
}

// DescribeNATGWPolicyResponse is response schema for DescribeNATGWPolicy action
type DescribeNATGWPolicyResponse struct {
	response.CommonBase

	// 查到的NATGW 转发策略的详细信息
	DataSet []NATGWPolicyDataSet

	// 满足条件的转发策略总数
	TotalCount int
}

// NewDescribeNATGWPolicyRequest will create request of DescribeNATGWPolicy action.
func (c *VPCClient) NewDescribeNATGWPolicyRequest() *DescribeNATGWPolicyRequest {
	req := &DescribeNATGWPolicyRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: DescribeNATGWPolicy

展示NAT网关端口转发规则
*/
func (c *VPCClient) DescribeNATGWPolicy(req *DescribeNATGWPolicyRequest) (*DescribeNATGWPolicyResponse, error) {
	var err error
	var res DescribeNATGWPolicyResponse

	reqCopier := *req

	err = c.Client.InvokeAction("DescribeNATGWPolicy", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// DescribeNetworkAclRequest is request schema for DescribeNetworkAcl action
type DescribeNetworkAclRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// 列表获取的个数限制
	Limit *string `required:"false"`

	// 列表偏移量
	Offset *int `required:"false"`

	// 需要获取的ACL所属的VPC的ID
	VpcId *string `required:"false"`
}

// DescribeNetworkAclResponse is response schema for DescribeNetworkAcl action
type DescribeNetworkAclResponse struct {
	response.CommonBase

	// ACL的信息，具体结构见下方AclInfo
	AclList []AclInfo
}

// NewDescribeNetworkAclRequest will create request of DescribeNetworkAcl action.
func (c *VPCClient) NewDescribeNetworkAclRequest() *DescribeNetworkAclRequest {
	req := &DescribeNetworkAclRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: DescribeNetworkAcl

获取网络ACL
*/
func (c *VPCClient) DescribeNetworkAcl(req *DescribeNetworkAclRequest) (*DescribeNetworkAclResponse, error) {
	var err error
	var res DescribeNetworkAclResponse

	reqCopier := *req

	err = c.Client.InvokeAction("DescribeNetworkAcl", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// DescribeNetworkAclAssociationRequest is request schema for DescribeNetworkAclAssociation action
type DescribeNetworkAclAssociationRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// Acl的ID
	AclId *string `required:"true"`

	// 列表获取的个数限制
	Limit *string `required:"false"`

	// 列表偏移量
	Offset *int `required:"false"`
}

// DescribeNetworkAclAssociationResponse is response schema for DescribeNetworkAclAssociation action
type DescribeNetworkAclAssociationResponse struct {
	response.CommonBase

	// 绑定信息列表
	AssociationList []AssociationInfo
}

// NewDescribeNetworkAclAssociationRequest will create request of DescribeNetworkAclAssociation action.
func (c *VPCClient) NewDescribeNetworkAclAssociationRequest() *DescribeNetworkAclAssociationRequest {
	req := &DescribeNetworkAclAssociationRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: DescribeNetworkAclAssociation

获取网络ACL的绑定关系列表
*/
func (c *VPCClient) DescribeNetworkAclAssociation(req *DescribeNetworkAclAssociationRequest) (*DescribeNetworkAclAssociationResponse, error) {
	var err error
	var res DescribeNetworkAclAssociationResponse

	reqCopier := *req

	err = c.Client.InvokeAction("DescribeNetworkAclAssociation", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// DescribeNetworkAclAssociationBySubnetRequest is request schema for DescribeNetworkAclAssociationBySubnet action
type DescribeNetworkAclAssociationBySubnetRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// 子网的ID
	SubnetworkId *string `required:"true"`
}

// DescribeNetworkAclAssociationBySubnetResponse is response schema for DescribeNetworkAclAssociationBySubnet action
type DescribeNetworkAclAssociationBySubnetResponse struct {
	response.CommonBase

	// 绑定信息
	Association AssociationInfo
}

// NewDescribeNetworkAclAssociationBySubnetRequest will create request of DescribeNetworkAclAssociationBySubnet action.
func (c *VPCClient) NewDescribeNetworkAclAssociationBySubnetRequest() *DescribeNetworkAclAssociationBySubnetRequest {
	req := &DescribeNetworkAclAssociationBySubnetRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: DescribeNetworkAclAssociationBySubnet

获取子网的ACL绑定信息
*/
func (c *VPCClient) DescribeNetworkAclAssociationBySubnet(req *DescribeNetworkAclAssociationBySubnetRequest) (*DescribeNetworkAclAssociationBySubnetResponse, error) {
	var err error
	var res DescribeNetworkAclAssociationBySubnetResponse

	reqCopier := *req

	err = c.Client.InvokeAction("DescribeNetworkAclAssociationBySubnet", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// DescribeNetworkAclEntryRequest is request schema for DescribeNetworkAclEntry action
type DescribeNetworkAclEntryRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// ACL的ID
	AclId *string `required:"true"`
}

// DescribeNetworkAclEntryResponse is response schema for DescribeNetworkAclEntry action
type DescribeNetworkAclEntryResponse struct {
	response.CommonBase

	// 所有的规则信息
	EntryList []AclEntryInfo
}

// NewDescribeNetworkAclEntryRequest will create request of DescribeNetworkAclEntry action.
func (c *VPCClient) NewDescribeNetworkAclEntryRequest() *DescribeNetworkAclEntryRequest {
	req := &DescribeNetworkAclEntryRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: DescribeNetworkAclEntry

获取ACL的规则信息
*/
func (c *VPCClient) DescribeNetworkAclEntry(req *DescribeNetworkAclEntryRequest) (*DescribeNetworkAclEntryResponse, error) {
	var err error
	var res DescribeNetworkAclEntryResponse

	reqCopier := *req

	err = c.Client.InvokeAction("DescribeNetworkAclEntry", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// DescribeRouteTableRequest is request schema for DescribeRouteTable action
type DescribeRouteTableRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// 业务组ID
	BusinessId *string `required:"false"`

	// 数据分页值。默认为20
	Limit *int `required:"false"`

	// 数据偏移量。默认为0
	OffSet *int `required:"false"`

	// 路由表资源ID
	RouteTableId *string `required:"false"`

	// 所属VPC的资源ID
	VPCId *string `required:"false"`
}

// DescribeRouteTableResponse is response schema for DescribeRouteTable action
type DescribeRouteTableResponse struct {
	response.CommonBase

	// 路由表信息
	RouteTables []RouteTableInfo

	// RouteTables字段的数量
	TotalCount int
}

// NewDescribeRouteTableRequest will create request of DescribeRouteTable action.
func (c *VPCClient) NewDescribeRouteTableRequest() *DescribeRouteTableRequest {
	req := &DescribeRouteTableRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: DescribeRouteTable

获取路由表详细信息(包括路由策略)
*/
func (c *VPCClient) DescribeRouteTable(req *DescribeRouteTableRequest) (*DescribeRouteTableResponse, error) {
	var err error
	var res DescribeRouteTableResponse

	reqCopier := *req

	err = c.Client.InvokeAction("DescribeRouteTable", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// DescribeSecondaryIpRequest is request schema for DescribeSecondaryIp action
type DescribeSecondaryIpRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// [公共参数] 可用区。参见 [可用区列表](../summary/regionlist.html)
	// Zone *string `required:"true"`

	// Ip
	Ip *string `required:"false"`

	// Mac
	Mac *string `required:"false"`

	// 子网Id
	SubnetId *string `required:"true"`

	// VPCId
	VPCId *string `required:"true"`
}

// DescribeSecondaryIpResponse is response schema for DescribeSecondaryIp action
type DescribeSecondaryIpResponse struct {
	response.CommonBase

	//
	DataSet []IpInfo
}

// NewDescribeSecondaryIpRequest will create request of DescribeSecondaryIp action.
func (c *VPCClient) NewDescribeSecondaryIpRequest() *DescribeSecondaryIpRequest {
	req := &DescribeSecondaryIpRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: DescribeSecondaryIp

查询SecondaryIp（uk8s使用）
*/
func (c *VPCClient) DescribeSecondaryIp(req *DescribeSecondaryIpRequest) (*DescribeSecondaryIpResponse, error) {
	var err error
	var res DescribeSecondaryIpResponse

	reqCopier := *req

	err = c.Client.InvokeAction("DescribeSecondaryIp", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// DescribeSubnetRequest is request schema for DescribeSubnet action
type DescribeSubnetRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// 【该字段已废弃，请谨慎使用】
	BusinessId *string `required:"false" deprecated:"true"`

	// 列表长度，默认为20
	Limit *int `required:"false"`

	// 偏移量，默认为0
	Offset *int `required:"false"`

	// 路由表Id
	RouteTableId *string `required:"false"`

	// 是否返回子网的可用IP数，true为是，false为否，默认不返回
	ShowAvailableIPs *bool `required:"false"`

	// 子网id，适用于一次查询一个子网信息
	SubnetId *string `required:"false"`

	// 子网id数组，适用于一次查询多个子网信息
	SubnetIds []string `required:"false"`

	// 业务组名称，默认为Default
	Tag *string `required:"false"`

	// VPC资源id
	VPCId *string `required:"false"`
}

// DescribeSubnetResponse is response schema for DescribeSubnet action
type DescribeSubnetResponse struct {
	response.CommonBase

	// 子网信息数组，具体资源见下方VPCSubnetInfoSet
	DataSet []VPCSubnetInfoSet

	// 子网总数量
	TotalCount int
}

// NewDescribeSubnetRequest will create request of DescribeSubnet action.
func (c *VPCClient) NewDescribeSubnetRequest() *DescribeSubnetRequest {
	req := &DescribeSubnetRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: DescribeSubnet

获取子网信息
*/
func (c *VPCClient) DescribeSubnet(req *DescribeSubnetRequest) (*DescribeSubnetResponse, error) {
	var err error
	var res DescribeSubnetResponse

	reqCopier := *req

	err = c.Client.InvokeAction("DescribeSubnet", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// DescribeSubnetResourceRequest is request schema for DescribeSubnetResource action
type DescribeSubnetResourceRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// 单页返回数据长度，默认为20
	Limit *int `required:"false"`

	// 列表起始位置偏移量，默认为0
	Offset *int `required:"false"`

	// 资源类型，默认为全部资源类型。枚举值为：UHOST，云主机；PHOST，物理云主机；ULB，负载均衡；UHADOOP_HOST，hadoop节点；UFORTRESS_HOST，堡垒机；UNATGW，NAT网关；UKAFKA，Kafka消息队列；UMEM，内存存储；DOCKER，容器集群；UDB，数据库；UDW，数据仓库；VIP，内网VIP.
	ResourceType *string `required:"false"`

	// 子网id
	SubnetId *string `required:"true"`
}

// DescribeSubnetResourceResponse is response schema for DescribeSubnetResource action
type DescribeSubnetResourceResponse struct {
	response.CommonBase

	// 返回数据集，请见ResourceInfo
	DataSet []ResourceInfo

	// 总数
	TotalCount int
}

// NewDescribeSubnetResourceRequest will create request of DescribeSubnetResource action.
func (c *VPCClient) NewDescribeSubnetResourceRequest() *DescribeSubnetResourceRequest {
	req := &DescribeSubnetResourceRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: DescribeSubnetResource

展示子网资源
*/
func (c *VPCClient) DescribeSubnetResource(req *DescribeSubnetResourceRequest) (*DescribeSubnetResourceResponse, error) {
	var err error
	var res DescribeSubnetResourceResponse

	reqCopier := *req

	err = c.Client.InvokeAction("DescribeSubnetResource", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// DescribeVIPRequest is request schema for DescribeVIP action
type DescribeVIPRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"true"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// [公共参数] 可用区。参见 [可用区列表](../summary/regionlist.html)
	// Zone *string `required:"false"`

	// 业务组
	BusinessId *string `required:"false"`

	// 子网id，不指定则获取VPCId下的所有vip
	SubnetId *string `required:"false"`

	// 业务组名称, 默认为 Default
	Tag *string `required:"false"`

	// VIP ID
	VIPId *string `required:"false"`

	// vpc的id,指定SubnetId时必填
	VPCId *string `required:"false"`
}

// DescribeVIPResponse is response schema for DescribeVIP action
type DescribeVIPResponse struct {
	response.CommonBase

	// 内网VIP地址列表
	DataSet []string

	// vip数量
	TotalCount int

	// 内网VIP详情，请见VIPDetailSet
	VIPSet []VIPDetailSet
}

// NewDescribeVIPRequest will create request of DescribeVIP action.
func (c *VPCClient) NewDescribeVIPRequest() *DescribeVIPRequest {
	req := &DescribeVIPRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: DescribeVIP

获取内网VIP详细信息
*/
func (c *VPCClient) DescribeVIP(req *DescribeVIPRequest) (*DescribeVIPResponse, error) {
	var err error
	var res DescribeVIPResponse

	reqCopier := *req

	err = c.Client.InvokeAction("DescribeVIP", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// DescribeVPCRequest is request schema for DescribeVPC action
type DescribeVPCRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"true"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	//
	Limit *int `required:"false"`

	//
	Offset *int `required:"false"`

	// 业务组名称
	Tag *string `required:"false"`

	// VPCId
	VPCIds []string `required:"false"`
}

// DescribeVPCResponse is response schema for DescribeVPC action
type DescribeVPCResponse struct {
	response.CommonBase

	// vpc信息，具体结构见下方VPCInfo
	DataSet []VPCInfo
}

// NewDescribeVPCRequest will create request of DescribeVPC action.
func (c *VPCClient) NewDescribeVPCRequest() *DescribeVPCRequest {
	req := &DescribeVPCRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: DescribeVPC

获取VPC信息
*/
func (c *VPCClient) DescribeVPC(req *DescribeVPCRequest) (*DescribeVPCResponse, error) {
	var err error
	var res DescribeVPCResponse

	reqCopier := *req

	err = c.Client.InvokeAction("DescribeVPC", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// DescribeVPCIntercomRequest is request schema for DescribeVPCIntercom action
type DescribeVPCIntercomRequest struct {
	request.CommonBase

	// [公共参数] 源VPC所在项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"true"`

	// [公共参数] 源VPC所在地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// 目的项目ID，默认为全部项目
	DstProjectId *string `required:"false"`

	// 目的VPC所在地域，默认为全部地域
	DstRegion *string `required:"false"`

	// VPC短ID
	VPCId *string `required:"true"`
}

// DescribeVPCIntercomResponse is response schema for DescribeVPCIntercom action
type DescribeVPCIntercomResponse struct {
	response.CommonBase

	// 联通VPC信息数组
	DataSet []VPCIntercomInfo
}

// NewDescribeVPCIntercomRequest will create request of DescribeVPCIntercom action.
func (c *VPCClient) NewDescribeVPCIntercomRequest() *DescribeVPCIntercomRequest {
	req := &DescribeVPCIntercomRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: DescribeVPCIntercom

获取VPC互通信息
*/
func (c *VPCClient) DescribeVPCIntercom(req *DescribeVPCIntercomRequest) (*DescribeVPCIntercomResponse, error) {
	var err error
	var res DescribeVPCIntercomResponse

	reqCopier := *req

	err = c.Client.InvokeAction("DescribeVPCIntercom", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// DescribeWhiteListResourceRequest is request schema for DescribeWhiteListResource action
type DescribeWhiteListResourceRequest struct {
	request.CommonBase

	// [公共参数] 项目id
	// ProjectId *string `required:"true"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// NAT网关的Id
	NATGWIds []string `required:"true"`
}

// DescribeWhiteListResourceResponse is response schema for DescribeWhiteListResource action
type DescribeWhiteListResourceResponse struct {
	response.CommonBase

	// 白名单资源的详细信息，详见DescribeResourceWhiteListDataSet
	DataSet []NatGWWhitelistDataSet

	// 上述DataSet总数量
	TotalCount int
}

// NewDescribeWhiteListResourceRequest will create request of DescribeWhiteListResource action.
func (c *VPCClient) NewDescribeWhiteListResourceRequest() *DescribeWhiteListResourceRequest {
	req := &DescribeWhiteListResourceRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: DescribeWhiteListResource

展示NAT网关白名单资源列表
*/
func (c *VPCClient) DescribeWhiteListResource(req *DescribeWhiteListResourceRequest) (*DescribeWhiteListResourceResponse, error) {
	var err error
	var res DescribeWhiteListResourceResponse

	reqCopier := *req

	err = c.Client.InvokeAction("DescribeWhiteListResource", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// EnableWhiteListRequest is request schema for EnableWhiteList action
type EnableWhiteListRequest struct {
	request.CommonBase

	// [公共参数] 项目Id。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// 白名单开关标记。0：关闭；1：开启。默认为0
	IfOpen *int `required:"true"`

	// NAT网关Id
	NATGWId *string `required:"true"`
}

// EnableWhiteListResponse is response schema for EnableWhiteList action
type EnableWhiteListResponse struct {
	response.CommonBase
}

// NewEnableWhiteListRequest will create request of EnableWhiteList action.
func (c *VPCClient) NewEnableWhiteListRequest() *EnableWhiteListRequest {
	req := &EnableWhiteListRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: EnableWhiteList

修改NAT网关白名单开关
*/
func (c *VPCClient) EnableWhiteList(req *EnableWhiteListRequest) (*EnableWhiteListResponse, error) {
	var err error
	var res EnableWhiteListResponse

	reqCopier := *req

	err = c.Client.InvokeAction("EnableWhiteList", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// GetAvailableResourceForPolicyRequest is request schema for GetAvailableResourceForPolicy action
type GetAvailableResourceForPolicyRequest struct {
	request.CommonBase

	// [公共参数] 项目Id。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// 返回数据长度，默认为10000
	Limit *int `required:"false"`

	// NAT网关Id
	NATGWId *string `required:"true"`

	// 列表起始位置偏移量，默认为0
	Offset *int `required:"false"`
}

// GetAvailableResourceForPolicyResponse is response schema for GetAvailableResourceForPolicy action
type GetAvailableResourceForPolicyResponse struct {
	response.CommonBase

	// 支持资源类型的信息
	DataSet []GetAvailableResourceForPolicyDataSet
}

// NewGetAvailableResourceForPolicyRequest will create request of GetAvailableResourceForPolicy action.
func (c *VPCClient) NewGetAvailableResourceForPolicyRequest() *GetAvailableResourceForPolicyRequest {
	req := &GetAvailableResourceForPolicyRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: GetAvailableResourceForPolicy

获取NAT网关可配置端口转发规则的资源信息
*/
func (c *VPCClient) GetAvailableResourceForPolicy(req *GetAvailableResourceForPolicyRequest) (*GetAvailableResourceForPolicyResponse, error) {
	var err error
	var res GetAvailableResourceForPolicyResponse

	reqCopier := *req

	err = c.Client.InvokeAction("GetAvailableResourceForPolicy", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// GetAvailableResourceForWhiteListRequest is request schema for GetAvailableResourceForWhiteList action
type GetAvailableResourceForWhiteListRequest struct {
	request.CommonBase

	// [公共参数] 项目Id。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// NAT网关Id
	NATGWId *string `required:"true"`
}

// GetAvailableResourceForWhiteListResponse is response schema for GetAvailableResourceForWhiteList action
type GetAvailableResourceForWhiteListResponse struct {
	response.CommonBase

	// 返回白名单列表的详细信息
	DataSet []GetAvailableResourceForWhiteListDataSet

	// 白名单资源列表的总的个数
	TotalCount int
}

// NewGetAvailableResourceForWhiteListRequest will create request of GetAvailableResourceForWhiteList action.
func (c *VPCClient) NewGetAvailableResourceForWhiteListRequest() *GetAvailableResourceForWhiteListRequest {
	req := &GetAvailableResourceForWhiteListRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: GetAvailableResourceForWhiteList

获取NAT网关可添加白名单的资源
*/
func (c *VPCClient) GetAvailableResourceForWhiteList(req *GetAvailableResourceForWhiteListRequest) (*GetAvailableResourceForWhiteListResponse, error) {
	var err error
	var res GetAvailableResourceForWhiteListResponse

	reqCopier := *req

	err = c.Client.InvokeAction("GetAvailableResourceForWhiteList", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// GetNetworkAclTargetResourceRequest is request schema for GetNetworkAclTargetResource action
type GetNetworkAclTargetResourceRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// 子网ID。
	SubnetworkId []string `required:"true"`
}

// GetNetworkAclTargetResourceResponse is response schema for GetNetworkAclTargetResource action
type GetNetworkAclTargetResourceResponse struct {
	response.CommonBase

	// ACL规则应用目标资源列表，具体结构见下方TargetResourceInfo
	TargetResourceList []TargetResourceInfo

	// ACL规则应用目标资源总数
	TotalCount int
}

// NewGetNetworkAclTargetResourceRequest will create request of GetNetworkAclTargetResource action.
func (c *VPCClient) NewGetNetworkAclTargetResourceRequest() *GetNetworkAclTargetResourceRequest {
	req := &GetNetworkAclTargetResourceRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: GetNetworkAclTargetResource

获取ACL规则应用目标列表
*/
func (c *VPCClient) GetNetworkAclTargetResource(req *GetNetworkAclTargetResourceRequest) (*GetNetworkAclTargetResourceResponse, error) {
	var err error
	var res GetNetworkAclTargetResourceResponse

	reqCopier := *req

	err = c.Client.InvokeAction("GetNetworkAclTargetResource", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// ListSubnetForNATGWRequest is request schema for ListSubnetForNATGW action
type ListSubnetForNATGWRequest struct {
	request.CommonBase

	// [公共参数] 项目Id。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// NAT网关所属VPC Id。默认值为Default VPC Id
	VPCId *string `required:"false"`
}

// ListSubnetForNATGWResponse is response schema for ListSubnetForNATGW action
type ListSubnetForNATGWResponse struct {
	response.CommonBase

	// 具体参数请见NatgwSubnetDataSet
	DataSet []NatgwSubnetDataSet
}

// NewListSubnetForNATGWRequest will create request of ListSubnetForNATGW action.
func (c *VPCClient) NewListSubnetForNATGWRequest() *ListSubnetForNATGWRequest {
	req := &ListSubnetForNATGWRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: ListSubnetForNATGW

展示NAT网关可绑定的子网列表
*/
func (c *VPCClient) ListSubnetForNATGW(req *ListSubnetForNATGWRequest) (*ListSubnetForNATGWResponse, error) {
	var err error
	var res ListSubnetForNATGWResponse

	reqCopier := *req

	err = c.Client.InvokeAction("ListSubnetForNATGW", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// ModifyRouteRuleRequest is request schema for ModifyRouteRule action
type ModifyRouteRuleRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"true"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// 格式: RouteRuleId | 目的网段 | 下一跳类型（支持INSTANCE、VIP） | 下一跳 |优先级（保留字段，填写0即可）| 备注 | 增、删、改标志（add/delete/update） 。"添加"示例: test_id | 10.8.0.0/16 | instance | uhost-xd8ja | 0 | Default Route Rule| add (添加的RouteRuleId填任意非空字符串) 。"删除"示例: routerule-xk3jxa | 10.8.0.0/16 | instance | uhost-xd8ja | 0 | Default Route Rule| delete (RouteRuleId来自DescribeRouteTable中)     。“修改”示例: routerule-xk3jxa | 10.8.0.0/16 | instance | uhost-cjksa2 | 0 | Default Route Rule| update (RouteRuleId来自DescribeRouteTable中)
	RouteRule []string `required:"true"`

	// 通过DescribeRouteTable拿到
	RouteTableId *string `required:"true"`
}

// ModifyRouteRuleResponse is response schema for ModifyRouteRule action
type ModifyRouteRuleResponse struct {
	response.CommonBase
}

// NewModifyRouteRuleRequest will create request of ModifyRouteRule action.
func (c *VPCClient) NewModifyRouteRuleRequest() *ModifyRouteRuleRequest {
	req := &ModifyRouteRuleRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: ModifyRouteRule

路由策略增、删、改
*/
func (c *VPCClient) ModifyRouteRule(req *ModifyRouteRuleRequest) (*ModifyRouteRuleResponse, error) {
	var err error
	var res ModifyRouteRuleResponse

	reqCopier := *req

	err = c.Client.InvokeAction("ModifyRouteRule", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// ReleaseVIPRequest is request schema for ReleaseVIP action
type ReleaseVIPRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写
	// ProjectId *string `required:"false"`

	// [公共参数] 地域
	// Region *string `required:"true"`

	// [公共参数] 可用区
	// Zone *string `required:"false"`

	// 内网VIP的id
	VIPId *string `required:"true"`
}

// ReleaseVIPResponse is response schema for ReleaseVIP action
type ReleaseVIPResponse struct {
	response.CommonBase
}

// NewReleaseVIPRequest will create request of ReleaseVIP action.
func (c *VPCClient) NewReleaseVIPRequest() *ReleaseVIPRequest {
	req := &ReleaseVIPRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: ReleaseVIP

释放VIP资源
*/
func (c *VPCClient) ReleaseVIP(req *ReleaseVIPRequest) (*ReleaseVIPResponse, error) {
	var err error
	var res ReleaseVIPResponse

	reqCopier := *req

	err = c.Client.InvokeAction("ReleaseVIP", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// SetGwDefaultExportRequest is request schema for SetGwDefaultExport action
type SetGwDefaultExportRequest struct {
	request.CommonBase

	// [公共参数] 项目Id。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// NAT网关绑定的EIP Id。ExportIp和ExportEipId必填一个
	ExportEipId *string `required:"false"`

	// NAT网关绑定的EIP。ExportIp和ExportEipId必填一个
	ExportIp *string `required:"false"`

	// NAT网关Id
	NATGWId *string `required:"true"`
}

// SetGwDefaultExportResponse is response schema for SetGwDefaultExport action
type SetGwDefaultExportResponse struct {
	response.CommonBase
}

// NewSetGwDefaultExportRequest will create request of SetGwDefaultExport action.
func (c *VPCClient) NewSetGwDefaultExportRequest() *SetGwDefaultExportRequest {
	req := &SetGwDefaultExportRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: SetGwDefaultExport

设置NAT网关的默认出口
*/
func (c *VPCClient) SetGwDefaultExport(req *SetGwDefaultExportRequest) (*SetGwDefaultExportResponse, error) {
	var err error
	var res SetGwDefaultExportResponse

	reqCopier := *req

	err = c.Client.InvokeAction("SetGwDefaultExport", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// UpdateNATGWPolicyRequest is request schema for UpdateNATGWPolicy action
type UpdateNATGWPolicyRequest struct {
	request.CommonBase

	// [公共参数] 项目Id。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// 目标IP。填写对饮的目标IP地址
	DstIP *string `required:"true"`

	// 目标端口。可填写固定端口，也可填写端口范围。支持的端口范围为1-65535
	DstPort *string `required:"true"`

	// NAT网关Id
	NATGWId *string `required:"true"`

	// 转发策略Id
	PolicyId *string `required:"true"`

	// 转发策略名称。默认为空
	PolicyName *string `required:"false"`

	// 协议类型。枚举值为：TCP 、 UDP
	Protocol *string `required:"true"`

	// 源IP。填写对应的EIP Id
	SrcEIPId *string `required:"true"`

	// 源端口。可填写固定端口，也可填写端口范围。支持的端口范围为1-6553
	SrcPort *string `required:"true"`
}

// UpdateNATGWPolicyResponse is response schema for UpdateNATGWPolicy action
type UpdateNATGWPolicyResponse struct {
	response.CommonBase
}

// NewUpdateNATGWPolicyRequest will create request of UpdateNATGWPolicy action.
func (c *VPCClient) NewUpdateNATGWPolicyRequest() *UpdateNATGWPolicyRequest {
	req := &UpdateNATGWPolicyRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: UpdateNATGWPolicy

更新NAT网关端口转发规则
*/
func (c *VPCClient) UpdateNATGWPolicy(req *UpdateNATGWPolicyRequest) (*UpdateNATGWPolicyResponse, error) {
	var err error
	var res UpdateNATGWPolicyResponse

	reqCopier := *req

	err = c.Client.InvokeAction("UpdateNATGWPolicy", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// UpdateNATGWSubnetRequest is request schema for UpdateNATGWSubnet action
type UpdateNATGWSubnetRequest struct {
	request.CommonBase

	// [公共参数] 项目Id。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// NAT网关Id
	NATGWId *string `required:"true"`

	// NAT网关绑定的子网Id
	SubnetworkIds []string `required:"true"`
}

// UpdateNATGWSubnetResponse is response schema for UpdateNATGWSubnet action
type UpdateNATGWSubnetResponse struct {
	response.CommonBase
}

// NewUpdateNATGWSubnetRequest will create request of UpdateNATGWSubnet action.
func (c *VPCClient) NewUpdateNATGWSubnetRequest() *UpdateNATGWSubnetRequest {
	req := &UpdateNATGWSubnetRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: UpdateNATGWSubnet

更新NAT网关绑定的子网
*/
func (c *VPCClient) UpdateNATGWSubnet(req *UpdateNATGWSubnetRequest) (*UpdateNATGWSubnetResponse, error) {
	var err error
	var res UpdateNATGWSubnetResponse

	reqCopier := *req

	err = c.Client.InvokeAction("UpdateNATGWSubnet", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// UpdateNetworkAclRequest is request schema for UpdateNetworkAcl action
type UpdateNetworkAclRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// 需要更改的ACL ID
	AclId *string `required:"true"`

	// Acl的名称
	AclName *string `required:"true"`

	// 描述
	Description *string `required:"true"`
}

// UpdateNetworkAclResponse is response schema for UpdateNetworkAcl action
type UpdateNetworkAclResponse struct {
	response.CommonBase
}

// NewUpdateNetworkAclRequest will create request of UpdateNetworkAcl action.
func (c *VPCClient) NewUpdateNetworkAclRequest() *UpdateNetworkAclRequest {
	req := &UpdateNetworkAclRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: UpdateNetworkAcl

更改ACL
*/
func (c *VPCClient) UpdateNetworkAcl(req *UpdateNetworkAclRequest) (*UpdateNetworkAclResponse, error) {
	var err error
	var res UpdateNetworkAclResponse

	reqCopier := *req

	err = c.Client.InvokeAction("UpdateNetworkAcl", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// UpdateNetworkAclEntryRequest is request schema for UpdateNetworkAclEntry action
type UpdateNetworkAclEntryRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// ACL的ID
	AclId *string `required:"true"`

	// IPv4段的CIDR表示
	CidrBlock *string `required:"true"`

	// 描述
	Description *string `required:"false"`

	// 出向或者入向（“Ingress”, "Egress")
	Direction *string `required:"true"`

	// 规则的行为("Accept", "Reject")
	EntryAction *string `required:"true"`

	// 需要更新的Entry Id
	EntryId *string `required:"true"`

	// 针对的协议规则
	IpProtocol *string `required:"true"`

	// 针对的端口范围
	PortRange *string `required:"true"`

	// Entry的优先级，对于同样的Direction来说，不能重复
	Priority *int `required:"true"`

	// 应用目标资源列表。默认为全部资源生效。TargetType为0时不用填写该值
	TargetResourceIds []string `required:"false"`

	// 应用目标类型。0代表“子网内全部资源”， 1代表“子网内指定资源”。默认为0
	TargetType *int `required:"false"`
}

// UpdateNetworkAclEntryResponse is response schema for UpdateNetworkAclEntry action
type UpdateNetworkAclEntryResponse struct {
	response.CommonBase
}

// NewUpdateNetworkAclEntryRequest will create request of UpdateNetworkAclEntry action.
func (c *VPCClient) NewUpdateNetworkAclEntryRequest() *UpdateNetworkAclEntryRequest {
	req := &UpdateNetworkAclEntryRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: UpdateNetworkAclEntry

更新ACL的规则
*/
func (c *VPCClient) UpdateNetworkAclEntry(req *UpdateNetworkAclEntryRequest) (*UpdateNetworkAclEntryResponse, error) {
	var err error
	var res UpdateNetworkAclEntryResponse

	reqCopier := *req

	err = c.Client.InvokeAction("UpdateNetworkAclEntry", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// UpdateRouteTableAttributeRequest is request schema for UpdateRouteTableAttribute action
type UpdateRouteTableAttributeRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"true"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// 名称
	Name *string `required:"false"`

	// 备注
	Remark *string `required:"false"`

	// 路由表ID
	RouteTableId *string `required:"true"`

	// 业务组名称
	Tag *string `required:"false"`
}

// UpdateRouteTableAttributeResponse is response schema for UpdateRouteTableAttribute action
type UpdateRouteTableAttributeResponse struct {
	response.CommonBase
}

// NewUpdateRouteTableAttributeRequest will create request of UpdateRouteTableAttribute action.
func (c *VPCClient) NewUpdateRouteTableAttributeRequest() *UpdateRouteTableAttributeRequest {
	req := &UpdateRouteTableAttributeRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: UpdateRouteTableAttribute

更新路由表基本信息
*/
func (c *VPCClient) UpdateRouteTableAttribute(req *UpdateRouteTableAttributeRequest) (*UpdateRouteTableAttributeResponse, error) {
	var err error
	var res UpdateRouteTableAttributeResponse

	reqCopier := *req

	err = c.Client.InvokeAction("UpdateRouteTableAttribute", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// UpdateSubnetAttributeRequest is request schema for UpdateSubnetAttribute action
type UpdateSubnetAttributeRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// 子网名称(如果Name不填写，Tag必须填写)
	Name *string `required:"false"`

	// 子网ID
	SubnetId *string `required:"true"`

	// 业务组名称(如果Tag不填写，Name必须填写)
	Tag *string `required:"false"`
}

// UpdateSubnetAttributeResponse is response schema for UpdateSubnetAttribute action
type UpdateSubnetAttributeResponse struct {
	response.CommonBase
}

// NewUpdateSubnetAttributeRequest will create request of UpdateSubnetAttribute action.
func (c *VPCClient) NewUpdateSubnetAttributeRequest() *UpdateSubnetAttributeRequest {
	req := &UpdateSubnetAttributeRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: UpdateSubnetAttribute

更新子网信息
*/
func (c *VPCClient) UpdateSubnetAttribute(req *UpdateSubnetAttributeRequest) (*UpdateSubnetAttributeResponse, error) {
	var err error
	var res UpdateSubnetAttributeResponse

	reqCopier := *req

	err = c.Client.InvokeAction("UpdateSubnetAttribute", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// UpdateVIPAttributeRequest is request schema for UpdateVIPAttribute action
type UpdateVIPAttributeRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"true"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// 内网VIP的名称
	Name *string `required:"false"`

	// 内网VIP的备注
	Remark *string `required:"false"`

	// 内网VIP所属的业务组
	Tag *string `required:"false"`

	// 内网VIP的资源Id
	VIPId *string `required:"true"`
}

// UpdateVIPAttributeResponse is response schema for UpdateVIPAttribute action
type UpdateVIPAttributeResponse struct {
	response.CommonBase
}

// NewUpdateVIPAttributeRequest will create request of UpdateVIPAttribute action.
func (c *VPCClient) NewUpdateVIPAttributeRequest() *UpdateVIPAttributeRequest {
	req := &UpdateVIPAttributeRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: UpdateVIPAttribute

更新VIP信息
*/
func (c *VPCClient) UpdateVIPAttribute(req *UpdateVIPAttributeRequest) (*UpdateVIPAttributeResponse, error) {
	var err error
	var res UpdateVIPAttributeResponse

	reqCopier := *req

	err = c.Client.InvokeAction("UpdateVIPAttribute", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}

// UpdateVPCNetworkRequest is request schema for UpdateVPCNetwork action
type UpdateVPCNetworkRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"true"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// 需要保留的VPC网段。当前仅支持删除VPC网段，添加网段请参考[AddVPCNetwork](../vpc2.0-api/add_vpc_network)
	Network []string `required:"true"`

	// VPC的ID
	VPCId *string `required:"true"`
}

// UpdateVPCNetworkResponse is response schema for UpdateVPCNetwork action
type UpdateVPCNetworkResponse struct {
	response.CommonBase

	// 【该字段已废弃，请谨慎使用】
	Message string `deprecated:"true"`
}

// NewUpdateVPCNetworkRequest will create request of UpdateVPCNetwork action.
func (c *VPCClient) NewUpdateVPCNetworkRequest() *UpdateVPCNetworkRequest {
	req := &UpdateVPCNetworkRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

/*
API: UpdateVPCNetwork

更新VPC网段
*/
func (c *VPCClient) UpdateVPCNetwork(req *UpdateVPCNetworkRequest) (*UpdateVPCNetworkResponse, error) {
	var err error
	var res UpdateVPCNetworkResponse

	reqCopier := *req

	err = c.Client.InvokeAction("UpdateVPCNetwork", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}
