// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0-devel
// 	protoc        v3.6.1
// source: yandex/cloud/mdb/mongodb/v1/cluster.proto

package mongodb

import (
	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	config "github.com/yandex-cloud/go-genproto/yandex/cloud/mdb/mongodb/v1/config"
	timeofday "google.golang.org/genproto/googleapis/type/timeofday"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Deployment environment.
type Cluster_Environment int32

const (
	Cluster_ENVIRONMENT_UNSPECIFIED Cluster_Environment = 0
	// Stable environment with a conservative update policy: only hotfixes
	// are applied during regular maintenance.
	Cluster_PRODUCTION Cluster_Environment = 1
	// Environment with more aggressive update policy: new versions
	// are rolled out irrespective of backward compatibility.
	Cluster_PRESTABLE Cluster_Environment = 2
)

// Enum value maps for Cluster_Environment.
var (
	Cluster_Environment_name = map[int32]string{
		0: "ENVIRONMENT_UNSPECIFIED",
		1: "PRODUCTION",
		2: "PRESTABLE",
	}
	Cluster_Environment_value = map[string]int32{
		"ENVIRONMENT_UNSPECIFIED": 0,
		"PRODUCTION":              1,
		"PRESTABLE":               2,
	}
)

func (x Cluster_Environment) Enum() *Cluster_Environment {
	p := new(Cluster_Environment)
	*p = x
	return p
}

func (x Cluster_Environment) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_Environment) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes[0].Descriptor()
}

func (Cluster_Environment) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes[0]
}

func (x Cluster_Environment) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_Environment.Descriptor instead.
func (Cluster_Environment) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{0, 0}
}

type Cluster_Health int32

const (
	// State of the cluster is unknown ([Host.health] for every host in the cluster is UNKNOWN).
	Cluster_HEALTH_UNKNOWN Cluster_Health = 0
	// Cluster is alive and well ([Host.health] for every host in the cluster is ALIVE).
	Cluster_ALIVE Cluster_Health = 1
	// Cluster is inoperable ([Host.health] for every host in the cluster is DEAD).
	Cluster_DEAD Cluster_Health = 2
	// Cluster is working below capacity ([Host.health] for at least one host in the cluster is not ALIVE).
	Cluster_DEGRADED Cluster_Health = 3
)

// Enum value maps for Cluster_Health.
var (
	Cluster_Health_name = map[int32]string{
		0: "HEALTH_UNKNOWN",
		1: "ALIVE",
		2: "DEAD",
		3: "DEGRADED",
	}
	Cluster_Health_value = map[string]int32{
		"HEALTH_UNKNOWN": 0,
		"ALIVE":          1,
		"DEAD":           2,
		"DEGRADED":       3,
	}
)

func (x Cluster_Health) Enum() *Cluster_Health {
	p := new(Cluster_Health)
	*p = x
	return p
}

func (x Cluster_Health) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_Health) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes[1].Descriptor()
}

func (Cluster_Health) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes[1]
}

func (x Cluster_Health) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_Health.Descriptor instead.
func (Cluster_Health) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{0, 1}
}

type Cluster_Status int32

const (
	// Cluster state is unknown.
	Cluster_STATUS_UNKNOWN Cluster_Status = 0
	// Cluster is being created.
	Cluster_CREATING Cluster_Status = 1
	// Cluster is running normally.
	Cluster_RUNNING Cluster_Status = 2
	// Cluster encountered a problem and cannot operate.
	Cluster_ERROR Cluster_Status = 3
	// Cluster is being updated.
	Cluster_UPDATING Cluster_Status = 4
	// Cluster is stopping.
	Cluster_STOPPING Cluster_Status = 5
	// Cluster stopped.
	Cluster_STOPPED Cluster_Status = 6
	// Cluster is starting.
	Cluster_STARTING Cluster_Status = 7
)

// Enum value maps for Cluster_Status.
var (
	Cluster_Status_name = map[int32]string{
		0: "STATUS_UNKNOWN",
		1: "CREATING",
		2: "RUNNING",
		3: "ERROR",
		4: "UPDATING",
		5: "STOPPING",
		6: "STOPPED",
		7: "STARTING",
	}
	Cluster_Status_value = map[string]int32{
		"STATUS_UNKNOWN": 0,
		"CREATING":       1,
		"RUNNING":        2,
		"ERROR":          3,
		"UPDATING":       4,
		"STOPPING":       5,
		"STOPPED":        6,
		"STARTING":       7,
	}
)

func (x Cluster_Status) Enum() *Cluster_Status {
	p := new(Cluster_Status)
	*p = x
	return p
}

func (x Cluster_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes[2].Descriptor()
}

func (Cluster_Status) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes[2]
}

func (x Cluster_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_Status.Descriptor instead.
func (Cluster_Status) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{0, 2}
}

type Host_Type int32

const (
	Host_TYPE_UNSPECIFIED Host_Type = 0
	// A mongod host.
	Host_MONGOD Host_Type = 1
	// A mongos host.
	Host_MONGOS Host_Type = 2
	// A mongocfg host.
	Host_MONGOCFG Host_Type = 3
	// A mongoinfra (mongos+mongocfg) host.
	Host_MONGOINFRA Host_Type = 4
)

// Enum value maps for Host_Type.
var (
	Host_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "MONGOD",
		2: "MONGOS",
		3: "MONGOCFG",
		4: "MONGOINFRA",
	}
	Host_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"MONGOD":           1,
		"MONGOS":           2,
		"MONGOCFG":         3,
		"MONGOINFRA":       4,
	}
)

func (x Host_Type) Enum() *Host_Type {
	p := new(Host_Type)
	*p = x
	return p
}

func (x Host_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Host_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes[3].Descriptor()
}

func (Host_Type) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes[3]
}

func (x Host_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Host_Type.Descriptor instead.
func (Host_Type) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{8, 0}
}

type Host_Role int32

const (
	// Role of the host in the cluster is unknown.
	Host_ROLE_UNKNOWN Host_Role = 0
	// Host is the primary MongoDB server in the cluster.
	Host_PRIMARY Host_Role = 1
	// Host is a secondary MongoDB server in the cluster.
	Host_SECONDARY Host_Role = 2
)

// Enum value maps for Host_Role.
var (
	Host_Role_name = map[int32]string{
		0: "ROLE_UNKNOWN",
		1: "PRIMARY",
		2: "SECONDARY",
	}
	Host_Role_value = map[string]int32{
		"ROLE_UNKNOWN": 0,
		"PRIMARY":      1,
		"SECONDARY":    2,
	}
)

func (x Host_Role) Enum() *Host_Role {
	p := new(Host_Role)
	*p = x
	return p
}

func (x Host_Role) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Host_Role) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes[4].Descriptor()
}

func (Host_Role) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes[4]
}

func (x Host_Role) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Host_Role.Descriptor instead.
func (Host_Role) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{8, 1}
}

type Host_Health int32

const (
	// Health of the host is unknown.
	Host_HEALTH_UNKNOWN Host_Health = 0
	// The host is performing all its functions normally.
	Host_ALIVE Host_Health = 1
	// The host is inoperable, and cannot perform any of its essential functions.
	Host_DEAD Host_Health = 2
	// The host is degraded, and can perform only some of its essential functions.
	Host_DEGRADED Host_Health = 3
)

// Enum value maps for Host_Health.
var (
	Host_Health_name = map[int32]string{
		0: "HEALTH_UNKNOWN",
		1: "ALIVE",
		2: "DEAD",
		3: "DEGRADED",
	}
	Host_Health_value = map[string]int32{
		"HEALTH_UNKNOWN": 0,
		"ALIVE":          1,
		"DEAD":           2,
		"DEGRADED":       3,
	}
)

func (x Host_Health) Enum() *Host_Health {
	p := new(Host_Health)
	*p = x
	return p
}

func (x Host_Health) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Host_Health) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes[5].Descriptor()
}

func (Host_Health) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes[5]
}

func (x Host_Health) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Host_Health.Descriptor instead.
func (Host_Health) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{8, 2}
}

type Service_Type int32

const (
	Service_TYPE_UNSPECIFIED Service_Type = 0
	// The host is running a mongod daemon.
	Service_MONGOD Service_Type = 1
	// The host is running a mongos daemon.
	Service_MONGOS Service_Type = 2
	// The host is running a MongoDB config server.
	Service_MONGOCFG Service_Type = 3
)

// Enum value maps for Service_Type.
var (
	Service_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "MONGOD",
		2: "MONGOS",
		3: "MONGOCFG",
	}
	Service_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"MONGOD":           1,
		"MONGOS":           2,
		"MONGOCFG":         3,
	}
)

func (x Service_Type) Enum() *Service_Type {
	p := new(Service_Type)
	*p = x
	return p
}

func (x Service_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Service_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes[6].Descriptor()
}

func (Service_Type) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes[6]
}

func (x Service_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Service_Type.Descriptor instead.
func (Service_Type) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{9, 0}
}

type Service_Health int32

const (
	// Health of the server is unknown.
	Service_HEALTH_UNKNOWN Service_Health = 0
	// The server is working normally.
	Service_ALIVE Service_Health = 1
	// The server is dead or unresponsive.
	Service_DEAD Service_Health = 2
)

// Enum value maps for Service_Health.
var (
	Service_Health_name = map[int32]string{
		0: "HEALTH_UNKNOWN",
		1: "ALIVE",
		2: "DEAD",
	}
	Service_Health_value = map[string]int32{
		"HEALTH_UNKNOWN": 0,
		"ALIVE":          1,
		"DEAD":           2,
	}
)

func (x Service_Health) Enum() *Service_Health {
	p := new(Service_Health)
	*p = x
	return p
}

func (x Service_Health) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Service_Health) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes[7].Descriptor()
}

func (Service_Health) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes[7]
}

func (x Service_Health) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Service_Health.Descriptor instead.
func (Service_Health) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{9, 1}
}

// A managed MongoDB cluster. For more information, see the [documentation](/docs/managed-mongodb/concepts).
type Cluster struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the MongoDB cluster.
	// This ID is assigned by MDB at creation time.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of the folder that the MongoDB cluster belongs to.
	FolderId string `protobuf:"bytes,2,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Creation timestamp in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	CreatedAt *timestamp.Timestamp `protobuf:"bytes,3,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Name of the MongoDB cluster.
	// The name is unique within the folder. 1-63 characters long.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the MongoDB cluster. 0-256 characters long.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Custom labels for the MongoDB cluster as `` key:value `` pairs. Maximum 64 per resource.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Deployment environment of the MongoDB cluster.
	Environment Cluster_Environment `protobuf:"varint,7,opt,name=environment,proto3,enum=yandex.cloud.mdb.mongodb.v1.Cluster_Environment" json:"environment,omitempty"`
	// Description of monitoring systems relevant to the MongoDB cluster.
	Monitoring []*Monitoring `protobuf:"bytes,8,rep,name=monitoring,proto3" json:"monitoring,omitempty"`
	// Configuration of the MongoDB cluster.
	Config *ClusterConfig `protobuf:"bytes,9,opt,name=config,proto3" json:"config,omitempty"`
	// ID of the network that the cluster belongs to.
	NetworkId string `protobuf:"bytes,10,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	// Aggregated cluster health.
	Health Cluster_Health `protobuf:"varint,11,opt,name=health,proto3,enum=yandex.cloud.mdb.mongodb.v1.Cluster_Health" json:"health,omitempty"`
	// Current state of the cluster.
	Status Cluster_Status `protobuf:"varint,12,opt,name=status,proto3,enum=yandex.cloud.mdb.mongodb.v1.Cluster_Status" json:"status,omitempty"`
	// Indicates current sharding status of the cluster.
	Sharded bool `protobuf:"varint,13,opt,name=sharded,proto3" json:"sharded,omitempty"`
	// Window of maintenance operations.
	MaintenanceWindow *MaintenanceWindow `protobuf:"bytes,14,opt,name=maintenance_window,json=maintenanceWindow,proto3" json:"maintenance_window,omitempty"`
	// Maintenance operation planned at nearest maintenance_window.
	PlannedOperation *MaintenanceOperation `protobuf:"bytes,15,opt,name=planned_operation,json=plannedOperation,proto3" json:"planned_operation,omitempty"`
}

func (x *Cluster) Reset() {
	*x = Cluster{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Cluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster) ProtoMessage() {}

func (x *Cluster) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster.ProtoReflect.Descriptor instead.
func (*Cluster) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{0}
}

func (x *Cluster) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Cluster) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *Cluster) GetCreatedAt() *timestamp.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *Cluster) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Cluster) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Cluster) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Cluster) GetEnvironment() Cluster_Environment {
	if x != nil {
		return x.Environment
	}
	return Cluster_ENVIRONMENT_UNSPECIFIED
}

func (x *Cluster) GetMonitoring() []*Monitoring {
	if x != nil {
		return x.Monitoring
	}
	return nil
}

func (x *Cluster) GetConfig() *ClusterConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Cluster) GetNetworkId() string {
	if x != nil {
		return x.NetworkId
	}
	return ""
}

func (x *Cluster) GetHealth() Cluster_Health {
	if x != nil {
		return x.Health
	}
	return Cluster_HEALTH_UNKNOWN
}

func (x *Cluster) GetStatus() Cluster_Status {
	if x != nil {
		return x.Status
	}
	return Cluster_STATUS_UNKNOWN
}

func (x *Cluster) GetSharded() bool {
	if x != nil {
		return x.Sharded
	}
	return false
}

func (x *Cluster) GetMaintenanceWindow() *MaintenanceWindow {
	if x != nil {
		return x.MaintenanceWindow
	}
	return nil
}

func (x *Cluster) GetPlannedOperation() *MaintenanceOperation {
	if x != nil {
		return x.PlannedOperation
	}
	return nil
}

// Monitoring system.
type Monitoring struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the monitoring system.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the monitoring system.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Link to the monitoring system charts for the MongoDB cluster.
	Link string `protobuf:"bytes,3,opt,name=link,proto3" json:"link,omitempty"`
}

func (x *Monitoring) Reset() {
	*x = Monitoring{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Monitoring) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Monitoring) ProtoMessage() {}

func (x *Monitoring) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Monitoring.ProtoReflect.Descriptor instead.
func (*Monitoring) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{1}
}

func (x *Monitoring) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Monitoring) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Monitoring) GetLink() string {
	if x != nil {
		return x.Link
	}
	return ""
}

type ClusterConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Version of MongoDB server software. Possible values: `3.6`, `4.0`, `4.2`, `4.4`.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// MongoDB feature compatibility version. See usage details in [MongoDB documentation](https://docs.mongodb.com/manual/reference/command/setFeatureCompatibilityVersion/).
	//
	// Possible values:
	// * `3.6` — persist data compatibility for version 3.6. After setting this option the data will not be compatible with 3.4 or lower.
	// * `4.0` — persist data compatibility for version 4.0. After setting this option the data will not be compatible with 3.6 or lower.
	// * `4.2` — persist data compatibility for version 4.2. After setting this option the data will not be compatible with 4.0 or lower.
	// * `4.4` — persist data compatibility for version 4.4. After setting this option the data will not be compatible with 4.2 or lower.
	FeatureCompatibilityVersion string `protobuf:"bytes,5,opt,name=feature_compatibility_version,json=featureCompatibilityVersion,proto3" json:"feature_compatibility_version,omitempty"`
	// Configuration for MongoDB servers in the cluster.
	//
	// Types that are assignable to Mongodb:
	//	*ClusterConfig_Mongodb_3_6
	//	*ClusterConfig_Mongodb_4_0
	//	*ClusterConfig_Mongodb_4_2
	//	*ClusterConfig_Mongodb_4_4
	Mongodb isClusterConfig_Mongodb `protobuf_oneof:"mongodb"`
	// Time to start the daily backup, in the UTC timezone.
	BackupWindowStart *timeofday.TimeOfDay `protobuf:"bytes,3,opt,name=backup_window_start,json=backupWindowStart,proto3" json:"backup_window_start,omitempty"`
	// Retain period of automatically created backup in days
	BackupRetainPeriodDays *wrappers.Int64Value `protobuf:"bytes,9,opt,name=backup_retain_period_days,json=backupRetainPeriodDays,proto3" json:"backup_retain_period_days,omitempty"`
	// Access policy to DB
	Access *Access `protobuf:"bytes,6,opt,name=access,proto3" json:"access,omitempty"`
}

func (x *ClusterConfig) Reset() {
	*x = ClusterConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClusterConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClusterConfig) ProtoMessage() {}

func (x *ClusterConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClusterConfig.ProtoReflect.Descriptor instead.
func (*ClusterConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{2}
}

func (x *ClusterConfig) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *ClusterConfig) GetFeatureCompatibilityVersion() string {
	if x != nil {
		return x.FeatureCompatibilityVersion
	}
	return ""
}

func (m *ClusterConfig) GetMongodb() isClusterConfig_Mongodb {
	if m != nil {
		return m.Mongodb
	}
	return nil
}

func (x *ClusterConfig) GetMongodb_3_6() *Mongodb3_6 {
	if x, ok := x.GetMongodb().(*ClusterConfig_Mongodb_3_6); ok {
		return x.Mongodb_3_6
	}
	return nil
}

func (x *ClusterConfig) GetMongodb_4_0() *Mongodb4_0 {
	if x, ok := x.GetMongodb().(*ClusterConfig_Mongodb_4_0); ok {
		return x.Mongodb_4_0
	}
	return nil
}

func (x *ClusterConfig) GetMongodb_4_2() *Mongodb4_2 {
	if x, ok := x.GetMongodb().(*ClusterConfig_Mongodb_4_2); ok {
		return x.Mongodb_4_2
	}
	return nil
}

func (x *ClusterConfig) GetMongodb_4_4() *Mongodb4_4 {
	if x, ok := x.GetMongodb().(*ClusterConfig_Mongodb_4_4); ok {
		return x.Mongodb_4_4
	}
	return nil
}

func (x *ClusterConfig) GetBackupWindowStart() *timeofday.TimeOfDay {
	if x != nil {
		return x.BackupWindowStart
	}
	return nil
}

func (x *ClusterConfig) GetBackupRetainPeriodDays() *wrappers.Int64Value {
	if x != nil {
		return x.BackupRetainPeriodDays
	}
	return nil
}

func (x *ClusterConfig) GetAccess() *Access {
	if x != nil {
		return x.Access
	}
	return nil
}

type isClusterConfig_Mongodb interface {
	isClusterConfig_Mongodb()
}

type ClusterConfig_Mongodb_3_6 struct {
	// Configuration and resource allocation for a MongoDB 3.6 cluster.
	Mongodb_3_6 *Mongodb3_6 `protobuf:"bytes,2,opt,name=mongodb_3_6,json=mongodb36,proto3,oneof"`
}

type ClusterConfig_Mongodb_4_0 struct {
	// Configuration and resource allocation for a MongoDB 4.0 cluster.
	Mongodb_4_0 *Mongodb4_0 `protobuf:"bytes,4,opt,name=mongodb_4_0,json=mongodb40,proto3,oneof"`
}

type ClusterConfig_Mongodb_4_2 struct {
	// Configuration and resource allocation for a MongoDB 4.2 cluster.
	Mongodb_4_2 *Mongodb4_2 `protobuf:"bytes,7,opt,name=mongodb_4_2,json=mongodb42,proto3,oneof"`
}

type ClusterConfig_Mongodb_4_4 struct {
	// Configuration and resource allocation for a MongoDB 4.4 cluster.
	Mongodb_4_4 *Mongodb4_4 `protobuf:"bytes,8,opt,name=mongodb_4_4,json=mongodb44,proto3,oneof"`
}

func (*ClusterConfig_Mongodb_3_6) isClusterConfig_Mongodb() {}

func (*ClusterConfig_Mongodb_4_0) isClusterConfig_Mongodb() {}

func (*ClusterConfig_Mongodb_4_2) isClusterConfig_Mongodb() {}

func (*ClusterConfig_Mongodb_4_4) isClusterConfig_Mongodb() {}

type Mongodb3_6 struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration and resource allocation for mongod in a MongoDB 3.6 cluster.
	Mongod *Mongodb3_6_Mongod `protobuf:"bytes,1,opt,name=mongod,proto3" json:"mongod,omitempty"`
	// Configuration and resource allocation for mongocfg in a MongoDB 3.6 cluster.
	Mongocfg *Mongodb3_6_MongoCfg `protobuf:"bytes,2,opt,name=mongocfg,proto3" json:"mongocfg,omitempty"`
	// Configuration and resource allocation for mongos in a MongoDB 3.6 cluster.
	Mongos *Mongodb3_6_Mongos `protobuf:"bytes,3,opt,name=mongos,proto3" json:"mongos,omitempty"`
	// Configuration and resource allocation for mongoinfra (mongos+mongocfg) in a MongoDB 3.6 cluster.
	Mongoinfra *Mongodb3_6_MongoInfra `protobuf:"bytes,4,opt,name=mongoinfra,proto3" json:"mongoinfra,omitempty"`
}

func (x *Mongodb3_6) Reset() {
	*x = Mongodb3_6{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb3_6) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb3_6) ProtoMessage() {}

func (x *Mongodb3_6) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb3_6.ProtoReflect.Descriptor instead.
func (*Mongodb3_6) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{3}
}

func (x *Mongodb3_6) GetMongod() *Mongodb3_6_Mongod {
	if x != nil {
		return x.Mongod
	}
	return nil
}

func (x *Mongodb3_6) GetMongocfg() *Mongodb3_6_MongoCfg {
	if x != nil {
		return x.Mongocfg
	}
	return nil
}

func (x *Mongodb3_6) GetMongos() *Mongodb3_6_Mongos {
	if x != nil {
		return x.Mongos
	}
	return nil
}

func (x *Mongodb3_6) GetMongoinfra() *Mongodb3_6_MongoInfra {
	if x != nil {
		return x.Mongoinfra
	}
	return nil
}

type Mongodb4_0 struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration and resource allocation for mongod in a MongoDB 4.0 cluster.
	Mongod *Mongodb4_0_Mongod `protobuf:"bytes,1,opt,name=mongod,proto3" json:"mongod,omitempty"`
	// Configuration and resource allocation for mongocfg in a MongoDB 4.0 cluster.
	Mongocfg *Mongodb4_0_MongoCfg `protobuf:"bytes,2,opt,name=mongocfg,proto3" json:"mongocfg,omitempty"`
	// Configuration and resource allocation for mongos in a MongoDB 4.0 cluster.
	Mongos *Mongodb4_0_Mongos `protobuf:"bytes,3,opt,name=mongos,proto3" json:"mongos,omitempty"`
	// Configuration and resource allocation for mongoinfra (mongos+mongocfg) in a MongoDB 4.0 cluster.
	Mongoinfra *Mongodb4_0_MongoInfra `protobuf:"bytes,4,opt,name=mongoinfra,proto3" json:"mongoinfra,omitempty"`
}

func (x *Mongodb4_0) Reset() {
	*x = Mongodb4_0{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb4_0) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_0) ProtoMessage() {}

func (x *Mongodb4_0) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_0.ProtoReflect.Descriptor instead.
func (*Mongodb4_0) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{4}
}

func (x *Mongodb4_0) GetMongod() *Mongodb4_0_Mongod {
	if x != nil {
		return x.Mongod
	}
	return nil
}

func (x *Mongodb4_0) GetMongocfg() *Mongodb4_0_MongoCfg {
	if x != nil {
		return x.Mongocfg
	}
	return nil
}

func (x *Mongodb4_0) GetMongos() *Mongodb4_0_Mongos {
	if x != nil {
		return x.Mongos
	}
	return nil
}

func (x *Mongodb4_0) GetMongoinfra() *Mongodb4_0_MongoInfra {
	if x != nil {
		return x.Mongoinfra
	}
	return nil
}

type Mongodb4_2 struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration and resource allocation for mongod in a MongoDB 4.2 cluster.
	Mongod *Mongodb4_2_Mongod `protobuf:"bytes,1,opt,name=mongod,proto3" json:"mongod,omitempty"`
	// Configuration and resource allocation for mongocfg in a MongoDB 4.2 cluster.
	Mongocfg *Mongodb4_2_MongoCfg `protobuf:"bytes,2,opt,name=mongocfg,proto3" json:"mongocfg,omitempty"`
	// Configuration and resource allocation for mongos in a MongoDB 4.2 cluster.
	Mongos *Mongodb4_2_Mongos `protobuf:"bytes,3,opt,name=mongos,proto3" json:"mongos,omitempty"`
	// Configuration and resource allocation for mongoinfra (mongos+mongocfg) in a MongoDB 4.2 cluster.
	Mongoinfra *Mongodb4_2_MongoInfra `protobuf:"bytes,4,opt,name=mongoinfra,proto3" json:"mongoinfra,omitempty"`
}

func (x *Mongodb4_2) Reset() {
	*x = Mongodb4_2{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb4_2) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_2) ProtoMessage() {}

func (x *Mongodb4_2) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_2.ProtoReflect.Descriptor instead.
func (*Mongodb4_2) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{5}
}

func (x *Mongodb4_2) GetMongod() *Mongodb4_2_Mongod {
	if x != nil {
		return x.Mongod
	}
	return nil
}

func (x *Mongodb4_2) GetMongocfg() *Mongodb4_2_MongoCfg {
	if x != nil {
		return x.Mongocfg
	}
	return nil
}

func (x *Mongodb4_2) GetMongos() *Mongodb4_2_Mongos {
	if x != nil {
		return x.Mongos
	}
	return nil
}

func (x *Mongodb4_2) GetMongoinfra() *Mongodb4_2_MongoInfra {
	if x != nil {
		return x.Mongoinfra
	}
	return nil
}

type Mongodb4_4 struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration and resource allocation for mongod in a MongoDB 4.4 cluster.
	Mongod *Mongodb4_4_Mongod `protobuf:"bytes,1,opt,name=mongod,proto3" json:"mongod,omitempty"`
	// Configuration and resource allocation for mongocfg in a MongoDB 4.4 cluster.
	Mongocfg *Mongodb4_4_MongoCfg `protobuf:"bytes,2,opt,name=mongocfg,proto3" json:"mongocfg,omitempty"`
	// Configuration and resource allocation for mongos in a MongoDB 4.4 cluster.
	Mongos *Mongodb4_4_Mongos `protobuf:"bytes,3,opt,name=mongos,proto3" json:"mongos,omitempty"`
	// Configuration and resource allocation for mongoinfra (mongos+mongocfg) in a MongoDB 4.4 cluster.
	Mongoinfra *Mongodb4_4_MongoInfra `protobuf:"bytes,4,opt,name=mongoinfra,proto3" json:"mongoinfra,omitempty"`
}

func (x *Mongodb4_4) Reset() {
	*x = Mongodb4_4{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb4_4) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_4) ProtoMessage() {}

func (x *Mongodb4_4) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_4.ProtoReflect.Descriptor instead.
func (*Mongodb4_4) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{6}
}

func (x *Mongodb4_4) GetMongod() *Mongodb4_4_Mongod {
	if x != nil {
		return x.Mongod
	}
	return nil
}

func (x *Mongodb4_4) GetMongocfg() *Mongodb4_4_MongoCfg {
	if x != nil {
		return x.Mongocfg
	}
	return nil
}

func (x *Mongodb4_4) GetMongos() *Mongodb4_4_Mongos {
	if x != nil {
		return x.Mongos
	}
	return nil
}

func (x *Mongodb4_4) GetMongoinfra() *Mongodb4_4_MongoInfra {
	if x != nil {
		return x.Mongoinfra
	}
	return nil
}

type Shard struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the shard.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// ID of the cluster that the shard belongs to.
	ClusterId string `protobuf:"bytes,2,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
}

func (x *Shard) Reset() {
	*x = Shard{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Shard) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Shard) ProtoMessage() {}

func (x *Shard) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Shard.ProtoReflect.Descriptor instead.
func (*Shard) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{7}
}

func (x *Shard) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Shard) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

type Host struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the MongoDB host. The host name is assigned by MDB at creation time, and cannot be changed.
	// 1-63 characters long.
	//
	// The name is unique across all existing MDB hosts in Yandex.Cloud, as it defines the FQDN of the host.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// ID of the MongoDB host. The ID is assigned by MDB at creation time.
	ClusterId string `protobuf:"bytes,2,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// ID of the availability zone where the MongoDB host resides.
	ZoneId string `protobuf:"bytes,3,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// Resources allocated to the MongoDB host.
	Resources *Resources `protobuf:"bytes,4,opt,name=resources,proto3" json:"resources,omitempty"`
	// Role of the host in the cluster.
	Role Host_Role `protobuf:"varint,5,opt,name=role,proto3,enum=yandex.cloud.mdb.mongodb.v1.Host_Role" json:"role,omitempty"`
	// Status code of the aggregated health of the host.
	Health Host_Health `protobuf:"varint,6,opt,name=health,proto3,enum=yandex.cloud.mdb.mongodb.v1.Host_Health" json:"health,omitempty"`
	// Services provided by the host.
	Services []*Service `protobuf:"bytes,7,rep,name=services,proto3" json:"services,omitempty"`
	// ID of the subnet that the host belongs to.
	SubnetId string `protobuf:"bytes,8,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	// Flag showing public IP assignment status to this host.
	AssignPublicIp bool `protobuf:"varint,9,opt,name=assign_public_ip,json=assignPublicIp,proto3" json:"assign_public_ip,omitempty"`
	// Shard which this host belongs to.
	ShardName string `protobuf:"bytes,10,opt,name=shard_name,json=shardName,proto3" json:"shard_name,omitempty"`
	// Host type
	Type Host_Type `protobuf:"varint,11,opt,name=type,proto3,enum=yandex.cloud.mdb.mongodb.v1.Host_Type" json:"type,omitempty"`
}

func (x *Host) Reset() {
	*x = Host{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Host) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Host) ProtoMessage() {}

func (x *Host) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Host.ProtoReflect.Descriptor instead.
func (*Host) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{8}
}

func (x *Host) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Host) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *Host) GetZoneId() string {
	if x != nil {
		return x.ZoneId
	}
	return ""
}

func (x *Host) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Host) GetRole() Host_Role {
	if x != nil {
		return x.Role
	}
	return Host_ROLE_UNKNOWN
}

func (x *Host) GetHealth() Host_Health {
	if x != nil {
		return x.Health
	}
	return Host_HEALTH_UNKNOWN
}

func (x *Host) GetServices() []*Service {
	if x != nil {
		return x.Services
	}
	return nil
}

func (x *Host) GetSubnetId() string {
	if x != nil {
		return x.SubnetId
	}
	return ""
}

func (x *Host) GetAssignPublicIp() bool {
	if x != nil {
		return x.AssignPublicIp
	}
	return false
}

func (x *Host) GetShardName() string {
	if x != nil {
		return x.ShardName
	}
	return ""
}

func (x *Host) GetType() Host_Type {
	if x != nil {
		return x.Type
	}
	return Host_TYPE_UNSPECIFIED
}

type Service struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of the service provided by the host.
	Type Service_Type `protobuf:"varint,1,opt,name=type,proto3,enum=yandex.cloud.mdb.mongodb.v1.Service_Type" json:"type,omitempty"`
	// Status code of server availability.
	Health Service_Health `protobuf:"varint,2,opt,name=health,proto3,enum=yandex.cloud.mdb.mongodb.v1.Service_Health" json:"health,omitempty"`
}

func (x *Service) Reset() {
	*x = Service{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Service) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Service) ProtoMessage() {}

func (x *Service) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Service.ProtoReflect.Descriptor instead.
func (*Service) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{9}
}

func (x *Service) GetType() Service_Type {
	if x != nil {
		return x.Type
	}
	return Service_TYPE_UNSPECIFIED
}

func (x *Service) GetHealth() Service_Health {
	if x != nil {
		return x.Health
	}
	return Service_HEALTH_UNKNOWN
}

type Resources struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the preset for computational resources available to a host (CPU, memory etc.).
	// All available presets are listed in the [documentation](/docs/managed-mongodb/concepts/instance-types).
	ResourcePresetId string `protobuf:"bytes,1,opt,name=resource_preset_id,json=resourcePresetId,proto3" json:"resource_preset_id,omitempty"`
	// Volume of the storage available to a host, in bytes.
	DiskSize int64 `protobuf:"varint,2,opt,name=disk_size,json=diskSize,proto3" json:"disk_size,omitempty"`
	// Type of the storage environment for the host.
	// Possible values:
	// * network-hdd — network HDD drive,
	// * network-ssd — network SSD drive,
	// * local-ssd — local SSD storage.
	DiskTypeId string `protobuf:"bytes,3,opt,name=disk_type_id,json=diskTypeId,proto3" json:"disk_type_id,omitempty"`
}

func (x *Resources) Reset() {
	*x = Resources{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Resources) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Resources) ProtoMessage() {}

func (x *Resources) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Resources.ProtoReflect.Descriptor instead.
func (*Resources) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{10}
}

func (x *Resources) GetResourcePresetId() string {
	if x != nil {
		return x.ResourcePresetId
	}
	return ""
}

func (x *Resources) GetDiskSize() int64 {
	if x != nil {
		return x.DiskSize
	}
	return 0
}

func (x *Resources) GetDiskTypeId() string {
	if x != nil {
		return x.DiskTypeId
	}
	return ""
}

type Access struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Allow access for DataLens
	DataLens bool `protobuf:"varint,1,opt,name=data_lens,json=dataLens,proto3" json:"data_lens,omitempty"`
}

func (x *Access) Reset() {
	*x = Access{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Access) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Access) ProtoMessage() {}

func (x *Access) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Access.ProtoReflect.Descriptor instead.
func (*Access) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{11}
}

func (x *Access) GetDataLens() bool {
	if x != nil {
		return x.DataLens
	}
	return false
}

type Mongodb3_6_Mongod struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for a mongod 3.6 hosts.
	Config *config.MongodConfigSet3_6 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to MongoDB hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
}

func (x *Mongodb3_6_Mongod) Reset() {
	*x = Mongodb3_6_Mongod{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb3_6_Mongod) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb3_6_Mongod) ProtoMessage() {}

func (x *Mongodb3_6_Mongod) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb3_6_Mongod.ProtoReflect.Descriptor instead.
func (*Mongodb3_6_Mongod) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{3, 0}
}

func (x *Mongodb3_6_Mongod) GetConfig() *config.MongodConfigSet3_6 {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb3_6_Mongod) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

type Mongodb3_6_MongoCfg struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Config *config.MongoCfgConfigSet3_6 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongocfg hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
}

func (x *Mongodb3_6_MongoCfg) Reset() {
	*x = Mongodb3_6_MongoCfg{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb3_6_MongoCfg) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb3_6_MongoCfg) ProtoMessage() {}

func (x *Mongodb3_6_MongoCfg) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb3_6_MongoCfg.ProtoReflect.Descriptor instead.
func (*Mongodb3_6_MongoCfg) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{3, 1}
}

func (x *Mongodb3_6_MongoCfg) GetConfig() *config.MongoCfgConfigSet3_6 {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb3_6_MongoCfg) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

type Mongodb3_6_Mongos struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Config *config.MongosConfigSet3_6 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongocfg hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
}

func (x *Mongodb3_6_Mongos) Reset() {
	*x = Mongodb3_6_Mongos{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb3_6_Mongos) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb3_6_Mongos) ProtoMessage() {}

func (x *Mongodb3_6_Mongos) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb3_6_Mongos.ProtoReflect.Descriptor instead.
func (*Mongodb3_6_Mongos) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{3, 2}
}

func (x *Mongodb3_6_Mongos) GetConfig() *config.MongosConfigSet3_6 {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb3_6_Mongos) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

type Mongodb3_6_MongoInfra struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConfigMongos   *config.MongosConfigSet3_6   `protobuf:"bytes,1,opt,name=config_mongos,json=configMongos,proto3" json:"config_mongos,omitempty"`
	ConfigMongocfg *config.MongoCfgConfigSet3_6 `protobuf:"bytes,2,opt,name=config_mongocfg,json=configMongocfg,proto3" json:"config_mongocfg,omitempty"`
	// Resources allocated to mongoinfra (mongos+mongocfg) hosts.
	Resources *Resources `protobuf:"bytes,3,opt,name=resources,proto3" json:"resources,omitempty"`
}

func (x *Mongodb3_6_MongoInfra) Reset() {
	*x = Mongodb3_6_MongoInfra{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb3_6_MongoInfra) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb3_6_MongoInfra) ProtoMessage() {}

func (x *Mongodb3_6_MongoInfra) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb3_6_MongoInfra.ProtoReflect.Descriptor instead.
func (*Mongodb3_6_MongoInfra) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{3, 3}
}

func (x *Mongodb3_6_MongoInfra) GetConfigMongos() *config.MongosConfigSet3_6 {
	if x != nil {
		return x.ConfigMongos
	}
	return nil
}

func (x *Mongodb3_6_MongoInfra) GetConfigMongocfg() *config.MongoCfgConfigSet3_6 {
	if x != nil {
		return x.ConfigMongocfg
	}
	return nil
}

func (x *Mongodb3_6_MongoInfra) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

type Mongodb4_0_Mongod struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for mongod 4.0 hosts.
	Config *config.MongodConfigSet4_0 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongod hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
}

func (x *Mongodb4_0_Mongod) Reset() {
	*x = Mongodb4_0_Mongod{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb4_0_Mongod) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_0_Mongod) ProtoMessage() {}

func (x *Mongodb4_0_Mongod) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_0_Mongod.ProtoReflect.Descriptor instead.
func (*Mongodb4_0_Mongod) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{4, 0}
}

func (x *Mongodb4_0_Mongod) GetConfig() *config.MongodConfigSet4_0 {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb4_0_Mongod) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

type Mongodb4_0_MongoCfg struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for mongocfg 4.0 hosts.
	Config *config.MongoCfgConfigSet4_0 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongocfg hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
}

func (x *Mongodb4_0_MongoCfg) Reset() {
	*x = Mongodb4_0_MongoCfg{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb4_0_MongoCfg) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_0_MongoCfg) ProtoMessage() {}

func (x *Mongodb4_0_MongoCfg) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_0_MongoCfg.ProtoReflect.Descriptor instead.
func (*Mongodb4_0_MongoCfg) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{4, 1}
}

func (x *Mongodb4_0_MongoCfg) GetConfig() *config.MongoCfgConfigSet4_0 {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb4_0_MongoCfg) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

type Mongodb4_0_Mongos struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for mongos 4.0 hosts.
	Config *config.MongosConfigSet4_0 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongos hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
}

func (x *Mongodb4_0_Mongos) Reset() {
	*x = Mongodb4_0_Mongos{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb4_0_Mongos) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_0_Mongos) ProtoMessage() {}

func (x *Mongodb4_0_Mongos) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_0_Mongos.ProtoReflect.Descriptor instead.
func (*Mongodb4_0_Mongos) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{4, 2}
}

func (x *Mongodb4_0_Mongos) GetConfig() *config.MongosConfigSet4_0 {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb4_0_Mongos) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

type Mongodb4_0_MongoInfra struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConfigMongos   *config.MongosConfigSet4_0   `protobuf:"bytes,1,opt,name=config_mongos,json=configMongos,proto3" json:"config_mongos,omitempty"`
	ConfigMongocfg *config.MongoCfgConfigSet4_0 `protobuf:"bytes,2,opt,name=config_mongocfg,json=configMongocfg,proto3" json:"config_mongocfg,omitempty"`
	// Resources allocated to mongoinfra (mongos+mongocfg) hosts.
	Resources *Resources `protobuf:"bytes,3,opt,name=resources,proto3" json:"resources,omitempty"`
}

func (x *Mongodb4_0_MongoInfra) Reset() {
	*x = Mongodb4_0_MongoInfra{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb4_0_MongoInfra) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_0_MongoInfra) ProtoMessage() {}

func (x *Mongodb4_0_MongoInfra) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_0_MongoInfra.ProtoReflect.Descriptor instead.
func (*Mongodb4_0_MongoInfra) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{4, 3}
}

func (x *Mongodb4_0_MongoInfra) GetConfigMongos() *config.MongosConfigSet4_0 {
	if x != nil {
		return x.ConfigMongos
	}
	return nil
}

func (x *Mongodb4_0_MongoInfra) GetConfigMongocfg() *config.MongoCfgConfigSet4_0 {
	if x != nil {
		return x.ConfigMongocfg
	}
	return nil
}

func (x *Mongodb4_0_MongoInfra) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

type Mongodb4_2_Mongod struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for mongod 4.2 hosts.
	Config *config.MongodConfigSet4_2 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongod hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
}

func (x *Mongodb4_2_Mongod) Reset() {
	*x = Mongodb4_2_Mongod{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb4_2_Mongod) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_2_Mongod) ProtoMessage() {}

func (x *Mongodb4_2_Mongod) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_2_Mongod.ProtoReflect.Descriptor instead.
func (*Mongodb4_2_Mongod) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{5, 0}
}

func (x *Mongodb4_2_Mongod) GetConfig() *config.MongodConfigSet4_2 {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb4_2_Mongod) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

type Mongodb4_2_MongoCfg struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for mongocfg 4.2 hosts.
	Config *config.MongoCfgConfigSet4_2 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongocfg hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
}

func (x *Mongodb4_2_MongoCfg) Reset() {
	*x = Mongodb4_2_MongoCfg{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb4_2_MongoCfg) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_2_MongoCfg) ProtoMessage() {}

func (x *Mongodb4_2_MongoCfg) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_2_MongoCfg.ProtoReflect.Descriptor instead.
func (*Mongodb4_2_MongoCfg) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{5, 1}
}

func (x *Mongodb4_2_MongoCfg) GetConfig() *config.MongoCfgConfigSet4_2 {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb4_2_MongoCfg) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

type Mongodb4_2_Mongos struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for mongos 4.2 hosts.
	Config *config.MongosConfigSet4_2 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongos hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
}

func (x *Mongodb4_2_Mongos) Reset() {
	*x = Mongodb4_2_Mongos{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb4_2_Mongos) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_2_Mongos) ProtoMessage() {}

func (x *Mongodb4_2_Mongos) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_2_Mongos.ProtoReflect.Descriptor instead.
func (*Mongodb4_2_Mongos) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{5, 2}
}

func (x *Mongodb4_2_Mongos) GetConfig() *config.MongosConfigSet4_2 {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb4_2_Mongos) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

type Mongodb4_2_MongoInfra struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConfigMongos   *config.MongosConfigSet4_2   `protobuf:"bytes,1,opt,name=config_mongos,json=configMongos,proto3" json:"config_mongos,omitempty"`
	ConfigMongocfg *config.MongoCfgConfigSet4_2 `protobuf:"bytes,2,opt,name=config_mongocfg,json=configMongocfg,proto3" json:"config_mongocfg,omitempty"`
	// Resources allocated to mongoinfra (mongos+mongocfg) hosts.
	Resources *Resources `protobuf:"bytes,3,opt,name=resources,proto3" json:"resources,omitempty"`
}

func (x *Mongodb4_2_MongoInfra) Reset() {
	*x = Mongodb4_2_MongoInfra{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb4_2_MongoInfra) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_2_MongoInfra) ProtoMessage() {}

func (x *Mongodb4_2_MongoInfra) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_2_MongoInfra.ProtoReflect.Descriptor instead.
func (*Mongodb4_2_MongoInfra) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{5, 3}
}

func (x *Mongodb4_2_MongoInfra) GetConfigMongos() *config.MongosConfigSet4_2 {
	if x != nil {
		return x.ConfigMongos
	}
	return nil
}

func (x *Mongodb4_2_MongoInfra) GetConfigMongocfg() *config.MongoCfgConfigSet4_2 {
	if x != nil {
		return x.ConfigMongocfg
	}
	return nil
}

func (x *Mongodb4_2_MongoInfra) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

type Mongodb4_4_Mongod struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for mongod 4.4 hosts.
	Config *config.MongodConfigSet4_4 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongod hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
}

func (x *Mongodb4_4_Mongod) Reset() {
	*x = Mongodb4_4_Mongod{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb4_4_Mongod) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_4_Mongod) ProtoMessage() {}

func (x *Mongodb4_4_Mongod) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_4_Mongod.ProtoReflect.Descriptor instead.
func (*Mongodb4_4_Mongod) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{6, 0}
}

func (x *Mongodb4_4_Mongod) GetConfig() *config.MongodConfigSet4_4 {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb4_4_Mongod) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

type Mongodb4_4_MongoCfg struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for mongocfg 4.4 hosts.
	Config *config.MongoCfgConfigSet4_4 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongocfg hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
}

func (x *Mongodb4_4_MongoCfg) Reset() {
	*x = Mongodb4_4_MongoCfg{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb4_4_MongoCfg) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_4_MongoCfg) ProtoMessage() {}

func (x *Mongodb4_4_MongoCfg) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_4_MongoCfg.ProtoReflect.Descriptor instead.
func (*Mongodb4_4_MongoCfg) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{6, 1}
}

func (x *Mongodb4_4_MongoCfg) GetConfig() *config.MongoCfgConfigSet4_4 {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb4_4_MongoCfg) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

type Mongodb4_4_Mongos struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for mongos 4.4 hosts.
	Config *config.MongosConfigSet4_4 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongos hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
}

func (x *Mongodb4_4_Mongos) Reset() {
	*x = Mongodb4_4_Mongos{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb4_4_Mongos) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_4_Mongos) ProtoMessage() {}

func (x *Mongodb4_4_Mongos) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_4_Mongos.ProtoReflect.Descriptor instead.
func (*Mongodb4_4_Mongos) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{6, 2}
}

func (x *Mongodb4_4_Mongos) GetConfig() *config.MongosConfigSet4_4 {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb4_4_Mongos) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

type Mongodb4_4_MongoInfra struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConfigMongos   *config.MongosConfigSet4_4   `protobuf:"bytes,1,opt,name=config_mongos,json=configMongos,proto3" json:"config_mongos,omitempty"`
	ConfigMongocfg *config.MongoCfgConfigSet4_4 `protobuf:"bytes,2,opt,name=config_mongocfg,json=configMongocfg,proto3" json:"config_mongocfg,omitempty"`
	// Resources allocated to mongoinfra (mongos+mongocfg) hosts.
	Resources *Resources `protobuf:"bytes,3,opt,name=resources,proto3" json:"resources,omitempty"`
}

func (x *Mongodb4_4_MongoInfra) Reset() {
	*x = Mongodb4_4_MongoInfra{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb4_4_MongoInfra) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_4_MongoInfra) ProtoMessage() {}

func (x *Mongodb4_4_MongoInfra) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_4_MongoInfra.ProtoReflect.Descriptor instead.
func (*Mongodb4_4_MongoInfra) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{6, 3}
}

func (x *Mongodb4_4_MongoInfra) GetConfigMongos() *config.MongosConfigSet4_4 {
	if x != nil {
		return x.ConfigMongos
	}
	return nil
}

func (x *Mongodb4_4_MongoInfra) GetConfigMongocfg() *config.MongoCfgConfigSet4_4 {
	if x != nil {
		return x.ConfigMongocfg
	}
	return nil
}

func (x *Mongodb4_4_MongoInfra) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

var File_yandex_cloud_mdb_mongodb_v1_cluster_proto protoreflect.FileDescriptor

var file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDesc = []byte{
	0x0a, 0x29, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d,
	0x64, 0x62, 0x2f, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1b, 0x79, 0x61, 0x6e,
	0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f,
	0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70,
	0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x66, 0x64, 0x61, 0x79,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x33, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x64, 0x62, 0x2f, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62,
	0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x6d, 0x6f, 0x6e, 0x67, 0x6f,
	0x64, 0x62, 0x33, 0x5f, 0x36, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x33, 0x79, 0x61, 0x6e,
	0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x64, 0x62, 0x2f, 0x6d, 0x6f,
	0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f,
	0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x34, 0x5f, 0x30, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x33, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d,
	0x64, 0x62, 0x2f, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2f, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x34, 0x5f, 0x32, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x33, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x64, 0x62, 0x2f, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2f,
	0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64,
	0x62, 0x34, 0x5f, 0x34, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x64, 0x62, 0x2f, 0x6d, 0x6f, 0x6e,
	0x67, 0x6f, 0x64, 0x62, 0x2f, 0x76, 0x31, 0x2f, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61,
	0x6e, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x96, 0x09, 0x0a, 0x07, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72,
	0x49, 0x64, 0x12, 0x39, 0x0a, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x09, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x48, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x06, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x52, 0x0a,
	0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x30, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e,
	0x74, 0x12, 0x47, 0x0a, 0x0a, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x18,
	0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62,
	0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x0a,
	0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x12, 0x42, 0x0a, 0x06, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x79, 0x61, 0x6e,
	0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f,
	0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1d,
	0x0a, 0x0a, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x69, 0x64, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x64, 0x12, 0x43, 0x0a,
	0x06, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62,
	0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x2e, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x52, 0x06, 0x68, 0x65, 0x61, 0x6c,
	0x74, 0x68, 0x12, 0x43, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x0c, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52,
	0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x68, 0x61, 0x72, 0x64,
	0x65, 0x64, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x73, 0x68, 0x61, 0x72, 0x64, 0x65,
	0x64, 0x12, 0x5d, 0x0a, 0x12, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65,
	0x5f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62,
	0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x69, 0x6e,
	0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x52, 0x11, 0x6d,
	0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77,
	0x12, 0x5e, 0x0a, 0x11, 0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x5f, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d,
	0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65,
	0x6e, 0x61, 0x6e, 0x63, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10,
	0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x49, 0x0a, 0x0b, 0x45,
	0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x17, 0x45, 0x4e,
	0x56, 0x49, 0x52, 0x4f, 0x4e, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x50, 0x52, 0x4f, 0x44, 0x55,
	0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x50, 0x52, 0x45, 0x53, 0x54,
	0x41, 0x42, 0x4c, 0x45, 0x10, 0x02, 0x22, 0x3f, 0x0a, 0x06, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68,
	0x12, 0x12, 0x0a, 0x0e, 0x48, 0x45, 0x41, 0x4c, 0x54, 0x48, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f,
	0x57, 0x4e, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x41, 0x4c, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12,
	0x08, 0x0a, 0x04, 0x44, 0x45, 0x41, 0x44, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x47,
	0x52, 0x41, 0x44, 0x45, 0x44, 0x10, 0x03, 0x22, 0x79, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x12, 0x12, 0x0a, 0x0e, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x55, 0x4e, 0x4b, 0x4e,
	0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e,
	0x47, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02,
	0x12, 0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x55,
	0x50, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54, 0x4f,
	0x50, 0x50, 0x49, 0x4e, 0x47, 0x10, 0x05, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x54, 0x4f, 0x50, 0x50,
	0x45, 0x44, 0x10, 0x06, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54, 0x41, 0x52, 0x54, 0x49, 0x4e, 0x47,
	0x10, 0x07, 0x22, 0x56, 0x0a, 0x0a, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6c, 0x69, 0x6e, 0x6b, 0x22, 0x81, 0x05, 0x0a, 0x0d, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x18, 0x0a, 0x07,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x42, 0x0a, 0x1d, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x1b, 0x66,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x49, 0x0a, 0x0b, 0x6d, 0x6f,
	0x6e, 0x67, 0x6f, 0x64, 0x62, 0x5f, 0x33, 0x5f, 0x36, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x27, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f,
	0x6e, 0x67, 0x6f, 0x64, 0x62, 0x33, 0x5f, 0x36, 0x48, 0x00, 0x52, 0x09, 0x6d, 0x6f, 0x6e, 0x67,
	0x6f, 0x64, 0x62, 0x33, 0x36, 0x12, 0x49, 0x0a, 0x0b, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62,
	0x5f, 0x34, 0x5f, 0x30, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x79, 0x61, 0x6e,
	0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f,
	0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62,
	0x34, 0x5f, 0x30, 0x48, 0x00, 0x52, 0x09, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x34, 0x30,
	0x12, 0x49, 0x0a, 0x0b, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x5f, 0x34, 0x5f, 0x32, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62,
	0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x34, 0x5f, 0x32, 0x48, 0x00,
	0x52, 0x09, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x34, 0x32, 0x12, 0x49, 0x0a, 0x0b, 0x6d,
	0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x5f, 0x34, 0x5f, 0x34, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d,
	0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x34, 0x5f, 0x34, 0x48, 0x00, 0x52, 0x09, 0x6d, 0x6f, 0x6e,
	0x67, 0x6f, 0x64, 0x62, 0x34, 0x34, 0x12, 0x46, 0x0a, 0x13, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x5f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70,
	0x65, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x44, 0x61, 0x79, 0x52, 0x11, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x53, 0x74, 0x61, 0x72, 0x74, 0x12, 0x56,
	0x0a, 0x19, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6e, 0x5f,
	0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x5f, 0x64, 0x61, 0x79, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x16,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x74, 0x61, 0x69, 0x6e, 0x50, 0x65, 0x72, 0x69,
	0x6f, 0x64, 0x44, 0x61, 0x79, 0x73, 0x12, 0x3b, 0x0a, 0x06, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x06, 0x61, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x42, 0x09, 0x0a, 0x07, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x22, 0xba,
	0x08, 0x0a, 0x0a, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x33, 0x5f, 0x36, 0x12, 0x46, 0x0a,
	0x06, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62,
	0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x67,
	0x6f, 0x64, 0x62, 0x33, 0x5f, 0x36, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x52, 0x06, 0x6d,
	0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x12, 0x4c, 0x0a, 0x08, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x63, 0x66,
	0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f,
	0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x33, 0x5f, 0x36,
	0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x43, 0x66, 0x67, 0x52, 0x08, 0x6d, 0x6f, 0x6e, 0x67, 0x6f,
	0x63, 0x66, 0x67, 0x12, 0x46, 0x0a, 0x06, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76,
	0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x33, 0x5f, 0x36, 0x2e, 0x4d, 0x6f, 0x6e,
	0x67, 0x6f, 0x73, 0x52, 0x06, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x12, 0x52, 0x0a, 0x0a, 0x6d,
	0x6f, 0x6e, 0x67, 0x6f, 0x69, 0x6e, 0x66, 0x72, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x32, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f,
	0x6e, 0x67, 0x6f, 0x64, 0x62, 0x33, 0x5f, 0x36, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x49, 0x6e,
	0x66, 0x72, 0x61, 0x52, 0x0a, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x69, 0x6e, 0x66, 0x72, 0x61, 0x1a,
	0x9e, 0x01, 0x0a, 0x06, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x12, 0x4e, 0x0a, 0x06, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x79, 0x61, 0x6e,
	0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f,
	0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x33,
	0x5f, 0x36, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x44, 0x0a, 0x09, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62,
	0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x1a, 0xa2, 0x01, 0x0a, 0x08, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x43, 0x66, 0x67, 0x12, 0x50, 0x0a,
	0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62,
	0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x43, 0x66, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x53, 0x65, 0x74, 0x33, 0x5f, 0x36, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x44, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31,
	0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x1a, 0x9e, 0x01, 0x0a, 0x06, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73,
	0x12, 0x4e, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x36, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x53, 0x65, 0x74, 0x33, 0x5f, 0x36, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x44, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x1a, 0x92, 0x02, 0x0a, 0x0a, 0x4d, 0x6f, 0x6e, 0x67, 0x6f,
	0x49, 0x6e, 0x66, 0x72, 0x61, 0x12, 0x5b, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f,
	0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x79,
	0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e,
	0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65,
	0x74, 0x33, 0x5f, 0x36, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x6f, 0x6e, 0x67,
	0x6f, 0x73, 0x12, 0x61, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x6d, 0x6f, 0x6e,
	0x67, 0x6f, 0x63, 0x66, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d,
	0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x43, 0x66, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53,
	0x65, 0x74, 0x33, 0x5f, 0x36, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x6f, 0x6e,
	0x67, 0x6f, 0x63, 0x66, 0x67, 0x12, 0x44, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65,
	0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67,
	0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x22, 0xba, 0x08, 0x0a, 0x0a,
	0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x34, 0x5f, 0x30, 0x12, 0x46, 0x0a, 0x06, 0x6d, 0x6f,
	0x6e, 0x67, 0x6f, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x79, 0x61, 0x6e,
	0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f,
	0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62,
	0x34, 0x5f, 0x30, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x52, 0x06, 0x6d, 0x6f, 0x6e, 0x67,
	0x6f, 0x64, 0x12, 0x4c, 0x0a, 0x08, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x63, 0x66, 0x67, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x34, 0x5f, 0x30, 0x2e, 0x4d, 0x6f,
	0x6e, 0x67, 0x6f, 0x43, 0x66, 0x67, 0x52, 0x08, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x63, 0x66, 0x67,
	0x12, 0x46, 0x0a, 0x06, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2e, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d,
	0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x34, 0x5f, 0x30, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73,
	0x52, 0x06, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x12, 0x52, 0x0a, 0x0a, 0x6d, 0x6f, 0x6e, 0x67,
	0x6f, 0x69, 0x6e, 0x66, 0x72, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x79,
	0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e,
	0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f,
	0x64, 0x62, 0x34, 0x5f, 0x30, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x49, 0x6e, 0x66, 0x72, 0x61,
	0x52, 0x0a, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x69, 0x6e, 0x66, 0x72, 0x61, 0x1a, 0x9e, 0x01, 0x0a,
	0x06, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x12, 0x4e, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f,
	0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x6e,
	0x67, 0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x34, 0x5f, 0x30, 0x52,
	0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x44, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e,
	0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f,
	0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x1a, 0xa2, 0x01,
	0x0a, 0x08, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x43, 0x66, 0x67, 0x12, 0x50, 0x0a, 0x06, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x79, 0x61, 0x6e,
	0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f,
	0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x43, 0x66, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65,
	0x74, 0x34, 0x5f, 0x30, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x44, 0x0a, 0x09,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x1a, 0x9e, 0x01, 0x0a, 0x06, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x12, 0x4e, 0x0a,
	0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62,
	0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53,
	0x65, 0x74, 0x34, 0x5f, 0x30, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x44, 0x0a,
	0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x1a, 0x92, 0x02, 0x0a, 0x0a, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x49, 0x6e, 0x66,
	0x72, 0x61, 0x12, 0x5b, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x6d, 0x6f, 0x6e,
	0x67, 0x6f, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e,
	0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d,
	0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x34, 0x5f,
	0x30, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x12,
	0x61, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x63,
	0x66, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65,
	0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67,
	0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f,
	0x6e, 0x67, 0x6f, 0x43, 0x66, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x34,
	0x5f, 0x30, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x63,
	0x66, 0x67, 0x12, 0x44, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x22, 0xba, 0x08, 0x0a, 0x0a, 0x4d, 0x6f, 0x6e,
	0x67, 0x6f, 0x64, 0x62, 0x34, 0x5f, 0x32, 0x12, 0x46, 0x0a, 0x06, 0x6d, 0x6f, 0x6e, 0x67, 0x6f,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f,
	0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x34, 0x5f, 0x32,
	0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x52, 0x06, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x12,
	0x4c, 0x0a, 0x08, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x63, 0x66, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x30, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e,
	0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x34, 0x5f, 0x32, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f,
	0x43, 0x66, 0x67, 0x52, 0x08, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x63, 0x66, 0x67, 0x12, 0x46, 0x0a,
	0x06, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62,
	0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x67,
	0x6f, 0x64, 0x62, 0x34, 0x5f, 0x32, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x52, 0x06, 0x6d,
	0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x12, 0x52, 0x0a, 0x0a, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x69, 0x6e,
	0x66, 0x72, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e,
	0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x34,
	0x5f, 0x32, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x52, 0x0a, 0x6d,
	0x6f, 0x6e, 0x67, 0x6f, 0x69, 0x6e, 0x66, 0x72, 0x61, 0x1a, 0x9e, 0x01, 0x0a, 0x06, 0x4d, 0x6f,
	0x6e, 0x67, 0x6f, 0x64, 0x12, 0x4e, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x34, 0x5f, 0x32, 0x52, 0x06, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x44, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f,
	0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52,
	0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x1a, 0xa2, 0x01, 0x0a, 0x08, 0x4d,
	0x6f, 0x6e, 0x67, 0x6f, 0x43, 0x66, 0x67, 0x12, 0x50, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f,
	0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x6e,
	0x67, 0x6f, 0x43, 0x66, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x34, 0x5f,
	0x32, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x44, 0x0a, 0x09, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x79,
	0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e,
	0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x1a,
	0x9e, 0x01, 0x0a, 0x06, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x12, 0x4e, 0x0a, 0x06, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x79, 0x61, 0x6e,
	0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f,
	0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x34,
	0x5f, 0x32, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x44, 0x0a, 0x09, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62,
	0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x1a, 0x92, 0x02, 0x0a, 0x0a, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x12,
	0x5b, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x6e, 0x67,
	0x6f, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x34, 0x5f, 0x32, 0x52, 0x0c,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x12, 0x61, 0x0a, 0x0f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x63, 0x66, 0x67, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62,
	0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f,
	0x43, 0x66, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x34, 0x5f, 0x32, 0x52,
	0x0e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x63, 0x66, 0x67, 0x12,
	0x44, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31,
	0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x22, 0xba, 0x08, 0x0a, 0x0a, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64,
	0x62, 0x34, 0x5f, 0x34, 0x12, 0x46, 0x0a, 0x06, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x34, 0x5f, 0x34, 0x2e, 0x4d, 0x6f,
	0x6e, 0x67, 0x6f, 0x64, 0x52, 0x06, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x12, 0x4c, 0x0a, 0x08,
	0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x63, 0x66, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30,
	0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64,
	0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e,
	0x67, 0x6f, 0x64, 0x62, 0x34, 0x5f, 0x34, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x43, 0x66, 0x67,
	0x52, 0x08, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x63, 0x66, 0x67, 0x12, 0x46, 0x0a, 0x06, 0x6d, 0x6f,
	0x6e, 0x67, 0x6f, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x79, 0x61, 0x6e,
	0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f,
	0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62,
	0x34, 0x5f, 0x34, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x52, 0x06, 0x6d, 0x6f, 0x6e, 0x67,
	0x6f, 0x73, 0x12, 0x52, 0x0a, 0x0a, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x69, 0x6e, 0x66, 0x72, 0x61,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x34, 0x5f, 0x34, 0x2e,
	0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x52, 0x0a, 0x6d, 0x6f, 0x6e, 0x67,
	0x6f, 0x69, 0x6e, 0x66, 0x72, 0x61, 0x1a, 0x9e, 0x01, 0x0a, 0x06, 0x4d, 0x6f, 0x6e, 0x67, 0x6f,
	0x64, 0x12, 0x4e, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x36, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x34, 0x5f, 0x34, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x44, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x1a, 0xa2, 0x01, 0x0a, 0x08, 0x4d, 0x6f, 0x6e, 0x67,
	0x6f, 0x43, 0x66, 0x67, 0x12, 0x50, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x43,
	0x66, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x34, 0x5f, 0x34, 0x52, 0x06,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x44, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e,
	0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x1a, 0x9e, 0x01, 0x0a,
	0x06, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x12, 0x4e, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f,
	0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x6e,
	0x67, 0x6f, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x34, 0x5f, 0x34, 0x52,
	0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x44, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e,
	0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f,
	0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x1a, 0x92, 0x02,
	0x0a, 0x0a, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x12, 0x5b, 0x0a, 0x0d,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76,
	0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x34, 0x5f, 0x34, 0x52, 0x0c, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x12, 0x61, 0x0a, 0x0f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x5f, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x63, 0x66, 0x67, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x38, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x43, 0x66, 0x67,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x34, 0x5f, 0x34, 0x52, 0x0e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x63, 0x66, 0x67, 0x12, 0x44, 0x0a, 0x09,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x22, 0x3a, 0x0a, 0x05, 0x53, 0x68, 0x61, 0x72, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x22, 0xc5,
	0x05, 0x0a, 0x04, 0x48, 0x6f, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x17, 0x0a, 0x07, 0x7a, 0x6f,
	0x6e, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x7a, 0x6f, 0x6e,
	0x65, 0x49, 0x64, 0x12, 0x44, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x3a, 0x0a, 0x04, 0x72, 0x6f, 0x6c,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f,
	0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x6f, 0x73, 0x74, 0x2e, 0x52, 0x6f, 0x6c, 0x65, 0x52,
	0x04, 0x72, 0x6f, 0x6c, 0x65, 0x12, 0x40, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x28, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62,
	0x2e, 0x76, 0x31, 0x2e, 0x48, 0x6f, 0x73, 0x74, 0x2e, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x52,
	0x06, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x12, 0x40, 0x0a, 0x08, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e,
	0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52,
	0x08, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x75, 0x62,
	0x6e, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x73, 0x75,
	0x62, 0x6e, 0x65, 0x74, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x10, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e,
	0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x69, 0x70, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0e, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x49, 0x70,
	0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x68, 0x61, 0x72, 0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x68, 0x61, 0x72, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x3a, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x26, 0x2e,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62,
	0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x6f, 0x73, 0x74,
	0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x52, 0x0a, 0x04, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x4d, 0x4f, 0x4e,
	0x47, 0x4f, 0x44, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x4d, 0x4f, 0x4e, 0x47, 0x4f, 0x53, 0x10,
	0x02, 0x12, 0x0c, 0x0a, 0x08, 0x4d, 0x4f, 0x4e, 0x47, 0x4f, 0x43, 0x46, 0x47, 0x10, 0x03, 0x12,
	0x0e, 0x0a, 0x0a, 0x4d, 0x4f, 0x4e, 0x47, 0x4f, 0x49, 0x4e, 0x46, 0x52, 0x41, 0x10, 0x04, 0x22,
	0x34, 0x0a, 0x04, 0x52, 0x6f, 0x6c, 0x65, 0x12, 0x10, 0x0a, 0x0c, 0x52, 0x4f, 0x4c, 0x45, 0x5f,
	0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x52, 0x49,
	0x4d, 0x41, 0x52, 0x59, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x45, 0x43, 0x4f, 0x4e, 0x44,
	0x41, 0x52, 0x59, 0x10, 0x02, 0x22, 0x3f, 0x0a, 0x06, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x12,
	0x12, 0x0a, 0x0e, 0x48, 0x45, 0x41, 0x4c, 0x54, 0x48, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57,
	0x4e, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x41, 0x4c, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x08,
	0x0a, 0x04, 0x44, 0x45, 0x41, 0x44, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x47, 0x52,
	0x41, 0x44, 0x45, 0x44, 0x10, 0x03, 0x22, 0x84, 0x02, 0x0a, 0x07, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x12, 0x3d, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x29, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x12, 0x43, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x2b, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x52, 0x06,
	0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x22, 0x42, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14,
	0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x4d, 0x4f, 0x4e, 0x47, 0x4f, 0x44, 0x10, 0x01,
	0x12, 0x0a, 0x0a, 0x06, 0x4d, 0x4f, 0x4e, 0x47, 0x4f, 0x53, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08,
	0x4d, 0x4f, 0x4e, 0x47, 0x4f, 0x43, 0x46, 0x47, 0x10, 0x03, 0x22, 0x31, 0x0a, 0x06, 0x48, 0x65,
	0x61, 0x6c, 0x74, 0x68, 0x12, 0x12, 0x0a, 0x0e, 0x48, 0x45, 0x41, 0x4c, 0x54, 0x48, 0x5f, 0x55,
	0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x41, 0x4c, 0x49, 0x56,
	0x45, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x44, 0x45, 0x41, 0x44, 0x10, 0x02, 0x22, 0x78, 0x0a,
	0x09, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x70, 0x72, 0x65, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x50, 0x72, 0x65, 0x73, 0x65, 0x74, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x64, 0x69, 0x73, 0x6b,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08, 0x64, 0x69, 0x73,
	0x6b, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x20, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x64, 0x69, 0x73,
	0x6b, 0x54, 0x79, 0x70, 0x65, 0x49, 0x64, 0x22, 0x25, 0x0a, 0x06, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x12, 0x1b, 0x0a, 0x09, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x6c, 0x65, 0x6e, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x4c, 0x65, 0x6e, 0x73, 0x42, 0x6a,
	0x0a, 0x1f, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x70, 0x69, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76,
	0x31, 0x5a, 0x47, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2d, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67, 0x6f, 0x2d, 0x67, 0x65,
	0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x64, 0x62, 0x2f, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2f,
	0x76, 0x31, 0x3b, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescOnce sync.Once
	file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescData = file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDesc
)

func file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP() []byte {
	file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescData = protoimpl.X.CompressGZIP(file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescData)
	})
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescData
}

var file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes = make([]protoimpl.EnumInfo, 8)
var file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes = make([]protoimpl.MessageInfo, 29)
var file_yandex_cloud_mdb_mongodb_v1_cluster_proto_goTypes = []interface{}{
	(Cluster_Environment)(0),            // 0: yandex.cloud.mdb.mongodb.v1.Cluster.Environment
	(Cluster_Health)(0),                 // 1: yandex.cloud.mdb.mongodb.v1.Cluster.Health
	(Cluster_Status)(0),                 // 2: yandex.cloud.mdb.mongodb.v1.Cluster.Status
	(Host_Type)(0),                      // 3: yandex.cloud.mdb.mongodb.v1.Host.Type
	(Host_Role)(0),                      // 4: yandex.cloud.mdb.mongodb.v1.Host.Role
	(Host_Health)(0),                    // 5: yandex.cloud.mdb.mongodb.v1.Host.Health
	(Service_Type)(0),                   // 6: yandex.cloud.mdb.mongodb.v1.Service.Type
	(Service_Health)(0),                 // 7: yandex.cloud.mdb.mongodb.v1.Service.Health
	(*Cluster)(nil),                     // 8: yandex.cloud.mdb.mongodb.v1.Cluster
	(*Monitoring)(nil),                  // 9: yandex.cloud.mdb.mongodb.v1.Monitoring
	(*ClusterConfig)(nil),               // 10: yandex.cloud.mdb.mongodb.v1.ClusterConfig
	(*Mongodb3_6)(nil),                  // 11: yandex.cloud.mdb.mongodb.v1.Mongodb3_6
	(*Mongodb4_0)(nil),                  // 12: yandex.cloud.mdb.mongodb.v1.Mongodb4_0
	(*Mongodb4_2)(nil),                  // 13: yandex.cloud.mdb.mongodb.v1.Mongodb4_2
	(*Mongodb4_4)(nil),                  // 14: yandex.cloud.mdb.mongodb.v1.Mongodb4_4
	(*Shard)(nil),                       // 15: yandex.cloud.mdb.mongodb.v1.Shard
	(*Host)(nil),                        // 16: yandex.cloud.mdb.mongodb.v1.Host
	(*Service)(nil),                     // 17: yandex.cloud.mdb.mongodb.v1.Service
	(*Resources)(nil),                   // 18: yandex.cloud.mdb.mongodb.v1.Resources
	(*Access)(nil),                      // 19: yandex.cloud.mdb.mongodb.v1.Access
	nil,                                 // 20: yandex.cloud.mdb.mongodb.v1.Cluster.LabelsEntry
	(*Mongodb3_6_Mongod)(nil),           // 21: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.Mongod
	(*Mongodb3_6_MongoCfg)(nil),         // 22: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.MongoCfg
	(*Mongodb3_6_Mongos)(nil),           // 23: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.Mongos
	(*Mongodb3_6_MongoInfra)(nil),       // 24: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.MongoInfra
	(*Mongodb4_0_Mongod)(nil),           // 25: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.Mongod
	(*Mongodb4_0_MongoCfg)(nil),         // 26: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.MongoCfg
	(*Mongodb4_0_Mongos)(nil),           // 27: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.Mongos
	(*Mongodb4_0_MongoInfra)(nil),       // 28: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.MongoInfra
	(*Mongodb4_2_Mongod)(nil),           // 29: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.Mongod
	(*Mongodb4_2_MongoCfg)(nil),         // 30: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.MongoCfg
	(*Mongodb4_2_Mongos)(nil),           // 31: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.Mongos
	(*Mongodb4_2_MongoInfra)(nil),       // 32: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.MongoInfra
	(*Mongodb4_4_Mongod)(nil),           // 33: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.Mongod
	(*Mongodb4_4_MongoCfg)(nil),         // 34: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.MongoCfg
	(*Mongodb4_4_Mongos)(nil),           // 35: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.Mongos
	(*Mongodb4_4_MongoInfra)(nil),       // 36: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.MongoInfra
	(*timestamp.Timestamp)(nil),         // 37: google.protobuf.Timestamp
	(*MaintenanceWindow)(nil),           // 38: yandex.cloud.mdb.mongodb.v1.MaintenanceWindow
	(*MaintenanceOperation)(nil),        // 39: yandex.cloud.mdb.mongodb.v1.MaintenanceOperation
	(*timeofday.TimeOfDay)(nil),         // 40: google.type.TimeOfDay
	(*wrappers.Int64Value)(nil),         // 41: google.protobuf.Int64Value
	(*config.MongodConfigSet3_6)(nil),   // 42: yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet3_6
	(*config.MongoCfgConfigSet3_6)(nil), // 43: yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet3_6
	(*config.MongosConfigSet3_6)(nil),   // 44: yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet3_6
	(*config.MongodConfigSet4_0)(nil),   // 45: yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet4_0
	(*config.MongoCfgConfigSet4_0)(nil), // 46: yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet4_0
	(*config.MongosConfigSet4_0)(nil),   // 47: yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet4_0
	(*config.MongodConfigSet4_2)(nil),   // 48: yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet4_2
	(*config.MongoCfgConfigSet4_2)(nil), // 49: yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet4_2
	(*config.MongosConfigSet4_2)(nil),   // 50: yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet4_2
	(*config.MongodConfigSet4_4)(nil),   // 51: yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet4_4
	(*config.MongoCfgConfigSet4_4)(nil), // 52: yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet4_4
	(*config.MongosConfigSet4_4)(nil),   // 53: yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet4_4
}
var file_yandex_cloud_mdb_mongodb_v1_cluster_proto_depIdxs = []int32{
	37, // 0: yandex.cloud.mdb.mongodb.v1.Cluster.created_at:type_name -> google.protobuf.Timestamp
	20, // 1: yandex.cloud.mdb.mongodb.v1.Cluster.labels:type_name -> yandex.cloud.mdb.mongodb.v1.Cluster.LabelsEntry
	0,  // 2: yandex.cloud.mdb.mongodb.v1.Cluster.environment:type_name -> yandex.cloud.mdb.mongodb.v1.Cluster.Environment
	9,  // 3: yandex.cloud.mdb.mongodb.v1.Cluster.monitoring:type_name -> yandex.cloud.mdb.mongodb.v1.Monitoring
	10, // 4: yandex.cloud.mdb.mongodb.v1.Cluster.config:type_name -> yandex.cloud.mdb.mongodb.v1.ClusterConfig
	1,  // 5: yandex.cloud.mdb.mongodb.v1.Cluster.health:type_name -> yandex.cloud.mdb.mongodb.v1.Cluster.Health
	2,  // 6: yandex.cloud.mdb.mongodb.v1.Cluster.status:type_name -> yandex.cloud.mdb.mongodb.v1.Cluster.Status
	38, // 7: yandex.cloud.mdb.mongodb.v1.Cluster.maintenance_window:type_name -> yandex.cloud.mdb.mongodb.v1.MaintenanceWindow
	39, // 8: yandex.cloud.mdb.mongodb.v1.Cluster.planned_operation:type_name -> yandex.cloud.mdb.mongodb.v1.MaintenanceOperation
	11, // 9: yandex.cloud.mdb.mongodb.v1.ClusterConfig.mongodb_3_6:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb3_6
	12, // 10: yandex.cloud.mdb.mongodb.v1.ClusterConfig.mongodb_4_0:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_0
	13, // 11: yandex.cloud.mdb.mongodb.v1.ClusterConfig.mongodb_4_2:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_2
	14, // 12: yandex.cloud.mdb.mongodb.v1.ClusterConfig.mongodb_4_4:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_4
	40, // 13: yandex.cloud.mdb.mongodb.v1.ClusterConfig.backup_window_start:type_name -> google.type.TimeOfDay
	41, // 14: yandex.cloud.mdb.mongodb.v1.ClusterConfig.backup_retain_period_days:type_name -> google.protobuf.Int64Value
	19, // 15: yandex.cloud.mdb.mongodb.v1.ClusterConfig.access:type_name -> yandex.cloud.mdb.mongodb.v1.Access
	21, // 16: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.mongod:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb3_6.Mongod
	22, // 17: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.mongocfg:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb3_6.MongoCfg
	23, // 18: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.mongos:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb3_6.Mongos
	24, // 19: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.mongoinfra:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb3_6.MongoInfra
	25, // 20: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.mongod:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_0.Mongod
	26, // 21: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.mongocfg:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_0.MongoCfg
	27, // 22: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.mongos:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_0.Mongos
	28, // 23: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.mongoinfra:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_0.MongoInfra
	29, // 24: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.mongod:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_2.Mongod
	30, // 25: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.mongocfg:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_2.MongoCfg
	31, // 26: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.mongos:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_2.Mongos
	32, // 27: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.mongoinfra:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_2.MongoInfra
	33, // 28: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.mongod:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_4.Mongod
	34, // 29: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.mongocfg:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_4.MongoCfg
	35, // 30: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.mongos:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_4.Mongos
	36, // 31: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.mongoinfra:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_4.MongoInfra
	18, // 32: yandex.cloud.mdb.mongodb.v1.Host.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	4,  // 33: yandex.cloud.mdb.mongodb.v1.Host.role:type_name -> yandex.cloud.mdb.mongodb.v1.Host.Role
	5,  // 34: yandex.cloud.mdb.mongodb.v1.Host.health:type_name -> yandex.cloud.mdb.mongodb.v1.Host.Health
	17, // 35: yandex.cloud.mdb.mongodb.v1.Host.services:type_name -> yandex.cloud.mdb.mongodb.v1.Service
	3,  // 36: yandex.cloud.mdb.mongodb.v1.Host.type:type_name -> yandex.cloud.mdb.mongodb.v1.Host.Type
	6,  // 37: yandex.cloud.mdb.mongodb.v1.Service.type:type_name -> yandex.cloud.mdb.mongodb.v1.Service.Type
	7,  // 38: yandex.cloud.mdb.mongodb.v1.Service.health:type_name -> yandex.cloud.mdb.mongodb.v1.Service.Health
	42, // 39: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.Mongod.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet3_6
	18, // 40: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.Mongod.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	43, // 41: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.MongoCfg.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet3_6
	18, // 42: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.MongoCfg.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	44, // 43: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.Mongos.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet3_6
	18, // 44: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.Mongos.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	44, // 45: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.MongoInfra.config_mongos:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet3_6
	43, // 46: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.MongoInfra.config_mongocfg:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet3_6
	18, // 47: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.MongoInfra.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	45, // 48: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.Mongod.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet4_0
	18, // 49: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.Mongod.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	46, // 50: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.MongoCfg.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet4_0
	18, // 51: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.MongoCfg.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	47, // 52: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.Mongos.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet4_0
	18, // 53: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.Mongos.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	47, // 54: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.MongoInfra.config_mongos:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet4_0
	46, // 55: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.MongoInfra.config_mongocfg:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet4_0
	18, // 56: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.MongoInfra.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	48, // 57: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.Mongod.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet4_2
	18, // 58: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.Mongod.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	49, // 59: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.MongoCfg.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet4_2
	18, // 60: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.MongoCfg.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	50, // 61: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.Mongos.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet4_2
	18, // 62: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.Mongos.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	50, // 63: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.MongoInfra.config_mongos:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet4_2
	49, // 64: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.MongoInfra.config_mongocfg:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet4_2
	18, // 65: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.MongoInfra.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	51, // 66: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.Mongod.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet4_4
	18, // 67: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.Mongod.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	52, // 68: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.MongoCfg.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet4_4
	18, // 69: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.MongoCfg.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	53, // 70: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.Mongos.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet4_4
	18, // 71: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.Mongos.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	53, // 72: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.MongoInfra.config_mongos:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet4_4
	52, // 73: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.MongoInfra.config_mongocfg:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet4_4
	18, // 74: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.MongoInfra.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	75, // [75:75] is the sub-list for method output_type
	75, // [75:75] is the sub-list for method input_type
	75, // [75:75] is the sub-list for extension type_name
	75, // [75:75] is the sub-list for extension extendee
	0,  // [0:75] is the sub-list for field type_name
}

func init() { file_yandex_cloud_mdb_mongodb_v1_cluster_proto_init() }
func file_yandex_cloud_mdb_mongodb_v1_cluster_proto_init() {
	if File_yandex_cloud_mdb_mongodb_v1_cluster_proto != nil {
		return
	}
	file_yandex_cloud_mdb_mongodb_v1_maintenance_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Cluster); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Monitoring); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClusterConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Mongodb3_6); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Mongodb4_0); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Mongodb4_2); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Mongodb4_4); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Shard); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Host); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Service); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Resources); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Access); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Mongodb3_6_Mongod); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Mongodb3_6_MongoCfg); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Mongodb3_6_Mongos); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Mongodb3_6_MongoInfra); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Mongodb4_0_Mongod); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Mongodb4_0_MongoCfg); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Mongodb4_0_Mongos); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Mongodb4_0_MongoInfra); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Mongodb4_2_Mongod); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Mongodb4_2_MongoCfg); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Mongodb4_2_Mongos); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Mongodb4_2_MongoInfra); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Mongodb4_4_Mongod); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Mongodb4_4_MongoCfg); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Mongodb4_4_Mongos); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Mongodb4_4_MongoInfra); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*ClusterConfig_Mongodb_3_6)(nil),
		(*ClusterConfig_Mongodb_4_0)(nil),
		(*ClusterConfig_Mongodb_4_2)(nil),
		(*ClusterConfig_Mongodb_4_4)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDesc,
			NumEnums:      8,
			NumMessages:   29,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_yandex_cloud_mdb_mongodb_v1_cluster_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_mdb_mongodb_v1_cluster_proto_depIdxs,
		EnumInfos:         file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes,
		MessageInfos:      file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes,
	}.Build()
	File_yandex_cloud_mdb_mongodb_v1_cluster_proto = out.File
	file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDesc = nil
	file_yandex_cloud_mdb_mongodb_v1_cluster_proto_goTypes = nil
	file_yandex_cloud_mdb_mongodb_v1_cluster_proto_depIdxs = nil
}
