// Code generated by sdkgen. DO NOT EDIT.

//nolint
package compute

import (
	"context"

	"google.golang.org/grpc"

	compute "github.com/yandex-cloud/go-genproto/yandex/cloud/compute/v1"
)

//revive:disable

// DiskTypeServiceClient is a compute.DiskTypeServiceClient with
// lazy GRPC connection initialization.
type DiskTypeServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Get implements compute.DiskTypeServiceClient
func (c *DiskTypeServiceClient) Get(ctx context.Context, in *compute.GetDiskTypeRequest, opts ...grpc.CallOption) (*compute.DiskType, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return compute.NewDiskTypeServiceClient(conn).Get(ctx, in, opts...)
}

// List implements compute.DiskTypeServiceClient
func (c *DiskTypeServiceClient) List(ctx context.Context, in *compute.ListDiskTypesRequest, opts ...grpc.CallOption) (*compute.ListDiskTypesResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return compute.NewDiskTypeServiceClient(conn).List(ctx, in, opts...)
}

type DiskTypeIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err     error
	started bool

	client  *DiskTypeServiceClient
	request *compute.ListDiskTypesRequest

	items []*compute.DiskType
}

func (c *DiskTypeServiceClient) DiskTypeIterator(ctx context.Context, opts ...grpc.CallOption) *DiskTypeIterator {
	return &DiskTypeIterator{
		ctx:    ctx,
		opts:   opts,
		client: c,
		request: &compute.ListDiskTypesRequest{
			PageSize: 1000,
		},
	}
}

func (it *DiskTypeIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.DiskTypes
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *DiskTypeIterator) Value() *compute.DiskType {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *DiskTypeIterator) Error() error {
	return it.err
}
