// Code generated by sdkgen. DO NOT EDIT.

//nolint
package loadbalancer

import (
	"context"

	"google.golang.org/grpc"

	loadbalancer "github.com/yandex-cloud/go-genproto/yandex/cloud/loadbalancer/v1"
	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
)

//revive:disable

// TargetGroupServiceClient is a loadbalancer.TargetGroupServiceClient with
// lazy GRPC connection initialization.
type TargetGroupServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// AddTargets implements loadbalancer.TargetGroupServiceClient
func (c *TargetGroupServiceClient) AddTargets(ctx context.Context, in *loadbalancer.AddTargetsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return loadbalancer.NewTargetGroupServiceClient(conn).AddTargets(ctx, in, opts...)
}

// Create implements loadbalancer.TargetGroupServiceClient
func (c *TargetGroupServiceClient) Create(ctx context.Context, in *loadbalancer.CreateTargetGroupRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return loadbalancer.NewTargetGroupServiceClient(conn).Create(ctx, in, opts...)
}

// Delete implements loadbalancer.TargetGroupServiceClient
func (c *TargetGroupServiceClient) Delete(ctx context.Context, in *loadbalancer.DeleteTargetGroupRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return loadbalancer.NewTargetGroupServiceClient(conn).Delete(ctx, in, opts...)
}

// Get implements loadbalancer.TargetGroupServiceClient
func (c *TargetGroupServiceClient) Get(ctx context.Context, in *loadbalancer.GetTargetGroupRequest, opts ...grpc.CallOption) (*loadbalancer.TargetGroup, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return loadbalancer.NewTargetGroupServiceClient(conn).Get(ctx, in, opts...)
}

// List implements loadbalancer.TargetGroupServiceClient
func (c *TargetGroupServiceClient) List(ctx context.Context, in *loadbalancer.ListTargetGroupsRequest, opts ...grpc.CallOption) (*loadbalancer.ListTargetGroupsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return loadbalancer.NewTargetGroupServiceClient(conn).List(ctx, in, opts...)
}

type TargetGroupIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err     error
	started bool

	client  *TargetGroupServiceClient
	request *loadbalancer.ListTargetGroupsRequest

	items []*loadbalancer.TargetGroup
}

func (c *TargetGroupServiceClient) TargetGroupIterator(ctx context.Context, folderId string, opts ...grpc.CallOption) *TargetGroupIterator {
	return &TargetGroupIterator{
		ctx:    ctx,
		opts:   opts,
		client: c,
		request: &loadbalancer.ListTargetGroupsRequest{
			FolderId: folderId,
			PageSize: 1000,
		},
	}
}

func (it *TargetGroupIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.TargetGroups
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *TargetGroupIterator) Value() *loadbalancer.TargetGroup {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *TargetGroupIterator) Error() error {
	return it.err
}

// ListOperations implements loadbalancer.TargetGroupServiceClient
func (c *TargetGroupServiceClient) ListOperations(ctx context.Context, in *loadbalancer.ListTargetGroupOperationsRequest, opts ...grpc.CallOption) (*loadbalancer.ListTargetGroupOperationsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return loadbalancer.NewTargetGroupServiceClient(conn).ListOperations(ctx, in, opts...)
}

type TargetGroupOperationsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err     error
	started bool

	client  *TargetGroupServiceClient
	request *loadbalancer.ListTargetGroupOperationsRequest

	items []*operation.Operation
}

func (c *TargetGroupServiceClient) TargetGroupOperationsIterator(ctx context.Context, targetGroupId string, opts ...grpc.CallOption) *TargetGroupOperationsIterator {
	return &TargetGroupOperationsIterator{
		ctx:    ctx,
		opts:   opts,
		client: c,
		request: &loadbalancer.ListTargetGroupOperationsRequest{
			TargetGroupId: targetGroupId,
			PageSize:      1000,
		},
	}
}

func (it *TargetGroupOperationsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	response, err := it.client.ListOperations(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Operations
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *TargetGroupOperationsIterator) Value() *operation.Operation {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *TargetGroupOperationsIterator) Error() error {
	return it.err
}

// RemoveTargets implements loadbalancer.TargetGroupServiceClient
func (c *TargetGroupServiceClient) RemoveTargets(ctx context.Context, in *loadbalancer.RemoveTargetsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return loadbalancer.NewTargetGroupServiceClient(conn).RemoveTargets(ctx, in, opts...)
}

// Update implements loadbalancer.TargetGroupServiceClient
func (c *TargetGroupServiceClient) Update(ctx context.Context, in *loadbalancer.UpdateTargetGroupRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return loadbalancer.NewTargetGroupServiceClient(conn).Update(ctx, in, opts...)
}
