// Code generated by sdkgen. DO NOT EDIT.

//nolint
package redis

import (
	"context"

	"google.golang.org/grpc"

	redis "github.com/yandex-cloud/go-genproto/yandex/cloud/mdb/redis/v1"
	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
)

//revive:disable

// ClusterServiceClient is a redis.ClusterServiceClient with
// lazy GRPC connection initialization.
type ClusterServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// AddHosts implements redis.ClusterServiceClient
func (c *ClusterServiceClient) AddHosts(ctx context.Context, in *redis.AddClusterHostsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return redis.NewClusterServiceClient(conn).AddHosts(ctx, in, opts...)
}

// AddShard implements redis.ClusterServiceClient
func (c *ClusterServiceClient) AddShard(ctx context.Context, in *redis.AddClusterShardRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return redis.NewClusterServiceClient(conn).AddShard(ctx, in, opts...)
}

// Backup implements redis.ClusterServiceClient
func (c *ClusterServiceClient) Backup(ctx context.Context, in *redis.BackupClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return redis.NewClusterServiceClient(conn).Backup(ctx, in, opts...)
}

// Create implements redis.ClusterServiceClient
func (c *ClusterServiceClient) Create(ctx context.Context, in *redis.CreateClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return redis.NewClusterServiceClient(conn).Create(ctx, in, opts...)
}

// Delete implements redis.ClusterServiceClient
func (c *ClusterServiceClient) Delete(ctx context.Context, in *redis.DeleteClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return redis.NewClusterServiceClient(conn).Delete(ctx, in, opts...)
}

// DeleteHosts implements redis.ClusterServiceClient
func (c *ClusterServiceClient) DeleteHosts(ctx context.Context, in *redis.DeleteClusterHostsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return redis.NewClusterServiceClient(conn).DeleteHosts(ctx, in, opts...)
}

// DeleteShard implements redis.ClusterServiceClient
func (c *ClusterServiceClient) DeleteShard(ctx context.Context, in *redis.DeleteClusterShardRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return redis.NewClusterServiceClient(conn).DeleteShard(ctx, in, opts...)
}

// Get implements redis.ClusterServiceClient
func (c *ClusterServiceClient) Get(ctx context.Context, in *redis.GetClusterRequest, opts ...grpc.CallOption) (*redis.Cluster, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return redis.NewClusterServiceClient(conn).Get(ctx, in, opts...)
}

// GetShard implements redis.ClusterServiceClient
func (c *ClusterServiceClient) GetShard(ctx context.Context, in *redis.GetClusterShardRequest, opts ...grpc.CallOption) (*redis.Shard, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return redis.NewClusterServiceClient(conn).GetShard(ctx, in, opts...)
}

// List implements redis.ClusterServiceClient
func (c *ClusterServiceClient) List(ctx context.Context, in *redis.ListClustersRequest, opts ...grpc.CallOption) (*redis.ListClustersResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return redis.NewClusterServiceClient(conn).List(ctx, in, opts...)
}

type ClusterIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err     error
	started bool

	client  *ClusterServiceClient
	request *redis.ListClustersRequest

	items []*redis.Cluster
}

func (c *ClusterServiceClient) ClusterIterator(ctx context.Context, folderId string, opts ...grpc.CallOption) *ClusterIterator {
	return &ClusterIterator{
		ctx:    ctx,
		opts:   opts,
		client: c,
		request: &redis.ListClustersRequest{
			FolderId: folderId,
			PageSize: 1000,
		},
	}
}

func (it *ClusterIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Clusters
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *ClusterIterator) Value() *redis.Cluster {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *ClusterIterator) Error() error {
	return it.err
}

// ListBackups implements redis.ClusterServiceClient
func (c *ClusterServiceClient) ListBackups(ctx context.Context, in *redis.ListClusterBackupsRequest, opts ...grpc.CallOption) (*redis.ListClusterBackupsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return redis.NewClusterServiceClient(conn).ListBackups(ctx, in, opts...)
}

type ClusterBackupsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err     error
	started bool

	client  *ClusterServiceClient
	request *redis.ListClusterBackupsRequest

	items []*redis.Backup
}

func (c *ClusterServiceClient) ClusterBackupsIterator(ctx context.Context, clusterId string, opts ...grpc.CallOption) *ClusterBackupsIterator {
	return &ClusterBackupsIterator{
		ctx:    ctx,
		opts:   opts,
		client: c,
		request: &redis.ListClusterBackupsRequest{
			ClusterId: clusterId,
			PageSize:  1000,
		},
	}
}

func (it *ClusterBackupsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	response, err := it.client.ListBackups(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Backups
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *ClusterBackupsIterator) Value() *redis.Backup {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *ClusterBackupsIterator) Error() error {
	return it.err
}

// ListHosts implements redis.ClusterServiceClient
func (c *ClusterServiceClient) ListHosts(ctx context.Context, in *redis.ListClusterHostsRequest, opts ...grpc.CallOption) (*redis.ListClusterHostsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return redis.NewClusterServiceClient(conn).ListHosts(ctx, in, opts...)
}

type ClusterHostsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err     error
	started bool

	client  *ClusterServiceClient
	request *redis.ListClusterHostsRequest

	items []*redis.Host
}

func (c *ClusterServiceClient) ClusterHostsIterator(ctx context.Context, clusterId string, opts ...grpc.CallOption) *ClusterHostsIterator {
	return &ClusterHostsIterator{
		ctx:    ctx,
		opts:   opts,
		client: c,
		request: &redis.ListClusterHostsRequest{
			ClusterId: clusterId,
			PageSize:  1000,
		},
	}
}

func (it *ClusterHostsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	response, err := it.client.ListHosts(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Hosts
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *ClusterHostsIterator) Value() *redis.Host {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *ClusterHostsIterator) Error() error {
	return it.err
}

// ListLogs implements redis.ClusterServiceClient
func (c *ClusterServiceClient) ListLogs(ctx context.Context, in *redis.ListClusterLogsRequest, opts ...grpc.CallOption) (*redis.ListClusterLogsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return redis.NewClusterServiceClient(conn).ListLogs(ctx, in, opts...)
}

type ClusterLogsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err     error
	started bool

	client  *ClusterServiceClient
	request *redis.ListClusterLogsRequest

	items []*redis.LogRecord
}

func (c *ClusterServiceClient) ClusterLogsIterator(ctx context.Context, clusterId string, opts ...grpc.CallOption) *ClusterLogsIterator {
	return &ClusterLogsIterator{
		ctx:    ctx,
		opts:   opts,
		client: c,
		request: &redis.ListClusterLogsRequest{
			ClusterId: clusterId,
			PageSize:  1000,
		},
	}
}

func (it *ClusterLogsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	response, err := it.client.ListLogs(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Logs
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *ClusterLogsIterator) Value() *redis.LogRecord {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *ClusterLogsIterator) Error() error {
	return it.err
}

// ListOperations implements redis.ClusterServiceClient
func (c *ClusterServiceClient) ListOperations(ctx context.Context, in *redis.ListClusterOperationsRequest, opts ...grpc.CallOption) (*redis.ListClusterOperationsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return redis.NewClusterServiceClient(conn).ListOperations(ctx, in, opts...)
}

type ClusterOperationsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err     error
	started bool

	client  *ClusterServiceClient
	request *redis.ListClusterOperationsRequest

	items []*operation.Operation
}

func (c *ClusterServiceClient) ClusterOperationsIterator(ctx context.Context, clusterId string, opts ...grpc.CallOption) *ClusterOperationsIterator {
	return &ClusterOperationsIterator{
		ctx:    ctx,
		opts:   opts,
		client: c,
		request: &redis.ListClusterOperationsRequest{
			ClusterId: clusterId,
			PageSize:  1000,
		},
	}
}

func (it *ClusterOperationsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	response, err := it.client.ListOperations(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Operations
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *ClusterOperationsIterator) Value() *operation.Operation {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *ClusterOperationsIterator) Error() error {
	return it.err
}

// ListShards implements redis.ClusterServiceClient
func (c *ClusterServiceClient) ListShards(ctx context.Context, in *redis.ListClusterShardsRequest, opts ...grpc.CallOption) (*redis.ListClusterShardsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return redis.NewClusterServiceClient(conn).ListShards(ctx, in, opts...)
}

type ClusterShardsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err     error
	started bool

	client  *ClusterServiceClient
	request *redis.ListClusterShardsRequest

	items []*redis.Shard
}

func (c *ClusterServiceClient) ClusterShardsIterator(ctx context.Context, clusterId string, opts ...grpc.CallOption) *ClusterShardsIterator {
	return &ClusterShardsIterator{
		ctx:    ctx,
		opts:   opts,
		client: c,
		request: &redis.ListClusterShardsRequest{
			ClusterId: clusterId,
			PageSize:  1000,
		},
	}
}

func (it *ClusterShardsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	response, err := it.client.ListShards(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Shards
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *ClusterShardsIterator) Value() *redis.Shard {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *ClusterShardsIterator) Error() error {
	return it.err
}

// Move implements redis.ClusterServiceClient
func (c *ClusterServiceClient) Move(ctx context.Context, in *redis.MoveClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return redis.NewClusterServiceClient(conn).Move(ctx, in, opts...)
}

// Rebalance implements redis.ClusterServiceClient
func (c *ClusterServiceClient) Rebalance(ctx context.Context, in *redis.RebalanceClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return redis.NewClusterServiceClient(conn).Rebalance(ctx, in, opts...)
}

// RescheduleMaintenance implements redis.ClusterServiceClient
func (c *ClusterServiceClient) RescheduleMaintenance(ctx context.Context, in *redis.RescheduleMaintenanceRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return redis.NewClusterServiceClient(conn).RescheduleMaintenance(ctx, in, opts...)
}

// Restore implements redis.ClusterServiceClient
func (c *ClusterServiceClient) Restore(ctx context.Context, in *redis.RestoreClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return redis.NewClusterServiceClient(conn).Restore(ctx, in, opts...)
}

// Start implements redis.ClusterServiceClient
func (c *ClusterServiceClient) Start(ctx context.Context, in *redis.StartClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return redis.NewClusterServiceClient(conn).Start(ctx, in, opts...)
}

// StartFailover implements redis.ClusterServiceClient
func (c *ClusterServiceClient) StartFailover(ctx context.Context, in *redis.StartClusterFailoverRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return redis.NewClusterServiceClient(conn).StartFailover(ctx, in, opts...)
}

// Stop implements redis.ClusterServiceClient
func (c *ClusterServiceClient) Stop(ctx context.Context, in *redis.StopClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return redis.NewClusterServiceClient(conn).Stop(ctx, in, opts...)
}

// StreamLogs implements redis.ClusterServiceClient
func (c *ClusterServiceClient) StreamLogs(ctx context.Context, in *redis.StreamClusterLogsRequest, opts ...grpc.CallOption) (redis.ClusterService_StreamLogsClient, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return redis.NewClusterServiceClient(conn).StreamLogs(ctx, in, opts...)
}

// Update implements redis.ClusterServiceClient
func (c *ClusterServiceClient) Update(ctx context.Context, in *redis.UpdateClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return redis.NewClusterServiceClient(conn).Update(ctx, in, opts...)
}
