// Code generated by sdkgen. DO NOT EDIT.

//nolint
package vpc

import (
	"context"

	"google.golang.org/grpc"

	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	vpc "github.com/yandex-cloud/go-genproto/yandex/cloud/vpc/v1"
)

//revive:disable

// AddressServiceClient is a vpc.AddressServiceClient with
// lazy GRPC connection initialization.
type AddressServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Create implements vpc.AddressServiceClient
func (c *AddressServiceClient) Create(ctx context.Context, in *vpc.CreateAddressRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewAddressServiceClient(conn).Create(ctx, in, opts...)
}

// Delete implements vpc.AddressServiceClient
func (c *AddressServiceClient) Delete(ctx context.Context, in *vpc.DeleteAddressRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewAddressServiceClient(conn).Delete(ctx, in, opts...)
}

// Get implements vpc.AddressServiceClient
func (c *AddressServiceClient) Get(ctx context.Context, in *vpc.GetAddressRequest, opts ...grpc.CallOption) (*vpc.Address, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewAddressServiceClient(conn).Get(ctx, in, opts...)
}

// GetByValue implements vpc.AddressServiceClient
func (c *AddressServiceClient) GetByValue(ctx context.Context, in *vpc.GetAddressByValueRequest, opts ...grpc.CallOption) (*vpc.Address, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewAddressServiceClient(conn).GetByValue(ctx, in, opts...)
}

// List implements vpc.AddressServiceClient
func (c *AddressServiceClient) List(ctx context.Context, in *vpc.ListAddressesRequest, opts ...grpc.CallOption) (*vpc.ListAddressesResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewAddressServiceClient(conn).List(ctx, in, opts...)
}

type AddressIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err     error
	started bool

	client  *AddressServiceClient
	request *vpc.ListAddressesRequest

	items []*vpc.Address
}

func (c *AddressServiceClient) AddressIterator(ctx context.Context, folderId string, opts ...grpc.CallOption) *AddressIterator {
	return &AddressIterator{
		ctx:    ctx,
		opts:   opts,
		client: c,
		request: &vpc.ListAddressesRequest{
			FolderId: folderId,
			PageSize: 1000,
		},
	}
}

func (it *AddressIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Addresses
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *AddressIterator) Value() *vpc.Address {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *AddressIterator) Error() error {
	return it.err
}

// ListOperations implements vpc.AddressServiceClient
func (c *AddressServiceClient) ListOperations(ctx context.Context, in *vpc.ListAddressOperationsRequest, opts ...grpc.CallOption) (*vpc.ListAddressOperationsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewAddressServiceClient(conn).ListOperations(ctx, in, opts...)
}

type AddressOperationsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err     error
	started bool

	client  *AddressServiceClient
	request *vpc.ListAddressOperationsRequest

	items []*operation.Operation
}

func (c *AddressServiceClient) AddressOperationsIterator(ctx context.Context, addressId string, opts ...grpc.CallOption) *AddressOperationsIterator {
	return &AddressOperationsIterator{
		ctx:    ctx,
		opts:   opts,
		client: c,
		request: &vpc.ListAddressOperationsRequest{
			AddressId: addressId,
			PageSize:  1000,
		},
	}
}

func (it *AddressOperationsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	response, err := it.client.ListOperations(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Operations
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *AddressOperationsIterator) Value() *operation.Operation {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *AddressOperationsIterator) Error() error {
	return it.err
}

// Update implements vpc.AddressServiceClient
func (c *AddressServiceClient) Update(ctx context.Context, in *vpc.UpdateAddressRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewAddressServiceClient(conn).Update(ctx, in, opts...)
}
