---
outline: deep
---

# Resource Functions

Each resource comes with built-in functions, all written in [Apple PKL](https://pkl-lang.org). This design provides the
flexibility to extend and customize these functions to suit your specific needs.

Below is a list of functions available for each resource:

## Exec Resource Functions

| **Function**             | **Description**                                                                                                              |
|:-------------------------|:-----------------------------------------------------------------------------------------------------------------------------|
| exec.resource("id")      | Accesses the `exec` resource for the specified ID, providing direct access to `command`, `stderr`, `stdout`, and `exitCode`. |
| exec.stderr("id")        | Retrieves the standard error (`stderr`) output of the shell execution for the specified `exec` resource ID.                  |
| exec.env("id", "ENVVAR") | Fetches the value of a defined environment variable (`ENV_VAR`) from the specified `exec` resource in the PKL.               |
| exec.stdout("id")        | Retrieves the standard output (`stdout`) of the shell execution for the specified `exec` resource ID.                        |
| exec.exitCode("id")      | Fetches the exit code resulting from the shell execution of the specified `exec` resource ID.                                |
| exec.file("id")          | Retrieves the file path where the stdout output was automatically saved during runtime.                                      |

## HTTP Client Resource Functions

| **Function**                             | **Description**                                                                                                                    |
|:-----------------------------------------|:-----------------------------------------------------------------------------------------------------------------------------------|
| client.resource("id")                    | Retrieves the HTTP `client` resource for the specified ID, providing access to `method`, `url`, `data`, `headers`, and `response`. |
| client.responseBody("id")                | Retrieves the body of the HTTP `client` response for the specified ID.                                                             |
| client.responseHeader("id", "HEADER_ID") | Fetches the value of the specified header (`HEADER_ID`) from the HTTP `client` response for the given resource ID.                 |
| client.file("id")                        | Retrieves the file path where the response body output was automatically saved during runtime.                                     |

## LLM Resource Functions

| **Function**               | **Description**                                                                                                                             |
|:---------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------|
| llm.resource("id")         | Accesses the `llm` resource for the specified ID, providing details about the `prompt`, `response`, `JSONResponse`, and `JSONResponseKeys`. |
| llm.response("id")         | Retrieves the response generated by the LLM for the specified resource ID.                                                                  |
| llm.prompt("id")           | Retrieves the prompt sent to the LLM for the specified resource ID.                                                                         |
| llm.JSONResponse("id")     | Retrieves the configuration of the `JSONResponse` for the specified resource ID.                                                            |
| llm.JSONResponseKeys("id") | Fetches the configuration of `JSONResponseKeys` for the specified resource ID.                                                              |
| llm.file("id")             | Retrieves the file path where the llm response output was automatically saved during runtime.                                               |

## Python Resource Functions

| **Function**                | **Description**                                                                                                                                    |
|:----------------------------|:---------------------------------------------------------------------------------------------------------------------------------------------------|
| python.resource("id")       | Accesses the `python` resource for the specified ID, providing details about the `condaEnvironment`, `script`, `stderr`, `stdout`, and `exitCode`. |
| python.stderr("id")         | Retrieves the standard error (`stderr`) output of the shell pythonution for the specified `python` resource ID.                                    |
| python.env("id", "ENV_VAR") | Fetches the value of a defined environment variable (`ENV_VAR`) from the specified `python` resource in the PKL.                                   |
| python.stdout("id")         | Retrieves the standard output (`stdout`) of the shell pythonution for the specified `python` resource ID.                                          |
| python.exitCode("id")       | Fetches the exit code resulting from the shell pythonution of the specified `python` resource ID.                                                  |
| python.file("id")           | Retrieves the file path where the python stdout output was automatically saved during runtime.                                                     |
