{{ .Header }}

actionID = "httpResource"
name = "HTTP Client"
description = "This resource allows for making API requests using an HTTP client."
category = ""
requires {
        // Define the ID of any dependency resource that must be executed before this resource.
}
run {
        // restrictToHTTPMethods specifies the HTTP methods required for the request.
        // If none are specified, all HTTP methods are permitted. This restriction is only
        // in effect when APIServerMode is enabled. If the request method is not in this list,
        // the action will be skipped.
        restrictToHTTPMethods {
            "GET"
        }

        // restrictToRoutes specifies the URL paths required for the request.
        // If none are specified, all routes are permitted. This restriction is only
        // in effect when APIServerMode is enabled. If the request path is not in this list,
        // the action will be skipped.
        restrictToRoutes {
            "/api/v1/whois"
        }

        // allowedHeaders specifies the permitted HTTP headers for the request.
        // If none are specified, all headers are allowed. This restriction is only
        // in effect when APIServerMode is enabled.
        allowedHeaders {
            // "X-API-KEY"
        }

        // allowedParams specifies the permitted query parameters for the request.
        // If none are specified, all parameters are allowed. This restriction is only
        // in effect when APIServerMode is enabled.
        allowedParams {}

        skipCondition {
                // Conditions under which the execution of this resource should be skipped.
                // If any evaluated condition returns true, the resource execution will be bypassed.
                // "@(request.path)" != "/api/v1/whois" && "@(request.method)" != "GET"
        }

        preflightCheck {
                validations {
                        // This section expects boolean validations.
                        // If any validation returns false, an exception will be thrown before proceeding to the next step.
                        // "@(request.header("X-API-KEY"))" != ""
                }
                //
                // Custom error message and code to be returned immediately if the preflight check fails.
                //
                // error {
                //         code = 0
                //         message = ""
                // }
        }

        // The expr block is space for evaluating standard PKL expressions. It is primarily used to execute
        // expressions that produce side effects, such as updating resources or triggering actions, but also supports
        // general-purpose evaluation of any valid PKL expression, making it a place for inline logic and
        // scripting within a configuration.
        expr {
                // "@(memory.setRecord("foo", "bar"))" // Persistent data
                // "@(memory.clear())"
                // "@(session.setRecord("foo", "bar"))" // Temporary data only for this request
        }

        // Initiates an HTTP client request for this resource.
        //
        // The HTTP resource provides the following helper functions:
        //
        // - "@(client.resource("ResourceID"))"
        // - "@(client.responseBody("ResourceID"))"
        // - "@(client.responseHeader("ResourceID", "HEADER"))"
        //
        // For example, to use these in your resource, you can define a local variable like this:
        //
        // local bearerToken = "@(client.responseHeader("ResourceID", "Bearer"))"
        // You can then access the value using "@(bearerToken)".
        //
        // The "@(...)" syntax enables lazy evaluation, ensuring that values are
        // retrieved only after the result is ready.
        //
        // Note: Each resource is restricted to a single dedicated action. Combining multiple
        // actions within the same resource is not allowed.
        HTTPClient {
                method = "GET"  // Specifies the HTTP method to be used for the request.
                url = ""        // The URL endpoint for the HTTP request.
                data {
                        // Any data that will be sent with the HTTP request.
                }
                headers {
                        // Headers to be included in the HTTP request.
                        // ["X-API-KEY"] = "@(request.header("X-API-KEY"))"  // Example header.
                }
                // Timeout duration in seconds. This specifies when to terminate the request.
                timeoutDuration = 60.s
        }
}
