{{ .Header }}

actionID = "execResource"
name = "Exec Resource"
description = "This resource creates a shell session."
category = ""
requires {
        // Define the ID of any dependency resource that must be executed before this resource.
}
run {
        // restrictToHTTPMethods specifies the HTTP methods required for the request.
        // If none are specified, all HTTP methods are permitted. This restriction is only
        // in effect when APIServerMode is enabled. If the request method is not in this list,
        // the action will be skipped.
        restrictToHTTPMethods {
            "GET"
        }

        // restrictToRoutes specifies the URL paths required for the request.
        // If none are specified, all routes are permitted. This restriction is only
        // in effect when APIServerMode is enabled. If the request path is not in this list,
        // the action will be skipped.
        restrictToRoutes {
            "/api/v1/whois"
        }

        // allowedHeaders specifies the permitted HTTP headers for the request.
        // If none are specified, all headers are allowed. This restriction is only
        // in effect when APIServerMode is enabled.
        allowedHeaders {
            // "X-API-KEY"
        }

        // allowedParams specifies the permitted query parameters for the request.
        // If none are specified, all parameters are allowed. This restriction is only
        // in effect when APIServerMode is enabled.
        allowedParams {}

        skipCondition {
                // Conditions under which the execution of this resource should be skipped.
                // If any evaluated condition returns true, the resource execution will be bypassed.
        }

        preflightCheck {
                validations {
                        // This section expects boolean validations.
                        // If any validation returns false, an exception will be thrown before proceeding to the next step.
                        //
                        // For example, this expects that the 'file.txt' is in the 'data' folder.
                        // All data files are mapped from 'data/file.txt' to 'data/<agentName>/<agentVersion>/file.txt'.
                        // read("file:/agent/workflow/data/%s/1.0.0/file.txt").text != "" && read("file:/agent/workflow/data/%s/1.0.0/file.txt").base64 != ""
                }
                //
                // Custom error message and code to be returned immediately if the preflight check fails.
                //
                // error {
                //         code = 0
                //         message = ""
                // }
        }

        // The expr block is space for evaluating standard PKL expressions. It is primarily used to execute
        // expressions that produce side effects, such as updating resources or triggering actions, but also supports
        // general-purpose evaluation of any valid PKL expression, making it a place for inline logic and
        // scripting within a configuration.
        expr {
                // "@(memory.setRecord("foo", "bar"))" // Persistent data
                // "@(memory.clear())"
                // "@(session.setRecord("foo", "bar"))" // Temporary data only for this request
        }

        // Initiates a shell session for executing commands within this resource. Any packages
        // defined in the workflow are accessible here.
        //
        // The exec resource provides the following helper functions:
        //
        // - "@(exec.resource("ResourceID"))"
        // - "@(exec.stderr("ResourceID"))"
        // - "@(exec.stdout("ResourceID"))"
        // - "@(exec.exitCode("ResourceID"))"
        //
        // To use these in your resource, you can define a local variable like this:
        //
        // local successExec = "@(exec.exitCode("ResourceID"))"
        // You can then reference the value using "@(successExec)".
        //
        // If you need to access a file in your resource, you can use PKL's read("file") API like this:
        // "@(read("file"))".
        //
        // The "@(...)" syntax enables lazy evaluation, ensuring that values are
        // retrieved only after the result is ready.
        //
        // Note: Each resource is restricted to a single dedicated action. Combining multiple
        // actions within the same resource is not allowed.
        exec {
                command = """
                echo "hello world"
                """
                env {
                        // Environment variables that would be accessible inside the shell
                        ["ENVVAR"] = "XYZ"  // Example ENVVAR.
                }
                // Timeout duration in seconds. This specifies when to terminate the shell exec.
                timeoutDuration = 60.s
        }
}
