{{ .Header }}

actionID = "responseResource"
name = "API Response Resource"
description = "This resource creates a API response."
category = ""

// Define the ID of any dependency resource that must be executed before this resource.
// For example "aiChatResource1"
requires {
        "llmResource"
        // "pythonResource"
        // "execResource"
        // "httpResource"
}

run {
        // restrictToHTTPMethods specifies the HTTP methods required for the request.
        // If none are specified, all HTTP methods are permitted. This restriction is only
        // in effect when APIServerMode is enabled. If the request method is not in this list,
        // the action will be skipped.
        restrictToHTTPMethods {
            "GET"
        }

        // restrictToRoutes specifies the URL paths required for the request.
        // If none are specified, all routes are permitted. This restriction is only
        // in effect when APIServerMode is enabled. If the request path is not in this list,
        // the action will be skipped.
        restrictToRoutes {
            "/api/v1/whois"
        }

        // allowedHeaders specifies the permitted HTTP headers for the request.
        // If none are specified, all headers are allowed. This restriction is only
        // in effect when APIServerMode is enabled.
        allowedHeaders {
            // "X-API-KEY"
        }

        // allowedParams specifies the permitted query parameters for the request.
        // If none are specified, all parameters are allowed. This restriction is only
        // in effect when APIServerMode is enabled.
        allowedParams {}

        skipCondition {
                // Conditions under which the execution of this resource should be skipped.
                // If any evaluated condition returns true, the resource execution will be bypassed.
        }

        preflightCheck {
                validations {
                        // This section expects boolean validations.
                        // If any validation returns false, an exception will be thrown before proceeding to the next step.
                }
                //
                // Custom error message and code to be returned immediately if the preflight check fails.
                //
                // error {
                //         code = 0
                //         message = ""
                // }
        }

        // The expr block is space for evaluating standard PKL expressions. It is primarily used to execute
        // expressions that produce side effects, such as updating resources or triggering actions, but also supports
        // general-purpose evaluation of any valid PKL expression, making it a place for inline logic and
        // scripting within a configuration.
        expr {
                // "@(memory.setRecord("foo", "bar"))" // Persistent data
                // "@(memory.clear())"
                // "@(session.setRecord("foo", "bar"))" // Temporary data only for this request
        }

        // Initializes an api response for this agent.
        //
        // This resource action is straightforward. It
        // creates a JSON response with the following shape
        //
        // {
        //   "success": true,
        //   "response": {
        //     "data": [],
        //   },
        //   "meta": {
        //     "requestID": "UUID-XXXX-XXXX-XXXX",
        //     "headers": [],
        //     "properties": [],
        //   },
        //   "errors": [{
        //     "code": 0,
        //     "message": ""
        //   }]
        // }
        //
        APIResponse {
                success = true
                meta {
                        headers {
                                // ["X-Frame-Options"] = "DENY"
                                // ["Content-Security-Policy"] = "default-src 'self'; connect-src *; font-src *; script-src-elem * 'unsafe-inline'; img-src * data:; style-src * 'unsafe-inline';"
                                // ["X-XSS-Protection"] = "1; mode=block"
                                // ["Strict-Transport-Security"] = "max-age=31536000; includeSubDomains; preload"
                                // ["Referrer-Policy"] = "strict-origin"
                                // ["X-Content-Type-Options"] = "nosniff"
                                // ["Permissions-Policy"] = "geolocation=(),midi=(),sync-xhr=(),microphone=(),camera=(),magnetometer=(),gyroscope=(),fullscreen=(self),payment=()"
                        }
                        properties {
                                // ["X-Custom-Properties"] = "value"
                        }
                }
                response {
                        data {
                                "@(llm.response("llmResource"))"
                                // "@(memory.getRecord("foo"))"
                                // "@(python.stdout("pythonResource"))"
                                // "@(exec.stdout("shellResource"))"
                                // "@(client.responseBody("httpResource"))"
                        }
                }
                errors {
                        // new {
                        //         code = 0
                        //         message = ""
                        // }
                }
        }
}
