# A CLI for Twilio

[![Travis Build Status](https://travis-ci.com/twilio/twilio-cli.svg?branch=main)](https://travis-ci.com/twilio/twilio-cli.svg?branch=main) [![codecov](https://codecov.io/gh/twilio/twilio-cli/branch/main/graph/badge.svg)](https://codecov.io/gh/twilio/twilio-cli)
 [![Learn with TwilioQuest](https://img.shields.io/static/v1?label=TwilioQuest&message=Learn%20to%20contribute%21&color=F22F46&labelColor=1f243c&style=flat-square&logo=data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAIAAAACACAMAAAD04JH5AAAASFBMVEUAAAAZGRkcHBwjIyMoKCgAAABgYGBoaGiAgICMjIyzs7PJycnMzMzNzc3UoBfd3d3m5ubqrhfrMEDu7u739/f4vSb/3AD///9tbdyEAAAABXRSTlMAAAAAAMJrBrEAAAKoSURBVHgB7ZrRcuI6EESdyxXGYoNFvMD//+l2bSszRgyUYpFAsXOeiJGmj4NkuWx1Qeh+Ekl9DgEXOBwOx+Px5xyQhDykfgq4wG63MxxaR4ddIkg6Ul3g84vCIcjPBA5gmUMeXESrlukuoK33+33uID8TWeLAdOWsKpJYzwVMB7bOzYSGOciyUlXSn0/ABXTosJ1M1SbypZ4O4MbZuIDMU02PMbauhhHMHXbmebmALIiEbbbbbUrpF1gwE9kFfRNAJaP+FQEXCCTGyJ4ngDrjOFo3jEL5JdqjF/pueR4cCeCGgAtwmuRS6gDwaRiGvu+DMFwSBLTE3+jF8JyuV1okPZ+AC4hDFhCHyHQjdjPHUKFDlHSJkHQXMB3KpSwXNGJPcwwTdZiXlRN0gSp0zpWxNtM0beYE0nRH6QIbO7rawwXaBYz0j78gxjokDuv12gVeUuBD0MDi0OQCLvDaAho4juP1Q/jkAncXqIcCfd+7gAu4QLMACCLxpRsSuQh0igu0C9Svhi7weAGZg50L3IE3cai4IfkNZAC8dfdhsUD3CgKBVC9JE5ABAFzg4QL/taYPAAWrHdYcgfLaIgAXWJ7OV38n1LEF8tt2TH29E+QAoDoO5Ve/LtCQDmKM9kPbvCEBApK+IXzbcSJ0cIGF6e8gpcRhUDogWZ8JnaWjPXc/fNnBBUKRngiHgTUSivSzDRDgHZQOLvBQgf8rRt+VdBUUhwkU6VpJ+xcOwQUqZr+mR0kvBUgv6cB4+37hQAkXqE8PwGisGhJtN4xAHMzrsgvI7rccXqSvKh6jltGlrOHA3Xk1At3LC4QiPdX9/0ndHpGVvTjR4bZA1ypAKgVcwE5vx74ulwIugDt8e/X7JgfkucBMIAr26ndnB4UCLnDOqvteQsHlgX9N4A+c4cW3DXSPbwAAAABJRU5ErkJggg==)](https://twil.io/learn-open-source)

## Requirements
Currently, Node 14+ is supported. We support the [LTS versions](https://nodejs.org/en/about/releases) of Node.

## Setup

Head over to the [Twilio CLI documentation](https://www.twilio.com/docs/twilio-cli/quickstart).
  
## Architecture and Functional Overview

Head over to the [CLI Architecture and Functional Overview](https://github.com/twilio/twilio-cli/blob/main/ARCHITECTURE.md)

## Versioning

`twilio-cli` uses a modified version of [Semantic Versioning](https://semver.org) for all changes. [See this document](VERSIONS.md) for details.

## Usage

See the [General usage guide](https://www.twilio.com/docs/twilio-cli/general-usage).

## Examples

Review the [Examples](https://www.twilio.com/docs/twilio-cli/examples).

## Plugins

You can review the docs on [available plugins and how to install them](https://www.twilio.com/docs/twilio-cli/plugins). If you are interested in writing your own plugin, refer to the [plugin authoring docs](docs/plugins.md).

## Contributing

1. Clone [this repo](https://github.com/twilio/twilio-cli).
1. From the repo directory, run: `npm install`
1. Run `./bin/run` from the repo directory to run the CLI.

## Feedback

Please file a [GitHub issue](https://github.com/twilio/twilio-cli/issues) in this repository for any issues/bugs.

We’d love to hear from you. Any time you have feedback you’d like to send us, fill the [CLI Feedback form](https://airtable.com/shrcFDU1gmKWOqZXe) or just run: the `twilio feedback` command.  

## License

MIT
