/*
 * Decompiled with CFR 0.152.
 */
package org.rismch;

import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.util.CharacterUtils;
import org.rismch.external.NativeInterfaces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PAEFilter
extends TokenFilter {
    private final CharacterUtils charUtils;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private static Logger LOGGER = LoggerFactory.getLogger(PAEFilter.class);

    public PAEFilter(TokenStream in) {
        super(in);
        this.charUtils = CharacterUtils.getInstance();
    }

    public final boolean incrementToken() throws IOException {
        String param;
        if (!this.input.incrementToken()) {
            return false;
        }
        StringBuilder sb = new StringBuilder();
        char[] buffer = this.termAtt.buffer();
        int length = this.termAtt.length();
        sb.append(buffer, 0, length);
        String input_data = param = sb.toString();
        String input_format = "PCH";
        if (param.contains("-")) {
            String[] parts = param.replace("*", "").split("-");
            input_data = parts[0];
            if (parts.length > 1) {
                input_format = parts[1];
            }
        }
        NativeInterfaces m = new NativeInterfaces();
        String s = m.transformPaeToKernTemplate(input_data);
        String q = m.doTindexSearch(s, input_format);
        String match = "";
        String[] result_parts = q.split("\t");
        for (int i = 0; i < result_parts.length; ++i) {
            String part = result_parts[i];
            if (part.contains("ZC=") || part.contains("::") || !StringUtils.containsAny((String)part, (String)"{#:%}jJ~^;&'`@=")) continue;
            match = part;
            break;
        }
        match.replaceAll("\\s+", "");
        if (param.charAt(param.length() - 1) == '*' && match.charAt(match.length() - 1) != '*') {
            match = match + "*";
        }
        if (param.charAt(0) == '*' && match.charAt(0) != '*') {
            match = "*" + match.substring(1);
        }
        this.termAtt.setEmpty();
        this.termAtt.copyBuffer(match.toCharArray(), 0, match.length());
        return true;
    }
}

