/*
 * Decompiled with CFR 0.152.
 */
package org.rismch;

import java.io.IOException;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.rismch.external.NativeInterfaces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PAETokenizer
extends Tokenizer {
    private static Logger LOGGER = LoggerFactory.getLogger(PAETokenizer.class);
    private String[] tokens;
    private int tokOffset = 2;
    private boolean splitted = false;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private final PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    private final TypeAttribute typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);

    private void splitStream() {
        StringBuilder sb = new StringBuilder();
        NativeInterfaces m = new NativeInterfaces();
        char[] buffer = new char[512];
        try {
            int length = this.input.read(buffer);
        }
        catch (IOException ex) {
            LOGGER.error("PAETokenizer could not read input " + ex.getMessage());
            return;
        }
        sb.append(buffer);
        String s = m.transformPaeToKern(sb.toString());
        String filename = m.getFileFromPAE(sb.toString());
        String q = m.doTindex(s, filename);
        this.tokens = q.split("\t");
    }

    public final boolean incrementToken() throws IOException {
        this.clearAttributes();
        if (!this.splitted) {
            this.splitStream();
            this.splitted = true;
        }
        if (this.tokOffset >= this.tokens.length) {
            return false;
        }
        this.posIncrAtt.setPositionIncrement(1);
        this.termAtt.append(this.tokens[this.tokOffset]);
        ++this.tokOffset;
        return true;
    }

    public final void end() throws IOException {
        super.end();
        this.offsetAtt.setOffset(0, 0);
    }

    public void close() throws IOException {
        super.close();
    }

    public void reset() throws IOException {
        super.reset();
        this.tokOffset = 2;
        this.splitStream();
    }
}

