/*
 * Decompiled with CFR 0.152.
 */
package org.rismch.external;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.rismch.NativeLibrary;
import org.rismch.verovio.fileFormat;
import org.rismch.verovio.toolkit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeInterfaces {
    private static Logger LOGGER = LoggerFactory.getLogger(NativeInterfaces.class);

    private native String pae2kern(String var1);

    private native String tindex(String var1, String var2);

    private native String tindexSearch(String var1, String var2);

    private native int themaxSearch(String var1);

    private native void themaxInit();

    private native float MusalignScore();

    public String transformPaeToKern(String pae) {
        String out = this.pae2kern(pae);
        return out;
    }

    public String getFileFromPAE(String pae) {
        String[] lines = pae.split("\n");
        String name = lines[0].replace("@start:", "");
        return name;
    }

    public String transformPaeToKernTemplate(String pae) {
        String s = "@start:00000400004625-1.1.1\n";
        s = s + "@clef:C-3\n";
        s = s + "@keysig:\n";
        s = s + "@key:\n";
        s = s + "@timesig:c\n";
        s = s + "@data:" + pae + "\n";
        s = s + "@end:00000400004625-1.1.1\n";
        return this.transformPaeToKern(s);
    }

    public String doTindex(String s, String file) {
        if (file == null) {
            file = "none";
        }
        return this.tindex(s, file);
    }

    public String doTindexSearch(String query, String type) {
        List<String> valid = Arrays.asList("PCH", "P", "PC", "MI", "DI", "INT", "I", "SD", "S", "D", "12P", "12I", "PGC", "GC", "CON", "PRC", "RC", "DUR", "IOI", "DGC", "RGC", "DRC", "RRC", "BLV", "MLV", "MPS", "MRC", "MGC");
        String checkType = valid.contains(type) ? type : "PCH";
        return this.tindexSearch(query, checkType);
    }

    public int doThemax(String s) {
        return this.themaxSearch(s);
    }

    public void doThemaxInit() {
        this.themaxInit();
    }

    public String pae2svg(String pae) {
        toolkit toolkit2 = new toolkit();
        String s = "@start:00000400004625-1.1.1\n";
        s = s + "@clef:C-3\n";
        s = s + "@keysig:\n";
        s = s + "@key:\n";
        s = s + "@timesig:c\n";
        s = s + "@data:" + pae + "\n";
        s = s + "@end:00000400004625-1.1.1\n";
        toolkit2.setFormat(fileFormat.PAE);
        toolkit2.loadData(s);
        String out = toolkit2.renderToSvg();
        return out;
    }

    public float doMusalignScore() {
        return this.MusalignScore();
    }

    static {
        try {
            NativeLibrary.loadLibraryFromJar("/META-INF/lib/libnativeinterfaces.jnilib");
        }
        catch (IOException e) {
            LOGGER.error("Could not load native interfaces JAR: " + e.getMessage());
        }
    }
}

