class CommentNotifications < ApplicationMailer

  def parse_comment(comment)
    matches = comment.scan(/@[A-Za-z0-9_-]*/)
    [] if matches.empty?
    
    user_ids = matches.each.map do |name|
      User.find_by_name(name.gsub("@", "").gsub("_", " ")).id rescue next
    end
    user_ids.compact
  end

  def new_comment(comment)
    
    all_comments = ActiveAdmin::Comment.where(resource_type: comment.resource_type, resource_id: comment.resource_id)
    @comment = comment
    # Try to get the owner of the resource
    @resource = Kernel.const_get(comment.resource_type).find(comment.resource_id)
    @commenter = User.find(comment.author_id)
    
    model_for_path = comment.resource_type.underscore.downcase
    link_function = "admin_#{model_for_path}_url"
    @resource_path = send(link_function, @resource)
    
    users = all_comments.map {|c| c.author_id}
    users << @resource.wf_owner
    all_comments.each {|c| users += parse_comment(c.body)}
    users.compact.uniq! # Users can be duplicated
    users -= [comment.author_id] # Don't send the comment to myself!

    addresses = users.each.map do |u|
      next if u == 0 # Don't send to user 0 (autogenerated items during import)
      next if u == 1 # Don't sent to admin
      email = User.find(u).email
      next if !email
      email
    end.compact
     
    addresses << RISM::COMMENT_EMAIL if (RISM::COMMENT_EMAIL && RISM::COMMENT_EMAIL.is_a?(String))

    return if addresses.empty?

    mail(to: "noreply-muscat@rism.info",
        name: "Muscat Comments",
        bcc: addresses,
        subject: "New Comment on Muscat [#{comment.resource_type} #{comment.resource_id}]")
 
  end

end
