ENV['RAILS_ENV'] ||= 'test'
require 'spec_helper'
require 'rspec/rails'
require 'capybara/rspec'

RSpec.configure do |config|
  config.include Rails.application.routes.url_helpers
  config.use_transactional_fixtures = false
  #config.include Devise::TestHelpers, :type => :controller
  config.include Devise::Test::ControllerHelpers, type: :controller
  config.infer_spec_type_from_file_location!
  config.include Warden::Test::Helpers
  config.include Capybara::DSL
  config.filter_rails_from_backtrace!
end

class ActiveRecord::Base
  mattr_accessor :shared_connection
  @@shared_connection = nil

  def self.connection
    @@shared_connection || retrieve_connection
  end
end

# Forces all threads to share the same connection. This works on
# # Capybara because it starts the web server in a thread.
ActiveRecord::Base.shared_connection = ActiveRecord::Base.connection
