/*
 * Decompiled with CFR 0.152.
 */
package com.thetransactioncompany.jsonrpc2.client;

import java.net.Proxy;
import java.util.regex.Pattern;

public class JSONRPC2SessionOptions {
    private String requestContentType = "application/json";
    public static final String DEFAULT_CONTENT_TYPE = "application/json";
    private String[] allowedResponseContentTypes = DEFAULT_ALLOWED_RESPONSE_CONTENT_TYPES;
    public static final String[] DEFAULT_ALLOWED_RESPONSE_CONTENT_TYPES = new String[]{"application/json", "text/plain"};
    private String origin = DEFAULT_ORIGIN;
    public static final String DEFAULT_ORIGIN = null;
    private boolean acceptCookies = false;
    public static final boolean DEFAULT_ACCEPT_COOKIES = false;
    private boolean preserveObjectMemberOrder = false;
    public static final boolean DEFAULT_PRESERVE_OBJECT_MEMBER_ORDER = false;
    private boolean ignoreVersion = false;
    public static final boolean DEFAULT_IGNORE_VERSION = false;
    private boolean parseNonStdAttributes = false;
    public static final boolean DEFAULT_PARSE_NON_STD_ATTRIBUTES = false;
    private int connectTimeout = 0;
    public static final int DEFAULT_CONNECT_TIMEOUT = 0;
    private int readTimeout = 0;
    public static final int DEFAULT_READ_TIMEOUT = 0;
    private Proxy proxy = null;
    private boolean enableCompression = false;
    public static final boolean DEFAULT_ENABLE_COMPRESSION = false;
    private boolean trustAll = false;
    public static final boolean DEFAULT_TRUST_ALL = false;

    public String getRequestContentType() {
        return this.requestContentType;
    }

    public void setRequestContentType(String contentType) {
        this.requestContentType = contentType;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public boolean acceptCookies() {
        return this.acceptCookies;
    }

    public void acceptCookies(boolean acceptCookies) {
        this.acceptCookies = acceptCookies;
    }

    public String[] getAllowedResponseContentTypes() {
        return this.allowedResponseContentTypes;
    }

    public void setAllowedResponseContentTypes(String[] contentTypes) {
        this.allowedResponseContentTypes = contentTypes;
    }

    public boolean isAllowedResponseContentType(String contentType) {
        if (this.allowedResponseContentTypes == null) {
            return true;
        }
        if (contentType == null) {
            return false;
        }
        for (String t : this.allowedResponseContentTypes) {
            if (!contentType.matches("^" + Pattern.quote(t) + "(\\s|;|$)?.*")) continue;
            return true;
        }
        return false;
    }

    public boolean preservesParseOrder() {
        return this.preserveObjectMemberOrder;
    }

    public void preserveParseOrder(boolean preserve) {
        this.preserveObjectMemberOrder = preserve;
    }

    public boolean ignoresVersion() {
        return this.ignoreVersion;
    }

    public void ignoreVersion(boolean ignore) {
        this.ignoreVersion = ignore;
    }

    public void parseNonStdAttributes(boolean enable) {
        this.parseNonStdAttributes = enable;
    }

    public boolean parsesNonStdAttributes() {
        return this.parseNonStdAttributes;
    }

    public void setConnectTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("The HTTP connect timeout must be zero or positive");
        }
        this.connectTimeout = timeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setReadTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("The HTTP read timeout must be zero or positive");
        }
        this.readTimeout = timeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void enableCompression(boolean enable) {
        this.enableCompression = enable;
    }

    public boolean enableCompression() {
        return this.enableCompression;
    }

    public void trustAllCerts(boolean trustAll) {
        this.trustAll = trustAll;
    }

    public boolean trustsAllCerts() {
        return this.trustAll;
    }
}

