package com.volmit.iris.util.interpolation;

import com.volmit.iris.util.function.NoiseProvider;

public class CompiledStarcast {
    private static final float[] MAGIC = {0.0F, 1.0F, 1.2246469E-16F, -1.0F
            , 0.8660254F, -0.5F, -0.8660254F, 6.123234E-17F
            , -1.8369701E-16F, 0.95105654F, 0.309017F, 0.58778524F
            , -0.809017F, -0.58778524F, -0.95105654F, 0.5F
            , 0.777146F, 0.6293204F, 0.9781476F, -0.20791169F
            , 0.4539905F, -0.8910065F, -0.40673664F, -0.9135454F
            , -0.9659258F, -0.25881904F, -0.052335955F, 0.9986295F
            , 0.70710677F, -0.70710677F, 0.64278764F, 0.76604444F
            , 0.9848077F, 0.17364818F, 0.34202015F, -0.9396926F
            , -0.34202015F, -0.9848077F, -0.64278764F, 0.809017F
            , -0.309017F, 0.52991927F, 0.8480481F, 0.89879405F
            , 0.43837115F, 0.9945219F, -0.104528464F, 0.7880108F
            , -0.6156615F, -0.9781476F, -0.6946584F, -0.7193398F
            , -0.9702957F, -0.2419219F, -0.1391731F, 0.99026805F
            , 0.8910065F, 0.98768836F, 0.15643446F, -0.15643446F
            , -0.98768836F, -0.4539905F, 0.42261827F, 0.9063078F
            , 0.9659258F, 0.25881904F, -0.17364818F, 0.81915206F
            , -0.57357645F, 0.087155744F, -0.9961947F, 0.40673664F
            , 0.9135454F, 0.7431448F, 0.6691306F, 0.20791169F
            , -0.9945219F, -0.7431448F, 0.37460658F, 0.92718387F
            , 0.6946584F, 0.7193398F, 0.99939084F, 0.034899496F
            , 0.9396926F, -0.6691306F, -0.89879405F, 0.06975647F
            , -0.9975641F, -0.76604444F, -0.88294756F, -0.46947157F
            , -0.9612617F, 0.27563736F, -0.7880108F, 0.6156615F
            , 0.35836795F, 0.9335804F, 0.104528464F, 0.54463905F
            , -0.83867055F, -0.777146F, -0.6293204F, -0.9986295F
            , 0.052335955F, 0.2923717F, 0.9563047F, 0.5591929F
            , 0.82903755F, 0.9961947F, 0.8746197F, -0.4848096F
            , -0.12186934F, -0.99254614F, -0.656059F, -0.7547096F
            , -0.8480481F, -0.52991927F, -0.99939084F, -0.94551855F
            , 0.32556817F, -0.60181504F, 0.7986355F, 0.9612617F
            , -0.37460658F, -0.82903755F, 0.2419219F, 0.9702957F
            , 0.46947157F, 0.88294756F, -0.034899496F, -0.27563736F
            , -0.06975647F, 0.22495106F, 0.97437006F, 0.9998477F
            , -0.017452406F, 0.60181504F, -0.7986355F, 0.190809F
            , -0.98162717F, -0.92050487F, -0.39073113F, -0.8746197F
            , 0.4848096F, 0.98162717F, 0.83867055F, 0.57357645F
            , 0.8571673F, -0.5150381F, -0.9563047F, -0.2923717F
            , 0.7547096F, -0.32556817F, 0.94551855F, 0.1391731F
            , -0.92718387F, 0.12186934F, 0.99254614F, 0.656059F
            , 0.7313537F, -0.6819984F, -0.9063078F, -0.42261827F
            , -0.190809F, -0.8571673F, 0.5150381F, -0.087155744F
            , -0.81915206F, 0.9975641F, -0.43837115F, -0.5591929F
            , -0.99026805F, -0.35836795F, -0.54463905F, -0.9335804F};

    public static float getStarcast(float x, float z, float r, float checks, NoiseProvider n) {
        if (checks >= 1 && checks <= 128) {
            if (checks < 2) {
                return sc1(x, z, r, n);
            }
            if (checks < 3) {
                return sc2(x, z, r, n);
            }
            if (checks < 4) {
                return sc3(x, z, r, n);
            }
            if (checks < 5) {
                return sc4(x, z, r, n);
            }
            if (checks < 6) {
                return sc5(x, z, r, n);
            }
            if (checks < 7) {
                return sc6(x, z, r, n);
            }
            if (checks < 8) {
                return sc7(x, z, r, n);
            }
            if (checks < 9) {
                return sc8(x, z, r, n);
            }
            if (checks < 10) {
                return sc9(x, z, r, n);
            }
            if (checks < 11) {
                return sc10(x, z, r, n);
            }
            if (checks < 12) {
                return sc11(x, z, r, n);
            }
            if (checks < 13) {
                return sc12(x, z, r, n);
            }
            if (checks < 14) {
                return sc13(x, z, r, n);
            }
            if (checks < 15) {
                return sc14(x, z, r, n);
            }
            if (checks < 16) {
                return sc15(x, z, r, n);
            }
            if (checks < 17) {
                return sc16(x, z, r, n);
            }
            if (checks < 18) {
                return sc17(x, z, r, n);
            }
            if (checks < 19) {
                return sc18(x, z, r, n);
            }
            if (checks < 20) {
                return sc19(x, z, r, n);
            }
            if (checks < 21) {
                return sc20(x, z, r, n);
            }
            if (checks < 22) {
                return sc21(x, z, r, n);
            }
            if (checks < 23) {
                return sc22(x, z, r, n);
            }
            if (checks < 24) {
                return sc23(x, z, r, n);
            }
            if (checks < 25) {
                return sc24(x, z, r, n);
            }
            if (checks < 26) {
                return sc25(x, z, r, n);
            }
            if (checks < 27) {
                return sc26(x, z, r, n);
            }
            if (checks < 28) {
                return sc27(x, z, r, n);
            }
            if (checks < 29) {
                return sc28(x, z, r, n);
            }
            if (checks < 30) {
                return sc29(x, z, r, n);
            }
            if (checks < 31) {
                return sc30(x, z, r, n);
            }
            if (checks < 32) {
                return sc31(x, z, r, n);
            }
            if (checks < 33) {
                return sc32(x, z, r, n);
            }
            if (checks < 34) {
                return sc33(x, z, r, n);
            }
            if (checks < 35) {
                return sc34(x, z, r, n);
            }
            if (checks < 36) {
                return sc35(x, z, r, n);
            }
            if (checks < 37) {
                return sc36(x, z, r, n);
            }
            if (checks < 38) {
                return sc37(x, z, r, n);
            }
            if (checks < 39) {
                return sc38(x, z, r, n);
            }
            if (checks < 40) {
                return sc39(x, z, r, n);
            }
            if (checks < 41) {
                return sc40(x, z, r, n);
            }
            if (checks < 42) {
                return sc41(x, z, r, n);
            }
            if (checks < 43) {
                return sc42(x, z, r, n);
            }
            if (checks < 44) {
                return sc43(x, z, r, n);
            }
            if (checks < 45) {
                return sc44(x, z, r, n);
            }
            if (checks < 46) {
                return sc45(x, z, r, n);
            }
            if (checks < 47) {
                return sc46(x, z, r, n);
            }
            if (checks < 48) {
                return sc47(x, z, r, n);
            }
            if (checks < 49) {
                return sc48(x, z, r, n);
            }
            if (checks < 50) {
                return sc49(x, z, r, n);
            }
            if (checks < 51) {
                return sc50(x, z, r, n);
            }
            if (checks < 52) {
                return sc51(x, z, r, n);
            }
            if (checks < 53) {
                return sc52(x, z, r, n);
            }
            if (checks < 54) {
                return sc53(x, z, r, n);
            }
            if (checks < 55) {
                return sc54(x, z, r, n);
            }
            if (checks < 56) {
                return sc55(x, z, r, n);
            }
            if (checks < 57) {
                return sc56(x, z, r, n);
            }
            if (checks < 58) {
                return sc57(x, z, r, n);
            }
            if (checks < 59) {
                return sc58(x, z, r, n);
            }
            if (checks < 60) {
                return sc59(x, z, r, n);
            }
            if (checks < 61) {
                return sc60(x, z, r, n);
            }
            if (checks < 62) {
                return sc61(x, z, r, n);
            }
            if (checks < 63) {
                return sc62(x, z, r, n);
            }
            if (checks < 64) {
                return sc63(x, z, r, n);
            }
            if (checks < 65) {
                return sc64(x, z, r, n);
            }
            if (checks < 66) {
                return sc65(x, z, r, n);
            }
            if (checks < 67) {
                return sc66(x, z, r, n);
            }
            if (checks < 68) {
                return sc67(x, z, r, n);
            }
            if (checks < 69) {
                return sc68(x, z, r, n);
            }
            if (checks < 70) {
                return sc69(x, z, r, n);
            }
            if (checks < 71) {
                return sc70(x, z, r, n);
            }
            if (checks < 72) {
                return sc71(x, z, r, n);
            }
            if (checks < 73) {
                return sc72(x, z, r, n);
            }
            if (checks < 74) {
                return sc73(x, z, r, n);
            }
            if (checks < 75) {
                return sc74(x, z, r, n);
            }
            if (checks < 76) {
                return sc75(x, z, r, n);
            }
            if (checks < 77) {
                return sc76(x, z, r, n);
            }
            if (checks < 78) {
                return sc77(x, z, r, n);
            }
            if (checks < 79) {
                return sc78(x, z, r, n);
            }
            if (checks < 80) {
                return sc79(x, z, r, n);
            }
            if (checks < 81) {
                return sc80(x, z, r, n);
            }
            if (checks < 82) {
                return sc81(x, z, r, n);
            }
            if (checks < 83) {
                return sc82(x, z, r, n);
            }
            if (checks < 84) {
                return sc83(x, z, r, n);
            }
            if (checks < 85) {
                return sc84(x, z, r, n);
            }
            if (checks < 86) {
                return sc85(x, z, r, n);
            }
            if (checks < 87) {
                return sc86(x, z, r, n);
            }
            if (checks < 88) {
                return sc87(x, z, r, n);
            }
            if (checks < 89) {
                return sc88(x, z, r, n);
            }
            if (checks < 90) {
                return sc89(x, z, r, n);
            }
            if (checks < 91) {
                return sc90(x, z, r, n);
            }
            if (checks < 92) {
                return sc91(x, z, r, n);
            }
            if (checks < 93) {
                return sc92(x, z, r, n);
            }
            if (checks < 94) {
                return sc93(x, z, r, n);
            }
            if (checks < 95) {
                return sc94(x, z, r, n);
            }
            if (checks < 96) {
                return sc95(x, z, r, n);
            }
            if (checks < 97) {
                return sc96(x, z, r, n);
            }
            if (checks < 98) {
                return sc97(x, z, r, n);
            }
            if (checks < 99) {
                return sc98(x, z, r, n);
            }
            if (checks < 100) {
                return sc99(x, z, r, n);
            }
            if (checks < 101) {
                return sc100(x, z, r, n);
            }
            if (checks < 102) {
                return sc101(x, z, r, n);
            }
            if (checks < 103) {
                return sc102(x, z, r, n);
            }
            if (checks < 104) {
                return sc103(x, z, r, n);
            }
            if (checks < 105) {
                return sc104(x, z, r, n);
            }
            if (checks < 106) {
                return sc105(x, z, r, n);
            }
            if (checks < 107) {
                return sc106(x, z, r, n);
            }
            if (checks < 108) {
                return sc107(x, z, r, n);
            }
            if (checks < 109) {
                return sc108(x, z, r, n);
            }
            if (checks < 110) {
                return sc109(x, z, r, n);
            }
            if (checks < 111) {
                return sc110(x, z, r, n);
            }
            if (checks < 112) {
                return sc111(x, z, r, n);
            }
            if (checks < 113) {
                return sc112(x, z, r, n);
            }
            if (checks < 114) {
                return sc113(x, z, r, n);
            }
            if (checks < 115) {
                return sc114(x, z, r, n);
            }
            if (checks < 116) {
                return sc115(x, z, r, n);
            }
            if (checks < 117) {
                return sc116(x, z, r, n);
            }
            if (checks < 118) {
                return sc117(x, z, r, n);
            }
            if (checks < 119) {
                return sc118(x, z, r, n);
            }
            if (checks < 120) {
                return sc119(x, z, r, n);
            }
            if (checks < 121) {
                return sc120(x, z, r, n);
            }
            if (checks < 122) {
                return sc121(x, z, r, n);
            }
            if (checks < 123) {
                return sc122(x, z, r, n);
            }
            if (checks < 124) {
                return sc123(x, z, r, n);
            }
            if (checks < 125) {
                return sc124(x, z, r, n);
            }
            if (checks < 126) {
                return sc125(x, z, r, n);
            }
            if (checks < 127) {
                return sc126(x, z, r, n);
            }
            if (checks < 128) {
                return sc127(x, z, r, n);
            }
            return sc128(x, z, r, n);
        }

        float m = 360F / checks;
        float v = 0;

        for (int i = 0; i < 360; i += m) {
            float sin = (float) Math.sin(Math.toRadians(i));
            float cos = (float) Math.cos(Math.toRadians(i));
            float cx = x + ((r * cos) - (r * sin));
            float cz = z + ((r * sin) + (r * cos));
            v += n.noise(cx, cz);
        }

        return v / checks;
    }

    private static float sc1(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))) * 1.0F;
    }

    private static float sc2(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))) * 0.5F;
    }

    private static float sc3(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))) * 0.33333334F;
    }

    private static float sc4(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))) * 0.25F;
    }

    private static float sc5(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))) * 0.2F;
    }

    private static float sc6(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))) * 0.16666667F;
    }

    private static float sc7(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[27]))))) * 0.14285715F;
    }

    private static float sc8(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))) * 0.125F;
    }

    private static float sc9(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[31]))))) * 0.11111111F;
    }

    private static float sc10(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))) * 0.1F;
    }

    private static float sc11(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[41])), z + ((r * MAGIC[41]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[43])), z + ((r * MAGIC[43]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[47])), z + ((r * MAGIC[47]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[52])), z + ((r * MAGIC[52]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[54])), z + ((r * MAGIC[54]) + (r * MAGIC[55]))))) * 0.09090909F;
    }

    private static float sc12(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))) * 0.083333336F;
    }

    private static float sc13(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[57]))))) * 0.07692308F;
    }

    private static float sc14(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[63]) - (r * MAGIC[62])), z + ((r * MAGIC[62]) + (r * MAGIC[63]))))
                + ((float) n.noise(x + ((r * MAGIC[30]) - (r * MAGIC[31])), z + ((r * MAGIC[31]) + (r * MAGIC[30]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[68]) - (r * MAGIC[67])), z + ((r * MAGIC[67]) + (r * MAGIC[68]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[70]) - (r * MAGIC[69])), z + ((r * MAGIC[69]) + (r * MAGIC[70]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[36]) - (r * MAGIC[35])), z + ((r * MAGIC[35]) + (r * MAGIC[36]))))
                + ((float) n.noise(x + ((r * MAGIC[69]) - (r * MAGIC[70])), z + ((r * MAGIC[70]) + (r * MAGIC[69]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[67]) - (r * MAGIC[68])), z + ((r * MAGIC[68]) + (r * MAGIC[67]))))
                + ((float) n.noise(x + ((r * MAGIC[32]) - (r * MAGIC[66])), z + ((r * MAGIC[66]) + (r * MAGIC[32]))))) * 0.071428575F;
    }

    private static float sc15(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))) * 0.06666667F;
    }

    private static float sc16(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[79]) - (r * MAGIC[78])), z + ((r * MAGIC[78]) + (r * MAGIC[79]))))
                + ((float) n.noise(x + ((r * MAGIC[81]) - (r * MAGIC[80])), z + ((r * MAGIC[80]) + (r * MAGIC[81]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[82])), z + ((r * MAGIC[82]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[36]) - (r * MAGIC[84])), z + ((r * MAGIC[84]) + (r * MAGIC[36]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[86]) - (r * MAGIC[44])), z + ((r * MAGIC[44]) + (r * MAGIC[86]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[87])), z + ((r * MAGIC[87]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[91]) - (r * MAGIC[90])), z + ((r * MAGIC[90]) + (r * MAGIC[91]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[93]) - (r * MAGIC[92])), z + ((r * MAGIC[92]) + (r * MAGIC[93]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[54])), z + ((r * MAGIC[54]) + (r * MAGIC[55]))))) * 0.0625F;
    }

    private static float sc17(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[27]))))) * 0.05882353F;
    }

    private static float sc18(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[84]))))) * 0.055555556F;
    }

    private static float sc19(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[9]))))) * 0.05263158F;
    }

    private static float sc20(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[9]))))) * 0.05F;
    }

    private static float sc21(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[106]) - (r * MAGIC[105])), z + ((r * MAGIC[105]) + (r * MAGIC[106]))))
                + ((float) n.noise(x + ((r * MAGIC[108]) - (r * MAGIC[107])), z + ((r * MAGIC[107]) + (r * MAGIC[108]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[78]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[78]))))
                + ((float) n.noise(x + ((r * MAGIC[69]) - (r * MAGIC[109])), z + ((r * MAGIC[109]) + (r * MAGIC[69]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[111]) - (r * MAGIC[110])), z + ((r * MAGIC[110]) + (r * MAGIC[111]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[80])), z + ((r * MAGIC[80]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[37]) - (r * MAGIC[33])), z + ((r * MAGIC[33]) + (r * MAGIC[37]))))
                + ((float) n.noise(x + ((r * MAGIC[113]) - (r * MAGIC[112])), z + ((r * MAGIC[112]) + (r * MAGIC[113]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[115]) - (r * MAGIC[114])), z + ((r * MAGIC[114]) + (r * MAGIC[115]))))
                + ((float) n.noise(x + ((r * MAGIC[117]) - (r * MAGIC[116])), z + ((r * MAGIC[116]) + (r * MAGIC[117]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[118])), z + ((r * MAGIC[118]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[120]) - (r * MAGIC[119])), z + ((r * MAGIC[119]) + (r * MAGIC[120]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[122]) - (r * MAGIC[121])), z + ((r * MAGIC[121]) + (r * MAGIC[122]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[27]))))) * 0.04761905F;
    }

    private static float sc22(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[93])), z + ((r * MAGIC[93]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[41])), z + ((r * MAGIC[41]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[43])), z + ((r * MAGIC[43]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[47])), z + ((r * MAGIC[47]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[87])), z + ((r * MAGIC[87]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[91])), z + ((r * MAGIC[91]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[52])), z + ((r * MAGIC[52]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[118])), z + ((r * MAGIC[118]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[125])), z + ((r * MAGIC[125]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[54])), z + ((r * MAGIC[54]) + (r * MAGIC[55]))))) * 0.045454547F;
    }

    private static float sc23(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[64]))))) * 0.04347826F;
    }

    private static float sc24(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[64]))))) * 0.041666668F;
    }

    private static float sc25(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[127]) - (r * MAGIC[126])), z + ((r * MAGIC[126]) + (r * MAGIC[127]))))
                + ((float) n.noise(x + ((r * MAGIC[129]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[129]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[34]) - (r * MAGIC[84])), z + ((r * MAGIC[84]) + (r * MAGIC[34]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[54]) - (r * MAGIC[55])), z + ((r * MAGIC[55]) + (r * MAGIC[54]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[86]) - (r * MAGIC[44])), z + ((r * MAGIC[44]) + (r * MAGIC[86]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[118]) - (r * MAGIC[130])), z + ((r * MAGIC[130]) + (r * MAGIC[118]))))
                + ((float) n.noise(x + ((r * MAGIC[92]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[92]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[117]) - (r * MAGIC[116])), z + ((r * MAGIC[116]) + (r * MAGIC[117]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[132]) - (r * MAGIC[88])), z + ((r * MAGIC[88]) + (r * MAGIC[132]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[47]) - (r * MAGIC[48])), z + ((r * MAGIC[48]) + (r * MAGIC[47]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[32]) - (r * MAGIC[66])), z + ((r * MAGIC[66]) + (r * MAGIC[32]))))) * 0.04F;
    }

    private static float sc26(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[134]) - (r * MAGIC[133])), z + ((r * MAGIC[133]) + (r * MAGIC[134]))))
                + ((float) n.noise(x + ((r * MAGIC[43]) - (r * MAGIC[44])), z + ((r * MAGIC[44]) + (r * MAGIC[43]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[47])), z + ((r * MAGIC[47]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[62]) - (r * MAGIC[63])), z + ((r * MAGIC[63]) + (r * MAGIC[62]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[136]) - (r * MAGIC[135])), z + ((r * MAGIC[135]) + (r * MAGIC[136]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[127])), z + ((r * MAGIC[127]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[38]) - (r * MAGIC[31])), z + ((r * MAGIC[31]) + (r * MAGIC[38]))))
                + ((float) n.noise(x + ((r * MAGIC[138]) - (r * MAGIC[137])), z + ((r * MAGIC[137]) + (r * MAGIC[138]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[140]) - (r * MAGIC[139])), z + ((r * MAGIC[139]) + (r * MAGIC[140]))))
                + ((float) n.noise(x + ((r * MAGIC[118]) - (r * MAGIC[130])), z + ((r * MAGIC[130]) + (r * MAGIC[118]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[91])), z + ((r * MAGIC[91]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[115]) - (r * MAGIC[114])), z + ((r * MAGIC[114]) + (r * MAGIC[115]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[142]) - (r * MAGIC[141])), z + ((r * MAGIC[141]) + (r * MAGIC[142]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[93]) - (r * MAGIC[92])), z + ((r * MAGIC[92]) + (r * MAGIC[93]))))
                + ((float) n.noise(x + ((r * MAGIC[144]) - (r * MAGIC[143])), z + ((r * MAGIC[143]) + (r * MAGIC[144]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[67]) - (r * MAGIC[68])), z + ((r * MAGIC[68]) + (r * MAGIC[67]))))
                + ((float) n.noise(x + ((r * MAGIC[79]) - (r * MAGIC[124])), z + ((r * MAGIC[124]) + (r * MAGIC[79]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[57]))))) * 0.03846154F;
    }

    private static float sc27(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[134]) - (r * MAGIC[133])), z + ((r * MAGIC[133]) + (r * MAGIC[134]))))
                + ((float) n.noise(x + ((r * MAGIC[43]) - (r * MAGIC[44])), z + ((r * MAGIC[44]) + (r * MAGIC[43]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[47])), z + ((r * MAGIC[47]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[62]) - (r * MAGIC[63])), z + ((r * MAGIC[63]) + (r * MAGIC[62]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[136]) - (r * MAGIC[135])), z + ((r * MAGIC[135]) + (r * MAGIC[136]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[127])), z + ((r * MAGIC[127]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[38]) - (r * MAGIC[31])), z + ((r * MAGIC[31]) + (r * MAGIC[38]))))
                + ((float) n.noise(x + ((r * MAGIC[138]) - (r * MAGIC[137])), z + ((r * MAGIC[137]) + (r * MAGIC[138]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[140]) - (r * MAGIC[139])), z + ((r * MAGIC[139]) + (r * MAGIC[140]))))
                + ((float) n.noise(x + ((r * MAGIC[118]) - (r * MAGIC[130])), z + ((r * MAGIC[130]) + (r * MAGIC[118]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[91])), z + ((r * MAGIC[91]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[115]) - (r * MAGIC[114])), z + ((r * MAGIC[114]) + (r * MAGIC[115]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[142]) - (r * MAGIC[141])), z + ((r * MAGIC[141]) + (r * MAGIC[142]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[93]) - (r * MAGIC[92])), z + ((r * MAGIC[92]) + (r * MAGIC[93]))))
                + ((float) n.noise(x + ((r * MAGIC[144]) - (r * MAGIC[143])), z + ((r * MAGIC[143]) + (r * MAGIC[144]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[67]) - (r * MAGIC[68])), z + ((r * MAGIC[68]) + (r * MAGIC[67]))))
                + ((float) n.noise(x + ((r * MAGIC[79]) - (r * MAGIC[124])), z + ((r * MAGIC[124]) + (r * MAGIC[79]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[57]))))) * 0.037037037F;
    }

    private static float sc28(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))) * 0.035714287F;
    }

    private static float sc29(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))) * 0.03448276F;
    }

    private static float sc30(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))) * 0.033333335F;
    }

    private static float sc31(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[145]) - (r * MAGIC[139])), z + ((r * MAGIC[139]) + (r * MAGIC[145]))))
                + ((float) n.noise(x + ((r * MAGIC[79]) - (r * MAGIC[78])), z + ((r * MAGIC[78]) + (r * MAGIC[79]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[81]) - (r * MAGIC[80])), z + ((r * MAGIC[80]) + (r * MAGIC[81]))))
                + ((float) n.noise(x + ((r * MAGIC[147]) - (r * MAGIC[67])), z + ((r * MAGIC[67]) + (r * MAGIC[147]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[133]) - (r * MAGIC[134])), z + ((r * MAGIC[134]) + (r * MAGIC[133]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[82])), z + ((r * MAGIC[82]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[36]) - (r * MAGIC[84])), z + ((r * MAGIC[84]) + (r * MAGIC[36]))))
                + ((float) n.noise(x + ((r * MAGIC[149]) - (r * MAGIC[148])), z + ((r * MAGIC[148]) + (r * MAGIC[149]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[138]) - (r * MAGIC[137])), z + ((r * MAGIC[137]) + (r * MAGIC[138]))))
                + ((float) n.noise(x + ((r * MAGIC[86]) - (r * MAGIC[44])), z + ((r * MAGIC[44]) + (r * MAGIC[86]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[87])), z + ((r * MAGIC[87]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[113]) - (r * MAGIC[112])), z + ((r * MAGIC[112]) + (r * MAGIC[113]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[143]) - (r * MAGIC[111])), z + ((r * MAGIC[111]) + (r * MAGIC[143]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[91]) - (r * MAGIC[90])), z + ((r * MAGIC[90]) + (r * MAGIC[91]))))
                + ((float) n.noise(x + ((r * MAGIC[151]) - (r * MAGIC[150])), z + ((r * MAGIC[150]) + (r * MAGIC[151]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[69]) - (r * MAGIC[70])), z + ((r * MAGIC[70]) + (r * MAGIC[69]))))
                + ((float) n.noise(x + ((r * MAGIC[93]) - (r * MAGIC[92])), z + ((r * MAGIC[92]) + (r * MAGIC[93]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[152]) - (r * MAGIC[114])), z + ((r * MAGIC[114]) + (r * MAGIC[152]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[154]) - (r * MAGIC[153])), z + ((r * MAGIC[153]) + (r * MAGIC[154]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[54])), z + ((r * MAGIC[54]) + (r * MAGIC[55]))))) * 0.032258064F;
    }

    private static float sc32(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[145]) - (r * MAGIC[139])), z + ((r * MAGIC[139]) + (r * MAGIC[145]))))
                + ((float) n.noise(x + ((r * MAGIC[79]) - (r * MAGIC[78])), z + ((r * MAGIC[78]) + (r * MAGIC[79]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[81]) - (r * MAGIC[80])), z + ((r * MAGIC[80]) + (r * MAGIC[81]))))
                + ((float) n.noise(x + ((r * MAGIC[147]) - (r * MAGIC[67])), z + ((r * MAGIC[67]) + (r * MAGIC[147]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[133]) - (r * MAGIC[134])), z + ((r * MAGIC[134]) + (r * MAGIC[133]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[82])), z + ((r * MAGIC[82]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[36]) - (r * MAGIC[84])), z + ((r * MAGIC[84]) + (r * MAGIC[36]))))
                + ((float) n.noise(x + ((r * MAGIC[149]) - (r * MAGIC[148])), z + ((r * MAGIC[148]) + (r * MAGIC[149]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[138]) - (r * MAGIC[137])), z + ((r * MAGIC[137]) + (r * MAGIC[138]))))
                + ((float) n.noise(x + ((r * MAGIC[86]) - (r * MAGIC[44])), z + ((r * MAGIC[44]) + (r * MAGIC[86]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[87])), z + ((r * MAGIC[87]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[113]) - (r * MAGIC[112])), z + ((r * MAGIC[112]) + (r * MAGIC[113]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[143]) - (r * MAGIC[111])), z + ((r * MAGIC[111]) + (r * MAGIC[143]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[91]) - (r * MAGIC[90])), z + ((r * MAGIC[90]) + (r * MAGIC[91]))))
                + ((float) n.noise(x + ((r * MAGIC[151]) - (r * MAGIC[150])), z + ((r * MAGIC[150]) + (r * MAGIC[151]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[69]) - (r * MAGIC[70])), z + ((r * MAGIC[70]) + (r * MAGIC[69]))))
                + ((float) n.noise(x + ((r * MAGIC[93]) - (r * MAGIC[92])), z + ((r * MAGIC[92]) + (r * MAGIC[93]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[152]) - (r * MAGIC[114])), z + ((r * MAGIC[114]) + (r * MAGIC[152]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[154]) - (r * MAGIC[153])), z + ((r * MAGIC[153]) + (r * MAGIC[154]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[54])), z + ((r * MAGIC[54]) + (r * MAGIC[55]))))) * 0.03125F;
    }

    private static float sc33(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[32]) - (r * MAGIC[33])), z + ((r * MAGIC[33]) + (r * MAGIC[32]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[30]) - (r * MAGIC[31])), z + ((r * MAGIC[31]) + (r * MAGIC[30]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[34]) - (r * MAGIC[84])), z + ((r * MAGIC[84]) + (r * MAGIC[34]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[36]) - (r * MAGIC[84])), z + ((r * MAGIC[84]) + (r * MAGIC[36]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[38]) - (r * MAGIC[31])), z + ((r * MAGIC[31]) + (r * MAGIC[38]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[37]) - (r * MAGIC[33])), z + ((r * MAGIC[33]) + (r * MAGIC[37]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[37]) - (r * MAGIC[66])), z + ((r * MAGIC[66]) + (r * MAGIC[37]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[38]) - (r * MAGIC[89])), z + ((r * MAGIC[89]) + (r * MAGIC[38]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[36]) - (r * MAGIC[35])), z + ((r * MAGIC[35]) + (r * MAGIC[36]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[34]) - (r * MAGIC[35])), z + ((r * MAGIC[35]) + (r * MAGIC[34]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[30]) - (r * MAGIC[89])), z + ((r * MAGIC[89]) + (r * MAGIC[30]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[32]) - (r * MAGIC[66])), z + ((r * MAGIC[66]) + (r * MAGIC[32]))))) * 0.030303031F;
    }

    private static float sc34(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[32]) - (r * MAGIC[33])), z + ((r * MAGIC[33]) + (r * MAGIC[32]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[30]) - (r * MAGIC[31])), z + ((r * MAGIC[31]) + (r * MAGIC[30]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[34]) - (r * MAGIC[84])), z + ((r * MAGIC[84]) + (r * MAGIC[34]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[36]) - (r * MAGIC[84])), z + ((r * MAGIC[84]) + (r * MAGIC[36]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[38]) - (r * MAGIC[31])), z + ((r * MAGIC[31]) + (r * MAGIC[38]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[37]) - (r * MAGIC[33])), z + ((r * MAGIC[33]) + (r * MAGIC[37]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[37]) - (r * MAGIC[66])), z + ((r * MAGIC[66]) + (r * MAGIC[37]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[38]) - (r * MAGIC[89])), z + ((r * MAGIC[89]) + (r * MAGIC[38]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[36]) - (r * MAGIC[35])), z + ((r * MAGIC[35]) + (r * MAGIC[36]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[34]) - (r * MAGIC[35])), z + ((r * MAGIC[35]) + (r * MAGIC[34]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[30]) - (r * MAGIC[89])), z + ((r * MAGIC[89]) + (r * MAGIC[30]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[32]) - (r * MAGIC[66])), z + ((r * MAGIC[66]) + (r * MAGIC[32]))))) * 0.029411765F;
    }

    private static float sc35(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[32]) - (r * MAGIC[33])), z + ((r * MAGIC[33]) + (r * MAGIC[32]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[30]) - (r * MAGIC[31])), z + ((r * MAGIC[31]) + (r * MAGIC[30]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[34]) - (r * MAGIC[84])), z + ((r * MAGIC[84]) + (r * MAGIC[34]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[36]) - (r * MAGIC[84])), z + ((r * MAGIC[84]) + (r * MAGIC[36]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[38]) - (r * MAGIC[31])), z + ((r * MAGIC[31]) + (r * MAGIC[38]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[37]) - (r * MAGIC[33])), z + ((r * MAGIC[33]) + (r * MAGIC[37]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[37]) - (r * MAGIC[66])), z + ((r * MAGIC[66]) + (r * MAGIC[37]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[38]) - (r * MAGIC[89])), z + ((r * MAGIC[89]) + (r * MAGIC[38]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[36]) - (r * MAGIC[35])), z + ((r * MAGIC[35]) + (r * MAGIC[36]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[34]) - (r * MAGIC[35])), z + ((r * MAGIC[35]) + (r * MAGIC[34]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[30]) - (r * MAGIC[89])), z + ((r * MAGIC[89]) + (r * MAGIC[30]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[32]) - (r * MAGIC[66])), z + ((r * MAGIC[66]) + (r * MAGIC[32]))))) * 0.028571429F;
    }

    private static float sc36(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[32]) - (r * MAGIC[33])), z + ((r * MAGIC[33]) + (r * MAGIC[32]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[30]) - (r * MAGIC[31])), z + ((r * MAGIC[31]) + (r * MAGIC[30]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[34]) - (r * MAGIC[84])), z + ((r * MAGIC[84]) + (r * MAGIC[34]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[36]) - (r * MAGIC[84])), z + ((r * MAGIC[84]) + (r * MAGIC[36]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[38]) - (r * MAGIC[31])), z + ((r * MAGIC[31]) + (r * MAGIC[38]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[37]) - (r * MAGIC[33])), z + ((r * MAGIC[33]) + (r * MAGIC[37]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[37]) - (r * MAGIC[66])), z + ((r * MAGIC[66]) + (r * MAGIC[37]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[38]) - (r * MAGIC[89])), z + ((r * MAGIC[89]) + (r * MAGIC[38]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[36]) - (r * MAGIC[35])), z + ((r * MAGIC[35]) + (r * MAGIC[36]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[34]) - (r * MAGIC[35])), z + ((r * MAGIC[35]) + (r * MAGIC[34]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[30]) - (r * MAGIC[89])), z + ((r * MAGIC[89]) + (r * MAGIC[30]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[32]) - (r * MAGIC[66])), z + ((r * MAGIC[66]) + (r * MAGIC[32]))))) * 0.027777778F;
    }

    private static float sc37(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[57]))))) * 0.027027028F;
    }

    private static float sc38(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[57]))))) * 0.02631579F;
    }

    private static float sc39(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[57]))))) * 0.025641026F;
    }

    private static float sc40(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[57]))))) * 0.025F;
    }

    private static float sc41(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[155])), z + ((r * MAGIC[155]) + (r * MAGIC[55]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[93])), z + ((r * MAGIC[93]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[41])), z + ((r * MAGIC[41]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[43])), z + ((r * MAGIC[43]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[82])), z + ((r * MAGIC[82]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[127])), z + ((r * MAGIC[127]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[47])), z + ((r * MAGIC[47]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[80])), z + ((r * MAGIC[80]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[87])), z + ((r * MAGIC[87]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[132])), z + ((r * MAGIC[132]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[91])), z + ((r * MAGIC[91]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[156])), z + ((r * MAGIC[156]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[52])), z + ((r * MAGIC[52]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[118])), z + ((r * MAGIC[118]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[86])), z + ((r * MAGIC[86]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[125])), z + ((r * MAGIC[125]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[117])), z + ((r * MAGIC[117]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[54])), z + ((r * MAGIC[54]) + (r * MAGIC[55]))))) * 0.024390243F;
    }

    private static float sc42(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[155])), z + ((r * MAGIC[155]) + (r * MAGIC[55]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[93])), z + ((r * MAGIC[93]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[41])), z + ((r * MAGIC[41]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[43])), z + ((r * MAGIC[43]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[82])), z + ((r * MAGIC[82]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[127])), z + ((r * MAGIC[127]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[47])), z + ((r * MAGIC[47]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[80])), z + ((r * MAGIC[80]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[87])), z + ((r * MAGIC[87]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[132])), z + ((r * MAGIC[132]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[91])), z + ((r * MAGIC[91]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[156])), z + ((r * MAGIC[156]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[52])), z + ((r * MAGIC[52]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[118])), z + ((r * MAGIC[118]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[86])), z + ((r * MAGIC[86]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[125])), z + ((r * MAGIC[125]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[117])), z + ((r * MAGIC[117]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[54])), z + ((r * MAGIC[54]) + (r * MAGIC[55]))))) * 0.023809524F;
    }

    private static float sc43(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[155])), z + ((r * MAGIC[155]) + (r * MAGIC[55]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[93])), z + ((r * MAGIC[93]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[41])), z + ((r * MAGIC[41]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[43])), z + ((r * MAGIC[43]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[82])), z + ((r * MAGIC[82]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[127])), z + ((r * MAGIC[127]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[47])), z + ((r * MAGIC[47]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[80])), z + ((r * MAGIC[80]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[87])), z + ((r * MAGIC[87]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[132])), z + ((r * MAGIC[132]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[91])), z + ((r * MAGIC[91]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[156])), z + ((r * MAGIC[156]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[52])), z + ((r * MAGIC[52]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[118])), z + ((r * MAGIC[118]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[86])), z + ((r * MAGIC[86]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[125])), z + ((r * MAGIC[125]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[117])), z + ((r * MAGIC[117]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[54])), z + ((r * MAGIC[54]) + (r * MAGIC[55]))))) * 0.023255814F;
    }

    private static float sc44(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[155])), z + ((r * MAGIC[155]) + (r * MAGIC[55]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[93])), z + ((r * MAGIC[93]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[41])), z + ((r * MAGIC[41]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[43])), z + ((r * MAGIC[43]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[82])), z + ((r * MAGIC[82]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[127])), z + ((r * MAGIC[127]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[47])), z + ((r * MAGIC[47]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[80])), z + ((r * MAGIC[80]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[87])), z + ((r * MAGIC[87]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[132])), z + ((r * MAGIC[132]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[91])), z + ((r * MAGIC[91]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[156])), z + ((r * MAGIC[156]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[52])), z + ((r * MAGIC[52]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[118])), z + ((r * MAGIC[118]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[86])), z + ((r * MAGIC[86]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[125])), z + ((r * MAGIC[125]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[117])), z + ((r * MAGIC[117]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[54])), z + ((r * MAGIC[54]) + (r * MAGIC[55]))))) * 0.022727273F;
    }

    private static float sc45(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[155])), z + ((r * MAGIC[155]) + (r * MAGIC[55]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[93])), z + ((r * MAGIC[93]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[41])), z + ((r * MAGIC[41]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[43])), z + ((r * MAGIC[43]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[82])), z + ((r * MAGIC[82]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[127])), z + ((r * MAGIC[127]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[47])), z + ((r * MAGIC[47]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[80])), z + ((r * MAGIC[80]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[87])), z + ((r * MAGIC[87]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[132])), z + ((r * MAGIC[132]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[91])), z + ((r * MAGIC[91]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[156])), z + ((r * MAGIC[156]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[52])), z + ((r * MAGIC[52]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[118])), z + ((r * MAGIC[118]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[86])), z + ((r * MAGIC[86]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[125])), z + ((r * MAGIC[125]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[117])), z + ((r * MAGIC[117]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[54])), z + ((r * MAGIC[54]) + (r * MAGIC[55]))))) * 0.022222223F;
    }

    private static float sc46(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[158]) - (r * MAGIC[157])), z + ((r * MAGIC[157]) + (r * MAGIC[158]))))
                + ((float) n.noise(x + ((r * MAGIC[127]) - (r * MAGIC[126])), z + ((r * MAGIC[126]) + (r * MAGIC[127]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[129]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[129]))))
                + ((float) n.noise(x + ((r * MAGIC[67]) - (r * MAGIC[147])), z + ((r * MAGIC[147]) + (r * MAGIC[67]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[159]) - (r * MAGIC[152])), z + ((r * MAGIC[152]) + (r * MAGIC[159]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[34]) - (r * MAGIC[84])), z + ((r * MAGIC[84]) + (r * MAGIC[34]))))
                + ((float) n.noise(x + ((r * MAGIC[133]) - (r * MAGIC[134])), z + ((r * MAGIC[134]) + (r * MAGIC[133]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[136]) - (r * MAGIC[135])), z + ((r * MAGIC[135]) + (r * MAGIC[136]))))
                + ((float) n.noise(x + ((r * MAGIC[54]) - (r * MAGIC[55])), z + ((r * MAGIC[55]) + (r * MAGIC[54]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[111]) - (r * MAGIC[110])), z + ((r * MAGIC[110]) + (r * MAGIC[111]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[161]) - (r * MAGIC[160])), z + ((r * MAGIC[160]) + (r * MAGIC[161]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[86]) - (r * MAGIC[44])), z + ((r * MAGIC[44]) + (r * MAGIC[86]))))
                + ((float) n.noise(x + ((r * MAGIC[119]) - (r * MAGIC[120])), z + ((r * MAGIC[120]) + (r * MAGIC[119]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[70]) - (r * MAGIC[69])), z + ((r * MAGIC[69]) + (r * MAGIC[70]))))
                + ((float) n.noise(x + ((r * MAGIC[118]) - (r * MAGIC[130])), z + ((r * MAGIC[130]) + (r * MAGIC[118]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[92]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[92]))))
                + ((float) n.noise(x + ((r * MAGIC[141]) - (r * MAGIC[142])), z + ((r * MAGIC[142]) + (r * MAGIC[141]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[138]) - (r * MAGIC[121])), z + ((r * MAGIC[121]) + (r * MAGIC[138]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[117]) - (r * MAGIC[116])), z + ((r * MAGIC[116]) + (r * MAGIC[117]))))
                + ((float) n.noise(x + ((r * MAGIC[163]) - (r * MAGIC[162])), z + ((r * MAGIC[162]) + (r * MAGIC[163]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[164]) - (r * MAGIC[140])), z + ((r * MAGIC[140]) + (r * MAGIC[164]))))
                + ((float) n.noise(x + ((r * MAGIC[132]) - (r * MAGIC[88])), z + ((r * MAGIC[88]) + (r * MAGIC[132]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[105]) - (r * MAGIC[150])), z + ((r * MAGIC[150]) + (r * MAGIC[105]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[166]) - (r * MAGIC[165])), z + ((r * MAGIC[165]) + (r * MAGIC[166]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[47]) - (r * MAGIC[48])), z + ((r * MAGIC[48]) + (r * MAGIC[47]))))
                + ((float) n.noise(x + ((r * MAGIC[148]) - (r * MAGIC[149])), z + ((r * MAGIC[149]) + (r * MAGIC[148]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[106]) - (r * MAGIC[151])), z + ((r * MAGIC[151]) + (r * MAGIC[106]))))
                + ((float) n.noise(x + ((r * MAGIC[32]) - (r * MAGIC[66])), z + ((r * MAGIC[66]) + (r * MAGIC[32]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[27]))))) * 0.02173913F;
    }

    private static float sc47(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[158]) - (r * MAGIC[157])), z + ((r * MAGIC[157]) + (r * MAGIC[158]))))
                + ((float) n.noise(x + ((r * MAGIC[127]) - (r * MAGIC[126])), z + ((r * MAGIC[126]) + (r * MAGIC[127]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[129]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[129]))))
                + ((float) n.noise(x + ((r * MAGIC[67]) - (r * MAGIC[147])), z + ((r * MAGIC[147]) + (r * MAGIC[67]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[159]) - (r * MAGIC[152])), z + ((r * MAGIC[152]) + (r * MAGIC[159]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[34]) - (r * MAGIC[84])), z + ((r * MAGIC[84]) + (r * MAGIC[34]))))
                + ((float) n.noise(x + ((r * MAGIC[133]) - (r * MAGIC[134])), z + ((r * MAGIC[134]) + (r * MAGIC[133]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[136]) - (r * MAGIC[135])), z + ((r * MAGIC[135]) + (r * MAGIC[136]))))
                + ((float) n.noise(x + ((r * MAGIC[54]) - (r * MAGIC[55])), z + ((r * MAGIC[55]) + (r * MAGIC[54]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[111]) - (r * MAGIC[110])), z + ((r * MAGIC[110]) + (r * MAGIC[111]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[161]) - (r * MAGIC[160])), z + ((r * MAGIC[160]) + (r * MAGIC[161]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[86]) - (r * MAGIC[44])), z + ((r * MAGIC[44]) + (r * MAGIC[86]))))
                + ((float) n.noise(x + ((r * MAGIC[119]) - (r * MAGIC[120])), z + ((r * MAGIC[120]) + (r * MAGIC[119]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[70]) - (r * MAGIC[69])), z + ((r * MAGIC[69]) + (r * MAGIC[70]))))
                + ((float) n.noise(x + ((r * MAGIC[118]) - (r * MAGIC[130])), z + ((r * MAGIC[130]) + (r * MAGIC[118]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[92]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[92]))))
                + ((float) n.noise(x + ((r * MAGIC[141]) - (r * MAGIC[142])), z + ((r * MAGIC[142]) + (r * MAGIC[141]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[138]) - (r * MAGIC[121])), z + ((r * MAGIC[121]) + (r * MAGIC[138]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[117]) - (r * MAGIC[116])), z + ((r * MAGIC[116]) + (r * MAGIC[117]))))
                + ((float) n.noise(x + ((r * MAGIC[163]) - (r * MAGIC[162])), z + ((r * MAGIC[162]) + (r * MAGIC[163]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[164]) - (r * MAGIC[140])), z + ((r * MAGIC[140]) + (r * MAGIC[164]))))
                + ((float) n.noise(x + ((r * MAGIC[132]) - (r * MAGIC[88])), z + ((r * MAGIC[88]) + (r * MAGIC[132]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[105]) - (r * MAGIC[150])), z + ((r * MAGIC[150]) + (r * MAGIC[105]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[166]) - (r * MAGIC[165])), z + ((r * MAGIC[165]) + (r * MAGIC[166]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[47]) - (r * MAGIC[48])), z + ((r * MAGIC[48]) + (r * MAGIC[47]))))
                + ((float) n.noise(x + ((r * MAGIC[148]) - (r * MAGIC[149])), z + ((r * MAGIC[149]) + (r * MAGIC[148]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[106]) - (r * MAGIC[151])), z + ((r * MAGIC[151]) + (r * MAGIC[106]))))
                + ((float) n.noise(x + ((r * MAGIC[32]) - (r * MAGIC[66])), z + ((r * MAGIC[66]) + (r * MAGIC[32]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[27]))))) * 0.021276595F;
    }

    private static float sc48(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[158]) - (r * MAGIC[157])), z + ((r * MAGIC[157]) + (r * MAGIC[158]))))
                + ((float) n.noise(x + ((r * MAGIC[127]) - (r * MAGIC[126])), z + ((r * MAGIC[126]) + (r * MAGIC[127]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[129]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[129]))))
                + ((float) n.noise(x + ((r * MAGIC[67]) - (r * MAGIC[147])), z + ((r * MAGIC[147]) + (r * MAGIC[67]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[159]) - (r * MAGIC[152])), z + ((r * MAGIC[152]) + (r * MAGIC[159]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[34]) - (r * MAGIC[84])), z + ((r * MAGIC[84]) + (r * MAGIC[34]))))
                + ((float) n.noise(x + ((r * MAGIC[133]) - (r * MAGIC[134])), z + ((r * MAGIC[134]) + (r * MAGIC[133]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[136]) - (r * MAGIC[135])), z + ((r * MAGIC[135]) + (r * MAGIC[136]))))
                + ((float) n.noise(x + ((r * MAGIC[54]) - (r * MAGIC[55])), z + ((r * MAGIC[55]) + (r * MAGIC[54]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[111]) - (r * MAGIC[110])), z + ((r * MAGIC[110]) + (r * MAGIC[111]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[161]) - (r * MAGIC[160])), z + ((r * MAGIC[160]) + (r * MAGIC[161]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[86]) - (r * MAGIC[44])), z + ((r * MAGIC[44]) + (r * MAGIC[86]))))
                + ((float) n.noise(x + ((r * MAGIC[119]) - (r * MAGIC[120])), z + ((r * MAGIC[120]) + (r * MAGIC[119]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[70]) - (r * MAGIC[69])), z + ((r * MAGIC[69]) + (r * MAGIC[70]))))
                + ((float) n.noise(x + ((r * MAGIC[118]) - (r * MAGIC[130])), z + ((r * MAGIC[130]) + (r * MAGIC[118]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[92]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[92]))))
                + ((float) n.noise(x + ((r * MAGIC[141]) - (r * MAGIC[142])), z + ((r * MAGIC[142]) + (r * MAGIC[141]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[138]) - (r * MAGIC[121])), z + ((r * MAGIC[121]) + (r * MAGIC[138]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[117]) - (r * MAGIC[116])), z + ((r * MAGIC[116]) + (r * MAGIC[117]))))
                + ((float) n.noise(x + ((r * MAGIC[163]) - (r * MAGIC[162])), z + ((r * MAGIC[162]) + (r * MAGIC[163]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[164]) - (r * MAGIC[140])), z + ((r * MAGIC[140]) + (r * MAGIC[164]))))
                + ((float) n.noise(x + ((r * MAGIC[132]) - (r * MAGIC[88])), z + ((r * MAGIC[88]) + (r * MAGIC[132]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[105]) - (r * MAGIC[150])), z + ((r * MAGIC[150]) + (r * MAGIC[105]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[166]) - (r * MAGIC[165])), z + ((r * MAGIC[165]) + (r * MAGIC[166]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[47]) - (r * MAGIC[48])), z + ((r * MAGIC[48]) + (r * MAGIC[47]))))
                + ((float) n.noise(x + ((r * MAGIC[148]) - (r * MAGIC[149])), z + ((r * MAGIC[149]) + (r * MAGIC[148]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[106]) - (r * MAGIC[151])), z + ((r * MAGIC[151]) + (r * MAGIC[106]))))
                + ((float) n.noise(x + ((r * MAGIC[32]) - (r * MAGIC[66])), z + ((r * MAGIC[66]) + (r * MAGIC[32]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[27]))))) * 0.020833334F;
    }

    private static float sc49(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[158]) - (r * MAGIC[157])), z + ((r * MAGIC[157]) + (r * MAGIC[158]))))
                + ((float) n.noise(x + ((r * MAGIC[127]) - (r * MAGIC[126])), z + ((r * MAGIC[126]) + (r * MAGIC[127]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[129]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[129]))))
                + ((float) n.noise(x + ((r * MAGIC[67]) - (r * MAGIC[147])), z + ((r * MAGIC[147]) + (r * MAGIC[67]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[159]) - (r * MAGIC[152])), z + ((r * MAGIC[152]) + (r * MAGIC[159]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[34]) - (r * MAGIC[84])), z + ((r * MAGIC[84]) + (r * MAGIC[34]))))
                + ((float) n.noise(x + ((r * MAGIC[133]) - (r * MAGIC[134])), z + ((r * MAGIC[134]) + (r * MAGIC[133]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[136]) - (r * MAGIC[135])), z + ((r * MAGIC[135]) + (r * MAGIC[136]))))
                + ((float) n.noise(x + ((r * MAGIC[54]) - (r * MAGIC[55])), z + ((r * MAGIC[55]) + (r * MAGIC[54]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[111]) - (r * MAGIC[110])), z + ((r * MAGIC[110]) + (r * MAGIC[111]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[161]) - (r * MAGIC[160])), z + ((r * MAGIC[160]) + (r * MAGIC[161]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[86]) - (r * MAGIC[44])), z + ((r * MAGIC[44]) + (r * MAGIC[86]))))
                + ((float) n.noise(x + ((r * MAGIC[119]) - (r * MAGIC[120])), z + ((r * MAGIC[120]) + (r * MAGIC[119]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[70]) - (r * MAGIC[69])), z + ((r * MAGIC[69]) + (r * MAGIC[70]))))
                + ((float) n.noise(x + ((r * MAGIC[118]) - (r * MAGIC[130])), z + ((r * MAGIC[130]) + (r * MAGIC[118]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[92]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[92]))))
                + ((float) n.noise(x + ((r * MAGIC[141]) - (r * MAGIC[142])), z + ((r * MAGIC[142]) + (r * MAGIC[141]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[138]) - (r * MAGIC[121])), z + ((r * MAGIC[121]) + (r * MAGIC[138]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[117]) - (r * MAGIC[116])), z + ((r * MAGIC[116]) + (r * MAGIC[117]))))
                + ((float) n.noise(x + ((r * MAGIC[163]) - (r * MAGIC[162])), z + ((r * MAGIC[162]) + (r * MAGIC[163]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[164]) - (r * MAGIC[140])), z + ((r * MAGIC[140]) + (r * MAGIC[164]))))
                + ((float) n.noise(x + ((r * MAGIC[132]) - (r * MAGIC[88])), z + ((r * MAGIC[88]) + (r * MAGIC[132]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[105]) - (r * MAGIC[150])), z + ((r * MAGIC[150]) + (r * MAGIC[105]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[166]) - (r * MAGIC[165])), z + ((r * MAGIC[165]) + (r * MAGIC[166]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[47]) - (r * MAGIC[48])), z + ((r * MAGIC[48]) + (r * MAGIC[47]))))
                + ((float) n.noise(x + ((r * MAGIC[148]) - (r * MAGIC[149])), z + ((r * MAGIC[149]) + (r * MAGIC[148]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[106]) - (r * MAGIC[151])), z + ((r * MAGIC[151]) + (r * MAGIC[106]))))
                + ((float) n.noise(x + ((r * MAGIC[32]) - (r * MAGIC[66])), z + ((r * MAGIC[66]) + (r * MAGIC[32]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[27]))))) * 0.020408163F;
    }

    private static float sc50(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[158]) - (r * MAGIC[157])), z + ((r * MAGIC[157]) + (r * MAGIC[158]))))
                + ((float) n.noise(x + ((r * MAGIC[127]) - (r * MAGIC[126])), z + ((r * MAGIC[126]) + (r * MAGIC[127]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[129]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[129]))))
                + ((float) n.noise(x + ((r * MAGIC[67]) - (r * MAGIC[147])), z + ((r * MAGIC[147]) + (r * MAGIC[67]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[159]) - (r * MAGIC[152])), z + ((r * MAGIC[152]) + (r * MAGIC[159]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[34]) - (r * MAGIC[84])), z + ((r * MAGIC[84]) + (r * MAGIC[34]))))
                + ((float) n.noise(x + ((r * MAGIC[133]) - (r * MAGIC[134])), z + ((r * MAGIC[134]) + (r * MAGIC[133]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[136]) - (r * MAGIC[135])), z + ((r * MAGIC[135]) + (r * MAGIC[136]))))
                + ((float) n.noise(x + ((r * MAGIC[54]) - (r * MAGIC[55])), z + ((r * MAGIC[55]) + (r * MAGIC[54]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[111]) - (r * MAGIC[110])), z + ((r * MAGIC[110]) + (r * MAGIC[111]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[161]) - (r * MAGIC[160])), z + ((r * MAGIC[160]) + (r * MAGIC[161]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[86]) - (r * MAGIC[44])), z + ((r * MAGIC[44]) + (r * MAGIC[86]))))
                + ((float) n.noise(x + ((r * MAGIC[119]) - (r * MAGIC[120])), z + ((r * MAGIC[120]) + (r * MAGIC[119]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[70]) - (r * MAGIC[69])), z + ((r * MAGIC[69]) + (r * MAGIC[70]))))
                + ((float) n.noise(x + ((r * MAGIC[118]) - (r * MAGIC[130])), z + ((r * MAGIC[130]) + (r * MAGIC[118]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[92]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[92]))))
                + ((float) n.noise(x + ((r * MAGIC[141]) - (r * MAGIC[142])), z + ((r * MAGIC[142]) + (r * MAGIC[141]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[138]) - (r * MAGIC[121])), z + ((r * MAGIC[121]) + (r * MAGIC[138]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[117]) - (r * MAGIC[116])), z + ((r * MAGIC[116]) + (r * MAGIC[117]))))
                + ((float) n.noise(x + ((r * MAGIC[163]) - (r * MAGIC[162])), z + ((r * MAGIC[162]) + (r * MAGIC[163]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[164]) - (r * MAGIC[140])), z + ((r * MAGIC[140]) + (r * MAGIC[164]))))
                + ((float) n.noise(x + ((r * MAGIC[132]) - (r * MAGIC[88])), z + ((r * MAGIC[88]) + (r * MAGIC[132]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[105]) - (r * MAGIC[150])), z + ((r * MAGIC[150]) + (r * MAGIC[105]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[166]) - (r * MAGIC[165])), z + ((r * MAGIC[165]) + (r * MAGIC[166]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[47]) - (r * MAGIC[48])), z + ((r * MAGIC[48]) + (r * MAGIC[47]))))
                + ((float) n.noise(x + ((r * MAGIC[148]) - (r * MAGIC[149])), z + ((r * MAGIC[149]) + (r * MAGIC[148]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[106]) - (r * MAGIC[151])), z + ((r * MAGIC[151]) + (r * MAGIC[106]))))
                + ((float) n.noise(x + ((r * MAGIC[32]) - (r * MAGIC[66])), z + ((r * MAGIC[66]) + (r * MAGIC[32]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[27]))))) * 0.02F;
    }

    private static float sc51(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[158]) - (r * MAGIC[157])), z + ((r * MAGIC[157]) + (r * MAGIC[158]))))
                + ((float) n.noise(x + ((r * MAGIC[127]) - (r * MAGIC[126])), z + ((r * MAGIC[126]) + (r * MAGIC[127]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[129]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[129]))))
                + ((float) n.noise(x + ((r * MAGIC[67]) - (r * MAGIC[147])), z + ((r * MAGIC[147]) + (r * MAGIC[67]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[159]) - (r * MAGIC[152])), z + ((r * MAGIC[152]) + (r * MAGIC[159]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[34]) - (r * MAGIC[84])), z + ((r * MAGIC[84]) + (r * MAGIC[34]))))
                + ((float) n.noise(x + ((r * MAGIC[133]) - (r * MAGIC[134])), z + ((r * MAGIC[134]) + (r * MAGIC[133]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[136]) - (r * MAGIC[135])), z + ((r * MAGIC[135]) + (r * MAGIC[136]))))
                + ((float) n.noise(x + ((r * MAGIC[54]) - (r * MAGIC[55])), z + ((r * MAGIC[55]) + (r * MAGIC[54]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[111]) - (r * MAGIC[110])), z + ((r * MAGIC[110]) + (r * MAGIC[111]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[161]) - (r * MAGIC[160])), z + ((r * MAGIC[160]) + (r * MAGIC[161]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[86]) - (r * MAGIC[44])), z + ((r * MAGIC[44]) + (r * MAGIC[86]))))
                + ((float) n.noise(x + ((r * MAGIC[119]) - (r * MAGIC[120])), z + ((r * MAGIC[120]) + (r * MAGIC[119]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[70]) - (r * MAGIC[69])), z + ((r * MAGIC[69]) + (r * MAGIC[70]))))
                + ((float) n.noise(x + ((r * MAGIC[118]) - (r * MAGIC[130])), z + ((r * MAGIC[130]) + (r * MAGIC[118]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[92]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[92]))))
                + ((float) n.noise(x + ((r * MAGIC[141]) - (r * MAGIC[142])), z + ((r * MAGIC[142]) + (r * MAGIC[141]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[138]) - (r * MAGIC[121])), z + ((r * MAGIC[121]) + (r * MAGIC[138]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[117]) - (r * MAGIC[116])), z + ((r * MAGIC[116]) + (r * MAGIC[117]))))
                + ((float) n.noise(x + ((r * MAGIC[163]) - (r * MAGIC[162])), z + ((r * MAGIC[162]) + (r * MAGIC[163]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[164]) - (r * MAGIC[140])), z + ((r * MAGIC[140]) + (r * MAGIC[164]))))
                + ((float) n.noise(x + ((r * MAGIC[132]) - (r * MAGIC[88])), z + ((r * MAGIC[88]) + (r * MAGIC[132]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[105]) - (r * MAGIC[150])), z + ((r * MAGIC[150]) + (r * MAGIC[105]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[166]) - (r * MAGIC[165])), z + ((r * MAGIC[165]) + (r * MAGIC[166]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[47]) - (r * MAGIC[48])), z + ((r * MAGIC[48]) + (r * MAGIC[47]))))
                + ((float) n.noise(x + ((r * MAGIC[148]) - (r * MAGIC[149])), z + ((r * MAGIC[149]) + (r * MAGIC[148]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[106]) - (r * MAGIC[151])), z + ((r * MAGIC[151]) + (r * MAGIC[106]))))
                + ((float) n.noise(x + ((r * MAGIC[32]) - (r * MAGIC[66])), z + ((r * MAGIC[66]) + (r * MAGIC[32]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[27]))))) * 0.019607844F;
    }

    private static float sc52(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[45]))))) * 0.01923077F;
    }

    private static float sc53(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[45]))))) * 0.018867925F;
    }

    private static float sc54(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[45]))))) * 0.018518519F;
    }

    private static float sc55(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[45]))))) * 0.018181818F;
    }

    private static float sc56(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[45]))))) * 0.017857144F;
    }

    private static float sc57(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[45]))))) * 0.01754386F;
    }

    private static float sc58(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[45]))))) * 0.01724138F;
    }

    private static float sc59(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[45]))))) * 0.016949153F;
    }

    private static float sc60(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[45]))))) * 0.016666668F;
    }

    private static float sc61(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[109]) - (r * MAGIC[69])), z + ((r * MAGIC[69]) + (r * MAGIC[109]))))
                + ((float) n.noise(x + ((r * MAGIC[32]) - (r * MAGIC[33])), z + ((r * MAGIC[33]) + (r * MAGIC[32]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[63]) - (r * MAGIC[62])), z + ((r * MAGIC[62]) + (r * MAGIC[63]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[67]) - (r * MAGIC[147])), z + ((r * MAGIC[147]) + (r * MAGIC[67]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[30]) - (r * MAGIC[31])), z + ((r * MAGIC[31]) + (r * MAGIC[30]))))
                + ((float) n.noise(x + ((r * MAGIC[147]) - (r * MAGIC[67])), z + ((r * MAGIC[67]) + (r * MAGIC[147]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[62]) - (r * MAGIC[63])), z + ((r * MAGIC[63]) + (r * MAGIC[62]))))
                + ((float) n.noise(x + ((r * MAGIC[34]) - (r * MAGIC[84])), z + ((r * MAGIC[84]) + (r * MAGIC[34]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[69]) - (r * MAGIC[109])), z + ((r * MAGIC[109]) + (r * MAGIC[69]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[167]) - (r * MAGIC[109])), z + ((r * MAGIC[109]) + (r * MAGIC[167]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[36]) - (r * MAGIC[84])), z + ((r * MAGIC[84]) + (r * MAGIC[36]))))
                + ((float) n.noise(x + ((r * MAGIC[163]) - (r * MAGIC[63])), z + ((r * MAGIC[63]) + (r * MAGIC[163]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[68]) - (r * MAGIC[67])), z + ((r * MAGIC[67]) + (r * MAGIC[68]))))
                + ((float) n.noise(x + ((r * MAGIC[38]) - (r * MAGIC[31])), z + ((r * MAGIC[31]) + (r * MAGIC[38]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[168]) - (r * MAGIC[147])), z + ((r * MAGIC[147]) + (r * MAGIC[168]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[162]) - (r * MAGIC[62])), z + ((r * MAGIC[62]) + (r * MAGIC[162]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[37]) - (r * MAGIC[33])), z + ((r * MAGIC[33]) + (r * MAGIC[37]))))
                + ((float) n.noise(x + ((r * MAGIC[70]) - (r * MAGIC[69])), z + ((r * MAGIC[69]) + (r * MAGIC[70]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[70]) - (r * MAGIC[167])), z + ((r * MAGIC[167]) + (r * MAGIC[70]))))
                + ((float) n.noise(x + ((r * MAGIC[37]) - (r * MAGIC[66])), z + ((r * MAGIC[66]) + (r * MAGIC[37]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[162]) - (r * MAGIC[163])), z + ((r * MAGIC[163]) + (r * MAGIC[162]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[168]) - (r * MAGIC[68])), z + ((r * MAGIC[68]) + (r * MAGIC[168]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[38]) - (r * MAGIC[89])), z + ((r * MAGIC[89]) + (r * MAGIC[38]))))
                + ((float) n.noise(x + ((r * MAGIC[68]) - (r * MAGIC[168])), z + ((r * MAGIC[168]) + (r * MAGIC[68]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[163]) - (r * MAGIC[162])), z + ((r * MAGIC[162]) + (r * MAGIC[163]))))
                + ((float) n.noise(x + ((r * MAGIC[36]) - (r * MAGIC[35])), z + ((r * MAGIC[35]) + (r * MAGIC[36]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[167]) - (r * MAGIC[70])), z + ((r * MAGIC[70]) + (r * MAGIC[167]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[69]) - (r * MAGIC[70])), z + ((r * MAGIC[70]) + (r * MAGIC[69]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[34]) - (r * MAGIC[35])), z + ((r * MAGIC[35]) + (r * MAGIC[34]))))
                + ((float) n.noise(x + ((r * MAGIC[62]) - (r * MAGIC[162])), z + ((r * MAGIC[162]) + (r * MAGIC[62]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[147]) - (r * MAGIC[168])), z + ((r * MAGIC[168]) + (r * MAGIC[147]))))
                + ((float) n.noise(x + ((r * MAGIC[30]) - (r * MAGIC[89])), z + ((r * MAGIC[89]) + (r * MAGIC[30]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[67]) - (r * MAGIC[68])), z + ((r * MAGIC[68]) + (r * MAGIC[67]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[63]) - (r * MAGIC[163])), z + ((r * MAGIC[163]) + (r * MAGIC[63]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[32]) - (r * MAGIC[66])), z + ((r * MAGIC[66]) + (r * MAGIC[32]))))
                + ((float) n.noise(x + ((r * MAGIC[109]) - (r * MAGIC[167])), z + ((r * MAGIC[167]) + (r * MAGIC[109]))))) * 0.016393442F;
    }

    private static float sc62(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[109]) - (r * MAGIC[69])), z + ((r * MAGIC[69]) + (r * MAGIC[109]))))
                + ((float) n.noise(x + ((r * MAGIC[32]) - (r * MAGIC[33])), z + ((r * MAGIC[33]) + (r * MAGIC[32]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[63]) - (r * MAGIC[62])), z + ((r * MAGIC[62]) + (r * MAGIC[63]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[67]) - (r * MAGIC[147])), z + ((r * MAGIC[147]) + (r * MAGIC[67]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[30]) - (r * MAGIC[31])), z + ((r * MAGIC[31]) + (r * MAGIC[30]))))
                + ((float) n.noise(x + ((r * MAGIC[147]) - (r * MAGIC[67])), z + ((r * MAGIC[67]) + (r * MAGIC[147]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[62]) - (r * MAGIC[63])), z + ((r * MAGIC[63]) + (r * MAGIC[62]))))
                + ((float) n.noise(x + ((r * MAGIC[34]) - (r * MAGIC[84])), z + ((r * MAGIC[84]) + (r * MAGIC[34]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[69]) - (r * MAGIC[109])), z + ((r * MAGIC[109]) + (r * MAGIC[69]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[167]) - (r * MAGIC[109])), z + ((r * MAGIC[109]) + (r * MAGIC[167]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[36]) - (r * MAGIC[84])), z + ((r * MAGIC[84]) + (r * MAGIC[36]))))
                + ((float) n.noise(x + ((r * MAGIC[163]) - (r * MAGIC[63])), z + ((r * MAGIC[63]) + (r * MAGIC[163]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[68]) - (r * MAGIC[67])), z + ((r * MAGIC[67]) + (r * MAGIC[68]))))
                + ((float) n.noise(x + ((r * MAGIC[38]) - (r * MAGIC[31])), z + ((r * MAGIC[31]) + (r * MAGIC[38]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[168]) - (r * MAGIC[147])), z + ((r * MAGIC[147]) + (r * MAGIC[168]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[162]) - (r * MAGIC[62])), z + ((r * MAGIC[62]) + (r * MAGIC[162]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[37]) - (r * MAGIC[33])), z + ((r * MAGIC[33]) + (r * MAGIC[37]))))
                + ((float) n.noise(x + ((r * MAGIC[70]) - (r * MAGIC[69])), z + ((r * MAGIC[69]) + (r * MAGIC[70]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[70]) - (r * MAGIC[167])), z + ((r * MAGIC[167]) + (r * MAGIC[70]))))
                + ((float) n.noise(x + ((r * MAGIC[37]) - (r * MAGIC[66])), z + ((r * MAGIC[66]) + (r * MAGIC[37]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[162]) - (r * MAGIC[163])), z + ((r * MAGIC[163]) + (r * MAGIC[162]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[168]) - (r * MAGIC[68])), z + ((r * MAGIC[68]) + (r * MAGIC[168]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[38]) - (r * MAGIC[89])), z + ((r * MAGIC[89]) + (r * MAGIC[38]))))
                + ((float) n.noise(x + ((r * MAGIC[68]) - (r * MAGIC[168])), z + ((r * MAGIC[168]) + (r * MAGIC[68]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[163]) - (r * MAGIC[162])), z + ((r * MAGIC[162]) + (r * MAGIC[163]))))
                + ((float) n.noise(x + ((r * MAGIC[36]) - (r * MAGIC[35])), z + ((r * MAGIC[35]) + (r * MAGIC[36]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[167]) - (r * MAGIC[70])), z + ((r * MAGIC[70]) + (r * MAGIC[167]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[69]) - (r * MAGIC[70])), z + ((r * MAGIC[70]) + (r * MAGIC[69]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[34]) - (r * MAGIC[35])), z + ((r * MAGIC[35]) + (r * MAGIC[34]))))
                + ((float) n.noise(x + ((r * MAGIC[62]) - (r * MAGIC[162])), z + ((r * MAGIC[162]) + (r * MAGIC[62]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[147]) - (r * MAGIC[168])), z + ((r * MAGIC[168]) + (r * MAGIC[147]))))
                + ((float) n.noise(x + ((r * MAGIC[30]) - (r * MAGIC[89])), z + ((r * MAGIC[89]) + (r * MAGIC[30]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[67]) - (r * MAGIC[68])), z + ((r * MAGIC[68]) + (r * MAGIC[67]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[63]) - (r * MAGIC[163])), z + ((r * MAGIC[163]) + (r * MAGIC[63]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[32]) - (r * MAGIC[66])), z + ((r * MAGIC[66]) + (r * MAGIC[32]))))
                + ((float) n.noise(x + ((r * MAGIC[109]) - (r * MAGIC[167])), z + ((r * MAGIC[167]) + (r * MAGIC[109]))))) * 0.016129032F;
    }

    private static float sc63(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[109]) - (r * MAGIC[69])), z + ((r * MAGIC[69]) + (r * MAGIC[109]))))
                + ((float) n.noise(x + ((r * MAGIC[32]) - (r * MAGIC[33])), z + ((r * MAGIC[33]) + (r * MAGIC[32]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[63]) - (r * MAGIC[62])), z + ((r * MAGIC[62]) + (r * MAGIC[63]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[67]) - (r * MAGIC[147])), z + ((r * MAGIC[147]) + (r * MAGIC[67]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[30]) - (r * MAGIC[31])), z + ((r * MAGIC[31]) + (r * MAGIC[30]))))
                + ((float) n.noise(x + ((r * MAGIC[147]) - (r * MAGIC[67])), z + ((r * MAGIC[67]) + (r * MAGIC[147]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[62]) - (r * MAGIC[63])), z + ((r * MAGIC[63]) + (r * MAGIC[62]))))
                + ((float) n.noise(x + ((r * MAGIC[34]) - (r * MAGIC[84])), z + ((r * MAGIC[84]) + (r * MAGIC[34]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[69]) - (r * MAGIC[109])), z + ((r * MAGIC[109]) + (r * MAGIC[69]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[167]) - (r * MAGIC[109])), z + ((r * MAGIC[109]) + (r * MAGIC[167]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[36]) - (r * MAGIC[84])), z + ((r * MAGIC[84]) + (r * MAGIC[36]))))
                + ((float) n.noise(x + ((r * MAGIC[163]) - (r * MAGIC[63])), z + ((r * MAGIC[63]) + (r * MAGIC[163]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[68]) - (r * MAGIC[67])), z + ((r * MAGIC[67]) + (r * MAGIC[68]))))
                + ((float) n.noise(x + ((r * MAGIC[38]) - (r * MAGIC[31])), z + ((r * MAGIC[31]) + (r * MAGIC[38]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[168]) - (r * MAGIC[147])), z + ((r * MAGIC[147]) + (r * MAGIC[168]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[162]) - (r * MAGIC[62])), z + ((r * MAGIC[62]) + (r * MAGIC[162]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[37]) - (r * MAGIC[33])), z + ((r * MAGIC[33]) + (r * MAGIC[37]))))
                + ((float) n.noise(x + ((r * MAGIC[70]) - (r * MAGIC[69])), z + ((r * MAGIC[69]) + (r * MAGIC[70]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[70]) - (r * MAGIC[167])), z + ((r * MAGIC[167]) + (r * MAGIC[70]))))
                + ((float) n.noise(x + ((r * MAGIC[37]) - (r * MAGIC[66])), z + ((r * MAGIC[66]) + (r * MAGIC[37]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[162]) - (r * MAGIC[163])), z + ((r * MAGIC[163]) + (r * MAGIC[162]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[168]) - (r * MAGIC[68])), z + ((r * MAGIC[68]) + (r * MAGIC[168]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[38]) - (r * MAGIC[89])), z + ((r * MAGIC[89]) + (r * MAGIC[38]))))
                + ((float) n.noise(x + ((r * MAGIC[68]) - (r * MAGIC[168])), z + ((r * MAGIC[168]) + (r * MAGIC[68]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[163]) - (r * MAGIC[162])), z + ((r * MAGIC[162]) + (r * MAGIC[163]))))
                + ((float) n.noise(x + ((r * MAGIC[36]) - (r * MAGIC[35])), z + ((r * MAGIC[35]) + (r * MAGIC[36]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[167]) - (r * MAGIC[70])), z + ((r * MAGIC[70]) + (r * MAGIC[167]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[69]) - (r * MAGIC[70])), z + ((r * MAGIC[70]) + (r * MAGIC[69]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[34]) - (r * MAGIC[35])), z + ((r * MAGIC[35]) + (r * MAGIC[34]))))
                + ((float) n.noise(x + ((r * MAGIC[62]) - (r * MAGIC[162])), z + ((r * MAGIC[162]) + (r * MAGIC[62]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[147]) - (r * MAGIC[168])), z + ((r * MAGIC[168]) + (r * MAGIC[147]))))
                + ((float) n.noise(x + ((r * MAGIC[30]) - (r * MAGIC[89])), z + ((r * MAGIC[89]) + (r * MAGIC[30]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[67]) - (r * MAGIC[68])), z + ((r * MAGIC[68]) + (r * MAGIC[67]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[63]) - (r * MAGIC[163])), z + ((r * MAGIC[163]) + (r * MAGIC[63]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[32]) - (r * MAGIC[66])), z + ((r * MAGIC[66]) + (r * MAGIC[32]))))
                + ((float) n.noise(x + ((r * MAGIC[109]) - (r * MAGIC[167])), z + ((r * MAGIC[167]) + (r * MAGIC[109]))))) * 0.015873017F;
    }

    private static float sc64(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[109]) - (r * MAGIC[69])), z + ((r * MAGIC[69]) + (r * MAGIC[109]))))
                + ((float) n.noise(x + ((r * MAGIC[32]) - (r * MAGIC[33])), z + ((r * MAGIC[33]) + (r * MAGIC[32]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[63]) - (r * MAGIC[62])), z + ((r * MAGIC[62]) + (r * MAGIC[63]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[67]) - (r * MAGIC[147])), z + ((r * MAGIC[147]) + (r * MAGIC[67]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[30]) - (r * MAGIC[31])), z + ((r * MAGIC[31]) + (r * MAGIC[30]))))
                + ((float) n.noise(x + ((r * MAGIC[147]) - (r * MAGIC[67])), z + ((r * MAGIC[67]) + (r * MAGIC[147]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[62]) - (r * MAGIC[63])), z + ((r * MAGIC[63]) + (r * MAGIC[62]))))
                + ((float) n.noise(x + ((r * MAGIC[34]) - (r * MAGIC[84])), z + ((r * MAGIC[84]) + (r * MAGIC[34]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[69]) - (r * MAGIC[109])), z + ((r * MAGIC[109]) + (r * MAGIC[69]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[167]) - (r * MAGIC[109])), z + ((r * MAGIC[109]) + (r * MAGIC[167]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[36]) - (r * MAGIC[84])), z + ((r * MAGIC[84]) + (r * MAGIC[36]))))
                + ((float) n.noise(x + ((r * MAGIC[163]) - (r * MAGIC[63])), z + ((r * MAGIC[63]) + (r * MAGIC[163]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[68]) - (r * MAGIC[67])), z + ((r * MAGIC[67]) + (r * MAGIC[68]))))
                + ((float) n.noise(x + ((r * MAGIC[38]) - (r * MAGIC[31])), z + ((r * MAGIC[31]) + (r * MAGIC[38]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[168]) - (r * MAGIC[147])), z + ((r * MAGIC[147]) + (r * MAGIC[168]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[162]) - (r * MAGIC[62])), z + ((r * MAGIC[62]) + (r * MAGIC[162]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[37]) - (r * MAGIC[33])), z + ((r * MAGIC[33]) + (r * MAGIC[37]))))
                + ((float) n.noise(x + ((r * MAGIC[70]) - (r * MAGIC[69])), z + ((r * MAGIC[69]) + (r * MAGIC[70]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[70]) - (r * MAGIC[167])), z + ((r * MAGIC[167]) + (r * MAGIC[70]))))
                + ((float) n.noise(x + ((r * MAGIC[37]) - (r * MAGIC[66])), z + ((r * MAGIC[66]) + (r * MAGIC[37]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[162]) - (r * MAGIC[163])), z + ((r * MAGIC[163]) + (r * MAGIC[162]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[168]) - (r * MAGIC[68])), z + ((r * MAGIC[68]) + (r * MAGIC[168]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[38]) - (r * MAGIC[89])), z + ((r * MAGIC[89]) + (r * MAGIC[38]))))
                + ((float) n.noise(x + ((r * MAGIC[68]) - (r * MAGIC[168])), z + ((r * MAGIC[168]) + (r * MAGIC[68]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[163]) - (r * MAGIC[162])), z + ((r * MAGIC[162]) + (r * MAGIC[163]))))
                + ((float) n.noise(x + ((r * MAGIC[36]) - (r * MAGIC[35])), z + ((r * MAGIC[35]) + (r * MAGIC[36]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[167]) - (r * MAGIC[70])), z + ((r * MAGIC[70]) + (r * MAGIC[167]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[69]) - (r * MAGIC[70])), z + ((r * MAGIC[70]) + (r * MAGIC[69]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[34]) - (r * MAGIC[35])), z + ((r * MAGIC[35]) + (r * MAGIC[34]))))
                + ((float) n.noise(x + ((r * MAGIC[62]) - (r * MAGIC[162])), z + ((r * MAGIC[162]) + (r * MAGIC[62]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[147]) - (r * MAGIC[168])), z + ((r * MAGIC[168]) + (r * MAGIC[147]))))
                + ((float) n.noise(x + ((r * MAGIC[30]) - (r * MAGIC[89])), z + ((r * MAGIC[89]) + (r * MAGIC[30]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[67]) - (r * MAGIC[68])), z + ((r * MAGIC[68]) + (r * MAGIC[67]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[63]) - (r * MAGIC[163])), z + ((r * MAGIC[163]) + (r * MAGIC[63]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[32]) - (r * MAGIC[66])), z + ((r * MAGIC[66]) + (r * MAGIC[32]))))
                + ((float) n.noise(x + ((r * MAGIC[109]) - (r * MAGIC[167])), z + ((r * MAGIC[167]) + (r * MAGIC[109]))))) * 0.015625F;
    }

    private static float sc65(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[109]) - (r * MAGIC[69])), z + ((r * MAGIC[69]) + (r * MAGIC[109]))))
                + ((float) n.noise(x + ((r * MAGIC[32]) - (r * MAGIC[33])), z + ((r * MAGIC[33]) + (r * MAGIC[32]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[63]) - (r * MAGIC[62])), z + ((r * MAGIC[62]) + (r * MAGIC[63]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[67]) - (r * MAGIC[147])), z + ((r * MAGIC[147]) + (r * MAGIC[67]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[30]) - (r * MAGIC[31])), z + ((r * MAGIC[31]) + (r * MAGIC[30]))))
                + ((float) n.noise(x + ((r * MAGIC[147]) - (r * MAGIC[67])), z + ((r * MAGIC[67]) + (r * MAGIC[147]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[62]) - (r * MAGIC[63])), z + ((r * MAGIC[63]) + (r * MAGIC[62]))))
                + ((float) n.noise(x + ((r * MAGIC[34]) - (r * MAGIC[84])), z + ((r * MAGIC[84]) + (r * MAGIC[34]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[69]) - (r * MAGIC[109])), z + ((r * MAGIC[109]) + (r * MAGIC[69]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[167]) - (r * MAGIC[109])), z + ((r * MAGIC[109]) + (r * MAGIC[167]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[36]) - (r * MAGIC[84])), z + ((r * MAGIC[84]) + (r * MAGIC[36]))))
                + ((float) n.noise(x + ((r * MAGIC[163]) - (r * MAGIC[63])), z + ((r * MAGIC[63]) + (r * MAGIC[163]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[68]) - (r * MAGIC[67])), z + ((r * MAGIC[67]) + (r * MAGIC[68]))))
                + ((float) n.noise(x + ((r * MAGIC[38]) - (r * MAGIC[31])), z + ((r * MAGIC[31]) + (r * MAGIC[38]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[168]) - (r * MAGIC[147])), z + ((r * MAGIC[147]) + (r * MAGIC[168]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[162]) - (r * MAGIC[62])), z + ((r * MAGIC[62]) + (r * MAGIC[162]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[37]) - (r * MAGIC[33])), z + ((r * MAGIC[33]) + (r * MAGIC[37]))))
                + ((float) n.noise(x + ((r * MAGIC[70]) - (r * MAGIC[69])), z + ((r * MAGIC[69]) + (r * MAGIC[70]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[70]) - (r * MAGIC[167])), z + ((r * MAGIC[167]) + (r * MAGIC[70]))))
                + ((float) n.noise(x + ((r * MAGIC[37]) - (r * MAGIC[66])), z + ((r * MAGIC[66]) + (r * MAGIC[37]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[162]) - (r * MAGIC[163])), z + ((r * MAGIC[163]) + (r * MAGIC[162]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[168]) - (r * MAGIC[68])), z + ((r * MAGIC[68]) + (r * MAGIC[168]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[38]) - (r * MAGIC[89])), z + ((r * MAGIC[89]) + (r * MAGIC[38]))))
                + ((float) n.noise(x + ((r * MAGIC[68]) - (r * MAGIC[168])), z + ((r * MAGIC[168]) + (r * MAGIC[68]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[163]) - (r * MAGIC[162])), z + ((r * MAGIC[162]) + (r * MAGIC[163]))))
                + ((float) n.noise(x + ((r * MAGIC[36]) - (r * MAGIC[35])), z + ((r * MAGIC[35]) + (r * MAGIC[36]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[167]) - (r * MAGIC[70])), z + ((r * MAGIC[70]) + (r * MAGIC[167]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[69]) - (r * MAGIC[70])), z + ((r * MAGIC[70]) + (r * MAGIC[69]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[34]) - (r * MAGIC[35])), z + ((r * MAGIC[35]) + (r * MAGIC[34]))))
                + ((float) n.noise(x + ((r * MAGIC[62]) - (r * MAGIC[162])), z + ((r * MAGIC[162]) + (r * MAGIC[62]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[147]) - (r * MAGIC[168])), z + ((r * MAGIC[168]) + (r * MAGIC[147]))))
                + ((float) n.noise(x + ((r * MAGIC[30]) - (r * MAGIC[89])), z + ((r * MAGIC[89]) + (r * MAGIC[30]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[67]) - (r * MAGIC[68])), z + ((r * MAGIC[68]) + (r * MAGIC[67]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[63]) - (r * MAGIC[163])), z + ((r * MAGIC[163]) + (r * MAGIC[63]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[32]) - (r * MAGIC[66])), z + ((r * MAGIC[66]) + (r * MAGIC[32]))))
                + ((float) n.noise(x + ((r * MAGIC[109]) - (r * MAGIC[167])), z + ((r * MAGIC[167]) + (r * MAGIC[109]))))) * 0.015384615F;
    }

    private static float sc66(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[109]) - (r * MAGIC[69])), z + ((r * MAGIC[69]) + (r * MAGIC[109]))))
                + ((float) n.noise(x + ((r * MAGIC[32]) - (r * MAGIC[33])), z + ((r * MAGIC[33]) + (r * MAGIC[32]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[63]) - (r * MAGIC[62])), z + ((r * MAGIC[62]) + (r * MAGIC[63]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[67]) - (r * MAGIC[147])), z + ((r * MAGIC[147]) + (r * MAGIC[67]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[30]) - (r * MAGIC[31])), z + ((r * MAGIC[31]) + (r * MAGIC[30]))))
                + ((float) n.noise(x + ((r * MAGIC[147]) - (r * MAGIC[67])), z + ((r * MAGIC[67]) + (r * MAGIC[147]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[62]) - (r * MAGIC[63])), z + ((r * MAGIC[63]) + (r * MAGIC[62]))))
                + ((float) n.noise(x + ((r * MAGIC[34]) - (r * MAGIC[84])), z + ((r * MAGIC[84]) + (r * MAGIC[34]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[69]) - (r * MAGIC[109])), z + ((r * MAGIC[109]) + (r * MAGIC[69]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[167]) - (r * MAGIC[109])), z + ((r * MAGIC[109]) + (r * MAGIC[167]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[36]) - (r * MAGIC[84])), z + ((r * MAGIC[84]) + (r * MAGIC[36]))))
                + ((float) n.noise(x + ((r * MAGIC[163]) - (r * MAGIC[63])), z + ((r * MAGIC[63]) + (r * MAGIC[163]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[68]) - (r * MAGIC[67])), z + ((r * MAGIC[67]) + (r * MAGIC[68]))))
                + ((float) n.noise(x + ((r * MAGIC[38]) - (r * MAGIC[31])), z + ((r * MAGIC[31]) + (r * MAGIC[38]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[168]) - (r * MAGIC[147])), z + ((r * MAGIC[147]) + (r * MAGIC[168]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[162]) - (r * MAGIC[62])), z + ((r * MAGIC[62]) + (r * MAGIC[162]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[37]) - (r * MAGIC[33])), z + ((r * MAGIC[33]) + (r * MAGIC[37]))))
                + ((float) n.noise(x + ((r * MAGIC[70]) - (r * MAGIC[69])), z + ((r * MAGIC[69]) + (r * MAGIC[70]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[70]) - (r * MAGIC[167])), z + ((r * MAGIC[167]) + (r * MAGIC[70]))))
                + ((float) n.noise(x + ((r * MAGIC[37]) - (r * MAGIC[66])), z + ((r * MAGIC[66]) + (r * MAGIC[37]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[162]) - (r * MAGIC[163])), z + ((r * MAGIC[163]) + (r * MAGIC[162]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[168]) - (r * MAGIC[68])), z + ((r * MAGIC[68]) + (r * MAGIC[168]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[38]) - (r * MAGIC[89])), z + ((r * MAGIC[89]) + (r * MAGIC[38]))))
                + ((float) n.noise(x + ((r * MAGIC[68]) - (r * MAGIC[168])), z + ((r * MAGIC[168]) + (r * MAGIC[68]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[163]) - (r * MAGIC[162])), z + ((r * MAGIC[162]) + (r * MAGIC[163]))))
                + ((float) n.noise(x + ((r * MAGIC[36]) - (r * MAGIC[35])), z + ((r * MAGIC[35]) + (r * MAGIC[36]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[167]) - (r * MAGIC[70])), z + ((r * MAGIC[70]) + (r * MAGIC[167]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[69]) - (r * MAGIC[70])), z + ((r * MAGIC[70]) + (r * MAGIC[69]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[34]) - (r * MAGIC[35])), z + ((r * MAGIC[35]) + (r * MAGIC[34]))))
                + ((float) n.noise(x + ((r * MAGIC[62]) - (r * MAGIC[162])), z + ((r * MAGIC[162]) + (r * MAGIC[62]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[147]) - (r * MAGIC[168])), z + ((r * MAGIC[168]) + (r * MAGIC[147]))))
                + ((float) n.noise(x + ((r * MAGIC[30]) - (r * MAGIC[89])), z + ((r * MAGIC[89]) + (r * MAGIC[30]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[67]) - (r * MAGIC[68])), z + ((r * MAGIC[68]) + (r * MAGIC[67]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[63]) - (r * MAGIC[163])), z + ((r * MAGIC[163]) + (r * MAGIC[63]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[32]) - (r * MAGIC[66])), z + ((r * MAGIC[66]) + (r * MAGIC[32]))))
                + ((float) n.noise(x + ((r * MAGIC[109]) - (r * MAGIC[167])), z + ((r * MAGIC[167]) + (r * MAGIC[109]))))) * 0.015151516F;
    }

    private static float sc67(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[109]) - (r * MAGIC[69])), z + ((r * MAGIC[69]) + (r * MAGIC[109]))))
                + ((float) n.noise(x + ((r * MAGIC[32]) - (r * MAGIC[33])), z + ((r * MAGIC[33]) + (r * MAGIC[32]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[63]) - (r * MAGIC[62])), z + ((r * MAGIC[62]) + (r * MAGIC[63]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[67]) - (r * MAGIC[147])), z + ((r * MAGIC[147]) + (r * MAGIC[67]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[30]) - (r * MAGIC[31])), z + ((r * MAGIC[31]) + (r * MAGIC[30]))))
                + ((float) n.noise(x + ((r * MAGIC[147]) - (r * MAGIC[67])), z + ((r * MAGIC[67]) + (r * MAGIC[147]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[62]) - (r * MAGIC[63])), z + ((r * MAGIC[63]) + (r * MAGIC[62]))))
                + ((float) n.noise(x + ((r * MAGIC[34]) - (r * MAGIC[84])), z + ((r * MAGIC[84]) + (r * MAGIC[34]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[69]) - (r * MAGIC[109])), z + ((r * MAGIC[109]) + (r * MAGIC[69]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[167]) - (r * MAGIC[109])), z + ((r * MAGIC[109]) + (r * MAGIC[167]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[36]) - (r * MAGIC[84])), z + ((r * MAGIC[84]) + (r * MAGIC[36]))))
                + ((float) n.noise(x + ((r * MAGIC[163]) - (r * MAGIC[63])), z + ((r * MAGIC[63]) + (r * MAGIC[163]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[68]) - (r * MAGIC[67])), z + ((r * MAGIC[67]) + (r * MAGIC[68]))))
                + ((float) n.noise(x + ((r * MAGIC[38]) - (r * MAGIC[31])), z + ((r * MAGIC[31]) + (r * MAGIC[38]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[168]) - (r * MAGIC[147])), z + ((r * MAGIC[147]) + (r * MAGIC[168]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[162]) - (r * MAGIC[62])), z + ((r * MAGIC[62]) + (r * MAGIC[162]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[37]) - (r * MAGIC[33])), z + ((r * MAGIC[33]) + (r * MAGIC[37]))))
                + ((float) n.noise(x + ((r * MAGIC[70]) - (r * MAGIC[69])), z + ((r * MAGIC[69]) + (r * MAGIC[70]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[70]) - (r * MAGIC[167])), z + ((r * MAGIC[167]) + (r * MAGIC[70]))))
                + ((float) n.noise(x + ((r * MAGIC[37]) - (r * MAGIC[66])), z + ((r * MAGIC[66]) + (r * MAGIC[37]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[162]) - (r * MAGIC[163])), z + ((r * MAGIC[163]) + (r * MAGIC[162]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[168]) - (r * MAGIC[68])), z + ((r * MAGIC[68]) + (r * MAGIC[168]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[38]) - (r * MAGIC[89])), z + ((r * MAGIC[89]) + (r * MAGIC[38]))))
                + ((float) n.noise(x + ((r * MAGIC[68]) - (r * MAGIC[168])), z + ((r * MAGIC[168]) + (r * MAGIC[68]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[163]) - (r * MAGIC[162])), z + ((r * MAGIC[162]) + (r * MAGIC[163]))))
                + ((float) n.noise(x + ((r * MAGIC[36]) - (r * MAGIC[35])), z + ((r * MAGIC[35]) + (r * MAGIC[36]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[167]) - (r * MAGIC[70])), z + ((r * MAGIC[70]) + (r * MAGIC[167]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[69]) - (r * MAGIC[70])), z + ((r * MAGIC[70]) + (r * MAGIC[69]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[34]) - (r * MAGIC[35])), z + ((r * MAGIC[35]) + (r * MAGIC[34]))))
                + ((float) n.noise(x + ((r * MAGIC[62]) - (r * MAGIC[162])), z + ((r * MAGIC[162]) + (r * MAGIC[62]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[147]) - (r * MAGIC[168])), z + ((r * MAGIC[168]) + (r * MAGIC[147]))))
                + ((float) n.noise(x + ((r * MAGIC[30]) - (r * MAGIC[89])), z + ((r * MAGIC[89]) + (r * MAGIC[30]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[67]) - (r * MAGIC[68])), z + ((r * MAGIC[68]) + (r * MAGIC[67]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[63]) - (r * MAGIC[163])), z + ((r * MAGIC[163]) + (r * MAGIC[63]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[32]) - (r * MAGIC[66])), z + ((r * MAGIC[66]) + (r * MAGIC[32]))))
                + ((float) n.noise(x + ((r * MAGIC[109]) - (r * MAGIC[167])), z + ((r * MAGIC[167]) + (r * MAGIC[109]))))) * 0.014925373F;
    }

    private static float sc68(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[109]) - (r * MAGIC[69])), z + ((r * MAGIC[69]) + (r * MAGIC[109]))))
                + ((float) n.noise(x + ((r * MAGIC[32]) - (r * MAGIC[33])), z + ((r * MAGIC[33]) + (r * MAGIC[32]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[63]) - (r * MAGIC[62])), z + ((r * MAGIC[62]) + (r * MAGIC[63]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[67]) - (r * MAGIC[147])), z + ((r * MAGIC[147]) + (r * MAGIC[67]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[30]) - (r * MAGIC[31])), z + ((r * MAGIC[31]) + (r * MAGIC[30]))))
                + ((float) n.noise(x + ((r * MAGIC[147]) - (r * MAGIC[67])), z + ((r * MAGIC[67]) + (r * MAGIC[147]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[62]) - (r * MAGIC[63])), z + ((r * MAGIC[63]) + (r * MAGIC[62]))))
                + ((float) n.noise(x + ((r * MAGIC[34]) - (r * MAGIC[84])), z + ((r * MAGIC[84]) + (r * MAGIC[34]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[69]) - (r * MAGIC[109])), z + ((r * MAGIC[109]) + (r * MAGIC[69]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[167]) - (r * MAGIC[109])), z + ((r * MAGIC[109]) + (r * MAGIC[167]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[36]) - (r * MAGIC[84])), z + ((r * MAGIC[84]) + (r * MAGIC[36]))))
                + ((float) n.noise(x + ((r * MAGIC[163]) - (r * MAGIC[63])), z + ((r * MAGIC[63]) + (r * MAGIC[163]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[68]) - (r * MAGIC[67])), z + ((r * MAGIC[67]) + (r * MAGIC[68]))))
                + ((float) n.noise(x + ((r * MAGIC[38]) - (r * MAGIC[31])), z + ((r * MAGIC[31]) + (r * MAGIC[38]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[168]) - (r * MAGIC[147])), z + ((r * MAGIC[147]) + (r * MAGIC[168]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[162]) - (r * MAGIC[62])), z + ((r * MAGIC[62]) + (r * MAGIC[162]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[37]) - (r * MAGIC[33])), z + ((r * MAGIC[33]) + (r * MAGIC[37]))))
                + ((float) n.noise(x + ((r * MAGIC[70]) - (r * MAGIC[69])), z + ((r * MAGIC[69]) + (r * MAGIC[70]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[70]) - (r * MAGIC[167])), z + ((r * MAGIC[167]) + (r * MAGIC[70]))))
                + ((float) n.noise(x + ((r * MAGIC[37]) - (r * MAGIC[66])), z + ((r * MAGIC[66]) + (r * MAGIC[37]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[162]) - (r * MAGIC[163])), z + ((r * MAGIC[163]) + (r * MAGIC[162]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[168]) - (r * MAGIC[68])), z + ((r * MAGIC[68]) + (r * MAGIC[168]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[38]) - (r * MAGIC[89])), z + ((r * MAGIC[89]) + (r * MAGIC[38]))))
                + ((float) n.noise(x + ((r * MAGIC[68]) - (r * MAGIC[168])), z + ((r * MAGIC[168]) + (r * MAGIC[68]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[163]) - (r * MAGIC[162])), z + ((r * MAGIC[162]) + (r * MAGIC[163]))))
                + ((float) n.noise(x + ((r * MAGIC[36]) - (r * MAGIC[35])), z + ((r * MAGIC[35]) + (r * MAGIC[36]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[167]) - (r * MAGIC[70])), z + ((r * MAGIC[70]) + (r * MAGIC[167]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[69]) - (r * MAGIC[70])), z + ((r * MAGIC[70]) + (r * MAGIC[69]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[34]) - (r * MAGIC[35])), z + ((r * MAGIC[35]) + (r * MAGIC[34]))))
                + ((float) n.noise(x + ((r * MAGIC[62]) - (r * MAGIC[162])), z + ((r * MAGIC[162]) + (r * MAGIC[62]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[147]) - (r * MAGIC[168])), z + ((r * MAGIC[168]) + (r * MAGIC[147]))))
                + ((float) n.noise(x + ((r * MAGIC[30]) - (r * MAGIC[89])), z + ((r * MAGIC[89]) + (r * MAGIC[30]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[67]) - (r * MAGIC[68])), z + ((r * MAGIC[68]) + (r * MAGIC[67]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[63]) - (r * MAGIC[163])), z + ((r * MAGIC[163]) + (r * MAGIC[63]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[32]) - (r * MAGIC[66])), z + ((r * MAGIC[66]) + (r * MAGIC[32]))))
                + ((float) n.noise(x + ((r * MAGIC[109]) - (r * MAGIC[167])), z + ((r * MAGIC[167]) + (r * MAGIC[109]))))) * 0.014705882F;
    }

    private static float sc69(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[109]) - (r * MAGIC[69])), z + ((r * MAGIC[69]) + (r * MAGIC[109]))))
                + ((float) n.noise(x + ((r * MAGIC[32]) - (r * MAGIC[33])), z + ((r * MAGIC[33]) + (r * MAGIC[32]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[63]) - (r * MAGIC[62])), z + ((r * MAGIC[62]) + (r * MAGIC[63]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[67]) - (r * MAGIC[147])), z + ((r * MAGIC[147]) + (r * MAGIC[67]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[30]) - (r * MAGIC[31])), z + ((r * MAGIC[31]) + (r * MAGIC[30]))))
                + ((float) n.noise(x + ((r * MAGIC[147]) - (r * MAGIC[67])), z + ((r * MAGIC[67]) + (r * MAGIC[147]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[62]) - (r * MAGIC[63])), z + ((r * MAGIC[63]) + (r * MAGIC[62]))))
                + ((float) n.noise(x + ((r * MAGIC[34]) - (r * MAGIC[84])), z + ((r * MAGIC[84]) + (r * MAGIC[34]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[69]) - (r * MAGIC[109])), z + ((r * MAGIC[109]) + (r * MAGIC[69]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[167]) - (r * MAGIC[109])), z + ((r * MAGIC[109]) + (r * MAGIC[167]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[36]) - (r * MAGIC[84])), z + ((r * MAGIC[84]) + (r * MAGIC[36]))))
                + ((float) n.noise(x + ((r * MAGIC[163]) - (r * MAGIC[63])), z + ((r * MAGIC[63]) + (r * MAGIC[163]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[68]) - (r * MAGIC[67])), z + ((r * MAGIC[67]) + (r * MAGIC[68]))))
                + ((float) n.noise(x + ((r * MAGIC[38]) - (r * MAGIC[31])), z + ((r * MAGIC[31]) + (r * MAGIC[38]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[168]) - (r * MAGIC[147])), z + ((r * MAGIC[147]) + (r * MAGIC[168]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[162]) - (r * MAGIC[62])), z + ((r * MAGIC[62]) + (r * MAGIC[162]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[37]) - (r * MAGIC[33])), z + ((r * MAGIC[33]) + (r * MAGIC[37]))))
                + ((float) n.noise(x + ((r * MAGIC[70]) - (r * MAGIC[69])), z + ((r * MAGIC[69]) + (r * MAGIC[70]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[70]) - (r * MAGIC[167])), z + ((r * MAGIC[167]) + (r * MAGIC[70]))))
                + ((float) n.noise(x + ((r * MAGIC[37]) - (r * MAGIC[66])), z + ((r * MAGIC[66]) + (r * MAGIC[37]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[162]) - (r * MAGIC[163])), z + ((r * MAGIC[163]) + (r * MAGIC[162]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[168]) - (r * MAGIC[68])), z + ((r * MAGIC[68]) + (r * MAGIC[168]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[38]) - (r * MAGIC[89])), z + ((r * MAGIC[89]) + (r * MAGIC[38]))))
                + ((float) n.noise(x + ((r * MAGIC[68]) - (r * MAGIC[168])), z + ((r * MAGIC[168]) + (r * MAGIC[68]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[163]) - (r * MAGIC[162])), z + ((r * MAGIC[162]) + (r * MAGIC[163]))))
                + ((float) n.noise(x + ((r * MAGIC[36]) - (r * MAGIC[35])), z + ((r * MAGIC[35]) + (r * MAGIC[36]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[167]) - (r * MAGIC[70])), z + ((r * MAGIC[70]) + (r * MAGIC[167]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[69]) - (r * MAGIC[70])), z + ((r * MAGIC[70]) + (r * MAGIC[69]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[34]) - (r * MAGIC[35])), z + ((r * MAGIC[35]) + (r * MAGIC[34]))))
                + ((float) n.noise(x + ((r * MAGIC[62]) - (r * MAGIC[162])), z + ((r * MAGIC[162]) + (r * MAGIC[62]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[147]) - (r * MAGIC[168])), z + ((r * MAGIC[168]) + (r * MAGIC[147]))))
                + ((float) n.noise(x + ((r * MAGIC[30]) - (r * MAGIC[89])), z + ((r * MAGIC[89]) + (r * MAGIC[30]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[67]) - (r * MAGIC[68])), z + ((r * MAGIC[68]) + (r * MAGIC[67]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[63]) - (r * MAGIC[163])), z + ((r * MAGIC[163]) + (r * MAGIC[63]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[32]) - (r * MAGIC[66])), z + ((r * MAGIC[66]) + (r * MAGIC[32]))))
                + ((float) n.noise(x + ((r * MAGIC[109]) - (r * MAGIC[167])), z + ((r * MAGIC[167]) + (r * MAGIC[109]))))) * 0.014492754F;
    }

    private static float sc70(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[109]) - (r * MAGIC[69])), z + ((r * MAGIC[69]) + (r * MAGIC[109]))))
                + ((float) n.noise(x + ((r * MAGIC[32]) - (r * MAGIC[33])), z + ((r * MAGIC[33]) + (r * MAGIC[32]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[63]) - (r * MAGIC[62])), z + ((r * MAGIC[62]) + (r * MAGIC[63]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[67]) - (r * MAGIC[147])), z + ((r * MAGIC[147]) + (r * MAGIC[67]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[30]) - (r * MAGIC[31])), z + ((r * MAGIC[31]) + (r * MAGIC[30]))))
                + ((float) n.noise(x + ((r * MAGIC[147]) - (r * MAGIC[67])), z + ((r * MAGIC[67]) + (r * MAGIC[147]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[62]) - (r * MAGIC[63])), z + ((r * MAGIC[63]) + (r * MAGIC[62]))))
                + ((float) n.noise(x + ((r * MAGIC[34]) - (r * MAGIC[84])), z + ((r * MAGIC[84]) + (r * MAGIC[34]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[69]) - (r * MAGIC[109])), z + ((r * MAGIC[109]) + (r * MAGIC[69]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[167]) - (r * MAGIC[109])), z + ((r * MAGIC[109]) + (r * MAGIC[167]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[36]) - (r * MAGIC[84])), z + ((r * MAGIC[84]) + (r * MAGIC[36]))))
                + ((float) n.noise(x + ((r * MAGIC[163]) - (r * MAGIC[63])), z + ((r * MAGIC[63]) + (r * MAGIC[163]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[68]) - (r * MAGIC[67])), z + ((r * MAGIC[67]) + (r * MAGIC[68]))))
                + ((float) n.noise(x + ((r * MAGIC[38]) - (r * MAGIC[31])), z + ((r * MAGIC[31]) + (r * MAGIC[38]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[168]) - (r * MAGIC[147])), z + ((r * MAGIC[147]) + (r * MAGIC[168]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[162]) - (r * MAGIC[62])), z + ((r * MAGIC[62]) + (r * MAGIC[162]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[37]) - (r * MAGIC[33])), z + ((r * MAGIC[33]) + (r * MAGIC[37]))))
                + ((float) n.noise(x + ((r * MAGIC[70]) - (r * MAGIC[69])), z + ((r * MAGIC[69]) + (r * MAGIC[70]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[70]) - (r * MAGIC[167])), z + ((r * MAGIC[167]) + (r * MAGIC[70]))))
                + ((float) n.noise(x + ((r * MAGIC[37]) - (r * MAGIC[66])), z + ((r * MAGIC[66]) + (r * MAGIC[37]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[162]) - (r * MAGIC[163])), z + ((r * MAGIC[163]) + (r * MAGIC[162]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[168]) - (r * MAGIC[68])), z + ((r * MAGIC[68]) + (r * MAGIC[168]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[38]) - (r * MAGIC[89])), z + ((r * MAGIC[89]) + (r * MAGIC[38]))))
                + ((float) n.noise(x + ((r * MAGIC[68]) - (r * MAGIC[168])), z + ((r * MAGIC[168]) + (r * MAGIC[68]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[163]) - (r * MAGIC[162])), z + ((r * MAGIC[162]) + (r * MAGIC[163]))))
                + ((float) n.noise(x + ((r * MAGIC[36]) - (r * MAGIC[35])), z + ((r * MAGIC[35]) + (r * MAGIC[36]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[167]) - (r * MAGIC[70])), z + ((r * MAGIC[70]) + (r * MAGIC[167]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[69]) - (r * MAGIC[70])), z + ((r * MAGIC[70]) + (r * MAGIC[69]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[34]) - (r * MAGIC[35])), z + ((r * MAGIC[35]) + (r * MAGIC[34]))))
                + ((float) n.noise(x + ((r * MAGIC[62]) - (r * MAGIC[162])), z + ((r * MAGIC[162]) + (r * MAGIC[62]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[147]) - (r * MAGIC[168])), z + ((r * MAGIC[168]) + (r * MAGIC[147]))))
                + ((float) n.noise(x + ((r * MAGIC[30]) - (r * MAGIC[89])), z + ((r * MAGIC[89]) + (r * MAGIC[30]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[67]) - (r * MAGIC[68])), z + ((r * MAGIC[68]) + (r * MAGIC[67]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[63]) - (r * MAGIC[163])), z + ((r * MAGIC[163]) + (r * MAGIC[63]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[32]) - (r * MAGIC[66])), z + ((r * MAGIC[66]) + (r * MAGIC[32]))))
                + ((float) n.noise(x + ((r * MAGIC[109]) - (r * MAGIC[167])), z + ((r * MAGIC[167]) + (r * MAGIC[109]))))) * 0.014285714F;
    }

    private static float sc71(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[109]) - (r * MAGIC[69])), z + ((r * MAGIC[69]) + (r * MAGIC[109]))))
                + ((float) n.noise(x + ((r * MAGIC[32]) - (r * MAGIC[33])), z + ((r * MAGIC[33]) + (r * MAGIC[32]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[63]) - (r * MAGIC[62])), z + ((r * MAGIC[62]) + (r * MAGIC[63]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[67]) - (r * MAGIC[147])), z + ((r * MAGIC[147]) + (r * MAGIC[67]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[30]) - (r * MAGIC[31])), z + ((r * MAGIC[31]) + (r * MAGIC[30]))))
                + ((float) n.noise(x + ((r * MAGIC[147]) - (r * MAGIC[67])), z + ((r * MAGIC[67]) + (r * MAGIC[147]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[62]) - (r * MAGIC[63])), z + ((r * MAGIC[63]) + (r * MAGIC[62]))))
                + ((float) n.noise(x + ((r * MAGIC[34]) - (r * MAGIC[84])), z + ((r * MAGIC[84]) + (r * MAGIC[34]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[69]) - (r * MAGIC[109])), z + ((r * MAGIC[109]) + (r * MAGIC[69]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[167]) - (r * MAGIC[109])), z + ((r * MAGIC[109]) + (r * MAGIC[167]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[36]) - (r * MAGIC[84])), z + ((r * MAGIC[84]) + (r * MAGIC[36]))))
                + ((float) n.noise(x + ((r * MAGIC[163]) - (r * MAGIC[63])), z + ((r * MAGIC[63]) + (r * MAGIC[163]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[68]) - (r * MAGIC[67])), z + ((r * MAGIC[67]) + (r * MAGIC[68]))))
                + ((float) n.noise(x + ((r * MAGIC[38]) - (r * MAGIC[31])), z + ((r * MAGIC[31]) + (r * MAGIC[38]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[168]) - (r * MAGIC[147])), z + ((r * MAGIC[147]) + (r * MAGIC[168]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[162]) - (r * MAGIC[62])), z + ((r * MAGIC[62]) + (r * MAGIC[162]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[37]) - (r * MAGIC[33])), z + ((r * MAGIC[33]) + (r * MAGIC[37]))))
                + ((float) n.noise(x + ((r * MAGIC[70]) - (r * MAGIC[69])), z + ((r * MAGIC[69]) + (r * MAGIC[70]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[70]) - (r * MAGIC[167])), z + ((r * MAGIC[167]) + (r * MAGIC[70]))))
                + ((float) n.noise(x + ((r * MAGIC[37]) - (r * MAGIC[66])), z + ((r * MAGIC[66]) + (r * MAGIC[37]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[162]) - (r * MAGIC[163])), z + ((r * MAGIC[163]) + (r * MAGIC[162]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[168]) - (r * MAGIC[68])), z + ((r * MAGIC[68]) + (r * MAGIC[168]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[38]) - (r * MAGIC[89])), z + ((r * MAGIC[89]) + (r * MAGIC[38]))))
                + ((float) n.noise(x + ((r * MAGIC[68]) - (r * MAGIC[168])), z + ((r * MAGIC[168]) + (r * MAGIC[68]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[163]) - (r * MAGIC[162])), z + ((r * MAGIC[162]) + (r * MAGIC[163]))))
                + ((float) n.noise(x + ((r * MAGIC[36]) - (r * MAGIC[35])), z + ((r * MAGIC[35]) + (r * MAGIC[36]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[167]) - (r * MAGIC[70])), z + ((r * MAGIC[70]) + (r * MAGIC[167]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[69]) - (r * MAGIC[70])), z + ((r * MAGIC[70]) + (r * MAGIC[69]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[34]) - (r * MAGIC[35])), z + ((r * MAGIC[35]) + (r * MAGIC[34]))))
                + ((float) n.noise(x + ((r * MAGIC[62]) - (r * MAGIC[162])), z + ((r * MAGIC[162]) + (r * MAGIC[62]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[147]) - (r * MAGIC[168])), z + ((r * MAGIC[168]) + (r * MAGIC[147]))))
                + ((float) n.noise(x + ((r * MAGIC[30]) - (r * MAGIC[89])), z + ((r * MAGIC[89]) + (r * MAGIC[30]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[67]) - (r * MAGIC[68])), z + ((r * MAGIC[68]) + (r * MAGIC[67]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[63]) - (r * MAGIC[163])), z + ((r * MAGIC[163]) + (r * MAGIC[63]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[32]) - (r * MAGIC[66])), z + ((r * MAGIC[66]) + (r * MAGIC[32]))))
                + ((float) n.noise(x + ((r * MAGIC[109]) - (r * MAGIC[167])), z + ((r * MAGIC[167]) + (r * MAGIC[109]))))) * 0.014084507F;
    }

    private static float sc72(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[109]) - (r * MAGIC[69])), z + ((r * MAGIC[69]) + (r * MAGIC[109]))))
                + ((float) n.noise(x + ((r * MAGIC[32]) - (r * MAGIC[33])), z + ((r * MAGIC[33]) + (r * MAGIC[32]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[63]) - (r * MAGIC[62])), z + ((r * MAGIC[62]) + (r * MAGIC[63]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[67]) - (r * MAGIC[147])), z + ((r * MAGIC[147]) + (r * MAGIC[67]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[30]) - (r * MAGIC[31])), z + ((r * MAGIC[31]) + (r * MAGIC[30]))))
                + ((float) n.noise(x + ((r * MAGIC[147]) - (r * MAGIC[67])), z + ((r * MAGIC[67]) + (r * MAGIC[147]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[62]) - (r * MAGIC[63])), z + ((r * MAGIC[63]) + (r * MAGIC[62]))))
                + ((float) n.noise(x + ((r * MAGIC[34]) - (r * MAGIC[84])), z + ((r * MAGIC[84]) + (r * MAGIC[34]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[69]) - (r * MAGIC[109])), z + ((r * MAGIC[109]) + (r * MAGIC[69]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[167]) - (r * MAGIC[109])), z + ((r * MAGIC[109]) + (r * MAGIC[167]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[36]) - (r * MAGIC[84])), z + ((r * MAGIC[84]) + (r * MAGIC[36]))))
                + ((float) n.noise(x + ((r * MAGIC[163]) - (r * MAGIC[63])), z + ((r * MAGIC[63]) + (r * MAGIC[163]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[68]) - (r * MAGIC[67])), z + ((r * MAGIC[67]) + (r * MAGIC[68]))))
                + ((float) n.noise(x + ((r * MAGIC[38]) - (r * MAGIC[31])), z + ((r * MAGIC[31]) + (r * MAGIC[38]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[168]) - (r * MAGIC[147])), z + ((r * MAGIC[147]) + (r * MAGIC[168]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[162]) - (r * MAGIC[62])), z + ((r * MAGIC[62]) + (r * MAGIC[162]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[37]) - (r * MAGIC[33])), z + ((r * MAGIC[33]) + (r * MAGIC[37]))))
                + ((float) n.noise(x + ((r * MAGIC[70]) - (r * MAGIC[69])), z + ((r * MAGIC[69]) + (r * MAGIC[70]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[70]) - (r * MAGIC[167])), z + ((r * MAGIC[167]) + (r * MAGIC[70]))))
                + ((float) n.noise(x + ((r * MAGIC[37]) - (r * MAGIC[66])), z + ((r * MAGIC[66]) + (r * MAGIC[37]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[162]) - (r * MAGIC[163])), z + ((r * MAGIC[163]) + (r * MAGIC[162]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[168]) - (r * MAGIC[68])), z + ((r * MAGIC[68]) + (r * MAGIC[168]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[38]) - (r * MAGIC[89])), z + ((r * MAGIC[89]) + (r * MAGIC[38]))))
                + ((float) n.noise(x + ((r * MAGIC[68]) - (r * MAGIC[168])), z + ((r * MAGIC[168]) + (r * MAGIC[68]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[163]) - (r * MAGIC[162])), z + ((r * MAGIC[162]) + (r * MAGIC[163]))))
                + ((float) n.noise(x + ((r * MAGIC[36]) - (r * MAGIC[35])), z + ((r * MAGIC[35]) + (r * MAGIC[36]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[167]) - (r * MAGIC[70])), z + ((r * MAGIC[70]) + (r * MAGIC[167]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[69]) - (r * MAGIC[70])), z + ((r * MAGIC[70]) + (r * MAGIC[69]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[34]) - (r * MAGIC[35])), z + ((r * MAGIC[35]) + (r * MAGIC[34]))))
                + ((float) n.noise(x + ((r * MAGIC[62]) - (r * MAGIC[162])), z + ((r * MAGIC[162]) + (r * MAGIC[62]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[147]) - (r * MAGIC[168])), z + ((r * MAGIC[168]) + (r * MAGIC[147]))))
                + ((float) n.noise(x + ((r * MAGIC[30]) - (r * MAGIC[89])), z + ((r * MAGIC[89]) + (r * MAGIC[30]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[67]) - (r * MAGIC[68])), z + ((r * MAGIC[68]) + (r * MAGIC[67]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[63]) - (r * MAGIC[163])), z + ((r * MAGIC[163]) + (r * MAGIC[63]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[32]) - (r * MAGIC[66])), z + ((r * MAGIC[66]) + (r * MAGIC[32]))))
                + ((float) n.noise(x + ((r * MAGIC[109]) - (r * MAGIC[167])), z + ((r * MAGIC[167]) + (r * MAGIC[109]))))) * 0.013888889F;
    }

    private static float sc73(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[169]) - (r * MAGIC[87])), z + ((r * MAGIC[87]) + (r * MAGIC[169]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[155])), z + ((r * MAGIC[155]) + (r * MAGIC[55]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[93])), z + ((r * MAGIC[93]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[129]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[129]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[41])), z + ((r * MAGIC[41]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[81]) - (r * MAGIC[80])), z + ((r * MAGIC[80]) + (r * MAGIC[81]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[47])), z + ((r * MAGIC[47]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[43])), z + ((r * MAGIC[43]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[78]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[78]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[126]) - (r * MAGIC[127])), z + ((r * MAGIC[127]) + (r * MAGIC[126]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[82])), z + ((r * MAGIC[82]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[130]) - (r * MAGIC[82])), z + ((r * MAGIC[82]) + (r * MAGIC[130]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[127])), z + ((r * MAGIC[127]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[170]) - (r * MAGIC[43])), z + ((r * MAGIC[43]) + (r * MAGIC[170]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[171]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[171]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[47])), z + ((r * MAGIC[47]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[80])), z + ((r * MAGIC[80]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[116]) - (r * MAGIC[41])), z + ((r * MAGIC[41]) + (r * MAGIC[116]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[92]) - (r * MAGIC[93])), z + ((r * MAGIC[93]) + (r * MAGIC[92]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[172]) - (r * MAGIC[155])), z + ((r * MAGIC[155]) + (r * MAGIC[172]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[87])), z + ((r * MAGIC[87]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[132])), z + ((r * MAGIC[132]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[172]) - (r * MAGIC[54])), z + ((r * MAGIC[54]) + (r * MAGIC[172]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[92]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[92]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[91])), z + ((r * MAGIC[91]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[116]) - (r * MAGIC[117])), z + ((r * MAGIC[117]) + (r * MAGIC[116]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[171]) - (r * MAGIC[125])), z + ((r * MAGIC[125]) + (r * MAGIC[171]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[170]) - (r * MAGIC[86])), z + ((r * MAGIC[86]) + (r * MAGIC[170]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[156])), z + ((r * MAGIC[156]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[52])), z + ((r * MAGIC[52]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[130]) - (r * MAGIC[118])), z + ((r * MAGIC[118]) + (r * MAGIC[130]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[118])), z + ((r * MAGIC[118]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[126]) - (r * MAGIC[52])), z + ((r * MAGIC[52]) + (r * MAGIC[126]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[78]) - (r * MAGIC[156])), z + ((r * MAGIC[156]) + (r * MAGIC[78]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[86])), z + ((r * MAGIC[86]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[125])), z + ((r * MAGIC[125]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[81]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[81]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[117])), z + ((r * MAGIC[117]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[129]) - (r * MAGIC[91])), z + ((r * MAGIC[91]) + (r * MAGIC[129]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[54])), z + ((r * MAGIC[54]) + (r * MAGIC[55]))))
                + ((float) n.noise(x + ((r * MAGIC[169]) - (r * MAGIC[132])), z + ((r * MAGIC[132]) + (r * MAGIC[169]))))) * 0.01369863F;
    }

    private static float sc74(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[169]) - (r * MAGIC[87])), z + ((r * MAGIC[87]) + (r * MAGIC[169]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[155])), z + ((r * MAGIC[155]) + (r * MAGIC[55]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[93])), z + ((r * MAGIC[93]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[129]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[129]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[41])), z + ((r * MAGIC[41]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[81]) - (r * MAGIC[80])), z + ((r * MAGIC[80]) + (r * MAGIC[81]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[47])), z + ((r * MAGIC[47]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[43])), z + ((r * MAGIC[43]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[78]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[78]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[126]) - (r * MAGIC[127])), z + ((r * MAGIC[127]) + (r * MAGIC[126]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[82])), z + ((r * MAGIC[82]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[130]) - (r * MAGIC[82])), z + ((r * MAGIC[82]) + (r * MAGIC[130]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[127])), z + ((r * MAGIC[127]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[170]) - (r * MAGIC[43])), z + ((r * MAGIC[43]) + (r * MAGIC[170]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[171]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[171]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[47])), z + ((r * MAGIC[47]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[80])), z + ((r * MAGIC[80]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[116]) - (r * MAGIC[41])), z + ((r * MAGIC[41]) + (r * MAGIC[116]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[92]) - (r * MAGIC[93])), z + ((r * MAGIC[93]) + (r * MAGIC[92]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[172]) - (r * MAGIC[155])), z + ((r * MAGIC[155]) + (r * MAGIC[172]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[87])), z + ((r * MAGIC[87]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[132])), z + ((r * MAGIC[132]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[172]) - (r * MAGIC[54])), z + ((r * MAGIC[54]) + (r * MAGIC[172]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[92]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[92]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[91])), z + ((r * MAGIC[91]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[116]) - (r * MAGIC[117])), z + ((r * MAGIC[117]) + (r * MAGIC[116]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[171]) - (r * MAGIC[125])), z + ((r * MAGIC[125]) + (r * MAGIC[171]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[170]) - (r * MAGIC[86])), z + ((r * MAGIC[86]) + (r * MAGIC[170]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[156])), z + ((r * MAGIC[156]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[52])), z + ((r * MAGIC[52]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[130]) - (r * MAGIC[118])), z + ((r * MAGIC[118]) + (r * MAGIC[130]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[118])), z + ((r * MAGIC[118]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[126]) - (r * MAGIC[52])), z + ((r * MAGIC[52]) + (r * MAGIC[126]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[78]) - (r * MAGIC[156])), z + ((r * MAGIC[156]) + (r * MAGIC[78]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[86])), z + ((r * MAGIC[86]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[125])), z + ((r * MAGIC[125]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[81]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[81]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[117])), z + ((r * MAGIC[117]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[129]) - (r * MAGIC[91])), z + ((r * MAGIC[91]) + (r * MAGIC[129]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[54])), z + ((r * MAGIC[54]) + (r * MAGIC[55]))))
                + ((float) n.noise(x + ((r * MAGIC[169]) - (r * MAGIC[132])), z + ((r * MAGIC[132]) + (r * MAGIC[169]))))) * 0.013513514F;
    }

    private static float sc75(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[169]) - (r * MAGIC[87])), z + ((r * MAGIC[87]) + (r * MAGIC[169]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[155])), z + ((r * MAGIC[155]) + (r * MAGIC[55]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[93])), z + ((r * MAGIC[93]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[129]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[129]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[41])), z + ((r * MAGIC[41]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[81]) - (r * MAGIC[80])), z + ((r * MAGIC[80]) + (r * MAGIC[81]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[47])), z + ((r * MAGIC[47]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[43])), z + ((r * MAGIC[43]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[78]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[78]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[126]) - (r * MAGIC[127])), z + ((r * MAGIC[127]) + (r * MAGIC[126]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[82])), z + ((r * MAGIC[82]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[130]) - (r * MAGIC[82])), z + ((r * MAGIC[82]) + (r * MAGIC[130]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[127])), z + ((r * MAGIC[127]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[170]) - (r * MAGIC[43])), z + ((r * MAGIC[43]) + (r * MAGIC[170]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[171]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[171]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[47])), z + ((r * MAGIC[47]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[80])), z + ((r * MAGIC[80]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[116]) - (r * MAGIC[41])), z + ((r * MAGIC[41]) + (r * MAGIC[116]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[92]) - (r * MAGIC[93])), z + ((r * MAGIC[93]) + (r * MAGIC[92]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[172]) - (r * MAGIC[155])), z + ((r * MAGIC[155]) + (r * MAGIC[172]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[87])), z + ((r * MAGIC[87]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[132])), z + ((r * MAGIC[132]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[172]) - (r * MAGIC[54])), z + ((r * MAGIC[54]) + (r * MAGIC[172]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[92]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[92]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[91])), z + ((r * MAGIC[91]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[116]) - (r * MAGIC[117])), z + ((r * MAGIC[117]) + (r * MAGIC[116]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[171]) - (r * MAGIC[125])), z + ((r * MAGIC[125]) + (r * MAGIC[171]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[170]) - (r * MAGIC[86])), z + ((r * MAGIC[86]) + (r * MAGIC[170]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[156])), z + ((r * MAGIC[156]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[52])), z + ((r * MAGIC[52]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[130]) - (r * MAGIC[118])), z + ((r * MAGIC[118]) + (r * MAGIC[130]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[118])), z + ((r * MAGIC[118]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[126]) - (r * MAGIC[52])), z + ((r * MAGIC[52]) + (r * MAGIC[126]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[78]) - (r * MAGIC[156])), z + ((r * MAGIC[156]) + (r * MAGIC[78]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[86])), z + ((r * MAGIC[86]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[125])), z + ((r * MAGIC[125]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[81]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[81]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[117])), z + ((r * MAGIC[117]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[129]) - (r * MAGIC[91])), z + ((r * MAGIC[91]) + (r * MAGIC[129]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[54])), z + ((r * MAGIC[54]) + (r * MAGIC[55]))))
                + ((float) n.noise(x + ((r * MAGIC[169]) - (r * MAGIC[132])), z + ((r * MAGIC[132]) + (r * MAGIC[169]))))) * 0.013333334F;
    }

    private static float sc76(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[169]) - (r * MAGIC[87])), z + ((r * MAGIC[87]) + (r * MAGIC[169]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[155])), z + ((r * MAGIC[155]) + (r * MAGIC[55]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[93])), z + ((r * MAGIC[93]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[129]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[129]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[41])), z + ((r * MAGIC[41]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[81]) - (r * MAGIC[80])), z + ((r * MAGIC[80]) + (r * MAGIC[81]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[47])), z + ((r * MAGIC[47]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[43])), z + ((r * MAGIC[43]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[78]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[78]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[126]) - (r * MAGIC[127])), z + ((r * MAGIC[127]) + (r * MAGIC[126]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[82])), z + ((r * MAGIC[82]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[130]) - (r * MAGIC[82])), z + ((r * MAGIC[82]) + (r * MAGIC[130]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[127])), z + ((r * MAGIC[127]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[170]) - (r * MAGIC[43])), z + ((r * MAGIC[43]) + (r * MAGIC[170]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[171]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[171]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[47])), z + ((r * MAGIC[47]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[80])), z + ((r * MAGIC[80]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[116]) - (r * MAGIC[41])), z + ((r * MAGIC[41]) + (r * MAGIC[116]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[92]) - (r * MAGIC[93])), z + ((r * MAGIC[93]) + (r * MAGIC[92]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[172]) - (r * MAGIC[155])), z + ((r * MAGIC[155]) + (r * MAGIC[172]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[87])), z + ((r * MAGIC[87]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[132])), z + ((r * MAGIC[132]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[172]) - (r * MAGIC[54])), z + ((r * MAGIC[54]) + (r * MAGIC[172]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[92]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[92]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[91])), z + ((r * MAGIC[91]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[116]) - (r * MAGIC[117])), z + ((r * MAGIC[117]) + (r * MAGIC[116]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[171]) - (r * MAGIC[125])), z + ((r * MAGIC[125]) + (r * MAGIC[171]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[170]) - (r * MAGIC[86])), z + ((r * MAGIC[86]) + (r * MAGIC[170]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[156])), z + ((r * MAGIC[156]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[52])), z + ((r * MAGIC[52]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[130]) - (r * MAGIC[118])), z + ((r * MAGIC[118]) + (r * MAGIC[130]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[118])), z + ((r * MAGIC[118]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[126]) - (r * MAGIC[52])), z + ((r * MAGIC[52]) + (r * MAGIC[126]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[78]) - (r * MAGIC[156])), z + ((r * MAGIC[156]) + (r * MAGIC[78]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[86])), z + ((r * MAGIC[86]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[125])), z + ((r * MAGIC[125]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[81]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[81]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[117])), z + ((r * MAGIC[117]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[129]) - (r * MAGIC[91])), z + ((r * MAGIC[91]) + (r * MAGIC[129]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[54])), z + ((r * MAGIC[54]) + (r * MAGIC[55]))))
                + ((float) n.noise(x + ((r * MAGIC[169]) - (r * MAGIC[132])), z + ((r * MAGIC[132]) + (r * MAGIC[169]))))) * 0.013157895F;
    }

    private static float sc77(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[169]) - (r * MAGIC[87])), z + ((r * MAGIC[87]) + (r * MAGIC[169]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[155])), z + ((r * MAGIC[155]) + (r * MAGIC[55]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[93])), z + ((r * MAGIC[93]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[129]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[129]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[41])), z + ((r * MAGIC[41]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[81]) - (r * MAGIC[80])), z + ((r * MAGIC[80]) + (r * MAGIC[81]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[47])), z + ((r * MAGIC[47]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[43])), z + ((r * MAGIC[43]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[78]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[78]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[126]) - (r * MAGIC[127])), z + ((r * MAGIC[127]) + (r * MAGIC[126]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[82])), z + ((r * MAGIC[82]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[130]) - (r * MAGIC[82])), z + ((r * MAGIC[82]) + (r * MAGIC[130]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[127])), z + ((r * MAGIC[127]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[170]) - (r * MAGIC[43])), z + ((r * MAGIC[43]) + (r * MAGIC[170]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[171]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[171]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[47])), z + ((r * MAGIC[47]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[80])), z + ((r * MAGIC[80]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[116]) - (r * MAGIC[41])), z + ((r * MAGIC[41]) + (r * MAGIC[116]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[92]) - (r * MAGIC[93])), z + ((r * MAGIC[93]) + (r * MAGIC[92]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[172]) - (r * MAGIC[155])), z + ((r * MAGIC[155]) + (r * MAGIC[172]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[87])), z + ((r * MAGIC[87]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[132])), z + ((r * MAGIC[132]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[172]) - (r * MAGIC[54])), z + ((r * MAGIC[54]) + (r * MAGIC[172]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[92]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[92]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[91])), z + ((r * MAGIC[91]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[116]) - (r * MAGIC[117])), z + ((r * MAGIC[117]) + (r * MAGIC[116]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[171]) - (r * MAGIC[125])), z + ((r * MAGIC[125]) + (r * MAGIC[171]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[170]) - (r * MAGIC[86])), z + ((r * MAGIC[86]) + (r * MAGIC[170]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[156])), z + ((r * MAGIC[156]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[52])), z + ((r * MAGIC[52]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[130]) - (r * MAGIC[118])), z + ((r * MAGIC[118]) + (r * MAGIC[130]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[118])), z + ((r * MAGIC[118]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[126]) - (r * MAGIC[52])), z + ((r * MAGIC[52]) + (r * MAGIC[126]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[78]) - (r * MAGIC[156])), z + ((r * MAGIC[156]) + (r * MAGIC[78]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[86])), z + ((r * MAGIC[86]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[125])), z + ((r * MAGIC[125]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[81]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[81]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[117])), z + ((r * MAGIC[117]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[129]) - (r * MAGIC[91])), z + ((r * MAGIC[91]) + (r * MAGIC[129]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[54])), z + ((r * MAGIC[54]) + (r * MAGIC[55]))))
                + ((float) n.noise(x + ((r * MAGIC[169]) - (r * MAGIC[132])), z + ((r * MAGIC[132]) + (r * MAGIC[169]))))) * 0.012987013F;
    }

    private static float sc78(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[169]) - (r * MAGIC[87])), z + ((r * MAGIC[87]) + (r * MAGIC[169]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[155])), z + ((r * MAGIC[155]) + (r * MAGIC[55]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[93])), z + ((r * MAGIC[93]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[129]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[129]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[41])), z + ((r * MAGIC[41]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[81]) - (r * MAGIC[80])), z + ((r * MAGIC[80]) + (r * MAGIC[81]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[47])), z + ((r * MAGIC[47]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[43])), z + ((r * MAGIC[43]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[78]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[78]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[126]) - (r * MAGIC[127])), z + ((r * MAGIC[127]) + (r * MAGIC[126]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[82])), z + ((r * MAGIC[82]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[130]) - (r * MAGIC[82])), z + ((r * MAGIC[82]) + (r * MAGIC[130]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[127])), z + ((r * MAGIC[127]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[170]) - (r * MAGIC[43])), z + ((r * MAGIC[43]) + (r * MAGIC[170]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[171]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[171]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[47])), z + ((r * MAGIC[47]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[80])), z + ((r * MAGIC[80]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[116]) - (r * MAGIC[41])), z + ((r * MAGIC[41]) + (r * MAGIC[116]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[92]) - (r * MAGIC[93])), z + ((r * MAGIC[93]) + (r * MAGIC[92]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[172]) - (r * MAGIC[155])), z + ((r * MAGIC[155]) + (r * MAGIC[172]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[87])), z + ((r * MAGIC[87]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[132])), z + ((r * MAGIC[132]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[172]) - (r * MAGIC[54])), z + ((r * MAGIC[54]) + (r * MAGIC[172]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[92]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[92]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[91])), z + ((r * MAGIC[91]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[116]) - (r * MAGIC[117])), z + ((r * MAGIC[117]) + (r * MAGIC[116]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[171]) - (r * MAGIC[125])), z + ((r * MAGIC[125]) + (r * MAGIC[171]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[170]) - (r * MAGIC[86])), z + ((r * MAGIC[86]) + (r * MAGIC[170]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[156])), z + ((r * MAGIC[156]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[52])), z + ((r * MAGIC[52]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[130]) - (r * MAGIC[118])), z + ((r * MAGIC[118]) + (r * MAGIC[130]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[118])), z + ((r * MAGIC[118]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[126]) - (r * MAGIC[52])), z + ((r * MAGIC[52]) + (r * MAGIC[126]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[78]) - (r * MAGIC[156])), z + ((r * MAGIC[156]) + (r * MAGIC[78]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[86])), z + ((r * MAGIC[86]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[125])), z + ((r * MAGIC[125]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[81]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[81]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[117])), z + ((r * MAGIC[117]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[129]) - (r * MAGIC[91])), z + ((r * MAGIC[91]) + (r * MAGIC[129]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[54])), z + ((r * MAGIC[54]) + (r * MAGIC[55]))))
                + ((float) n.noise(x + ((r * MAGIC[169]) - (r * MAGIC[132])), z + ((r * MAGIC[132]) + (r * MAGIC[169]))))) * 0.012820513F;
    }

    private static float sc79(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[169]) - (r * MAGIC[87])), z + ((r * MAGIC[87]) + (r * MAGIC[169]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[155])), z + ((r * MAGIC[155]) + (r * MAGIC[55]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[93])), z + ((r * MAGIC[93]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[129]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[129]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[41])), z + ((r * MAGIC[41]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[81]) - (r * MAGIC[80])), z + ((r * MAGIC[80]) + (r * MAGIC[81]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[47])), z + ((r * MAGIC[47]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[43])), z + ((r * MAGIC[43]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[78]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[78]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[126]) - (r * MAGIC[127])), z + ((r * MAGIC[127]) + (r * MAGIC[126]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[82])), z + ((r * MAGIC[82]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[130]) - (r * MAGIC[82])), z + ((r * MAGIC[82]) + (r * MAGIC[130]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[127])), z + ((r * MAGIC[127]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[170]) - (r * MAGIC[43])), z + ((r * MAGIC[43]) + (r * MAGIC[170]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[171]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[171]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[47])), z + ((r * MAGIC[47]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[80])), z + ((r * MAGIC[80]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[116]) - (r * MAGIC[41])), z + ((r * MAGIC[41]) + (r * MAGIC[116]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[92]) - (r * MAGIC[93])), z + ((r * MAGIC[93]) + (r * MAGIC[92]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[172]) - (r * MAGIC[155])), z + ((r * MAGIC[155]) + (r * MAGIC[172]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[87])), z + ((r * MAGIC[87]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[132])), z + ((r * MAGIC[132]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[172]) - (r * MAGIC[54])), z + ((r * MAGIC[54]) + (r * MAGIC[172]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[92]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[92]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[91])), z + ((r * MAGIC[91]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[116]) - (r * MAGIC[117])), z + ((r * MAGIC[117]) + (r * MAGIC[116]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[171]) - (r * MAGIC[125])), z + ((r * MAGIC[125]) + (r * MAGIC[171]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[170]) - (r * MAGIC[86])), z + ((r * MAGIC[86]) + (r * MAGIC[170]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[156])), z + ((r * MAGIC[156]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[52])), z + ((r * MAGIC[52]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[130]) - (r * MAGIC[118])), z + ((r * MAGIC[118]) + (r * MAGIC[130]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[118])), z + ((r * MAGIC[118]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[126]) - (r * MAGIC[52])), z + ((r * MAGIC[52]) + (r * MAGIC[126]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[78]) - (r * MAGIC[156])), z + ((r * MAGIC[156]) + (r * MAGIC[78]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[86])), z + ((r * MAGIC[86]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[125])), z + ((r * MAGIC[125]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[81]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[81]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[117])), z + ((r * MAGIC[117]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[129]) - (r * MAGIC[91])), z + ((r * MAGIC[91]) + (r * MAGIC[129]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[54])), z + ((r * MAGIC[54]) + (r * MAGIC[55]))))
                + ((float) n.noise(x + ((r * MAGIC[169]) - (r * MAGIC[132])), z + ((r * MAGIC[132]) + (r * MAGIC[169]))))) * 0.012658228F;
    }

    private static float sc80(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[169]) - (r * MAGIC[87])), z + ((r * MAGIC[87]) + (r * MAGIC[169]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[155])), z + ((r * MAGIC[155]) + (r * MAGIC[55]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[93])), z + ((r * MAGIC[93]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[129]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[129]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[41])), z + ((r * MAGIC[41]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[81]) - (r * MAGIC[80])), z + ((r * MAGIC[80]) + (r * MAGIC[81]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[47])), z + ((r * MAGIC[47]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[43])), z + ((r * MAGIC[43]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[78]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[78]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[126]) - (r * MAGIC[127])), z + ((r * MAGIC[127]) + (r * MAGIC[126]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[82])), z + ((r * MAGIC[82]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[130]) - (r * MAGIC[82])), z + ((r * MAGIC[82]) + (r * MAGIC[130]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[127])), z + ((r * MAGIC[127]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[170]) - (r * MAGIC[43])), z + ((r * MAGIC[43]) + (r * MAGIC[170]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[171]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[171]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[47])), z + ((r * MAGIC[47]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[80])), z + ((r * MAGIC[80]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[116]) - (r * MAGIC[41])), z + ((r * MAGIC[41]) + (r * MAGIC[116]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[92]) - (r * MAGIC[93])), z + ((r * MAGIC[93]) + (r * MAGIC[92]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[172]) - (r * MAGIC[155])), z + ((r * MAGIC[155]) + (r * MAGIC[172]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[87])), z + ((r * MAGIC[87]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[132])), z + ((r * MAGIC[132]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[172]) - (r * MAGIC[54])), z + ((r * MAGIC[54]) + (r * MAGIC[172]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[92]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[92]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[91])), z + ((r * MAGIC[91]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[116]) - (r * MAGIC[117])), z + ((r * MAGIC[117]) + (r * MAGIC[116]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[171]) - (r * MAGIC[125])), z + ((r * MAGIC[125]) + (r * MAGIC[171]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[170]) - (r * MAGIC[86])), z + ((r * MAGIC[86]) + (r * MAGIC[170]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[156])), z + ((r * MAGIC[156]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[52])), z + ((r * MAGIC[52]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[130]) - (r * MAGIC[118])), z + ((r * MAGIC[118]) + (r * MAGIC[130]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[118])), z + ((r * MAGIC[118]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[126]) - (r * MAGIC[52])), z + ((r * MAGIC[52]) + (r * MAGIC[126]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[78]) - (r * MAGIC[156])), z + ((r * MAGIC[156]) + (r * MAGIC[78]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[86])), z + ((r * MAGIC[86]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[125])), z + ((r * MAGIC[125]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[81]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[81]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[117])), z + ((r * MAGIC[117]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[129]) - (r * MAGIC[91])), z + ((r * MAGIC[91]) + (r * MAGIC[129]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[54])), z + ((r * MAGIC[54]) + (r * MAGIC[55]))))
                + ((float) n.noise(x + ((r * MAGIC[169]) - (r * MAGIC[132])), z + ((r * MAGIC[132]) + (r * MAGIC[169]))))) * 0.0125F;
    }

    private static float sc81(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[169]) - (r * MAGIC[87])), z + ((r * MAGIC[87]) + (r * MAGIC[169]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[155])), z + ((r * MAGIC[155]) + (r * MAGIC[55]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[93])), z + ((r * MAGIC[93]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[129]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[129]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[41])), z + ((r * MAGIC[41]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[81]) - (r * MAGIC[80])), z + ((r * MAGIC[80]) + (r * MAGIC[81]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[47])), z + ((r * MAGIC[47]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[43])), z + ((r * MAGIC[43]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[78]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[78]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[126]) - (r * MAGIC[127])), z + ((r * MAGIC[127]) + (r * MAGIC[126]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[82])), z + ((r * MAGIC[82]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[130]) - (r * MAGIC[82])), z + ((r * MAGIC[82]) + (r * MAGIC[130]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[127])), z + ((r * MAGIC[127]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[170]) - (r * MAGIC[43])), z + ((r * MAGIC[43]) + (r * MAGIC[170]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[171]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[171]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[47])), z + ((r * MAGIC[47]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[80])), z + ((r * MAGIC[80]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[116]) - (r * MAGIC[41])), z + ((r * MAGIC[41]) + (r * MAGIC[116]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[92]) - (r * MAGIC[93])), z + ((r * MAGIC[93]) + (r * MAGIC[92]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[172]) - (r * MAGIC[155])), z + ((r * MAGIC[155]) + (r * MAGIC[172]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[87])), z + ((r * MAGIC[87]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[132])), z + ((r * MAGIC[132]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[172]) - (r * MAGIC[54])), z + ((r * MAGIC[54]) + (r * MAGIC[172]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[92]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[92]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[91])), z + ((r * MAGIC[91]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[116]) - (r * MAGIC[117])), z + ((r * MAGIC[117]) + (r * MAGIC[116]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[171]) - (r * MAGIC[125])), z + ((r * MAGIC[125]) + (r * MAGIC[171]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[170]) - (r * MAGIC[86])), z + ((r * MAGIC[86]) + (r * MAGIC[170]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[156])), z + ((r * MAGIC[156]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[52])), z + ((r * MAGIC[52]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[130]) - (r * MAGIC[118])), z + ((r * MAGIC[118]) + (r * MAGIC[130]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[118])), z + ((r * MAGIC[118]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[126]) - (r * MAGIC[52])), z + ((r * MAGIC[52]) + (r * MAGIC[126]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[78]) - (r * MAGIC[156])), z + ((r * MAGIC[156]) + (r * MAGIC[78]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[86])), z + ((r * MAGIC[86]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[125])), z + ((r * MAGIC[125]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[81]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[81]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[117])), z + ((r * MAGIC[117]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[129]) - (r * MAGIC[91])), z + ((r * MAGIC[91]) + (r * MAGIC[129]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[54])), z + ((r * MAGIC[54]) + (r * MAGIC[55]))))
                + ((float) n.noise(x + ((r * MAGIC[169]) - (r * MAGIC[132])), z + ((r * MAGIC[132]) + (r * MAGIC[169]))))) * 0.012345679F;
    }

    private static float sc82(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[169]) - (r * MAGIC[87])), z + ((r * MAGIC[87]) + (r * MAGIC[169]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[155])), z + ((r * MAGIC[155]) + (r * MAGIC[55]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[93])), z + ((r * MAGIC[93]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[129]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[129]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[41])), z + ((r * MAGIC[41]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[81]) - (r * MAGIC[80])), z + ((r * MAGIC[80]) + (r * MAGIC[81]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[47])), z + ((r * MAGIC[47]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[43])), z + ((r * MAGIC[43]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[78]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[78]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[126]) - (r * MAGIC[127])), z + ((r * MAGIC[127]) + (r * MAGIC[126]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[82])), z + ((r * MAGIC[82]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[130]) - (r * MAGIC[82])), z + ((r * MAGIC[82]) + (r * MAGIC[130]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[127])), z + ((r * MAGIC[127]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[170]) - (r * MAGIC[43])), z + ((r * MAGIC[43]) + (r * MAGIC[170]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[171]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[171]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[47])), z + ((r * MAGIC[47]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[80])), z + ((r * MAGIC[80]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[116]) - (r * MAGIC[41])), z + ((r * MAGIC[41]) + (r * MAGIC[116]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[92]) - (r * MAGIC[93])), z + ((r * MAGIC[93]) + (r * MAGIC[92]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[172]) - (r * MAGIC[155])), z + ((r * MAGIC[155]) + (r * MAGIC[172]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[87])), z + ((r * MAGIC[87]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[132])), z + ((r * MAGIC[132]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[172]) - (r * MAGIC[54])), z + ((r * MAGIC[54]) + (r * MAGIC[172]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[92]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[92]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[91])), z + ((r * MAGIC[91]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[116]) - (r * MAGIC[117])), z + ((r * MAGIC[117]) + (r * MAGIC[116]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[171]) - (r * MAGIC[125])), z + ((r * MAGIC[125]) + (r * MAGIC[171]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[170]) - (r * MAGIC[86])), z + ((r * MAGIC[86]) + (r * MAGIC[170]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[156])), z + ((r * MAGIC[156]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[52])), z + ((r * MAGIC[52]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[130]) - (r * MAGIC[118])), z + ((r * MAGIC[118]) + (r * MAGIC[130]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[118])), z + ((r * MAGIC[118]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[126]) - (r * MAGIC[52])), z + ((r * MAGIC[52]) + (r * MAGIC[126]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[78]) - (r * MAGIC[156])), z + ((r * MAGIC[156]) + (r * MAGIC[78]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[86])), z + ((r * MAGIC[86]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[125])), z + ((r * MAGIC[125]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[81]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[81]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[117])), z + ((r * MAGIC[117]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[129]) - (r * MAGIC[91])), z + ((r * MAGIC[91]) + (r * MAGIC[129]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[54])), z + ((r * MAGIC[54]) + (r * MAGIC[55]))))
                + ((float) n.noise(x + ((r * MAGIC[169]) - (r * MAGIC[132])), z + ((r * MAGIC[132]) + (r * MAGIC[169]))))) * 0.0121951215F;
    }

    private static float sc83(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[169]) - (r * MAGIC[87])), z + ((r * MAGIC[87]) + (r * MAGIC[169]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[155])), z + ((r * MAGIC[155]) + (r * MAGIC[55]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[93])), z + ((r * MAGIC[93]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[129]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[129]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[41])), z + ((r * MAGIC[41]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[81]) - (r * MAGIC[80])), z + ((r * MAGIC[80]) + (r * MAGIC[81]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[47])), z + ((r * MAGIC[47]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[43])), z + ((r * MAGIC[43]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[78]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[78]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[126]) - (r * MAGIC[127])), z + ((r * MAGIC[127]) + (r * MAGIC[126]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[82])), z + ((r * MAGIC[82]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[130]) - (r * MAGIC[82])), z + ((r * MAGIC[82]) + (r * MAGIC[130]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[127])), z + ((r * MAGIC[127]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[170]) - (r * MAGIC[43])), z + ((r * MAGIC[43]) + (r * MAGIC[170]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[171]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[171]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[47])), z + ((r * MAGIC[47]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[80])), z + ((r * MAGIC[80]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[116]) - (r * MAGIC[41])), z + ((r * MAGIC[41]) + (r * MAGIC[116]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[92]) - (r * MAGIC[93])), z + ((r * MAGIC[93]) + (r * MAGIC[92]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[172]) - (r * MAGIC[155])), z + ((r * MAGIC[155]) + (r * MAGIC[172]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[87])), z + ((r * MAGIC[87]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[132])), z + ((r * MAGIC[132]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[172]) - (r * MAGIC[54])), z + ((r * MAGIC[54]) + (r * MAGIC[172]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[92]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[92]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[91])), z + ((r * MAGIC[91]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[116]) - (r * MAGIC[117])), z + ((r * MAGIC[117]) + (r * MAGIC[116]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[171]) - (r * MAGIC[125])), z + ((r * MAGIC[125]) + (r * MAGIC[171]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[170]) - (r * MAGIC[86])), z + ((r * MAGIC[86]) + (r * MAGIC[170]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[156])), z + ((r * MAGIC[156]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[52])), z + ((r * MAGIC[52]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[130]) - (r * MAGIC[118])), z + ((r * MAGIC[118]) + (r * MAGIC[130]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[118])), z + ((r * MAGIC[118]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[126]) - (r * MAGIC[52])), z + ((r * MAGIC[52]) + (r * MAGIC[126]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[78]) - (r * MAGIC[156])), z + ((r * MAGIC[156]) + (r * MAGIC[78]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[86])), z + ((r * MAGIC[86]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[125])), z + ((r * MAGIC[125]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[81]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[81]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[117])), z + ((r * MAGIC[117]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[129]) - (r * MAGIC[91])), z + ((r * MAGIC[91]) + (r * MAGIC[129]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[54])), z + ((r * MAGIC[54]) + (r * MAGIC[55]))))
                + ((float) n.noise(x + ((r * MAGIC[169]) - (r * MAGIC[132])), z + ((r * MAGIC[132]) + (r * MAGIC[169]))))) * 0.012048192F;
    }

    private static float sc84(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[169]) - (r * MAGIC[87])), z + ((r * MAGIC[87]) + (r * MAGIC[169]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[155])), z + ((r * MAGIC[155]) + (r * MAGIC[55]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[93])), z + ((r * MAGIC[93]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[129]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[129]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[41])), z + ((r * MAGIC[41]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[81]) - (r * MAGIC[80])), z + ((r * MAGIC[80]) + (r * MAGIC[81]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[47])), z + ((r * MAGIC[47]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[43])), z + ((r * MAGIC[43]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[78]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[78]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[126]) - (r * MAGIC[127])), z + ((r * MAGIC[127]) + (r * MAGIC[126]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[82])), z + ((r * MAGIC[82]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[130]) - (r * MAGIC[82])), z + ((r * MAGIC[82]) + (r * MAGIC[130]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[127])), z + ((r * MAGIC[127]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[170]) - (r * MAGIC[43])), z + ((r * MAGIC[43]) + (r * MAGIC[170]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[171]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[171]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[47])), z + ((r * MAGIC[47]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[80])), z + ((r * MAGIC[80]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[116]) - (r * MAGIC[41])), z + ((r * MAGIC[41]) + (r * MAGIC[116]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[92]) - (r * MAGIC[93])), z + ((r * MAGIC[93]) + (r * MAGIC[92]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[172]) - (r * MAGIC[155])), z + ((r * MAGIC[155]) + (r * MAGIC[172]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[87])), z + ((r * MAGIC[87]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[132])), z + ((r * MAGIC[132]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[172]) - (r * MAGIC[54])), z + ((r * MAGIC[54]) + (r * MAGIC[172]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[92]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[92]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[91])), z + ((r * MAGIC[91]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[116]) - (r * MAGIC[117])), z + ((r * MAGIC[117]) + (r * MAGIC[116]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[171]) - (r * MAGIC[125])), z + ((r * MAGIC[125]) + (r * MAGIC[171]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[170]) - (r * MAGIC[86])), z + ((r * MAGIC[86]) + (r * MAGIC[170]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[156])), z + ((r * MAGIC[156]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[52])), z + ((r * MAGIC[52]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[130]) - (r * MAGIC[118])), z + ((r * MAGIC[118]) + (r * MAGIC[130]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[118])), z + ((r * MAGIC[118]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[126]) - (r * MAGIC[52])), z + ((r * MAGIC[52]) + (r * MAGIC[126]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[78]) - (r * MAGIC[156])), z + ((r * MAGIC[156]) + (r * MAGIC[78]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[86])), z + ((r * MAGIC[86]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[125])), z + ((r * MAGIC[125]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[81]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[81]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[117])), z + ((r * MAGIC[117]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[129]) - (r * MAGIC[91])), z + ((r * MAGIC[91]) + (r * MAGIC[129]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[54])), z + ((r * MAGIC[54]) + (r * MAGIC[55]))))
                + ((float) n.noise(x + ((r * MAGIC[169]) - (r * MAGIC[132])), z + ((r * MAGIC[132]) + (r * MAGIC[169]))))) * 0.011904762F;
    }

    private static float sc85(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[169]) - (r * MAGIC[87])), z + ((r * MAGIC[87]) + (r * MAGIC[169]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[155])), z + ((r * MAGIC[155]) + (r * MAGIC[55]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[93])), z + ((r * MAGIC[93]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[129]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[129]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[41])), z + ((r * MAGIC[41]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[81]) - (r * MAGIC[80])), z + ((r * MAGIC[80]) + (r * MAGIC[81]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[47])), z + ((r * MAGIC[47]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[43])), z + ((r * MAGIC[43]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[78]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[78]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[126]) - (r * MAGIC[127])), z + ((r * MAGIC[127]) + (r * MAGIC[126]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[82])), z + ((r * MAGIC[82]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[130]) - (r * MAGIC[82])), z + ((r * MAGIC[82]) + (r * MAGIC[130]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[127])), z + ((r * MAGIC[127]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[170]) - (r * MAGIC[43])), z + ((r * MAGIC[43]) + (r * MAGIC[170]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[171]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[171]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[47])), z + ((r * MAGIC[47]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[80])), z + ((r * MAGIC[80]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[116]) - (r * MAGIC[41])), z + ((r * MAGIC[41]) + (r * MAGIC[116]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[92]) - (r * MAGIC[93])), z + ((r * MAGIC[93]) + (r * MAGIC[92]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[172]) - (r * MAGIC[155])), z + ((r * MAGIC[155]) + (r * MAGIC[172]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[87])), z + ((r * MAGIC[87]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[132])), z + ((r * MAGIC[132]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[172]) - (r * MAGIC[54])), z + ((r * MAGIC[54]) + (r * MAGIC[172]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[92]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[92]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[91])), z + ((r * MAGIC[91]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[116]) - (r * MAGIC[117])), z + ((r * MAGIC[117]) + (r * MAGIC[116]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[171]) - (r * MAGIC[125])), z + ((r * MAGIC[125]) + (r * MAGIC[171]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[170]) - (r * MAGIC[86])), z + ((r * MAGIC[86]) + (r * MAGIC[170]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[156])), z + ((r * MAGIC[156]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[52])), z + ((r * MAGIC[52]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[130]) - (r * MAGIC[118])), z + ((r * MAGIC[118]) + (r * MAGIC[130]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[118])), z + ((r * MAGIC[118]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[126]) - (r * MAGIC[52])), z + ((r * MAGIC[52]) + (r * MAGIC[126]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[78]) - (r * MAGIC[156])), z + ((r * MAGIC[156]) + (r * MAGIC[78]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[86])), z + ((r * MAGIC[86]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[125])), z + ((r * MAGIC[125]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[81]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[81]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[117])), z + ((r * MAGIC[117]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[129]) - (r * MAGIC[91])), z + ((r * MAGIC[91]) + (r * MAGIC[129]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[54])), z + ((r * MAGIC[54]) + (r * MAGIC[55]))))
                + ((float) n.noise(x + ((r * MAGIC[169]) - (r * MAGIC[132])), z + ((r * MAGIC[132]) + (r * MAGIC[169]))))) * 0.011764706F;
    }

    private static float sc86(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[169]) - (r * MAGIC[87])), z + ((r * MAGIC[87]) + (r * MAGIC[169]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[155])), z + ((r * MAGIC[155]) + (r * MAGIC[55]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[93])), z + ((r * MAGIC[93]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[129]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[129]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[41])), z + ((r * MAGIC[41]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[81]) - (r * MAGIC[80])), z + ((r * MAGIC[80]) + (r * MAGIC[81]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[47])), z + ((r * MAGIC[47]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[43])), z + ((r * MAGIC[43]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[78]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[78]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[126]) - (r * MAGIC[127])), z + ((r * MAGIC[127]) + (r * MAGIC[126]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[82])), z + ((r * MAGIC[82]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[130]) - (r * MAGIC[82])), z + ((r * MAGIC[82]) + (r * MAGIC[130]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[127])), z + ((r * MAGIC[127]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[170]) - (r * MAGIC[43])), z + ((r * MAGIC[43]) + (r * MAGIC[170]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[171]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[171]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[47])), z + ((r * MAGIC[47]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[80])), z + ((r * MAGIC[80]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[116]) - (r * MAGIC[41])), z + ((r * MAGIC[41]) + (r * MAGIC[116]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[92]) - (r * MAGIC[93])), z + ((r * MAGIC[93]) + (r * MAGIC[92]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[172]) - (r * MAGIC[155])), z + ((r * MAGIC[155]) + (r * MAGIC[172]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[87])), z + ((r * MAGIC[87]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[132])), z + ((r * MAGIC[132]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[172]) - (r * MAGIC[54])), z + ((r * MAGIC[54]) + (r * MAGIC[172]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[92]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[92]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[91])), z + ((r * MAGIC[91]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[116]) - (r * MAGIC[117])), z + ((r * MAGIC[117]) + (r * MAGIC[116]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[171]) - (r * MAGIC[125])), z + ((r * MAGIC[125]) + (r * MAGIC[171]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[170]) - (r * MAGIC[86])), z + ((r * MAGIC[86]) + (r * MAGIC[170]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[156])), z + ((r * MAGIC[156]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[52])), z + ((r * MAGIC[52]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[130]) - (r * MAGIC[118])), z + ((r * MAGIC[118]) + (r * MAGIC[130]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[118])), z + ((r * MAGIC[118]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[126]) - (r * MAGIC[52])), z + ((r * MAGIC[52]) + (r * MAGIC[126]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[78]) - (r * MAGIC[156])), z + ((r * MAGIC[156]) + (r * MAGIC[78]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[86])), z + ((r * MAGIC[86]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[125])), z + ((r * MAGIC[125]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[81]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[81]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[117])), z + ((r * MAGIC[117]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[129]) - (r * MAGIC[91])), z + ((r * MAGIC[91]) + (r * MAGIC[129]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[54])), z + ((r * MAGIC[54]) + (r * MAGIC[55]))))
                + ((float) n.noise(x + ((r * MAGIC[169]) - (r * MAGIC[132])), z + ((r * MAGIC[132]) + (r * MAGIC[169]))))) * 0.011627907F;
    }

    private static float sc87(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[169]) - (r * MAGIC[87])), z + ((r * MAGIC[87]) + (r * MAGIC[169]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[155])), z + ((r * MAGIC[155]) + (r * MAGIC[55]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[93])), z + ((r * MAGIC[93]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[129]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[129]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[41])), z + ((r * MAGIC[41]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[81]) - (r * MAGIC[80])), z + ((r * MAGIC[80]) + (r * MAGIC[81]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[47])), z + ((r * MAGIC[47]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[43])), z + ((r * MAGIC[43]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[78]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[78]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[126]) - (r * MAGIC[127])), z + ((r * MAGIC[127]) + (r * MAGIC[126]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[82])), z + ((r * MAGIC[82]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[130]) - (r * MAGIC[82])), z + ((r * MAGIC[82]) + (r * MAGIC[130]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[127])), z + ((r * MAGIC[127]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[170]) - (r * MAGIC[43])), z + ((r * MAGIC[43]) + (r * MAGIC[170]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[171]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[171]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[47])), z + ((r * MAGIC[47]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[80])), z + ((r * MAGIC[80]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[116]) - (r * MAGIC[41])), z + ((r * MAGIC[41]) + (r * MAGIC[116]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[92]) - (r * MAGIC[93])), z + ((r * MAGIC[93]) + (r * MAGIC[92]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[172]) - (r * MAGIC[155])), z + ((r * MAGIC[155]) + (r * MAGIC[172]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[87])), z + ((r * MAGIC[87]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[132])), z + ((r * MAGIC[132]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[172]) - (r * MAGIC[54])), z + ((r * MAGIC[54]) + (r * MAGIC[172]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[92]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[92]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[91])), z + ((r * MAGIC[91]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[116]) - (r * MAGIC[117])), z + ((r * MAGIC[117]) + (r * MAGIC[116]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[171]) - (r * MAGIC[125])), z + ((r * MAGIC[125]) + (r * MAGIC[171]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[170]) - (r * MAGIC[86])), z + ((r * MAGIC[86]) + (r * MAGIC[170]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[156])), z + ((r * MAGIC[156]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[52])), z + ((r * MAGIC[52]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[130]) - (r * MAGIC[118])), z + ((r * MAGIC[118]) + (r * MAGIC[130]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[118])), z + ((r * MAGIC[118]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[126]) - (r * MAGIC[52])), z + ((r * MAGIC[52]) + (r * MAGIC[126]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[78]) - (r * MAGIC[156])), z + ((r * MAGIC[156]) + (r * MAGIC[78]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[86])), z + ((r * MAGIC[86]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[125])), z + ((r * MAGIC[125]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[81]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[81]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[117])), z + ((r * MAGIC[117]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[129]) - (r * MAGIC[91])), z + ((r * MAGIC[91]) + (r * MAGIC[129]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[54])), z + ((r * MAGIC[54]) + (r * MAGIC[55]))))
                + ((float) n.noise(x + ((r * MAGIC[169]) - (r * MAGIC[132])), z + ((r * MAGIC[132]) + (r * MAGIC[169]))))) * 0.011494253F;
    }

    private static float sc88(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[169]) - (r * MAGIC[87])), z + ((r * MAGIC[87]) + (r * MAGIC[169]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[155])), z + ((r * MAGIC[155]) + (r * MAGIC[55]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[93])), z + ((r * MAGIC[93]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[129]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[129]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[41])), z + ((r * MAGIC[41]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[81]) - (r * MAGIC[80])), z + ((r * MAGIC[80]) + (r * MAGIC[81]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[47])), z + ((r * MAGIC[47]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[43])), z + ((r * MAGIC[43]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[78]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[78]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[126]) - (r * MAGIC[127])), z + ((r * MAGIC[127]) + (r * MAGIC[126]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[82])), z + ((r * MAGIC[82]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[130]) - (r * MAGIC[82])), z + ((r * MAGIC[82]) + (r * MAGIC[130]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[127])), z + ((r * MAGIC[127]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[170]) - (r * MAGIC[43])), z + ((r * MAGIC[43]) + (r * MAGIC[170]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[171]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[171]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[47])), z + ((r * MAGIC[47]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[80])), z + ((r * MAGIC[80]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[116]) - (r * MAGIC[41])), z + ((r * MAGIC[41]) + (r * MAGIC[116]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[92]) - (r * MAGIC[93])), z + ((r * MAGIC[93]) + (r * MAGIC[92]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[172]) - (r * MAGIC[155])), z + ((r * MAGIC[155]) + (r * MAGIC[172]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[87])), z + ((r * MAGIC[87]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[132])), z + ((r * MAGIC[132]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[172]) - (r * MAGIC[54])), z + ((r * MAGIC[54]) + (r * MAGIC[172]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[92]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[92]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[91])), z + ((r * MAGIC[91]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[116]) - (r * MAGIC[117])), z + ((r * MAGIC[117]) + (r * MAGIC[116]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[171]) - (r * MAGIC[125])), z + ((r * MAGIC[125]) + (r * MAGIC[171]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[170]) - (r * MAGIC[86])), z + ((r * MAGIC[86]) + (r * MAGIC[170]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[156])), z + ((r * MAGIC[156]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[52])), z + ((r * MAGIC[52]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[130]) - (r * MAGIC[118])), z + ((r * MAGIC[118]) + (r * MAGIC[130]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[118])), z + ((r * MAGIC[118]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[126]) - (r * MAGIC[52])), z + ((r * MAGIC[52]) + (r * MAGIC[126]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[78]) - (r * MAGIC[156])), z + ((r * MAGIC[156]) + (r * MAGIC[78]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[86])), z + ((r * MAGIC[86]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[125])), z + ((r * MAGIC[125]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[81]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[81]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[117])), z + ((r * MAGIC[117]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[129]) - (r * MAGIC[91])), z + ((r * MAGIC[91]) + (r * MAGIC[129]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[54])), z + ((r * MAGIC[54]) + (r * MAGIC[55]))))
                + ((float) n.noise(x + ((r * MAGIC[169]) - (r * MAGIC[132])), z + ((r * MAGIC[132]) + (r * MAGIC[169]))))) * 0.011363637F;
    }

    private static float sc89(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[169]) - (r * MAGIC[87])), z + ((r * MAGIC[87]) + (r * MAGIC[169]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[155])), z + ((r * MAGIC[155]) + (r * MAGIC[55]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[93])), z + ((r * MAGIC[93]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[129]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[129]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[41])), z + ((r * MAGIC[41]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[81]) - (r * MAGIC[80])), z + ((r * MAGIC[80]) + (r * MAGIC[81]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[47])), z + ((r * MAGIC[47]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[43])), z + ((r * MAGIC[43]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[78]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[78]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[126]) - (r * MAGIC[127])), z + ((r * MAGIC[127]) + (r * MAGIC[126]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[82])), z + ((r * MAGIC[82]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[130]) - (r * MAGIC[82])), z + ((r * MAGIC[82]) + (r * MAGIC[130]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[127])), z + ((r * MAGIC[127]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[170]) - (r * MAGIC[43])), z + ((r * MAGIC[43]) + (r * MAGIC[170]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[171]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[171]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[47])), z + ((r * MAGIC[47]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[80])), z + ((r * MAGIC[80]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[116]) - (r * MAGIC[41])), z + ((r * MAGIC[41]) + (r * MAGIC[116]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[92]) - (r * MAGIC[93])), z + ((r * MAGIC[93]) + (r * MAGIC[92]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[172]) - (r * MAGIC[155])), z + ((r * MAGIC[155]) + (r * MAGIC[172]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[87])), z + ((r * MAGIC[87]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[132])), z + ((r * MAGIC[132]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[172]) - (r * MAGIC[54])), z + ((r * MAGIC[54]) + (r * MAGIC[172]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[92]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[92]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[91])), z + ((r * MAGIC[91]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[116]) - (r * MAGIC[117])), z + ((r * MAGIC[117]) + (r * MAGIC[116]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[171]) - (r * MAGIC[125])), z + ((r * MAGIC[125]) + (r * MAGIC[171]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[170]) - (r * MAGIC[86])), z + ((r * MAGIC[86]) + (r * MAGIC[170]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[156])), z + ((r * MAGIC[156]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[52])), z + ((r * MAGIC[52]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[130]) - (r * MAGIC[118])), z + ((r * MAGIC[118]) + (r * MAGIC[130]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[118])), z + ((r * MAGIC[118]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[126]) - (r * MAGIC[52])), z + ((r * MAGIC[52]) + (r * MAGIC[126]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[78]) - (r * MAGIC[156])), z + ((r * MAGIC[156]) + (r * MAGIC[78]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[86])), z + ((r * MAGIC[86]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[125])), z + ((r * MAGIC[125]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[81]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[81]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[117])), z + ((r * MAGIC[117]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[129]) - (r * MAGIC[91])), z + ((r * MAGIC[91]) + (r * MAGIC[129]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[54])), z + ((r * MAGIC[54]) + (r * MAGIC[55]))))
                + ((float) n.noise(x + ((r * MAGIC[169]) - (r * MAGIC[132])), z + ((r * MAGIC[132]) + (r * MAGIC[169]))))) * 0.011235955F;
    }

    private static float sc90(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[169]) - (r * MAGIC[87])), z + ((r * MAGIC[87]) + (r * MAGIC[169]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[155])), z + ((r * MAGIC[155]) + (r * MAGIC[55]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[93])), z + ((r * MAGIC[93]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[129]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[129]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[41])), z + ((r * MAGIC[41]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[81]) - (r * MAGIC[80])), z + ((r * MAGIC[80]) + (r * MAGIC[81]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[47])), z + ((r * MAGIC[47]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[43])), z + ((r * MAGIC[43]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[78]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[78]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[126]) - (r * MAGIC[127])), z + ((r * MAGIC[127]) + (r * MAGIC[126]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[82])), z + ((r * MAGIC[82]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[130]) - (r * MAGIC[82])), z + ((r * MAGIC[82]) + (r * MAGIC[130]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[127])), z + ((r * MAGIC[127]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[170]) - (r * MAGIC[43])), z + ((r * MAGIC[43]) + (r * MAGIC[170]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[171]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[171]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[47])), z + ((r * MAGIC[47]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[80])), z + ((r * MAGIC[80]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[116]) - (r * MAGIC[41])), z + ((r * MAGIC[41]) + (r * MAGIC[116]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[92]) - (r * MAGIC[93])), z + ((r * MAGIC[93]) + (r * MAGIC[92]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[172]) - (r * MAGIC[155])), z + ((r * MAGIC[155]) + (r * MAGIC[172]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[87])), z + ((r * MAGIC[87]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[132])), z + ((r * MAGIC[132]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[172]) - (r * MAGIC[54])), z + ((r * MAGIC[54]) + (r * MAGIC[172]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[92]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[92]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[91])), z + ((r * MAGIC[91]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[116]) - (r * MAGIC[117])), z + ((r * MAGIC[117]) + (r * MAGIC[116]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[171]) - (r * MAGIC[125])), z + ((r * MAGIC[125]) + (r * MAGIC[171]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[170]) - (r * MAGIC[86])), z + ((r * MAGIC[86]) + (r * MAGIC[170]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[156])), z + ((r * MAGIC[156]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[52])), z + ((r * MAGIC[52]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[130]) - (r * MAGIC[118])), z + ((r * MAGIC[118]) + (r * MAGIC[130]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[118])), z + ((r * MAGIC[118]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[126]) - (r * MAGIC[52])), z + ((r * MAGIC[52]) + (r * MAGIC[126]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[78]) - (r * MAGIC[156])), z + ((r * MAGIC[156]) + (r * MAGIC[78]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[86])), z + ((r * MAGIC[86]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[125])), z + ((r * MAGIC[125]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[81]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[81]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[117])), z + ((r * MAGIC[117]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[129]) - (r * MAGIC[91])), z + ((r * MAGIC[91]) + (r * MAGIC[129]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[54])), z + ((r * MAGIC[54]) + (r * MAGIC[55]))))
                + ((float) n.noise(x + ((r * MAGIC[169]) - (r * MAGIC[132])), z + ((r * MAGIC[132]) + (r * MAGIC[169]))))) * 0.011111111F;
    }

    private static float sc91(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[27]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[27]))))) * 0.010989011F;
    }

    private static float sc92(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[27]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[27]))))) * 0.010869565F;
    }

    private static float sc93(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[27]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[27]))))) * 0.010752688F;
    }

    private static float sc94(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[27]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[27]))))) * 0.010638298F;
    }

    private static float sc95(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[27]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[27]))))) * 0.010526316F;
    }

    private static float sc96(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[27]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[27]))))) * 0.010416667F;
    }

    private static float sc97(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[27]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[27]))))) * 0.010309278F;
    }

    private static float sc98(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[27]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[27]))))) * 0.010204081F;
    }

    private static float sc99(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[27]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[27]))))) * 0.01010101F;
    }

    private static float sc100(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[27]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[27]))))) * 0.01F;
    }

    private static float sc101(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[27]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[27]))))) * 0.00990099F;
    }

    private static float sc102(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[27]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[27]))))) * 0.009803922F;
    }

    private static float sc103(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[27]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[27]))))) * 0.009708738F;
    }

    private static float sc104(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[27]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[27]))))) * 0.009615385F;
    }

    private static float sc105(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[27]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[27]))))) * 0.00952381F;
    }

    private static float sc106(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[27]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[27]))))) * 0.009433962F;
    }

    private static float sc107(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[27]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[27]))))) * 0.009345794F;
    }

    private static float sc108(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[27]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[27]))))) * 0.009259259F;
    }

    private static float sc109(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[27]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[27]))))) * 0.0091743115F;
    }

    private static float sc110(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[27]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[27]))))) * 0.009090909F;
    }

    private static float sc111(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[27]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[27]))))) * 0.009009009F;
    }

    private static float sc112(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[27]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[27]))))) * 0.008928572F;
    }

    private static float sc113(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[27]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[27]))))) * 0.0088495575F;
    }

    private static float sc114(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[27]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[27]))))) * 0.00877193F;
    }

    private static float sc115(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[27]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[27]))))) * 0.008695652F;
    }

    private static float sc116(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[27]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[27]))))) * 0.00862069F;
    }

    private static float sc117(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[27]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[27]))))) * 0.008547009F;
    }

    private static float sc118(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[27]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[27]))))) * 0.008474576F;
    }

    private static float sc119(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[27]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[27]))))) * 0.008403362F;
    }

    private static float sc120(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[27]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[27])), z + ((r * MAGIC[27]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[57])), z + ((r * MAGIC[57]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[64])), z + ((r * MAGIC[64]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[97])), z + ((r * MAGIC[97]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[56])), z + ((r * MAGIC[56]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[146])), z + ((r * MAGIC[146]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[16])), z + ((r * MAGIC[16]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[28])), z + ((r * MAGIC[28]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[17])), z + ((r * MAGIC[17]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[99])), z + ((r * MAGIC[99]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[20])), z + ((r * MAGIC[20]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[96])), z + ((r * MAGIC[96]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[65])), z + ((r * MAGIC[65]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[58])), z + ((r * MAGIC[58]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[104])), z + ((r * MAGIC[104]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[103]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[103]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[60]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[60]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[24]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[24]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[175]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[175]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[21]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[21]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[100]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[100]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[101]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[101]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[29]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[29]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[102]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[102]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[174]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[174]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[61]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[61]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[173]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[173]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[25]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[25]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[59]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[59]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[26]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[26]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[104]) - (r * MAGIC[103])), z + ((r * MAGIC[103]) + (r * MAGIC[104]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[58]) - (r * MAGIC[60])), z + ((r * MAGIC[60]) + (r * MAGIC[58]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[65]) - (r * MAGIC[24])), z + ((r * MAGIC[24]) + (r * MAGIC[65]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[96]) - (r * MAGIC[175])), z + ((r * MAGIC[175]) + (r * MAGIC[96]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[20]) - (r * MAGIC[21])), z + ((r * MAGIC[21]) + (r * MAGIC[20]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[99]) - (r * MAGIC[100])), z + ((r * MAGIC[100]) + (r * MAGIC[99]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[17]) - (r * MAGIC[101])), z + ((r * MAGIC[101]) + (r * MAGIC[17]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[28]) - (r * MAGIC[29])), z + ((r * MAGIC[29]) + (r * MAGIC[28]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[16]) - (r * MAGIC[102])), z + ((r * MAGIC[102]) + (r * MAGIC[16]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[146]) - (r * MAGIC[174])), z + ((r * MAGIC[174]) + (r * MAGIC[146]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[56]) - (r * MAGIC[61])), z + ((r * MAGIC[61]) + (r * MAGIC[56]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[97]) - (r * MAGIC[173])), z + ((r * MAGIC[173]) + (r * MAGIC[97]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[64]) - (r * MAGIC[25])), z + ((r * MAGIC[25]) + (r * MAGIC[64]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[57]) - (r * MAGIC[59])), z + ((r * MAGIC[59]) + (r * MAGIC[57]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[27]) - (r * MAGIC[26])), z + ((r * MAGIC[26]) + (r * MAGIC[27]))))) * 0.008333334F;
    }

    private static float sc121(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[82]) - (r * MAGIC[83])), z + ((r * MAGIC[83]) + (r * MAGIC[82]))))
                + ((float) n.noise(x + ((r * MAGIC[169]) - (r * MAGIC[87])), z + ((r * MAGIC[87]) + (r * MAGIC[169]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[155])), z + ((r * MAGIC[155]) + (r * MAGIC[55]))))
                + ((float) n.noise(x + ((r * MAGIC[32]) - (r * MAGIC[33])), z + ((r * MAGIC[33]) + (r * MAGIC[32]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[127]) - (r * MAGIC[126])), z + ((r * MAGIC[126]) + (r * MAGIC[127]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[93])), z + ((r * MAGIC[93]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[79]) - (r * MAGIC[78])), z + ((r * MAGIC[78]) + (r * MAGIC[79]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[43]) - (r * MAGIC[44])), z + ((r * MAGIC[44]) + (r * MAGIC[43]))))
                + ((float) n.noise(x + ((r * MAGIC[129]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[129]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[41])), z + ((r * MAGIC[41]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[108]) - (r * MAGIC[107])), z + ((r * MAGIC[107]) + (r * MAGIC[108]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[47]) - (r * MAGIC[95])), z + ((r * MAGIC[95]) + (r * MAGIC[47]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[81]) - (r * MAGIC[80])), z + ((r * MAGIC[80]) + (r * MAGIC[81]))))
                + ((float) n.noise(x + ((r * MAGIC[80]) - (r * MAGIC[81])), z + ((r * MAGIC[81]) + (r * MAGIC[80]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[30]) - (r * MAGIC[31])), z + ((r * MAGIC[31]) + (r * MAGIC[30]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[47])), z + ((r * MAGIC[47]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[41]) - (r * MAGIC[42])), z + ((r * MAGIC[42]) + (r * MAGIC[41]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[128]) - (r * MAGIC[129])), z + ((r * MAGIC[129]) + (r * MAGIC[128]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[43])), z + ((r * MAGIC[43]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[78]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[78]))))
                + ((float) n.noise(x + ((r * MAGIC[34]) - (r * MAGIC[84])), z + ((r * MAGIC[84]) + (r * MAGIC[34]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[93]) - (r * MAGIC[123])), z + ((r * MAGIC[123]) + (r * MAGIC[93]))))
                + ((float) n.noise(x + ((r * MAGIC[126]) - (r * MAGIC[127])), z + ((r * MAGIC[127]) + (r * MAGIC[126]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[155]) - (r * MAGIC[55])), z + ((r * MAGIC[55]) + (r * MAGIC[155]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[87]) - (r * MAGIC[169])), z + ((r * MAGIC[169]) + (r * MAGIC[87]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[82])), z + ((r * MAGIC[82]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[7]) - (r * MAGIC[1])), z + ((r * MAGIC[1]) + (r * MAGIC[7]))))
                + ((float) n.noise(x + ((r * MAGIC[130]) - (r * MAGIC[82])), z + ((r * MAGIC[82]) + (r * MAGIC[130]))))
                + ((float) n.noise(x + ((r * MAGIC[132]) - (r * MAGIC[169])), z + ((r * MAGIC[169]) + (r * MAGIC[132]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[54]) - (r * MAGIC[55])), z + ((r * MAGIC[55]) + (r * MAGIC[54]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[127])), z + ((r * MAGIC[127]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[131]) - (r * MAGIC[123])), z + ((r * MAGIC[123]) + (r * MAGIC[131]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[36]) - (r * MAGIC[84])), z + ((r * MAGIC[84]) + (r * MAGIC[36]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[170]) - (r * MAGIC[43])), z + ((r * MAGIC[43]) + (r * MAGIC[170]))))
                + ((float) n.noise(x + ((r * MAGIC[91]) - (r * MAGIC[129])), z + ((r * MAGIC[129]) + (r * MAGIC[91]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[117]) - (r * MAGIC[42])), z + ((r * MAGIC[42]) + (r * MAGIC[117]))))
                + ((float) n.noise(x + ((r * MAGIC[171]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[171]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[47])), z + ((r * MAGIC[47]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[38]) - (r * MAGIC[31])), z + ((r * MAGIC[31]) + (r * MAGIC[38]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[50]) - (r * MAGIC[81])), z + ((r * MAGIC[81]) + (r * MAGIC[50]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[80])), z + ((r * MAGIC[80]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[94]) - (r * MAGIC[95])), z + ((r * MAGIC[95]) + (r * MAGIC[94]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[125]) - (r * MAGIC[107])), z + ((r * MAGIC[107]) + (r * MAGIC[125]))))
                + ((float) n.noise(x + ((r * MAGIC[116]) - (r * MAGIC[41])), z + ((r * MAGIC[41]) + (r * MAGIC[116]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[86]) - (r * MAGIC[44])), z + ((r * MAGIC[44]) + (r * MAGIC[86]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[156]) - (r * MAGIC[78])), z + ((r * MAGIC[78]) + (r * MAGIC[156]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[92]) - (r * MAGIC[93])), z + ((r * MAGIC[93]) + (r * MAGIC[92]))))
                + ((float) n.noise(x + ((r * MAGIC[52]) - (r * MAGIC[126])), z + ((r * MAGIC[126]) + (r * MAGIC[52]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[37]) - (r * MAGIC[33])), z + ((r * MAGIC[33]) + (r * MAGIC[37]))))
                + ((float) n.noise(x + ((r * MAGIC[172]) - (r * MAGIC[155])), z + ((r * MAGIC[155]) + (r * MAGIC[172]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[87])), z + ((r * MAGIC[87]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[118]) - (r * MAGIC[83])), z + ((r * MAGIC[83]) + (r * MAGIC[118]))))
                + ((float) n.noise(x + ((r * MAGIC[3]) - (r * MAGIC[2])), z + ((r * MAGIC[2]) + (r * MAGIC[3]))))
                + ((float) n.noise(x + ((r * MAGIC[118]) - (r * MAGIC[130])), z + ((r * MAGIC[130]) + (r * MAGIC[118]))))
                + ((float) n.noise(x + ((r * MAGIC[88]) - (r * MAGIC[132])), z + ((r * MAGIC[132]) + (r * MAGIC[88]))))
                + ((float) n.noise(x + ((r * MAGIC[76]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[76]))))
                + ((float) n.noise(x + ((r * MAGIC[172]) - (r * MAGIC[54])), z + ((r * MAGIC[54]) + (r * MAGIC[172]))))
                + ((float) n.noise(x + ((r * MAGIC[37]) - (r * MAGIC[66])), z + ((r * MAGIC[66]) + (r * MAGIC[37]))))
                + ((float) n.noise(x + ((r * MAGIC[49]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[49]))))
                + ((float) n.noise(x + ((r * MAGIC[52]) - (r * MAGIC[53])), z + ((r * MAGIC[53]) + (r * MAGIC[52]))))
                + ((float) n.noise(x + ((r * MAGIC[92]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[92]))))
                + ((float) n.noise(x + ((r * MAGIC[14]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[14]))))
                + ((float) n.noise(x + ((r * MAGIC[35]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[35]))))
                + ((float) n.noise(x + ((r * MAGIC[156]) - (r * MAGIC[124])), z + ((r * MAGIC[124]) + (r * MAGIC[156]))))
                + ((float) n.noise(x + ((r * MAGIC[23]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[23]))))
                + ((float) n.noise(x + ((r * MAGIC[86]) - (r * MAGIC[170])), z + ((r * MAGIC[170]) + (r * MAGIC[86]))))
                + ((float) n.noise(x + ((r * MAGIC[90]) - (r * MAGIC[91])), z + ((r * MAGIC[91]) + (r * MAGIC[90]))))
                + ((float) n.noise(x + ((r * MAGIC[6]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[6]))))
                + ((float) n.noise(x + ((r * MAGIC[116]) - (r * MAGIC[117])), z + ((r * MAGIC[117]) + (r * MAGIC[116]))))
                + ((float) n.noise(x + ((r * MAGIC[125]) - (r * MAGIC[171])), z + ((r * MAGIC[171]) + (r * MAGIC[125]))))
                + ((float) n.noise(x + ((r * MAGIC[12]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[12]))))
                + ((float) n.noise(x + ((r * MAGIC[94]) - (r * MAGIC[48])), z + ((r * MAGIC[48]) + (r * MAGIC[94]))))
                + ((float) n.noise(x + ((r * MAGIC[89]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[89]))))
                + ((float) n.noise(x + ((r * MAGIC[77]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[77]))))
                + ((float) n.noise(x + ((r * MAGIC[51]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[51]))))
                + ((float) n.noise(x + ((r * MAGIC[50]) - (r * MAGIC[51])), z + ((r * MAGIC[51]) + (r * MAGIC[50]))))
                + ((float) n.noise(x + ((r * MAGIC[85]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[85]))))
                + ((float) n.noise(x + ((r * MAGIC[38]) - (r * MAGIC[89])), z + ((r * MAGIC[89]) + (r * MAGIC[38]))))
                + ((float) n.noise(x + ((r * MAGIC[48]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[48]))))
                + ((float) n.noise(x + ((r * MAGIC[13]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[13]))))
                + ((float) n.noise(x + ((r * MAGIC[171]) - (r * MAGIC[125])), z + ((r * MAGIC[125]) + (r * MAGIC[171]))))
                + ((float) n.noise(x + ((r * MAGIC[117]) - (r * MAGIC[116])), z + ((r * MAGIC[116]) + (r * MAGIC[117]))))
                + ((float) n.noise(x + ((r * MAGIC[5]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[5]))))
                + ((float) n.noise(x + ((r * MAGIC[91]) - (r * MAGIC[90])), z + ((r * MAGIC[90]) + (r * MAGIC[91]))))
                + ((float) n.noise(x + ((r * MAGIC[170]) - (r * MAGIC[86])), z + ((r * MAGIC[86]) + (r * MAGIC[170]))))
                + ((float) n.noise(x + ((r * MAGIC[22]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[22]))))
                + ((float) n.noise(x + ((r * MAGIC[124]) - (r * MAGIC[156])), z + ((r * MAGIC[156]) + (r * MAGIC[124]))))
                + ((float) n.noise(x + ((r * MAGIC[36]) - (r * MAGIC[35])), z + ((r * MAGIC[35]) + (r * MAGIC[36]))))
                + ((float) n.noise(x + ((r * MAGIC[40]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[40]))))
                + ((float) n.noise(x + ((r * MAGIC[131]) - (r * MAGIC[92])), z + ((r * MAGIC[92]) + (r * MAGIC[131]))))
                + ((float) n.noise(x + ((r * MAGIC[53]) - (r * MAGIC[52])), z + ((r * MAGIC[52]) + (r * MAGIC[53]))))
                + ((float) n.noise(x + ((r * MAGIC[19]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[19]))))
                + ((float) n.noise(x + ((r * MAGIC[66]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[66]))))
                + ((float) n.noise(x + ((r * MAGIC[54]) - (r * MAGIC[172])), z + ((r * MAGIC[172]) + (r * MAGIC[54]))))
                + ((float) n.noise(x + ((r * MAGIC[46]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[46]))))
                + ((float) n.noise(x + ((r * MAGIC[132]) - (r * MAGIC[88])), z + ((r * MAGIC[88]) + (r * MAGIC[132]))))
                + ((float) n.noise(x + ((r * MAGIC[130]) - (r * MAGIC[118])), z + ((r * MAGIC[118]) + (r * MAGIC[130]))))
                + ((float) n.noise(x + ((r * MAGIC[8]) - (r * MAGIC[3])), z + ((r * MAGIC[3]) + (r * MAGIC[8]))))
                + ((float) n.noise(x + ((r * MAGIC[83]) - (r * MAGIC[118])), z + ((r * MAGIC[118]) + (r * MAGIC[83]))))
                + ((float) n.noise(x + ((r * MAGIC[87]) - (r * MAGIC[88])), z + ((r * MAGIC[88]) + (r * MAGIC[87]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[76])), z + ((r * MAGIC[76]) + (r * MAGIC[98]))))
                + ((float) n.noise(x + ((r * MAGIC[155]) - (r * MAGIC[172])), z + ((r * MAGIC[172]) + (r * MAGIC[155]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[37])), z + ((r * MAGIC[37]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[49])), z + ((r * MAGIC[49]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[126]) - (r * MAGIC[52])), z + ((r * MAGIC[52]) + (r * MAGIC[126]))))
                + ((float) n.noise(x + ((r * MAGIC[93]) - (r * MAGIC[92])), z + ((r * MAGIC[92]) + (r * MAGIC[93]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[14])), z + ((r * MAGIC[14]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[34]) - (r * MAGIC[35])), z + ((r * MAGIC[35]) + (r * MAGIC[34]))))
                + ((float) n.noise(x + ((r * MAGIC[78]) - (r * MAGIC[156])), z + ((r * MAGIC[156]) + (r * MAGIC[78]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[23])), z + ((r * MAGIC[23]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[86])), z + ((r * MAGIC[86]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[128]) - (r * MAGIC[90])), z + ((r * MAGIC[90]) + (r * MAGIC[128]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[6])), z + ((r * MAGIC[6]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[41]) - (r * MAGIC[116])), z + ((r * MAGIC[116]) + (r * MAGIC[41]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[125])), z + ((r * MAGIC[125]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[12])), z + ((r * MAGIC[12]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[94])), z + ((r * MAGIC[94]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[30]) - (r * MAGIC[89])), z + ((r * MAGIC[89]) + (r * MAGIC[30]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[77])), z + ((r * MAGIC[77]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[80]) - (r * MAGIC[51])), z + ((r * MAGIC[51]) + (r * MAGIC[80]))))
                + ((float) n.noise(x + ((r * MAGIC[81]) - (r * MAGIC[50])), z + ((r * MAGIC[50]) + (r * MAGIC[81]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[85])), z + ((r * MAGIC[85]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[38])), z + ((r * MAGIC[38]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[47]) - (r * MAGIC[48])), z + ((r * MAGIC[48]) + (r * MAGIC[47]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[13])), z + ((r * MAGIC[13]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[108]) - (r * MAGIC[171])), z + ((r * MAGIC[171]) + (r * MAGIC[108]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[117])), z + ((r * MAGIC[117]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[5])), z + ((r * MAGIC[5]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[129]) - (r * MAGIC[91])), z + ((r * MAGIC[91]) + (r * MAGIC[129]))))
                + ((float) n.noise(x + ((r * MAGIC[43]) - (r * MAGIC[170])), z + ((r * MAGIC[170]) + (r * MAGIC[43]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[22])), z + ((r * MAGIC[22]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[79]) - (r * MAGIC[124])), z + ((r * MAGIC[124]) + (r * MAGIC[79]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[36])), z + ((r * MAGIC[36]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[40])), z + ((r * MAGIC[40]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[131])), z + ((r * MAGIC[131]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[127]) - (r * MAGIC[53])), z + ((r * MAGIC[53]) + (r * MAGIC[127]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[19])), z + ((r * MAGIC[19]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[32]) - (r * MAGIC[66])), z + ((r * MAGIC[66]) + (r * MAGIC[32]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[54])), z + ((r * MAGIC[54]) + (r * MAGIC[55]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[46])), z + ((r * MAGIC[46]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[169]) - (r * MAGIC[132])), z + ((r * MAGIC[132]) + (r * MAGIC[169]))))
                + ((float) n.noise(x + ((r * MAGIC[82]) - (r * MAGIC[130])), z + ((r * MAGIC[130]) + (r * MAGIC[82]))))) * 0.008264462F;
    }

    private static float sc122(float x, float z, float r, NoiseProvider n) {
        return (((float) n.noise(x + ((r * MAGIC[1]) - (r * MAGIC[0])), z + ((r * MAGIC[0]) + (r * MAGIC[1]))))
                + ((float) n.noise(x + ((r * MAGIC[82]) - (r * MAGIC[83])), z + ((r * MAGIC[83]) + (r * MAGIC[82]))))
                + ((float) n.noise(x + ((r * MAGIC[169]) - (r * MAGIC[87])), z + ((r * MAGIC[87]) + (r * MAGIC[169]))))
                + ((float) n.noise(x + ((r * MAGIC[45]) - (r * MAGIC[98])), z + ((r * MAGIC[98]) + (r * MAGIC[45]))))
                + ((float) n.noise(x + ((r * MAGIC[55]) - (r * MAGIC[155])), z + ((r * MAGIC[155]) + (r * MAGIC[55]))))
                + ((float) n.noise(x + ((r * MAGIC[32]) - (r * MAGIC[33])), z + ((r * MAGIC[33]) + (r * MAGIC[32]))))
                + ((float) n.noise(x + ((r * MAGIC[18]) - (r * MAGIC[75])), z + ((r * MAGIC[75]) + (r * MAGIC[18]))))
                + ((float) n.noise(x + ((r * MAGIC[127]) - (r * MAGIC[126])), z + ((r * MAGIC[126]) + (r * MAGIC[127]))))
                + ((float) n.noise(x + ((r * MAGIC[123]) - (r * MAGIC[93])), z + ((r * MAGIC[93]) + (r * MAGIC[123]))))
                + ((float) n.noise(x + ((r * MAGIC[9]) - (r * MAGIC[10])), z + ((r * MAGIC[10]) + (r * MAGIC[9]))))
                + ((float) n.noise(x + ((r * MAGIC[84]) - (r * MAGIC[34])), z + ((r * MAGIC[34]) + (r * MAGIC[84]))))
                + ((float) n.noise(x + ((r * MAGIC[79]) - (r * MAGIC[78])), z + ((r * MAGIC[78]) + (r * MAGIC[79]))))
                + ((float) n.noise(x + ((r * MAGIC[72]) - (r * MAGIC[71])), z + ((r * MAGIC[71]) + (r * MAGIC[72]))))
                + ((float) n.noise(x + ((r * MAGIC[43]) - (r * MAGIC[44])), z + ((r * MAGIC[44]) + (r * MAGIC[43]))))
                + ((float) n.noise(x + ((r * MAGIC[129]) - (r * MAGIC[128])), z + ((r * MAGIC[128]) + (r * MAGIC[129]))))
                + ((float) n.noise(x + ((r * MAGIC[4]) - (r * MAGIC[15])), z + ((r * MAGIC[15]) + (r * MAGIC[4]))))
                + ((float) n.noise(x + ((r * MAGIC[42]) - (r * MAGIC[41])), z + ((r * MAGIC[41]) + (r * MAGIC[42]))))
                + ((float) n.noise(x + ((r * MAGIC[108]) - (r * MAGIC[107])), z + ((r * MAGIC[107]) + (r * MAGIC[108]))))
                + ((float) n.noise(x + ((r * MAGIC[39]) - (r * MAGIC[11])), z + ((r * MAGIC[11]) + (r * MAGIC[39]))))
                + ((float) n.noise(x + ((r * MAGIC[47]) - (r * MAGIC[95])), z + ((r * MAGIC[95]) + (r * MAGIC[47]))))
                + ((float) n.noise(x + ((r * MAGIC[31]) - (r * MAGIC[30])), z + ((r * MAGIC[30]) + (r * MAGIC[31]))))
                + ((float) n.noise(x + ((r * MAGIC[73]) - (r * MAGIC[74])), z + ((r * MAGIC[74]) + (r * MAGIC[73]))))
                + ((float) n.noise(x + ((r * MAGIC[81]) - (r * MAGIC[80])), z + ((r * MAGIC[80]) + (r * MAGIC[81]))))
                + ((float) n.noise(x + ((r * MAGIC[80]) - (r * MAGIC[81])), z + ((r * MAGIC[81]) + (r * MAGIC[80]))))
                + ((float) n.noise(x + ((r * MAGIC[74]) - (r * MAGIC[73])), z + ((r * MAGIC[73]) + (r * MAGIC[74]))))
                + ((float) n.noise(x + ((r * MAGIC[30]) - (r * MAGIC[31])), z + ((r * MAGIC[31]) + (r * MAGIC[30]))))
                + ((float) n.noise(x + ((r * MAGIC[95]) - (r * MAGIC[47])), z + ((r * MAGIC[47]) + (r * MAGIC[95]))))
                + ((float) n.noise(x + ((r * MAGIC[11]) - (r * MAGIC[39])), z + ((r * MAGIC[39]) + (r * MAGIC[11]))))
                + ((float) n.noise(x + ((r * MAGIC[107]) - (r * MAGIC[108])), z + ((r * MAGIC[108]) + (r * MAGIC[107]))))
                + ((float) n.noise(x + ((r * MAGIC[41]) - (r * MAGIC[42])), z + ((r * MAGIC[42]) + (r * MAGIC[41]))))
                + ((float) n.noise(x + ((r * MAGIC[15]) - (r * MAGIC[4])), z + ((r * MAGIC[4]) + (r * MAGIC[15]))))
                + ((float) n.noise(x + ((r * MAGIC[128]) - (r * MAGIC[129])), z + ((r * MAGIC[129]) + (r * MAGIC[128]))))
                + ((float) n.noise(x + ((r * MAGIC[44]) - (r * MAGIC[43])), z + ((r * MAGIC[43]) + (r * MAGIC[44]))))
                + ((float) n.noise(x + ((r * MAGIC[71]) - (r * MAGIC[72])), z + ((r * MAGIC[72]) + (r * MAGIC[71]))))
                + ((float) n.noise(x + ((r * MAGIC[78]) - (r * MAGIC[79])), z + ((r * MAGIC[79]) + (r * MAGIC[78]))))
                + ((float) n.noise(x + ((r * MAGIC[34]) - (r * MAGIC[84])), z + ((r * MAGIC[84]) + (r * MAGIC[34]))))
                + ((float) n.noise(x + ((r * MAGIC[10]) - (r * MAGIC[9])), z + ((r * MAGIC[9]) + (r * MAGIC[10]))))
                + ((float) n.noise(x + ((r * MAGIC[93]) - (r * MAGIC[123])), z + ((r * MAGIC[123]) + (r * MAGIC[93]))))
                + ((float) n.noise(x + ((r * MAGIC[126]) - (r * MAGIC[127])), z + ((r * MAGIC[127]) + (r * MAGIC[126]))))
                + ((float) n.noise(x + ((r * MAGIC[75]) - (r * MAGIC[18])), z + ((r * MAGIC[18]) + (r * MAGIC[75]))))
                + ((float) n.noise(x + ((r * MAGIC[33]) - (r * MAGIC[32])), z + ((r * MAGIC[32]) + (r * MAGIC[33]))))
                + ((float) n.noise(x + ((r * MAGIC[155]) - (r * MAGIC[55])), z + ((r * MAGIC[55]) + (r * MAGIC[155]))))
                + ((float) n.noise(x + ((r * MAGIC[98]) - (r * MAGIC[45])), z + ((r * MAGIC[45]) + (r * MAGIC[98]))))
        