<?php

namespace Fabiang\Xmpp\Connection;

use Fabiang\Xmpp\Options;
use Fabiang\Xmpp\Connection\Socket;
use Fabiang\Xmpp\EventListener\Stream\Stream;

/**
 * Generated by PHPUnit_SkeletonGenerator 1.2.1 on 2014-01-20 at 15:29:46.
 */
class TestTest extends \PHPUnit_Framework_TestCase
{

    /**
     * @var Test
     */
    protected $object;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     *
     * @return void
     */
    protected function setUp()
    {
        $options = new Options;
        $options->setTo('test');
        $this->object = new Test;
        $this->object->setOptions($options);
        $options->setConnection($this->object);
    }

    /**
     * Test connect.
     *
     * @covers Fabiang\Xmpp\Connection\Test::connect
     * @return void
     */
    public function testConnect()
    {
        $this->object->connect();
        $this->assertContains(
            sprintf(Socket::STREAM_START, 'test'),
            $this->object->getBuffer()
        );
        $this->assertTrue($this->object->isConnected());
    }

    /**
     * Test disconnect.
     *
     * @covers Fabiang\Xmpp\Connection\Test::disconnect
     * @return void
     */
    public function testDisconnect()
    {
        $this->object->connect();
        $this->assertTrue($this->object->isConnected());
        $this->object->disconnect();
        $this->assertContains(Socket::STREAM_END, $this->object->getBuffer());
        $this->assertFalse($this->object->isConnected());
    }

    /**
     * Test receiving data.
     *
     * @covers Fabiang\Xmpp\Connection\Test::receive
     * @return void
     */
    public function testReceive()
    {
        $received1 = '<?xml version="1.0"?><test xmlns="test">';
        $received2 = '<test></test>';

        $this->object->setData(array($received1, $received2));

        $this->assertSame($received1, $this->object->receive());
        $this->assertSame($received2, $this->object->receive());
        $this->assertNull($this->object->receive());
    }

    /**
     * Test sending data.
     *
     * @covers Fabiang\Xmpp\Connection\Test::send
     * @covers Fabiang\Xmpp\Connection\Test::getBuffer
     * @return void
     */
    public function testSend()
    {
        $this->object->connect();
        $this->object->send('<test></test>');
        $buffer = $this->object->getBuffer();
        $this->assertSame('<test></test>', $buffer[1]);
    }

    /**
     * Test setting and getting data.
     *
     * @covers Fabiang\Xmpp\Connection\Test::setData
     * @covers Fabiang\Xmpp\Connection\Test::getData
     * @return void
     */
    public function testSetAndGetData()
    {
        $this->assertSame(array(1, 2, 3), $this->object->setData(array(1, 2, 3))->getData());
    }
    
    /**
     * 
     * 
     * @covers Fabiang\Xmpp\Connection\Test::checkBlockingListeners
     * @return void
     */
    public function testBlockingListener()
    {
        $eventListener = new Stream;
        $eventListener->setEventManager($this->object->getEventManager())
            ->setOptions($this->object->getOptions())
            ->attachEvents();
        $this->object->addListener($eventListener);
        
        $this->object->setData(array(
           "<?xml version='1.0'?><stream:stream xmlns='jabber:client' xmlns:stream='http://etherx.jabber.org/streams' "
            . "id='1234567890' from='localhost' version='1.0' xml:lang='en'><stream:features></stream:features>" 
        ));
        $this->object->connect();
        $this->assertContains(sprintf(Socket::STREAM_START, 'test'), $this->object->getBuffer());
    }

}
