<?php

/**
 * Copyright 2014 Fabian Grutschus. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are those
 * of the authors and should not be interpreted as representing official policies,
 * either expressed or implied, of the copyright holders.
 *
 * @author    Fabian Grutschus <f.grutschus@lubyte.de>
 * @copyright 2014 Fabian Grutschus. All rights reserved.
 * @license   BSD
 * @link      http://github.com/fabiang/xmpp
 */

namespace Fabiang\Xmpp\Event;

/**
 * Generated by PHPUnit_SkeletonGenerator 1.2.1 on 2013-12-31 at 20:01:01.
 */
class EventTest extends \PHPUnit_Framework_TestCase
{

    /**
     * @var Event
     */
    protected $object;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     *
     * @return void
     */
    protected function setUp()
    {
        $this->object = new Event;
    }

    /**
     * Test setting and getting name.
     *
     * @covers Fabiang\Xmpp\Event\Event::getName
     * @covers Fabiang\Xmpp\Event\Event::setName
     * @return void
     */
    public function testSetAndGetName()
    {
        $this->assertSame('1', $this->object->setName(1)->getName());
    }

    /**
     * Test setting and getting target.
     *
     * @covers Fabiang\Xmpp\Event\Event::getTarget
     * @covers Fabiang\Xmpp\Event\Event::setTarget
     * @return void
     */
    public function testSetAndGetTarget()
    {
        $target = new \stdClass();
        $this->assertSame($target, $this->object->setTarget($target)->getTarget());
    }

    /**
     * Test setting and getting parameters.
     *
     * @covers Fabiang\Xmpp\Event\Event::getParameters
     * @covers Fabiang\Xmpp\Event\Event::setParameters
     * @return void
     */
    public function testGetParameters()
    {
        $params = array(1, 2, 3);
        $this->assertSame($params, $this->object->setParameters($params)->getParameters());
    }

    /**
     * Test setting and getting event stack.
     *
     * @covers Fabiang\Xmpp\Event\Event::getEventStack
     * @covers Fabiang\Xmpp\Event\Event::setEventStack
     * @return void
     */
    public function testSetAndGetEventStack()
    {
        $stack = array(function() {

        });
        $this->assertSame($stack, $this->object->setEventStack($stack)->getEventStack());
    }
    
    /**
     * Test getting parameter by index.
     * 
     * @covers Fabiang\Xmpp\Event\Event::getParameter
     * @return void
     */
    public function testGetParameter()
    {
        $this->object->setParameters(array(1, 2, 3));
        $this->assertSame(1, $this->object->getParameter(0));
        $this->assertSame(2, $this->object->getParameter(1));
        $this->assertSame(3, $this->object->getParameter(2));
    }
    
    /**
     * Test getting parameter by missing index.
     * 
     * @covers Fabiang\Xmpp\Event\Event::getParameter
     * @expectedException \Fabiang\Xmpp\Exception\OutOfRangeException
     * @return void
     */
    public function testGetParameterNotSet()
    {
        $this->object->getParameter(0);
    }
    
    /**
     * Test getting parameter by missing index.
     * 
     * @covers Fabiang\Xmpp\Event\Event::getParameter
     * @expectedException \Fabiang\Xmpp\Exception\InvalidArgumentException
     * @return void
     */
    public function testGetParameterIbvalidType()
    {
        $this->object->getParameter('test');
    }

}
