<?php

/**
 * Copyright 2014 Fabian Grutschus. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are those
 * of the authors and should not be interpreted as representing official policies,
 * either expressed or implied, of the copyright holders.
 *
 * @author    Fabian Grutschus <f.grutschus@lubyte.de>
 * @copyright 2014 Fabian Grutschus. All rights reserved.
 * @license   BSD
 * @link      http://github.com/fabiang/xmpp
 */

namespace Fabiang\Xmpp\Exception\Stream;

use Fabiang\Xmpp\Event\XMLEvent;

/**
 * Generated by PHPUnit_SkeletonGenerator 1.2.1 on 2014-01-17 at 11:18:45.
 */
class StreamErrorExceptionTest extends \PHPUnit_Framework_TestCase
{

    /**
     * Test create exception from XMLEvent.
     *
     * @covers Fabiang\Xmpp\Exception\Stream\StreamErrorException::createFromEvent
     * @return void
     */
    public function testCreateFromEventGeneric()
    {
        $document = new \DOMDocument;
        $element = new \DOMElement('error');
        $document->appendChild($element);
        $event   = new XMLEvent;
        $event->setParameters(array($element));
        
        $exception = StreamErrorException::createFromEvent($event);
        $this->assertSame('Generic stream error', $exception->getMessage());
        $this->assertSame('<error/>', $exception->getContent());
    }
    
    /**
     * Test create exception from XMLEvent.
     *
     * @covers Fabiang\Xmpp\Exception\Stream\StreamErrorException::createFromEvent
     * @return void
     */
    public function testCreateFromEventNamed()
    {
        $document = new \DOMDocument;
        $element = new \DOMElement('error');
        $document->appendChild($element);
        
        $reason = new \DOMElement('host-unknown');
        $element->appendChild($reason);
        
        $event   = new XMLEvent;
        $event->setParameters(array($element));
        
        $exception = StreamErrorException::createFromEvent($event);
        $this->assertSame('Stream Error: "host-unknown"', $exception->getMessage());
        $this->assertSame('<error><host-unknown/></error>', $exception->getContent());
    }

    /**
     * Test setting and getting content.
     *
     * @covers Fabiang\Xmpp\Exception\Stream\StreamErrorException::getContent
     * @covers Fabiang\Xmpp\Exception\Stream\StreamErrorException::setContent
     * @return void
     */
    public function testSetAndGetContent()
    {
        $object = new StreamErrorException;
        $this->assertSame('1', $object->setContent(1)->getContent());
    }

}
