<?php

/**
 * Copyright 2014 Fabian Grutschus. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are those
 * of the authors and should not be interpreted as representing official policies,
 * either expressed or implied, of the copyright holders.
 *
 * @author    Fabian Grutschus <f.grutschus@lubyte.de>
 * @copyright 2014 Fabian Grutschus. All rights reserved.
 * @license   BSD
 * @link      http://github.com/fabiang/xmpp
 */

namespace Fabiang\Xmpp\Exception;

/**
 * Generated by PHPUnit_SkeletonGenerator 1.2.1 on 2014-01-17 at 11:09:05.
 */
class XMLParserExceptionTest extends \PHPUnit_Framework_TestCase
{

    /**
     * Test creation of exception.
     * 
     * @covers Fabiang\Xmpp\Exception\XMLParserException::create
     * @return void
     */
    public function testCreate()
    {
        $parser = xml_parser_create();
        $this->assertSame(0, xml_parse($parser, "<?xml version=\"1.0\" ?>\n<xml>\n<test<></xml>"));
        
        $exception = XMLParserException::create($parser);
        $this->assertSame('XML parsing error: "> required" at Line 3 at column 6', $exception->getMessage());
    }
    
    /**
     * Test if no resource instance is given.
     * 
     * @covers Fabiang\Xmpp\Exception\XMLParserException::create
     * @expectedException Fabiang\Xmpp\Exception\InvalidArgumentException
     * @return void
     */
    public function testCreateNoResourceInstance()
    {
        XMLParserException::create('test');
    }
    
    /**
     * Test if resource is no xml parser instance.
     * 
     * @covers Fabiang\Xmpp\Exception\XMLParserException::create
     * @expectedException Fabiang\Xmpp\Exception\InvalidArgumentException
     * @return void
     */
    public function testCreateNoXMLResourceInstance()
    {
        $handle = fopen('php://memory', 'r');
        try {
            XMLParserException::create($handle);
        } catch (\Exception $e) {
            fclose($handle);
            throw $e;
        }
    }

}
