<?php

namespace Fabiang\Xmpp\Protocol;

/**
 * Generated by PHPUnit_SkeletonGenerator 1.2.1 on 2014-01-20 at 11:12:27.
 */
class PresenceTest extends \PHPUnit_Framework_TestCase
{

    /**
     * @var Presence
     */
    protected $object;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     *
     * @return void
     */
    protected function setUp()
    {
        $this->object = new Presence;
    }

    /**
     * Test truning object into string.
     *
     * @covers Fabiang\Xmpp\Protocol\Presence::toString
     * @return void
     */
    public function testToString()
    {
        $this->assertSame('<presence><priority>1</priority></presence>', $this->object->toString());
        $this->object->setTo('foobar')->setNickname('phpunit');
        $this->assertSame('<presence to="foobar/phpunit"><priority>1</priority></presence>', $this->object->toString());
    }
    
    /**
     * Test constructor.
     * 
     * @covers Fabiang\Xmpp\Protocol\Presence::__construct
     * @return void
     */
    public function testConstructor()
    {
        $object = new Presence('2', 'foo', 3);
        $this->assertSame('foo', $object->getTo());
        $this->assertSame(2, $object->getPriority());
        $this->assertSame('3', $object->getNickname());
    }

    /**
     * Test setter and getter.
     *
     * @covers Fabiang\Xmpp\Protocol\Presence::getTo
     * @covers Fabiang\Xmpp\Protocol\Presence::setTo
     * @covers Fabiang\Xmpp\Protocol\Presence::getPriority
     * @covers Fabiang\Xmpp\Protocol\Presence::setPriority
     * @covers Fabiang\Xmpp\Protocol\Presence::setNickname
     * @covers Fabiang\Xmpp\Protocol\Presence::getNickname
     * @return void
     */
    public function testSetterAndGetter()
    {
        $this->assertSame('foobar', $this->object->setTo('foobar')->getTo());
        $this->assertSame(2, $this->object->setPriority('2')->getPriority());
        $this->assertSame('3', $this->object->setNickname(3)->getNickname());
    }

}
