# Vuex [![Build Status](https://img.shields.io/circleci/project/vuejs/vuex/master.svg)](https://circleci.com/gh/vuejs/vuex) [![npm package](https://img.shields.io/npm/v/vuex.svg)](https://www.npmjs.com/package/vuex)

> Flux-inspired Application Architecture for Vue.js.

<p align="center">
  <img width="700px" src="https://raw.githubusercontent.com/vuejs/vuex/master/docs/en/vuex.png">
</p>

## NOTE: Vuex is still in development - API may change anytime.

- [Documentation](http://vuex.vuejs.org/)
- [Great introduction and explanation by @skyronic](http://skyronic.com/2016/01/03/vuex-basics-tutorial/)

## Examples

- [Counter](https://github.com/vuejs/vuex/tree/master/examples/counter)
- [Counter with Hot Reload](https://github.com/vuejs/vuex/tree/master/examples/counter-hot)
- [TodoMVC](https://github.com/vuejs/vuex/tree/master/examples/todomvc)
- [Flux Chat](https://github.com/vuejs/vuex/tree/master/examples/chat)
- [Shopping Cart](https://github.com/vuejs/vuex/tree/master/examples/shopping-cart)

Running the examples:

``` bash
$ npm install
$ npm run counter # run the counter example
```

See [npm scripts](https://github.com/vuejs/vuex/blob/master/package.json#L11-L15) for all example npm scripts.

## Principles

- Terse
- Testable
- Reactive
- Single State Tree
- Hot Reloading
- Time Travel (with upcoming vue-devtools support)
