import { defineConfig } from 'cypress'

export default defineConfig({
  defaultCommandTimeout: 10000,
  e2e: {
    // We've imported your old cypress plugins here.
    // You may want to clean this up later by importing these.
    setupNodeEvents(on, config) {
      return require('./plugins/index.ts')(on, config)
    },
    experimentalSessionAndOrigin: true,
    supportFile: './support/e2e.ts',
    fixturesFolder: './fixtures',
    screenshotsFolder: './screenshots',
    videosFolder :'./videos',
    downloadsFolder :'./downloads',
    specPattern:
      'e2e/unit_tests/*.spec.ts', 
  },
})
