# Test `/rest/files/{id}/versions`

A file can have multiple versions.

To view all versions of a file we first create: 

[ ](- "#docId=createDocument()")
[ ](- "#fileId=createFile(#docId)")
[ ](- "#oldVersionId=createVersion(#fileId)")
[ ](- "#newVersionId=createVersionWithDelay(#fileId)")

  - a document;
  - a file: [ ](- "ext:embed=code(#fileId)");
  - an old version: [ ](- "ext:embed=code(#oldVersionId)");
  - and a new version: [ ](- "ext:embed=code(#newVersionId)").

### Retrieve file versions
Versions are sorted by creation date, newest versions first.

When retrieving the versions of a file with a `GET` to [/rest/files/{id}/versions](- "#getEndpoint") 

 - where `{id}` is [ ](- "ext:embed=code(#fileId)"):

[ ](- "#retrieveResult=retrieve(#getEndpoint, #fileId, #oldVersionId, #newVersionId)")

Then:

 - The response status should be: [200](- "?=#retrieveResult.status");
 - The response should contain both the [new and then the old](- "?=#retrieveResult.twoVersions") version;
 - Full response:

[ ](- "ext:embed=#retrieveResult.body")

### Paginate file versions
Results are divided in pages using offset and limit.

When retrieving the versions of a file with a `GET` to [/rest/files/{id}/versions?offset={offset}&limit={limit}](- "#getEndpoint") 

 - where `{id}` is [ ](- "ext:embed=code(#fileId)");
 - where `{offset}` is [0](- "#offset") and `{limit}` is [1](- "#limit").

[ ](- "#paginateResult=paginate(#getEndpoint, #fileId, #offset, #limit, #newVersionId)")

Then:

 - The response status should be: [200](- "?=#paginateResult.status");
 - The response should only contain the [new](- "?=#paginateResult.hasOld") version;
 - Total should be [2](- "?=#paginateResult.total");
 - Full response:

[ ](- "ext:embed=#paginateResult.body")

### Filter with 'createdAfter'
The query parameter `createdAfter` filters out any versions that where created before the specified date. 

To test this filter we create a new version after a certain delay.
[ ](- "#delayedVersionId=createVersionWithDelay(#fileId)")


When retrieving the versions of a file with a `GET` to [/rest/files/{id}/versions?createdAfter={date}](- "#getEndpoint")
[ ](- "#date=getCreatedAt(#delayedVersionId)")

 - where `{id}` is [ ](- "ext:embed=code(#fileId)");
 - where `{date}` is [ ](- "ext:embed=code(#date)").

[ ](- "#paginateResult=filterByCreatedAfter(#getEndpoint, #fileId, #date, #delayedVersionId)")

Then:

 - The response status should be: [200](- "?=#paginateResult.status");
 - The response should only contain the [new](- "?=#paginateResult.hasNew") version;
 - Total should be [1](- "?=#paginateResult.total");
 - Full response:

[ ](- "ext:embed=#paginateResult.body")


