// Copyright 2017 the V8 project authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Generated by tools/bigint-tester.py.

// Flags: --harmony-bigint

var data = [{
  a: "-be5e349bf5ad48e7a5d",
  b: "a47a19a48667620a82973579739e08c64651b3ede2c578ff975e",
  r: "-7a4f25aa8725368922062fc91a110352a660657ffb3a489126ded10ccd29d929120c926"
}, {
  a: "912d5d85aec5ec6caf90514f0ec005f711caac82960c0ee911ef30f145107ae236783e6",
  b: "0",
  r: "0"
}, {
  a: "-87c17f6930bdef7e7c7ae7dab8be3baa2e7d67",
  b: "285af6503c42d077a0d59558deb170bad",
  r: "-1566788db7747e33ddb6540190617b57856e5f3924447f9f400f34a9aa75aa7d20f2b9b"
}, {
  a: "-3d0fd72abc5fb82d5cf45679812b71",
  b: "-3c537c742e17c5fac136e33f5e7edf256ef52b6df",
  r: "e63a0402966391e13e600371183f223379b66912ee706a2b369668b3e33e9a15992d6f"
}, {
  a: "dfd77cf4b0d071df2487c9b77959ee027380a159b0",
  b: "-56300fb05cba28d5150892ff66e77",
  r: "-4b5c6a1976d3a318cb9f93e154dc362da4e740fa31d82baefead60c355bfea99eaa50d0"
}, {
  a: "-bea52261387bb2aaf8c61b5ee7bbf85b3bbbedfe60773ed9873cbceba078d3fecbb",
  b: "-2ad7",
  r: "1fe73453d2eabb331a676ede8eb9759c8c6bffe09c76947578e08b0152379841d867f0d"
}, {
  a: "5b5a3a047d8f7e1519d6d92d3241c0f32c4d789",
  b: "-4bd3e8c09b0ba71bc25416877a4c7135",
  r: "-1b0f0d6ba20fe60049c4a172e8b1fb9824c1e85e21f1ebe08556b7074d8d4f4ac90185d"
}, {
  a: "1b2c8263d4bac8cc825657f81fca6196799aff00fa960d5c04",
  b: "-6b140fca30c8037b18d88",
  r: "-b5dbba6fba700592408e2ebbba2d4c6557d61d1201e24314f690e77c0b59c68d8b1620"
}, {
  a: "dd74f1f92ab5b9e0b447b7fe9076f7",
  b: "-9dbb0acb24e6336fe4f37f8e942d1d5c22dfe4f34",
  r: "-88728628dd4ed79514e720448e4f9ad422ba6ca62cd61bf779cfb3cb12afb5bbe20632c"
}, {
  a: "-e97d2712832aa20a",
  b: "-cb98c0fa9b4b35fc7a4ebed6d3d106bb758c244eb756c75587300ad",
  r: "b9b1904d502a19d20cc7bd8e05670f667db817bb9104ef8acc747f3df6541eede4d80c2"
}, {
  a: "828ca2d8981f347f4bec14ba",
  b: "-8ce5b6b1c329477a0a728ed81331af1f03e3eaa1ccb2cb3",
  r: "-47da0e06c179e58b3e5d8abc4a2b274ede3a7d73c0b5fcb3690f0b544ed6c0b7120760e"
}, {
  a: "aade382f2483a571e12cb1796bd124e21c6014261cef5d733a1b35fb01db7232c5b",
  b: "-d34a",
  r: "-8d068c8b18b90f6aaf82ed3260f68bdb06bf64613cdda736fc33395b7d16688edb9d34e"
}, {
  a: "34188043594e64ac10b37923ad29b4b536a4098ce76c9133155820b7843de95af",
  b: "106952",
  r: "356f6c0aa4a1a0d27dd2e8867420eddcd9fb5614450d6bb85cba0071e03e4563a0b90e"
}, {
  a: "96b2a125fc041fe36aebe7dfd02a4f56b90",
  b: "-a9f9c57a732002abf0764868f297442f61d1",
  r: "-640ef4605c38f6643d60526833e7a3b7b71a72b7042434abc0ca600e7f79b3aa98e6090"
}, {
  a: "-ae8327a77a340d2c90c93bb0ebe02d7a77d7c2a4e8d21a21d0",
  b: "268a49068f2769f949d95",
  r: "-1a45bc5e1b636b28bf716dfeaf0599cd932270796233adf7d58b8d72d06ac580c323e10"
}, {
  a: "-a0adcb953540a4f25fc97a40a2c9285bfba7e70e4ffc",
  b: "fff2302a069e8f69d00e529a81b",
  r: "-a0a5204f09eeb3ecd9fe2c6de34d0e0ed70c6d1589d95fd83de33d921a3152dfe5bcf94"
}, {
  a: "-83771467194c5b612539be7228f366a8",
  b: "9412ce8f98510486287bc15c35883fff04d126e",
  r: "-4c0a803e9a079742969e01dbb7990566b2f5ac9658653c967b5d295f6a996ba1655ec30"
}, {
  a: "12c3327d3d7ed4b3180cc301f98d351804451be431137fa48aa67627db867a2cd",
  b: "-ee0af6",
  r: "-11724697fa94a9caafbee6e7b778ecae17ed7ebba5575296b1fc4995a12fe5c9a8872fe"
}, {
  a: "-5",
  b: "-a00c8e774e3d4a6fc2fa384382720700e49e3e4b882bb5c4c0dbe4cdcd92126731128b",
  r: "3203ec8548732742ecee319518c3a230477173779a8da8cd7c44b780503da5c03f55cb7"
}, {
  a: "a0a4dc9610ada50dfa633ad910a02aa20c85",
  b: "-4d7aa1dc1cc1d1767b4e25a839e7c177652",
  r: "-309e8a7c10fbc6b50f6ad012099765a35395b9d51112d50e0a8f3ac076942a9e5a0509a"
}];

var error_count = 0;
for (var i = 0; i < data.length; i++) {
  var d = data[i];
  var a = BigInt.parseInt(d.a, 16);
  var b = BigInt.parseInt(d.b, 16);
  var r = a * b;
  if (d.r !== r.toString(16)) {
    print("Input A:  " + a.toString(16));
    print("Input B:  " + b.toString(16));
    print("Result:   " + r.toString(16));
    print("Expected: " + d.r);
    print("Op: *");
    error_count++;
  }
}
if (error_count !== 0) {
  print("Finished with " + error_count + " errors.")
  quit(1);
}
