---
title: "Sponsors"
bookCollapseSection: false
weight: 500
summary: "How Sponsors can use Kosli to ensure secure, compliant software delivery across their organization."
---

# Sponsors

You’re responsible for making sure your organization delivers software quickly, safely, and in a way that satisfies regulatory, customer, or internal compliance expectations.

You might lead an engineering org, oversee platform strategy, or be responsible for DevSecOps or governance transformation. You care about reducing lead time without sacrificing control or trust.

## How Kosli helps you

Kosli gives your teams the ability to automate governance across the entire software delivery lifecycle (SDLC). It makes it easy to verify that changes have passed the right checks and policies without slowing down releases.

With Kosli, you can:

- Replace manual approvals and change control boards with real-time, automated evidence
- Give your platform and product teams compliant workflows by default
- Get instant answers to “what changed, where, and why” across all environments
- Demonstrate governance and audit readiness without adding burden to developers

## Your role in using Kosli
As a sponsor, you are the enabler. You set the strategic direction and ensure the right people are equipped to succeed. Your key responsibilities include:

- Aligning Kosli adoption with organizational goals around speed, safety, and compliance
- Supporting platform teams in rolling out Kosli at scale
- Communicating the value of automated governance across the organization
- Using Kosli dashboards or reports to track adoption, policy health, and delivery confidence

## What you’ll work with

You won’t typically use the CLI. Instead, your interaction with Kosli will focus on:

- The Kosli UI to view environment compliance, trail status, and audit readiness
- Dashboards to understand where controls are working or missing
- Audit Packages and Evidence Vault exports to support reporting or audits
- Occasional reference to Kosli’s terminology or data model when aligning internal processes

## What success looks like

- You have visibility into delivery health and compliance posture across the org
- Product and platform teams operate with fewer manual gates or surprises
- You can demonstrate governance to stakeholders without relying on ad hoc processes
- Audits are predictable and repeatable
- Kosli becomes a quiet enabler. Developers deliver, compliance is provable, and your platform team scales without friction

## Common questions you might have

**“Can we remove manual approvals without increasing risk?”**<br>
Yes. Kosli replaces them with clear, automated evidence. Every change has a traceable chain of custody.

**“Does this help us with [SOC 2 / ISO / internal controls]?”**<br>
Yes. Kosli maps technical events to audit-friendly records, with downloadable audit packages and policy enforcement.

**“Will this add overhead for my teams?”**<br>
No. Platform engineers handle setup and integration. Developers rarely need to interact with Kosli directly.

**"How can I measure success?"**<br>
You'll see reduced lead times, fewer compliance exceptions, and improved audit efficiency. Kosli makes this visible through environment compliance views and evidence tracking.

## Required Kosli User Roles

To perform the responsibilities described above, users in this role typically need:
- **Recommended role**: Reader

Sponsors need visibility into adoption progress, compliance status, and overall system health but don't need to make technical changes. The Reader role provides necessary oversight without operational access, allowing you to view dashboards, compliance reports, and audit data.

Learn more about [Kosli user roles and permissions]({{< ref "/administration/managing_users/roles_in_kosli" >}}).

## Where to Start
- [**What is Kosli?**]({{< ref "/understand_kosli/what_is_kosli/">}}): Understand the value and core ideas
- [**Implementing Kosli**]({{< ref "/implementation_guide">}}): A rollout guide aligned to business and technical outcomes
- [**Concepts**]({{< ref "/understand_kosli/concepts" >}}): Understand how Flows, Trails, and Attestations fit together.