---
title: 'What is Kosli?'
weight: 120
summary: "Kosli is a change recording and compliance monitoring platform which allows you to record, track and query changes about any software or business process so you can prove compliance and maintain security without slowing down."
---
# What is Kosli?

Kosli is a change recording and compliance monitoring platform which allows you to record, track and query changes about any software or business process so you can prove compliance and maintain security without slowing down.

Kosli connects the recorded changes to establish immutable "chains of custody" which enables you to:

1. **Track Changes**: Trace how your business or software processes change over time.
2. **Identify Sources**: Understand where changes originated from, which can help in identifying issues.
3. **Continuous Compliance**: Ensure that you continuously adhere to your compliance requirements.
4. **Enable Audits**: Access audit packages on demand allowing audits and investigations into the software supply chain.
5. **Enhance Trust**: Build trust among users, customers, and stakeholders by providing transparent and verified information about the change history.
6. **Remove Friction**: Make changes at the DevOps speed with continuous compliance. No spreadsheets, paperwork or CAB meetings required.

# When to use Kosli?

Kosli serves as a versatile solution for a variety of use cases. Two primary scenarios which customers find Kosli valuable are:

- Monitoring and Ensuring Compliance in Software and Business Processes:
  Regardless of your specific process requirements and tools, Kosli empowers you to streamline and automate your change management and evidence recording processes. This capability ensures that organizations are consistently prepared for audits.

  Examples of software process requirements that Kosli can assist with are:
  - Verification that all artifacts running in production have undergone a specific risk control (e.g. security scanning).
  - Mandatory code review in a pull request before deployment to production.
  
  Examples of business process requirements that Kosli can address include:
  - Confirmation that employee onboarding/off-boarding aligns with relevant policies.
  - Logging and adherence to relevant policies for accessing production servers.
  
- Enhancing Overall Observability of Changes in Complex Systems and Environments:
  Beyond compliance considerations, Kosli remains valuable as a comprehensive platform, offering a unified view to different stakeholders. It provides visibility into changes occurring across various components of complex systems, even when there are no specific compliance requirements in place. This single pane of glass enhances overall observability.

Feel free to contact us with any additional questions or if you require further information regarding the capabilities of Kosli. Alternatively, [explore how our customers have successfully implemented and used our services](https://www.kosli.com/case-studies/).

# Where does Kosli fit in the growing tools landscape?

Kosli is tool-agnostic, specifically crafted to seamlessly integrate with various tools, including CI systems, code analysis tools, runtime environments, and more. Serving as a comprehensive compliance and change data hub, Kosli consolidates information from all your tools into a unified platform. It acts as your singular compliance and change management interface, providing a consolidated and streamlined view of data from diverse sources.

# How does Kosli work?

Kosli operates akin to a black box recorder, functioning as an append-only repository for immutable change records. Users report specific changes of interest through the command line interface (CLI) or API. Kosli, in turn, captures and stores these changes while actively monitoring compliance with designated policies.

Notably, change sources can originate from diverse environments, including build systems (such as CI systems) and runtime environments (for instance, a Kubernetes cluster). This flexibility ensures that Kosli effectively captures and monitors changes across various stages of development and deployment.

{{<figure src="/images/kosli-overview-docs.jpg" alt="Kosli overview" width="1000">}}

