/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.errorprone.annotations.CanIgnoreReturnValue;

public final class Preconditions {
    public static void checkArgument(boolean expression2) {
        if (!expression2) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean expression2, Object errorMessage) {
        if (!expression2) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
    }

    public static void checkArgument(boolean b2, String errorMessageTemplate, Object p1) {
        if (!b2) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, p1));
        }
    }

    public static void checkArgument(boolean b2, String errorMessageTemplate, Object p1, Object p2) {
        if (!b2) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkState(boolean expression2) {
        if (!expression2) {
            throw new IllegalStateException();
        }
    }

    public static void checkState(boolean expression2, Object errorMessage) {
        if (!expression2) {
            throw new IllegalStateException(String.valueOf(errorMessage));
        }
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T reference, Object errorMessage) {
        if (reference == null) {
            throw new NullPointerException(String.valueOf(errorMessage));
        }
        return reference;
    }

    @CanIgnoreReturnValue
    public static int checkElementIndex(int index2, int size) {
        return Preconditions.checkElementIndex(index2, size, "index");
    }

    @CanIgnoreReturnValue
    public static int checkElementIndex(int index2, int size, String desc) {
        if (index2 < 0 || index2 >= size) {
            throw new IndexOutOfBoundsException(Preconditions.badElementIndex(index2, size, desc));
        }
        return index2;
    }

    private static String badElementIndex(int index2, int size, String desc) {
        if (index2 < 0) {
            return Preconditions.format("%s (%s) must not be negative", desc, index2);
        }
        if (size < 0) {
            throw new IllegalArgumentException("negative size: " + size);
        }
        return Preconditions.format("%s (%s) must be less than size (%s)", desc, index2, size);
    }

    @CanIgnoreReturnValue
    public static int checkPositionIndex(int index2, int size) {
        return Preconditions.checkPositionIndex(index2, size, "index");
    }

    @CanIgnoreReturnValue
    public static int checkPositionIndex(int index2, int size, String desc) {
        if (index2 < 0 || index2 > size) {
            throw new IndexOutOfBoundsException(Preconditions.badPositionIndex(index2, size, desc));
        }
        return index2;
    }

    private static String badPositionIndex(int index2, int size, String desc) {
        if (index2 < 0) {
            return Preconditions.format("%s (%s) must not be negative", desc, index2);
        }
        if (size < 0) {
            throw new IllegalArgumentException("negative size: " + size);
        }
        return Preconditions.format("%s (%s) must not be greater than size (%s)", desc, index2, size);
    }

    public static void checkPositionIndexes(int start, int end, int size) {
        if (start < 0 || end < start || end > size) {
            throw new IndexOutOfBoundsException(Preconditions.badPositionIndexes(start, end, size));
        }
    }

    private static String badPositionIndexes(int start, int end, int size) {
        if (start < 0 || start > size) {
            return Preconditions.badPositionIndex(start, size, "start index");
        }
        if (end < 0 || end > size) {
            return Preconditions.badPositionIndex(end, size, "end index");
        }
        return Preconditions.format("end index (%s) must not be less than start index (%s)", end, start);
    }

    static String format(String template, Object ... args) {
        int placeholderStart;
        template = String.valueOf(template);
        StringBuilder builder = new StringBuilder(template.length() + 16 * args.length);
        int templateStart = 0;
        int i2 = 0;
        while (i2 < args.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template, templateStart, placeholderStart);
            builder.append(args[i2++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template, templateStart, template.length());
        if (i2 < args.length) {
            builder.append(" [");
            builder.append(args[i2++]);
            while (i2 < args.length) {
                builder.append(", ");
                builder.append(args[i2++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }
}

